@extends('layouts.UserLayout')
@section('content')
<!-- <link href="https://uat1.billdesk.com/merchant-uat/sdk/dist/billdesksdk/billdesksdk.css"rel="stylesheet"> -->

<link href="https://pay.billdesk.com/jssdk/v1/dist/billdesksdk/billdesksdk.css"rel="stylesheet">

@php
@endphp
<style type="text/css">
  .item {
        color: #000000 !important;
  }
</style>
<div class="container-xxl flex-grow-1 container-p-y" xmlns="http://www.w3.org/1999/html">
    @if(Session::has('message'))
        <p class="alert text-dark {{ Session::get('alert-class', 'alert-success') }}">{{ Session::get('message') }}</p>
    @endif
  <div class="row">
    <div class="col-md-12">
      <div class="card mb-4 mt-5">
          <h5 class="card-header bg-info mb-4">DNS Name Server  Payment Summary</h5>
          <div class="card-body">
              <div class="row ">
                  <div class="col-lg-12 mb-4 mb-xl-0">
                      <small class=" fw-semibold"></small>
                      <!-- <form method="get" action="{{route('billdesk.initiate.payment')}}" >
                          @csrf -->

                          <?php
                             
                          $dnssetupcharge=0;

                          if(isset($ernet_name_server)){

                            if($ernet_name_server->server_type!=1)
                            {

                            $taxes=json_encode(getmisc()->service_tax);

                            $dnssetupcharge=200+200*$taxes/100;
  
                            }

                          }else{
                            $taxes=json_encode(getmisc()->service_tax);

                            $dnssetupcharge=200+200*$taxes/100;

                          }


                       
                          ?>

                          
                <form method="post" id="editdomainform">
                      @csrf

                          <div class="demo-inline-spacing mt-3">
                              <div class="list-group">
                                  <ul class="list-group">
                                      <li class="list-group-item ">Domain Name : {{Auth::user()->domainName}}</li>
                                      <li class="list-group-item ">DNS Service Duration : {{Session::get('data')['years']}} years</li>
                                      <li class="list-group-item ">Price : ₹{{Session::get('data')['server_price']}}</li>
                                      <li class="list-group-item ">Tax( {{ number_format(getmisc()->service_tax,2)}} % ): ₹{{Session::get('data')['server_price_tax']}}</li>

                                      @if($dnssetupcharge!=0)
                                      <li class="list-group-item ">DNS Setup Charges (Tax {{$taxes}}% Included) : ₹236</li>
                                      @endif

                                      <li class="list-group-item ">Total DNS Amount : ₹{{Session::get('data')['server_price_total']+$dnssetupcharge}}</li>

                                      <input type="hidden" class="form-control" name="period"  value="{{Session::get('data')['years']}}" readonly/>

                                      @if(isset($ernet_name_server) && isset($ernet_name_server->server_type))

                                      @if($ernet_name_server->server_type!=1)

                                      <input type="hidden" class="form-control" name="dns_setupcharge"  value="{{$dnssetupcharge}}" readonly/>
                                      <input type="hidden" class="form-control" name="dns_setupamount"  value="200" readonly/>
                                      <input type="hidden" class="form-control" name="dns_taxamount"  value="{{$taxes}}" readonly/>

                                      @endif

                                      @else 

                                      <input type="hidden" class="form-control" name="dns_setupcharge"  value="{{$dnssetupcharge}}" readonly/>
                                      <input type="hidden" class="form-control" name="dns_setupamount"  value="200" readonly/>
                                      <input type="hidden" class="form-control" name="dns_taxamount"  value="{{$taxes}}" readonly/>

                                      @endif
                                    
                                      <input type="hidden" class="form-control" name="domain_name"  value="{{Auth::user()->domainName}}" readonly/>
                                      <input type="hidden" class="form-control" name="dns_duration" value="{{Session::get('data')['years']}}" readonly/>
                                      <input type="hidden" class="form-control" name="dns_price" value="{{Session::get('data')['server_price']}}" readonly/>
                                      <input type="hidden" class="form-control" name="dns_taxper"  value="{{ number_format(getmisc()->service_tax,2)}}" readonly/>
                                      <input type="hidden" class="form-control" name="dns_tax"  value="{{Session::get('data')['server_price_tax']}}" readonly/>
                                      <input type="hidden" class="form-control" name="amount"  value="{{Session::get('data')['server_price_total']+$dnssetupcharge}}" readonly/>
                                      <input type="hidden" class="form-control" name="transaction_type" id="transaction_type"  value="nameServerUpdate" readonly/>
                                      <input type="hidden" class="form-control" name="remark" id="remark"  value="Ernet Name Server Fee" readonly/>


                                  </ul>
                              </div>
                          </div>
                          <div class="col-12 mt-3">
                              <label class="form-label"></label>
                              <a href="{{url()->previous()}}"> <input type="button" class="btn btn-danger ml-3" id="back" name="back" value="Back"/></a>
                              <button type="submit" class="btn btn-success mr-4"  id="myButton" style="display:none">Make Payment</button>
                          </div>
                      </form>
                  </div>
              </div>
          </div>
      </div>
    </div>
  </div>
</div>
@endsection
@section("js")

<!-- <script type="module" src="https://uat1.billdesk.com/merchant-uat/sdk/dist/billdesksdk/billdesksdk.esm.js"></script></script>
<script nomodule="" src="https://uat1.billdesk.com/merchant-uat/sdk/dist/billdesksdk.js"></script> -->


<script type="module" src="https://pay.billdesk.com/jssdk/v1/dist/billdesksdk/billdesksdk.esm.js"></script></script>
<script nomodule="" src="https://pay.billdesk.com/jssdk/v1/dist/billdesksdk.js"></script> 


<script src="https://code.jquery.com/jquery-latest.min.js"></script>


<script type="text/javascript">

$(document).ready(function() {


  setTimeout(function () {
            // Show the button after 3 seconds
            $('#myButton').show();
        }, 3000);

$('body').on('submit', '#editdomainform', function(e) {
  e.preventDefault();
  $('#overlay').show();

  var current = $(this);		
  var data = current.serialize();
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  $.ajax({
    url: "{{route('createBilldeskOrder')}}",
    dataType : "json",
    type: "post",
    data : data,
    success : function(response) {
    if(response.status == 'success') {

var flow_config ={
merchantId:response.mid,
bdOrderId: response.orderId,
authToken: response.otoken,
childWindow: false,
returnUrl: response.ru, 
retryCount: 3,
prefs: {
 "payment_categories": ["card", "nb","upi"],
//"payment_categories": ["upi"],
// "allowed_bins": ["459150", "525211"]
 },
netBanking:{
 "showPopularBanks" : "Y",
 "popularBanks": ["Kotak Bank"," AXIS Bank [Retail]"],
}
} 

var theme_config = {
 sdkPrimaryColor: response.sdkPrimaryColor,
 sdkAccentColor: response.sdkAccentColor,
 sdkBackgroundColor: response.sdkBackgroundColor,
 sdkBannerColor: response.sdkBannerColor
}

var config = {
responseHandler: responseHandler,
merchantLogo: response.logo,
flowConfig: flow_config,
flowType: "payments",
themeConfig: theme_config
}

$('#overlay').hide();

window.loadBillDeskSdk(config);

} else if(response.status == 'error') {
        Swal.fire({
            icon: 'error',
            text: 'Please try again',
            showConfirmButton: true,
        })
      }
    },
  });
});

});

var responseHandler = function (txn) {
 console.log("callback received status:: ",txn.status)
 console.log("callback received response:: ",txn.response)
}

</script> 

@endsection
