@extends('layouts.UserLayout')
@section('content')
<!-- Content wrapper -->
<div class="container-xxl flex-grow-1 container-p-y">
  <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"></span> Dashboard </h4>
  <div class="row">
    <!-- Domain Status Table Start-->
      @if(Session::has('message'))
          <p class="alert text-dark {{ Session::get('alert-class', 'alert-success') }}">{{ Session::get('message') }}</p>
      @endif
    <div class="col-12 my-3">
      <h5 class="card-header bg-info">Domain Status </h5>
      <div class="card">
        <div class="card-body">
          <div class="table-responsive text-nowrap">
            <table class="table table-striped table-bordered dataTable no-footer">
              <thead class="table-secondary">
                <tr>
                  <th>Domain</th>
                  <th>Status</th>
                  <th>Last update</th>
                  <th>Domain Expiry Date</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                <?php
                     if(Auth::user()->domainStatus==6){
                        $ex=\Carbon\Carbon::parse(Auth::user()->domainExpiryDate);
                        $years=\Carbon\Carbon::now()->diffInYears($ex);
                        $allowyear=9-$years;
                     }else{
                         $allowyear=0;
                     }
                ?>

                  <td>
                    <strong>
                      @if(Auth::user()->domainStatus > 5)
                      <a style="color:#000" href="{{url('user-application-preview')}}" > {{\Illuminate\Support\Facades\Auth::user()->domainName}}
                      @if(Auth::user()->domainLangID==3)
                      {{(Auth::user()->domainPunycode)}}
                      @endif
                    </a>
                      @else
                      {{\Illuminate\Support\Facades\Auth::user()->domainName}}
                      @if(Auth::user()->domainLangID==3)
                      {{(Auth::user()->domainPunycode)}}
                      @endif
                       @endif</strong>
                  </td>
                   <td>
                       @if(Auth::user()->domainStatus == 0)
                           <a href="{{url('add-contact-details')}}">Contact Details Pending <i class="bx bx-edit"></i></a>
                       @elseif(Auth::user()->domainStatus == 1)
                            <a href="{{url('dns-name-server')}}">DNS Details Pending <i class="bx bx-edit"></i></a>
                       @elseif(Auth::user()->domainStatus == 2)
                            <a href="{{url('dns-name-server-payment')}}">Payment Pending <i class="bx bx-edit"></i></a>
                       @elseif(Auth::user()->domainStatus == 3)
                           <a href="{{url('upload-documents')}}">Documents Upload Pending <i class="bx bx-edit"></i></a>
                       @elseif(Auth::user()->domainStatus == 4 && Auth::user()->applicationDate != '')
                           <!-- <a href="{{url('upload-documents')}}">Document Modification Required <i class="bx bx-edit"></i></a> -->
                       @elseif(Auth::user()->domainStatus == 4 && Auth::user()->applicationDate == '')
                           <a href="{{url('user-application-preview')}}">Application Preview<i class="bx bx-edit"></i></a>
                       @elseif(Auth::user()->domainStatus == 5)
                           Domain Application Successfully Submitted
                       @elseif(Auth::user()->domainStatus == 6)
                           <a class="text-success" href="{{url('user-application-preview')}}" >Active</a>
                       @elseif(Auth::user()->domainStatus == 7)
                       <b class="text-danger">Domain Hold</b>
                       @elseif(Auth::user()->domainStatus == 8)
                       <b class="text-danger">Pending Restorable</b>
                       @elseif(Auth::user()->domainStatus == 10)
                           <b class="text-success">Applied for Renewal</b>
                       @elseif(Auth::user()->domainStatus == 11)
                       <b class="text-danger">Pending Restorable</b>
                       @endif
                     
                       <!-- @if($renewshowdate < $todaydate)

                       @if(Auth::user()->domainStatus != 10 )
                      
                       <a href="{{url('renew-domain')}}" style="float:right">Renew Domain</a>
                       @endif
                       @endif -->

                       
                       @if(Auth::user()->domainStatus != 10 && Auth::user()->domainStatus>=6)
                      
                       <a href="{{url('renew-domain')}}" style="float:right">Renew Domain</a>

                       @endif

                        @if((Auth::user()->domainStatus == 4 &&  Auth::user()->document_status==1 ) || (Auth::user()->domainStatus == 10 &&  Auth::user()->document_status==1))
                           <a href="{{url('upload-documents')}}">Document Modification Required <i class="bx bx-edit"></i></a>
                        @endif
                   </td>
                  <td>{{\Carbon\Carbon::parse(Auth::user()->updated_at)->format('d/m/Y g:i A')}}</td>
                  <td>
                  @if(Auth::user()->domainExpiryDate!=null)
                  {{\Carbon\Carbon::parse(Auth::user()->domainExpiryDate)->format('d/m/Y g:i A')}}
                  @endif
                  </td>
                  
                </tr>
              </tbody>
            </table>
              @if(Auth::user()->domainStatus == 5)
                  <div class="col-12 mt-3 px-1">
                      <a href="{{url('user-application-preview')}}" class="btn btn-info ml-3" id="add-server-smt-btn" >Preview Application</a>
                      <a href="{{url('signout')}}" class="btn btn-danger ml-3">Logout</a>
                  </div>
              @endif

          </div>
        </div>
      </div>
    </div>
    <!-- Domain Status Table End-->
  </div>
</div>
<!-- Content wrapper -->

@endsection
@section("js")

<script>
       
       @if(session('message'))
           
          @if(session('message')=='The Payment is Successfully done.')
          
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: '{{ session('message') }}',
                customClass: {
                    container: 'alert-container'
                }
            });

           @endif

        @endif

</script>

@endsection
