@extends('layouts.UserLayout')
@section('content')
@php
@endphp

<style>
      .blink {
            animation: blinker 4.5s linear infinite;
            color: #fff;
            font-family: sans-serif;
        }
        @keyframes blinker {
            50% {
                opacity: 0;
            }
        }
</style>
<div class="container-xxl flex-grow-1 container-p-y" xmlns="http://www.w3.org/1999/html">
  <div class="row">
    <div class="col-md-12">
      <div class="card mb-4 mt-5">
          <h5 class="card-header bg-info mb-4">Modify ERNET India Zone Records</h5>
        <div class="card-body px-5 ">
            <form role="form" id="save-ernet-dns-record" method="POST">
                @csrf
                <div class="row">
                    <input type="hidden" value="" name="id" id="id">
                    <div class="row mb-3">
                        <label class="col-md-12  " for="basic-default-city">Zone Name (FQDN) :  {{Auth::user()->domainName}} </label>
                    </div>
                    <div class="col-md-3 mb-3">
                        <label class="form-label">Record Type </label>
                        <select class="form-control" id="type" name="type" required>
                            <option value="A" selected="selected">A</option>
                            <option value="AAAA">AAAA</option>
                            <option value="CNAME">CNAME</option>
                            <option value="MX">MX</option>
                            <option value="NAPTR">NAPTR</option>
                            <option value="NS">NS</option>
                            <option value="SRV">SRV</option>
                            <option value="TXT">TXT</option>
                        </select>
                    </div>
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="name" id="name" value="@" placeholder="@"  required>
                            <span style="font-size: 0.85rem;">Use'@' to refer to the fully qualified domain name.</span>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label class="form-label">Value <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="data" id="data" placeholder="xx.xx.xx.xx" required >
                        </div>
                        <div class="col-md-3 mb-3 ttl">
                            <label class="form-label">TTL (seconds) </label>
                            <input type="number" class="form-control" name="ttl" id="ttl" placeholder="Default" value="" maxlength="35" >
                            <span style="font-size: 0.85rem;">Leave empty, to use default's TTL value (see Settings).</span>
                        </div>
                </div>
                <div class="my-3">
                    <button class="btn btn-success d-grid float-end" id="add_dns_btn" name="action" value="submit">Add Record</button>
                </div>
            </form>
            <button id="showHelpDiv" class="btn btn-secondary blink" >Show Help</button>
            <div id="helpDiv" class=" m-5" style="display: none">
                    <pre>
            A
                Maps a host name to IPv4 address.
                Data is a IPv4 address in dotted decimal format.
                Multiple addresses are defined with the same name.

            AAAA
                Maps a host name to IPv6 address.
                Data is a IPv6 address.
                Multiple addresses are defined with the same name.

            CNAME
                Maps an alias to the real or canonical name.
                Data is a host name.
                Ends Data with a '.' if you supply Fully Qualified Domain Name (FQDN).
                CNAME records must be unique on a domain.

            MX
                Specifies the name and relative preference of mail exchangers.
                Priority field is relative to other MX record for the same name.
                Data is a host name.
                Ends Data with a '.' if you supply FQDN.
                Any number of MX records may be defined.

            NS
                Can't use '@' as a Name.
                Delegates a subdomain to a DNS server.
                Data is a host name.
                Ends Data with a '.' if you supply FQDN.

            PTR
                Only used on IN-ADDR.ARPA. zones.
                Maps an IP address (IPv4 or IPv6) to a host name.
                Data is a host name. Must use an FQDN format (they end with a dot).

            SRV
                Identifies the host(s) that will support a particular service.
                Name is defined as '_service._proto' FQDN format (see RFC 2782).
                Priority field is relative to other SRV record for the same service.
                Data field include weight, port and target information (see RFC 2782).

            TXT
                 Associate some arbirary and unformatted text with a host or other name.</pre>
            </div>

        </div>
          <div class="card-body px-5">
              <div class="table-responsive">
                  @if($records != null)
                    <table class="table table-striped table-bordered">
                      <thead>
                      <tr>
                          <th>Type</th>
                          <th>Name</th>
                          <th>Content</th>
                          <th>TTL (seconds)</th>
                          <th>Action</th>
                      </tr>
                      </thead>
                      <tbody>

                             @foreach($records as $record)
                                 <tr>
                                     <td>{{$record->type}}</td>
                                     <td>{{$record->name}}</td>
                                     <td>{{$record->data}}</td>
                                     <td>{{$record->ttl}}</td>
                                     <td>
                                         <a class="ml-3" style="cursor:pointer" onclick="editRecord('{{$record->id}}','{{$record->type}}','{{$record->name}}','{{$record->data}}','{{$record->ttl}}','{{$record->priority}}','{{$record->weight}}','{{$record->port}}','{{$record->protocol}}','{{$record->service}}')" ><i class="fa fa-edit text-info fs-3 " ></i></a>
                                         <a class="ml-3" style="cursor:pointer" onclick="deleteRecord({{$record->id}})"><i class="fa fa-trash text-danger fs-3 "></i></a>
                                     </td>
                                 </tr>
                              @endforeach
                           
                      </tbody>
                  </table>
                  @endif
              </div>
              @if($records != null)
                <div class="row justify-content-end mt-5 mb-3">
                  <div class="col-md-12">
                      <a href="{{url()->previous()}}"> <input type="button" class="btn btn-danger" id="back" name="back" value="Back"/></a>
{{--                      <button class="btn btn-info ml-3" id="PushToServer"  >Push Resource Record</button>--}}
                  </div>

              </div>
              @endif
          </div>
      </div>
    </div>
  </div>
</div>
<!-- Content wrapper -->

@endsection
@section("js")
<script>

  $('#save-ernet-dns-record').validate({
    submitHandler:function(form)
    {
      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url:"{{url('save-ernet-dns-record')}}",
        type:'POST',
        dataType:'json',
        data:$("#save-ernet-dns-record").serialize(),
        cache: false,
        beforeSend: function(){
            $(".loader-area").show();
        },
        success:function(res)
        {
          if(res.status == true)
          {
              Swal.fire({
                  icon: 'success',
                  text: res.msg,
                  showConfirmButton: true,
              }).then(function () {
                  location.reload();
              });
          }else if(res.status == false)
          {
              Swal.fire({
                  icon: 'error',
                  text: res.msg,
                  showConfirmButton: true,
              })
          }
        },
        complete: function(){
            $("#add-server-smt-btn").prop('disabled',false);
        },
      });
    }
  });

  function editRecord(id,type,name,data,ttl,priority,weight,port,protocol,service){
   

      $('.Priority').remove();
      $('.Weight').remove();
      $('.Port').remove();
      $('.Service').remove();
      $('.Protocol').remove();
      $('#data').removeAttr('placeholder');

    //   if (type == 'A'){
    //       $('#data').attr('placeholder','xx.xx.xx.xx');
          
    //   }

    //   if (type == 'MX'){
    //       $('#data').attr('placeholder','Name Server');
    //       $('.ttl').after('' +
    //           ' <div class="col-md-3 mb-3 Priority">\n' +
    //           '                            <label class="form-label">Priority <span class="text-danger">*</span></label>\n' +
    //           '                            <input type="number" class="form-control" name="priority" id="priority" value="" required onKeyPress="if(this.value.length==2) return false;">\n' +
    //           '                        </div>');

    //       $('#priority').val(priority);

    //   }

    //   if (type == 'SRV'){
    //       $('.ttl').after('' +
    //           ' <div class="col-md-3 mb-3 Priority">\n' +
    //           '                            <label class="form-label">Priority </label>\n' +
    //           '                            <input type="number" class="form-control" name="priority" id="priority" value="" maxlength="35" >\n' +
    //           '                        </div>' +
    //           '<div class="col-md-3 mb-3 Service">\n' +
    //           '                        <label class="form-label">Service</label>\n' +
    //           '                        <input type="text" class="form-control" name="service" id="service" value="" placeholder="_ldap,_ftp or _smtp" maxlength="35" >\n' +
    //           '                    </div>' +
    //           '<div class="col-md-3 mb-3 Protocol">\n' +
    //           '                        <label class="form-label">Protocol</label>\n' +
    //           '                        <input type="text" class="form-control" name="protocol" id="protocol" placeholder="_tcp or _upd" value="" maxlength="35" >\n' +
    //           '                    </div>' +
    //           '<div class="col-md-3 mb-3 Weight">\n' +
    //           '                        <label class="form-label">Weight</label>\n' +
    //           '                        <input type="number" class="form-control" name="weight" id="weight" value="" maxlength="35" >\n' +
    //           '                    </div>' +
    //           '<div class="col-md-3 mb-3 Port">\n' +
    //           '                        <label class="form-label">Port</label>\n' +
    //           '                        <input type="text" class="form-control" name="port" id="port" value="" maxlength="35" >\n' +
    //           '                    </div>');

    //       $('#priority').val(priority);
    //       $('#weight').val(weight);
    //       $('#port').val(port);
    //       $('#protocol').val(protocol);
    //       $('#service').val(service);
    //   }

    //   if (type == 'NS'){

    //       $('#data').attr('placeholder','Name Server');
    //   }
      window.scrollTo(0,0);
      $('#name').focus();


      
      if (type == 'A'){
          $('#data').attr('placeholder','xx.xx.xx.xx');
          $('#name').attr('placeholder','@ or www');

          $('#data').removeAttr('pattern');

          $('#data').attr('pattern', '^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$');
      }

      if (type == 'AAAA'){
          $('#data').attr('placeholder','xxxx.xxxx.xxxx.xxxx.xxxx.xxxx.xxxx.xxxx');
          $('#name').attr('placeholder','@ or mail');
          $('#data').removeAttr('pattern');
         
        $('#data').attr('pattern', '^[0-9A-Fa-f:.]+$');

      }

      if(type=='NAPTR'){
        $('#data').removeAttr('pattern');
        // $('#data').attr('pattern', '^\d+ (\d+) "([^"]+)" (\S+) (\S+) "([^"]+)"$');
      }

      if (type == 'TXT'){
          $('#data').attr('placeholder','String of characters');
          $('#data').removeAttr('pattern');
      }

      if (type == 'CNAME'){
          $('#data').attr('placeholder','coolexample.com');
          $('#name').attr('placeholder','blog or shop');
          $('#data').removeAttr('pattern');

          $('#data').attr('pattern', '^[a-zA-Z0-9.]+$');

      }

      if (type == 'MX'){
          $('#data').attr('placeholder','smtp.secureserver.net');
          $('#data').removeAttr('pattern');
          
          $('.ttl').after('' +
              ' <div class="col-md-3 mb-3 Priority">\n' +
              '                            <label class="form-label">Priority <span class="text-danger">*</span></label>\n' +
              '                            <input type="number" min="0" max="10" class="form-control" name="priority" id="priority" value="" required onKeyPress="if(this.value.length==2) return false;">\n' +
              '                        </div>');
      }

      if (type == 'SRV'){
          $('#data').attr('placeholder','host.domain.com');
          $('#name').attr('placeholder','@ or mail');
          $('#data').removeAttr('pattern');

          $('#data').attr('pattern', '^[a-zA-Z0-9_.]+$');

          $('#priority').attr('pattern','^[0-9]+(\.[0-9]+)?$');
          $('#weight').attr('pattern','^[0-9]+(\.[0-9]+)?$');
          $('#port').attr('pattern','^[0-9]+(\.[0-9]+)?$');
          $('.ttl').after('' +
              ' <div class="col-md-3 mb-3 Priority">\n' +
              '                            <label class="form-label">Priority </label>\n' +
              '                            <input type="number"  min="0" max="10" class="form-control" name="priority" id="priority" value=""  placeholder="0 or greater" onKeyPress="if(this.value.length==2) return false;" >\n' +
              '                        </div>' +
              '<div class="col-md-3 mb-3 Service">\n' +
              '                        <label class="form-label">Service</label>\n' +
              '                        <input type="text" class="form-control" name="service" id="service" value="" placeholder="_ldap,_ftp or _smtp" maxlength="35" >\n' +
              '                    </div>' +
              '<div class="col-md-3 mb-3 Protocol">\n' +
              '                        <label class="form-label">Protocol</label>\n' +
              '                        <input type="text" class="form-control" name="protocol" id="protocol" placeholder="_tcp or _upd" value="" maxlength="35" >\n' +
              '                    </div>' +
              '<div class="col-md-3 mb-3 Weight">\n' +
              '                        <label class="form-label">Weight</label>\n' +
              '                        <input type="number" class="form-control" min="0" name="weight" id="weight" placeholder="0 or greater" value="" onKeyPress="if(this.value.length==2) return false;">\n' +
              '                    </div>' +
              '<div class="col-md-3 mb-3 Port">\n' +
              '                        <label class="form-label">Port</label>\n' +
              '                        <input type="text" class="form-control" min="0" name="port" id="port" placeholder="80 or 21" value="" onKeyPress="if(this.value.length==4) return false;">\n' +
              '                    </div>');
      }

      if (type == 'NS'){
          $('#name').attr('placeholder','@ or www');
          $('#data').attr('placeholder','ns1.domain.com');
          $('#data').removeAttr('pattern');
      }

      $('#id').val(id);
      $('#type').val(type);
      $('#name').val(name);
      $('#data').val(data);
      $('#ttl').val(ttl);

      $('#priority').val(priority);
      $('#service').val(service);
      $('#weight').val(weight);
      $('#protocol').val(protocol);
      $('#port').val(port);

  }

  function deleteRecord(id){
      Swal.fire({
          title: 'Are you sure?',
          text: 'You are about delete this record.',
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#28a745',
          cancelButtonColor: '#6c757d',
          confirmButtonText: 'Confirm',
          cancelButtonText: 'Cancel'
      }).then((result) => {
          if (result.isConfirmed) {
              $.ajax({
                  url: "{{ url('deleteRecord') }}"+'/'+id,
                  dataType : "json",
                  type: "get",
                  success : function(response) {
                      if(response.status == true)
                      {
                          Swal.fire({
                              icon: 'success',
                              text: response.msg,
                              showConfirmButton: true,
                          }).then(function () {
                              location.reload();
                          });
                      }else if(response.status == false)
                      {
                          Swal.fire({
                              icon: 'error',
                              text: response.msg,
                              showConfirmButton: true,
                          })
                      }

                  },
              });
          }
      });


  }

  $(document).on("click",'#showHelpDiv',function(){
      if ($(this).text() == 'Show Help'){
          $("#helpDiv").show();
          $(this).text('Hide Help');
      }else {
          $("#helpDiv").hide();
          $(this).text('Show Help');
      }

  });

  $('#data').attr('pattern', '^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$');


  $(document).on("change",'#type',function(){
      $('.Priority').remove();
      $('.Weight').remove();
      $('.Port').remove();
      $('#data').removeAttr('placeholder');

      if ($(this).val() == 'A'){
          $('#data').attr('placeholder','xx.xx.xx.xx');
          $('#name').attr('placeholder','@ or www');

          $('#data').removeAttr('pattern');

          $('#data').attr('pattern', '^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$');
      }

      if ($(this).val() == 'AAAA'){
          $('#data').attr('placeholder','xxxx.xxxx.xxxx.xxxx.xxxx.xxxx.xxxx.xxxx');
          $('#name').attr('placeholder','@ or mail');
          $('#data').removeAttr('pattern');
         
        $('#data').attr('pattern', '^[0-9A-Fa-f:.]+$');

      }

      if($(this).val()=='NAPTR'){
        $('#data').removeAttr('pattern');
        // $('#data').attr('pattern', '^\d+ (\d+) "([^"]+)" (\S+) (\S+) "([^"]+)"$');
      }

      if ($(this).val() == 'TXT'){
          $('#data').attr('placeholder','String of characters');
          $('#data').removeAttr('pattern');
      }

      if ($(this).val() == 'CNAME'){
          $('#data').attr('placeholder','coolexample.com');
          $('#name').attr('placeholder','blog or shop');
          $('#data').removeAttr('pattern');

          $('#data').attr('pattern', '^[a-zA-Z0-9.]+$');

      }

      if ($(this).val() == 'MX'){
          $('#data').attr('placeholder','smtp.secureserver.net');
          $('#data').removeAttr('pattern');
          
          $('.ttl').after('' +
              ' <div class="col-md-3 mb-3 Priority">\n' +
              '                            <label class="form-label">Priority <span class="text-danger">*</span></label>\n' +
              '                            <input type="number" min="0" max="10" class="form-control" name="priority" id="priority" value="" required onKeyPress="if(this.value.length==2) return false;">\n' +
              '                        </div>');
      }

      if ($(this).val() == 'SRV'){
          $('#data').attr('placeholder','host.domain.com');
          $('#name').attr('placeholder','@ or mail');
          $('#data').removeAttr('pattern');

          $('#data').attr('pattern', '^[a-zA-Z0-9_.]+$');

          $('#priority').attr('pattern','^[0-9]+(\.[0-9]+)?$');
          $('#weight').attr('pattern','^[0-9]+(\.[0-9]+)?$');
          $('#port').attr('pattern','^[0-9]+(\.[0-9]+)?$');
          $('.ttl').after('' +
              ' <div class="col-md-3 mb-3 Priority">\n' +
              '                            <label class="form-label">Priority </label>\n' +
              '                            <input type="number"  min="0" max="10" class="form-control" name="priority" id="priority" value=""  placeholder="0 or greater" onKeyPress="if(this.value.length==2) return false;" >\n' +
              '                        </div>' +
              '<div class="col-md-3 mb-3 Service">\n' +
              '                        <label class="form-label">Service</label>\n' +
              '                        <input type="text" class="form-control" name="service" id="service" value="" placeholder="_ldap,_ftp or _smtp" maxlength="35" >\n' +
              '                    </div>' +
              '<div class="col-md-3 mb-3 Protocol">\n' +
              '                        <label class="form-label">Protocol</label>\n' +
              '                        <input type="text" class="form-control" name="protocol" id="protocol" placeholder="_tcp or _upd" value="" maxlength="35" >\n' +
              '                    </div>' +
              '<div class="col-md-3 mb-3 Weight">\n' +
              '                        <label class="form-label">Weight</label>\n' +
              '                        <input type="number" class="form-control" min="0" name="weight" id="weight" placeholder="0 or greater" value="" onKeyPress="if(this.value.length==2) return false;">\n' +
              '                    </div>' +
              '<div class="col-md-3 mb-3 Port">\n' +
              '                        <label class="form-label">Port</label>\n' +
              '                        <input type="text" class="form-control" min="0" name="port" id="port" placeholder="80 or 21" value="" onKeyPress="if(this.value.length==4) return false;">\n' +
              '                    </div>');
      }

      if ($(this).val() == 'NS'){
          $('#name').attr('placeholder','@ or www');
          $('#data').attr('placeholder','ns1.domain.com');
          $('#data').removeAttr('pattern');
      }

  });

  $(document).on("click",'#PushToServer',function(){
      $('#PushToServer').attr('disabled');
      Swal.fire({
          title: "Please wait...",
          html: "resource records are updating"
      })
      Swal.showLoading();
      $.ajax({
          url: "{{ url('pushResourceRecord') }}",
          dataType : "json",
          type: "get",
          success : function(response) {

              if(response.status == true) {
                  $('#PushToServer').removeAttr('disabled');
                  Swal.fire({
                      icon: 'success',
                      text: response.msg,
                      showConfirmButton: true,
                  });

              } else if(response.status == false) {
                  Swal.fire({
                      icon: 'error',
                      text: response.msg,
                      showConfirmButton: true,
                  });

              }

          },
      });
  });

</script>
@endsection
