@extends('layouts.UserLayout')
@section('content')
@php
@endphp
<!-- Content wrapper -->
<div class="container-xxl flex-grow-1 container-p-y" xmlns="http://www.w3.org/1999/html">
  <div class="row">
    <div class="col-md-12">
      <div class="card mb-4 mt-5">
          <h5 class="card-header bg-info mb-4">Modify ERNET India DNS Resource Record</h5>
        <div class="card-body px-5 ">
            <form role="form" id="save-ernet-dns-record" method="POST">
                @csrf
                <div class="row">
                    <div class="row mb-3">
                        Primary DNS zone (aka. master)
                    </div>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">Zone Name (FQDN) <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="name" id="name" value=""  required>
                        </div>
                    <div class="col-md-3 mb-4 p-5">
                        <input id="moreSettings" type="checkbox" class=""><label class="form-label">Use specific settings for this zone</label>
                    </div>
                    <div class="col-md-4 mb-3 p-5">
                        <button class="btn btn-success d-grid float-end" id="add_dns_btn" name="action" value="submit">Save</button>
                    </div>
                    <div class="input-group col-md-4 m-3">
                        <div id="helpDiv" class="" style="display: none">
                            <div  id="custom_settings_section" >

                                <div class="row mb-3">
                                    Zone specific settings
                                </div>
                                <fieldset id="custom_settings_fields">

                                    <!-- Copy from global settings -->
                                    <div class="form-group">
                                        <input type="checkbox" id="setDefaultValue" class="" ><label class="form-label"> Copy values from defaults</label>
                                    </div>
                                    <!-- ./ Copy from global settings -->

                                    <!-- row -->
                                    <div class="row">
                                        <div class="col-md-6">
                                            <!-- refresh -->
                                            <div class="form-group ">
                                                <label for="refresh" class="form-label required">Refresh time (seconds)</label>
                                                <div class="controls">
                                                    <input class="form-control" required="required" name="refresh" type="number" id="refresh">
                                                    <span class="help-block">Sets how often the zone should be synchronized from primary name server to secondary name server.</span>
                                                    <span class="help-block"></span>
                                                </div>
                                            </div>
                                            <!-- ./ refresh -->
                                        </div>
                                        <div class="col-md-6">

                                            <!-- retry -->
                                            <div class="form-group ">
                                                <label for="retry" class="form-label required">Retry time (seconds)</label>
                                                <div class="controls">
                                                    <input class="form-control" required="required" name="retry" type="number" id="retry">
                                                    <span class="help-block">Sets how often secondary name servers try to synchronize the zone from primary name server if synchronization fails.</span>
                                                    <span class="help-block"></span>
                                                </div>
                                            </div>
                                            <!-- ./ retry -->
                                        </div>
                                    </div>
                                    <!-- ./ row -->

                                    <!-- row -->
                                    <div class="row">
                                        <div class="col-md-6">
                                            <!-- expire -->
                                            <div class="form-group ">
                                                <label for="expire" class="form-label required">Expiration (seconds)</label>
                                                <div class="controls">
                                                    <input class="form-control" required="required" name="expire" type="number" id="expire">
                                                    <span class="help-block">Means the period after which the zone expires on secondary name servers.</span>
                                                    <span class="help-block"></span>
                                                </div>
                                            </div>
                                            <!-- ./ expire -->
                                        </div>
                                        <div class="col-md-6">

                                            <!-- negative_ttl -->
                                            <div class="form-group ">
                                                <label for="negative_ttl" class="form-label required">Negative Answers TTL (seconds)</label>
                                                <div class="controls">
                                                    <input class="form-control" required="required" name="negative_ttl" type="number" id="negative_ttl">
                                                    <span class="help-block">Specifies the time to live in the zone for caching negative answers on secondary servers.</span>
                                                    <span class="help-block"></span>
                                                </div>
                                            </div>
                                            <!-- ./ negative_ttl -->
                                        </div>
                                    </div>
                                    <!-- ./ row -->

                                    <!-- default_ttl -->
                                    <div class="form-group ">
                                        <label for="default_ttl" class="form-label required">Default TTL for records (seconds)</label>
                                        <div class="controls">
                                            <input class="form-control" required="required" name="default_ttl" type="number" id="default_ttl">
                                            <span class="help-block">Specifies the time to live for all records in the zone that do not have an explicit TTL.</span>
                                            <span class="help-block"></span>
                                        </div>
                                    </div>
                                    <!-- ./ default_ttl -->

                                </fieldset>
                            </div>
                        </div>
                    </div>

                    <div class="row mb-3 mt-5">
                        Secondary DNS zone (aka. slave)
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Zone Name (FQDN) <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="name" id="name" value=""  required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <label class="form-label">Primary DNS (server IP) <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="data" id="data" value="" required >
                    </div>
                    <div class="col-md-4 mb-3 p-5">
                        <button class="btn btn-success d-grid float-end" id="add_dns_btn" name="action" value="submit">Save</button>
                    </div>
                </div>
            </form>
{{--            <button id="showHelpDiv" class="btn btn-secondary" >Use specific settings for this zone</button>--}}
        </div>
      </div>
    </div>
  </div>
</div>
<!-- Content wrapper -->

@endsection
@section("js")
<script>

  $('#save-ernet-dns-record').validate({
    submitHandler:function(form)
    {
      $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
      });
      $.ajax({
        url:"{{url('save-ernet-dns-record')}}",
        type:'POST',
        dataType:'json',
        data:$("#save-ernet-dns-record").serialize(),
        cache: false,
        beforeSend: function(){
            $(".loader-area").show();
        },
        success:function(res)
        {
          if(res.status == true)
          {
              Swal.fire({
                  icon: 'success',
                  text: res.msg,
                  showConfirmButton: true,
              }).then(function () {
                  location.reload();
              });
          }else if(res.status == false)
          {
              Swal.fire({
                  icon: 'error',
                  text: res.msg,
                  showConfirmButton: true,
              })
          }
        },
        complete: function(){
            $("#add-server-smt-btn").prop('disabled',false);
        },
      });
    }
  });

  function editRecord(type,name,data,ttl,priority,weight,port){
      $('#type').val(type);
      $('#name').val(name);
      $('#data').val(data);
      $('#ttl').val(ttl);

      $('.Priority').remove();
      $('.Weight').remove();
      $('.Port').remove();
      $('#data').removeAttr('placeholder');

      if (type == 'MX'){

          $('.ttl').after('' +
              ' <div class="col-md-3 mb-3 Priority">\n' +
              '                            <label class="form-label">Priority </label>\n' +
              '                            <input type="number" min="0" class="form-control" name="priority" id="priority" value="" maxlength="35" >\n' +
              '                        </div>');

          $('#priority').val(priority);

      }

      if (type == 'SRV'){
          $('.ttl').after('' +
              ' <div class="col-md-3 mb-3 Priority">\n' +
              '                            <label class="form-label">Priority </label>\n' +
              '                            <input type="number" min="0"  class="form-control" name="priority" id="priority" value="" maxlength="35" >\n' +
              '                        </div>' +
              '<div class="col-md-3 mb-3 Weight">\n' +
              '                        <label class="form-label">Weight</label>\n' +
              '                        <input type="number" class="form-control" name="weight" id="weight" value="" maxlength="35" >\n' +
              '                    </div>' +
              '<div class="col-md-3 mb-3 Port">\n' +
              '                        <label class="form-label">Port</label>\n' +
              '                        <input type="text" class="form-control" name="port" id="port" value="" maxlength="35" >\n' +
              '                    </div>');

          $('#priority').val(priority);
          $('#weight').val(weight);
          $('#port').val(port);
      }

      if (type == 'NS'){

          $('#data').attr('placeholder','Name Server');
      }
      window.scrollTo(0,0);
      $('#name').focus();

  }

  function deleteRecord(id){
      Swal.fire({
          title: 'Are you sure?',
          text: 'You are about delete this record.',
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#28a745',
          cancelButtonColor: '#6c757d',
          confirmButtonText: 'Confirm',
          cancelButtonText: 'Cancel'
      }).then((result) => {
          if (result.isConfirmed) {
              $.ajax({
                  url: "{{ url('deleteRecord') }}"+'/'+id,
                  dataType : "json",
                  type: "get",
                  success : function(response) {
                      if(response.status == true)
                      {
                          Swal.fire({
                              icon: 'success',
                              text: response.msg,
                              showConfirmButton: true,
                          }).then(function () {
                              location.reload();
                          });
                      }else if(response.status == false)
                      {
                          Swal.fire({
                              icon: 'error',
                              text: response.msg,
                              showConfirmButton: true,
                          })
                      }

                  },
              });
          }
      });


  }

  $(document).on("change",'#setDefaultValue',function(){
      if(this.checked) {
          $("#refresh").val('86400');
          $("#retry").val('7200');
          $("#expire").val('3628800');
          $("#negative_ttl").val('7200');
          $("#default_ttl").val('172800');
      }else {
          $("#refresh").val('');
          $("#retry").val('');
          $("#expire").val('');
          $("#negative_ttl").val('');
          $("#default_ttl").val('');
      }

  });
  $(document).on("change",'#moreSettings',function(){
      if(this.checked) {
          $("#helpDiv").show();
      }else {
          $("#helpDiv").hide();
      }

  });

  $(document).on("change",'#type',function(){
      $('.Priority').remove();
      $('.Weight').remove();
      $('.Port').remove();
      $('#data').removeAttr('placeholder');
      if ($(this).val() == 'MX'){

          $('.ttl').after('' +
              ' <div class="col-md-3 mb-3 Priority">\n' +
              '                            <label class="form-label">Priority </label>\n' +
              '                            <input type="number" class="form-control"  min="0"  name="priority" id="priority" value="" maxlength="35" >\n' +
              '                        </div>');
      }

      if ($(this).val() == 'SRV'){
          $('.ttl').after('' +
              ' <div class="col-md-3 mb-3 Priority">\n' +
              '                            <label class="form-label">Priority </label>\n' +
              '                            <input type="number" class="form-control" min="0"  name="priority" id="priority" value="" maxlength="35" >\n' +
              '                        </div>' +
              '<div class="col-md-3 mb-3 Weight">\n' +
              '                        <label class="form-label">Weight</label>\n' +
              '                        <input type="number" class="form-control" name="weight" id="weight" value="" maxlength="35" >\n' +
              '                    </div>' +
              '<div class="col-md-3 mb-3 Port">\n' +
              '                        <label class="form-label">Port</label>\n' +
              '                        <input type="text" class="form-control" name="port" id="port" value="" maxlength="35" >\n' +
              '                    </div>');
      }

      if ($(this).val() == 'NS'){

          $('#data').attr('placeholder','Name Server');
      }

  });

  $(document).on("click",'#PushToServer',function(){
      $('#PushToServer').attr('disabled');
      Swal.fire({
          title: "Please wait...",
          html: "resource records are updating"
      })
      Swal.showLoading();
      $.ajax({
          url: "{{ url('pushResourceRecord') }}",
          dataType : "json",
          type: "get",
          success : function(response) {

              if(response.status == true) {
                  $('#PushToServer').removeAttr('disabled');
                  Swal.fire({
                      icon: 'success',
                      text: response.msg,
                      showConfirmButton: true,
                  });

              } else if(response.status == false) {
                  Swal.fire({
                      icon: 'error',
                      text: response.msg,
                      showConfirmButton: true,
                  });

              }

          },
      });
  });

</script>
@endsection
