@extends('layouts.UserLayout')
@section('content')
    @php
        @endphp
    <!-- Content wrapper -->
    <div class="container-xxl flex-grow-1 container-p-y" xmlns="http://www.w3.org/1999/html">
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4 mt-5">
                    <h5 class="card-header bg-info mb-4">DNS Name Server Details</h5>
                    <div class="card-body">
                        <div class="table-responsive text-nowrap">
                            <table class="table table-bordered">
                                <thead>

                                <tr>
                                    <th>DNS</th>
                                    <th>Name Server</th>
                                    <th>IPv4 Address</th>
                                    <th>IPv6 Address</th>
                                </tr>
                                </thead>
                                <tbody>
                                <tr>
                                    <td>Primary Name Server</td>
                                    <td>{{$name_server_data->primary_name_server}}</td>
                                    <td>{{$name_server_data->primary_name_server_ip}}</td>
                                    <td>{{$name_server_data->primary_name_server_ip6}}</td>
                                </tr>

                                <tr>
                                    <td>Secondary Name Server 1</td>
                                    <td>{{$name_server_data->secondary_name_server1}}</td>
                                    <td>{{$name_server_data->secondary_name_server1_ip}}</td>
                                    <td>{{$name_server_data->secondary_name_server1_ip6}}</td>
                                </tr>

                                <tr>
                                    <td>Secondary Name Server 2</td>
                                    <td>{{$name_server_data->secondary_name_server2}}</td>
                                    <td>{{$name_server_data->secondary_name_server2_ip}}</td>
                                    <td>{{$name_server_data->secondary_name_server2_ip6}}</td>
                                </tr>

                                <tr>
                                    <td>Secondary Name Server 3</td>
                                    <td>{{$name_server_data->secondary_name_server3}}</td>
                                    <td>{{$name_server_data->secondary_name_server3_ip}}</td>
                                    <td>{{$name_server_data->secondary_name_server3_ip6}}</td>
                                </tr>

                                <tr>
                                    <td>Secondary Name Server 4</td>
                                    <td>{{$name_server_data->secondary_name_server4}}</td>
                                    <td>{{$name_server_data->secondary_name_server4_ip}}</td>
                                    <td>{{$name_server_data->secondary_name_server4_ip6}}</td>
                                </tr>
                                <tr>
                                    <td>Secondary Name Server 5</td>
                                    <td>{{$name_server_data->secondary_name_server5}}</td>
                                    <td>{{$name_server_data->secondary_name_server5_ip}}</td>
                                    <td>{{$name_server_data->secondary_name_server5_ip6}}</td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section("js")
    <script>
        var i = 0;
        $('.remove-row').hide();
        $(document).on("click",'.add-row',function(){
            $('.remove-row').show();
            i++;
            var markup = ' <tr id="row-'+i+'">'+
                '<td><input type="text" class="form-control" name="dnsse['+i+'][key_tag]" id="key_tag" value=""></td>'+
                ' <td><input type="text" class="form-control" name="dnsse['+i+'][algorithm]" id="algorithm" value=""></td>'+
                '<td> <select name="dnsse['+i+'][digest_type]" class="form-control">\n' +
                '                            <option value="SHA1">SHA1</option>\n' +
                '                        </select></td>'+
                '<td><input type="text" class="form-control" name="dnsse['+i+'][digest]" id="digest" value=""></td>'+
                '</tr>';
            $("table tbody").append(markup);
        });
        $(document).on("click",'.remove-row',function(){
            $('#row-'+i+'').remove();
            i--;
        });

        $("#enable_dnsse_no").click(function(){
            $("#kripa").hide();
        });

        $("#enable_dnsse_yes").click(function(){
            $("#kripa").show();
        });

        $(document).ready(function() {
            $('input[type="radio"]').click(function() {
                if($(this).attr('id') == 'ernet_name_server_form') {
                    $('.user-server-form').addClass('d-none');
                    $('.ernet-server-form').removeClass('d-none');
                }

                else {
                    $('.user-server-form').removeClass('d-none');
                    $('.ernet-server-form').addClass('d-none');
                }
            });
        });

        $('#modified_server_form').validate({
            rules: {
                primary_server: {
                    required: true,
                },
            },
            messages: {
                primary_server: {
                    required: "Please fill server name",
                    primary_server: "Please fill valid server name",
                },
            },

            submitHandler:function(form)
            {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    url:"{{url('addDnsNameServer')}}",
                    type:'POST',
                    dataType:'json',
                    data:$("#modified_server_form").serialize(),
                    cache: false,
                    beforeSend: function(){
                        $(".loader-area").show();
                    },
                    success:function(res)
                    {
                        if(res.status == true)
                        {
                            alert('Name Server Details have been submitted successfully');
                            window.location.href = "{{ url('upload-documents')}}";
                        }
                        else
                        {
                            alert('Name Server Details have been submitted successfully');
                        }
                    },
                    complete: function(){
                        $("form").trigger("reset");
                        $("#add-server-smt-btn").prop('disabled',false);
                    },
                });
            }
        });
        $(document).on("change",'#service_duration',function(){
            $.ajax({
                url: "{{ url('getNameServerPrice') }}"+'/'+$(this).val(),
                dataType : "json",
                type: "get",
                success : function(response) {

                    if(response.status == true) {
                        $('#server_price').val(response.data.price);
                        var server_price_gst_percent = (18*response.data.price)/100;
                        $('#server_price_tax').val(server_price_gst_percent);
                        $('#server_price_total').val(parseFloat(response.data.price)+parseFloat(server_price_gst_percent));
                    } else if(response.status == false) {
                        alert(response.message);
                    }

                },
            });
        });

    </script>
@endsection
