@extends('layouts.UserLayout')
@section('content')
    <link href="https://uat1.billdesk.com/merchant-uat/sdk/dist/billdesksdk/billdesksdk.css" rel="stylesheet">


    @php
    @endphp
    <div class="container-xxl flex-grow-1 container-p-y" xmlns="http://www.w3.org/1999/html">
        @if (Session::has('message'))
            <p class="alert text-dark {{ Session::get('alert-class', 'alert-success') }}">{{ Session::get('message') }}</p>
        @endif
        <div class="row">
            <div class="col-md-12">
                <div class="card mb-4 mt-5">
                    <h5 class="card-header bg-info mb-4">Renewal of Domain Services</h5>
                    <div class="card-body">
                        <div class="row ">
                            <div class="col-lg-12 mb-4 align-content-center  ">
                                <small class="fw-semibold"></small>
                                <div class="demo-inline-spacing mt-3 px-5">

                                    <!-- <form method="get" action="{{ route('billdesk.initiate.payment') }}">
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @csrf -->

                                    {{-- <form method="post" id="editdomainform">
                                        @csrf
                                        <input type="hidden" class="form-control" name="late_charges" id="late_charges"
                                            value="{{ $extra_charge ?? 0 }}" readonly />
                                        <input type="hidden" class="form-control" name="domain_name"
                                            value="{{ Auth::user()->domainName }}" readonly />
                                        <input type="hidden" class="form-control" name="amount" id="amount" value=""
                                            readonly />
                                        <input type="hidden" class="form-control" name="transaction_type"
                                            id="transaction_type" value="domainRenewal" readonly />
                                        <input type="hidden" class="form-control" name="remark" id="remark"
                                            value="Domain Renewal Fee" readonly />
                                        <div class="row mb-3">
                                            <label class="col-md-12 text-center " for="basic-default-city">Your Domain Name
                                                : {{ Auth::user()->domainName }} </label>
                                        </div>
                                        <div class="col-6 my-2">
                                            <label class="form-label">Renewal Years</label>
                                            <select id="service_duration" name="year" class="form-control year" required>
                                                <option value="" class="form-control">Select Years</option>
                                                @foreach ($renew_prices as $price)
                                                <option value="{{ $price->id }}" class="form-control">
                                                    {{ $price->year == 1 ? $price->year . ' Year' : $price->year . ' Years'
                                                    }}
                                                </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="col-6 my-2">
                                            <label class="form-label">Price</label>
                                            <input type="text" class="form-control" name="server_price" id="server_price"
                                                value="" readonly required />
                                        </div>

                                        <div class="col-6 my-2">
                                            <label class="form-label">Extra Charges</label>
                                            <input type="text" class="form-control" name="extra_charges" id="extra_charges"
                                                value="{{ $extra_charge ?? 0 }}" readonly />
                                        </div>


                                        <div class="col-6 my-2">
                                            <label class="form-label">Amount</label>
                                            <input type="text" class="form-control" name="server_amount" id="server_amount"
                                                value="" readonly />
                                        </div>


                                        <div class="col-6 my-2">
                                            <label class="form-label"> Taxes ( 18.00 % )</label>
                                            <input type="hidden" class="form-control" name="period" id="period" value=""
                                                readonly required />
                                            <input type="hidden" class="form-control" name="server_price_taxper"
                                                id="server_price_taxper" value="" readonly required />
                                            <input type="text" class="form-control" name="server_price_tax"
                                                id="server_price_tax" value="" readonly required />
                                        </div>


                                        <div class="col-6 my-2">
                                            <label class="form-label">Total Amount</label>
                                            <input type="text" class="form-control" name="server_price_total"
                                                id="server_price_total" value="" readonly required />
                                        </div>

                                        <div class="row mb-3">
                                            <div class="col-12 mt-3 float-end">
                                                <label class="form-label"></label>
                                                <a href="{{ url()->previous() }}"> <input type="button"
                                                        class="btn btn-danger mr-3" id="back" name="back"
                                                        value="Back" /></a>
                                                <button type="submit" class="btn btn-success ml-4 myButton"
                                                    id="add-server-smt-btn" style="display:none">Proceed to
                                                    Payment</button>
                                            </div>
                                        </div>

                                    </form> --}}
                                    <div id="errorAlert" class="alert alert-danger d-none" role="alert"></div>

                                    <form method="POST" id="DomainSubmit">
                                        @csrf
                                        <input type="hidden" class="form-control" name="transaction_type"
                                            id="transaction_type" value="domainRenewal" readonly />

                                        <input type="hidden" class="form-control" name="discountPercent"
                                            id="discountPercent" value="" />

                                        <input type="hidden" id="discountAmount" name="discountAmount" value="">

                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th>Type</th>
                                                    <th>Domain Name</th>
                                                    <th>Expiry Date</th>
                                                    <th>Years</th>
                                                    <th>New Expiry</th>
                                                    <th>Pricing Details</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php
                                                    $domain = $user_domains->first();
                                                @endphp

                                                @if ($domain)
                                                    {{-- Domain Row --}}

                                                    <tr class="Domain">
                                                        <input type="hidden" name="remarkDomain" value="Domain Renewal Fee" />
                                                        <td><input type="checkbox" class="checkDomain" name="checkboxdomain"
                                                                value="checkDomain" checked> Domain</td>
                                                        <td>{{ $domain->domainName }}</td>
                                                        <td class="domainExpiryDate" id="domainExpiryDate">
                                                            {{ date('d/m/Y', strtotime($domain->domainExpiryDate)) }}
                                                        </td>
                                                        <td>
                                                            <select name="yearsDomain" class="form-control service_duration"
                                                                data-domain="{{ $domain->id }}">
                                                                <option value="">Select Years</option>
                                                                @foreach ($renew_prices as $price)
                                                                    {{-- <option value="{{ $price->id }}" {{ $price->year == 1 ?
                                                                        'selected' : '' }}>
                                                                        {{ $price->year == 1 ? '1 Year' : $price->year . ' Years' }}
                                                                    </option> --}}
                                                                    <option value="{{ $price->id }}">
                                                                        {{ $price->year == 1 ? '1 Year' : $price->year . ' Years' }}
                                                                    </option>
                                                                @endforeach
                                                            </select>
                                                            <input type="hidden" class="new_domain_year" name="domain_year"
                                                                value="">
                                                        </td>
                                                        <td class="new-expiry-date_D" id="newDomainExpiryDate"></td>
                                                        <td>
                                                            <div><strong>Price:</strong> ₹ <span
                                                                    class="domain_price">0.00</span></div>
                                                            {{-- <div><strong>Extra Charges:</strong> ₹ <span
                                                                    class="domain_extra_charges">{{ $extra_charge ?? 0 }}</span>
                                                            </div> --}}

                                                            <div>
                                                                <strong>
                                                                    @if (Auth::user()->domainStatus == 7)
                                                                        Reactivation Charges:
                                                                    @elseif (Auth::user()->domainStatus == 8)
                                                                        restorable Charges:
                                                                    @else
                                                                        Extra Charges:
                                                                    @endif
                                                                </strong>
                                                                ₹ <span
                                                                    class="domain_extra_charges">{{ $extra_charge ?? 0 }}</span>
                                                            </div>

                                                            <div style="display: none;"><strong>Amount:</strong> ₹ <span
                                                                    class="domain_amount">0.00</span></div>
                                                            <div style="display: none;"><strong>Tax (18%):</strong> ₹ <span
                                                                    class="domain_price_tax">0.00</span></div>
                                                            <div style="display: none;"><strong>Total:</strong> ₹ <span
                                                                    class="domain_server_price_total">0.00</span></div>
                                                        </td>
                                                        <input type="hidden" name="domain_server_price_taxper"
                                                            class="domain_server_price_taxper" data-domain="{{ $domain->id }}">
                                                        <input type="hidden" name="period" class="periodDomain"
                                                            data-domain="{{ $domain->id }}">
                                                    </tr>

                                                    {{-- DNS --}}
                                                    @if ($domain->server_type == 1)
                                                        <tr class="DNS" id="DNS">
                                                            <input type="hidden" name="remarkDNS" value="DNS Renewal Fee" />
                                                            <td><input type="checkbox" class="checkDNS" name="checkboxDomainName"
                                                                    value="checkDNS" checked> DNS
                                                            </td>
                                                            <td>{{ $domain->domainName }}</td>
                                                            {{-- <td class="DNS_expiry_date">
                                                               {{ date('d/m/Y', strtotime($domain->dnsExpiryDate)) }}
                                                            </td> --}}

                                                            <td class="DNS_expiry_date">
    {{ $domain->dnsExpiryDate ? date('d/m/Y', strtotime($domain->dnsExpiryDate)) : '-' }}
</td>

                                                            {{-- <td>
                                                                <select name="yearsDNS" class="form-control service_domain_name"
                                                                    data-domain="{{ $domain->id }}">
                                                                    <option value="">Select Years</option>
                                                                    @foreach ($renew_date as $price)
                                                                    <option value="{{ $price->id }}" {{ $price->year == 1 ?
                                                                        'selected' : '' }}>
                                                                        {{ $price->year == 1 ? '1 Year' : $price->year . ' Years' }}
                                                                    </option>
                                                                    @endforeach
                                                                </select>
                                                                <input type="hidden" name="dns_year" class="dns_year" value="">
                                                            </td> --}}


                                                            <td>
                                                                <select name="yearsDNS" class="form-control service_domain_name"
                                                                    data-domain="{{ $domain->id }}">
                                                                    <option value="">Select Years</option>
                                                                    @foreach ($renew_date as $price)
                                                                        <option value="{{ $price->id }}">
                                                                            {{ $price->years == 1 ? '1 Year' : $price->years . ' Years' }}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                                <input type="hidden" name="dns_year" class="dns_year" value="">
                                                            </td>

                                                            <td class="new-expiry-date_DNS"></td>
                                                            <td>
                                                                <div><strong>Price:</strong> ₹ <span
                                                                        class="domain_name_server_price"
                                                                        data-domain="{{ $domain->id }}">0.00</span></div>
                                                                {{-- <div><strong>Extra Charges:</strong> ₹ <span
                                                                        class="domain_name_extra_charges"
                                                                        data-domain="{{ $domain->id }}">{{ $dns_extra_charge ?? 100
                                                                        }}</span>
                                                                </div> --}}


                                                                <div>
                                                                    <strong>
                                                                        @if (Auth::user()->domainStatus == 7)
                                                                            Reactivation Charges:
                                                                        @elseif (Auth::user()->domainStatus == 8)
                                                                            restorable Charges:
                                                                        @else
                                                                            Extra Charges:
                                                                        @endif
                                                                    </strong>
                                                                    ₹ <span
                                                                        class="domain_name_extra_charges">{{ $dns_extra_charge ?? 0 }}</span>
                                                                </div>

                                                                <div style="display: none;"><strong>Amount:</strong> ₹ <span
                                                                        class="domain_name_server_amount"
                                                                        data-domain="{{ $domain->id }}">0.00</span></div>
                                                                <div style="display: none;"><strong>Tax (18%):</strong> ₹
                                                                    <span class="domain_name_server_price_tax"
                                                                        data-domain="{{ $domain->id }}">0.00</span>
                                                                </div>
                                                                <div style="display: none;"><strong>Total:</strong> ₹ <span
                                                                        class="domain_name_server_price_total"
                                                                        data-domain="{{ $domain->id }}">0.00</span>
                                                                </div>
                                                                <input type="hidden" name="domain_name_server_price_taxper"
                                                                    class="domain_name_server_price_taxper"
                                                                    data-domain="{{ $domain->id }}">
                                                                <input type="hidden" name="period_dns" class="period"
                                                                    data-domain="{{ $domain->id }}">
                                                            </td>
                                                        </tr>
                                                    @endif


                                                    {{-- Ewaas Temp --}}
                                                    @if ($domain->ewaas_temp_publish_status == 1)
                                                        <tr class="ewaas" id="ewaas">
                                                            <input type="hidden" name="remark_ewaas" value="Ewaas Renewal Fee" />
                                                            <td><input type="checkbox" class="checkEwaas" name="checkboxEwaas"
                                                                    value="checkEwaas" checked> Ewaas
                                                                service</td>
                                                            <td>{{ $domain->domainName }}</td>
                                                            <td class="ewaas_expiry_date">
                                                                {{ \Carbon\Carbon::parse($domain->EwaasExpiryDate)->format('d/m/Y') }}
                                                            </td>
                                                            <td>
                                                                <select name="years_ewaas" class="form-control ewaas_temp"
                                                                    data-domain="{{ $domain->id }}">
                                                                    <option value="">Select Years</option>
                                                                    @foreach ($renew_date as $price)
                                                                        {{-- <option value="{{ $price->id }}" {{ $price->year == 1 ?
                                                                            'selected' : '' }}>
                                                                            {{ $price->year == 1 ? '1 Year' : $price->year . ' Years' }}
                                                                        </option> --}}

                                                                        <option value="{{ $price->id }}">
                                                                            {{ $price->years == 1 ? '1 Year' : $price->years . ' Years' }}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                                <input type="hidden" name="ewaas_year" class="ewaas_year" value="">
                                                            </td>
                                                            <td class="new-expiry-date_ewaas"></td>
                                                            <td>
                                                                <div><strong>Price:</strong> ₹ <span class="ewaas_temp_server_price"
                                                                        data-domain="{{ $domain->id }}">0.00</span>
                                                                </div>
                                                                {{-- <div><strong>Extra Charges:</strong> ₹ <span
                                                                        class="ewaas_temp_extra_charges"
                                                                        data-domain="{{ $domain->id }}">{{ $ewaas_extra_charge ??
                                                                        200 }}</span>
                                                                </div> --}}



                                                                <div>
                                                                    <strong>
                                                                        @if (Auth::user()->domainStatus == 7)
                                                                            Reactivation Charges:
                                                                        @elseif (Auth::user()->domainStatus == 8)
                                                                            restorable Charges:
                                                                        @else
                                                                            Extra Charges:
                                                                        @endif
                                                                    </strong>
                                                                    ₹ <span
                                                                        class="ewaas_temp_extra_charges">{{ $ewaas_extra_charge ?? 0 }}</span>
                                                                </div>
                                                                <div style="display: none;"><strong>Amount:</strong> ₹
                                                                    <span class="ewaas_temp_server_amount"
                                                                        data-domain="{{ $domain->id }}">0.00</span>
                                                                </div>
                                                                <div style="display: none;"><strong>Tax (18%):</strong> ₹
                                                                    <span class="ewaas_temp_server_price_tax"
                                                                        data-domain="{{ $domain->id }}">0.00</span>
                                                                </div>
                                                                <div style="display: none;"><strong>Total:</strong> ₹ <span
                                                                        class="ewaas_temp_server_price_total"
                                                                        data-domain="{{ $domain->id }}">0.00</span>
                                                                </div>
                                                                <input type="hidden" name="ewaas_temp_server_price_taxper"
                                                                    class="server_price_taxper" data-domain="{{ $domain->id }}">
                                                                <input type="hidden" name="period_ewaas" class="period"
                                                                    data-domain="{{ $domain->id }}">
                                                            </td>
                                                        </tr>
                                                    @endif

                                                    {{-- Lmaas Temp --}}
                                                    @if ($domain->temp_publish_status == 1)
                                                        <tr class="lmaas">
                                                            <input type="hidden" name="remark_lmaas" value="Lmaas Renewal Fee" />
                                                            <td><input type="checkbox" class="checkLmaas" name="checkboxLmaas"
                                                                    value="checkboxLmaas" checked>
                                                                Lmaas service</td>
                                                            <td>{{ $domain->domainName }}</td>
                                                            <td class="lmaas_expiry_date">
                                                                @if ($domain->lmaas_ExpiryDate === null)
                                                                    {{ \Carbon\Carbon::parse($domain->lmaas_ExpiryDate)->format('d/m/Y') }}
                                                                @else
                                                                    {{ \Carbon\Carbon::parse($domain->lmaas_ExpiryDate)->format('d/m/Y') }}
                                                                @endif
                                                            </td>

                                                            <td>
                                                                <select name="years_lmaas" class="form-control lmaas_temp"
                                                                    data-domain="{{ $domain->id }}">
                                                                    <option value="">Select Years</option>
                                                                    @foreach ($renew_date as $price)
                                                                        {{-- <option value="{{ $price->id }}" {{ $price->year == 1 ?
                                                                            'selected' : '' }}>
                                                                            {{ $price->year == 1 ? '1 Year' : $price->year . ' Years' }}
                                                                        </option> --}}
                                                                        <option value="{{ $price->id }}">
                                                                            {{ $price->years == 1 ? '1 Year' : $price->years . ' Years' }}
                                                                        </option>
                                                                    @endforeach
                                                                </select>
                                                                <input type="hidden" name="lmaas_year" class="lmaas_year" value="">
                                                            </td>
                                                            <td class="new-expiry-date_lmaas"></td>
                                                            <td>
                                                                <div><strong>Price:</strong> ₹ <span class="lmaas_temp_server_price"
                                                                        data-domain="{{ $domain->id }}">0.00</span>
                                                                </div>
                                                                {{-- <div><strong>Extra Charges:</strong> ₹ <span
                                                                        class="lmaas_temp_extra_charges"
                                                                        data-domain="{{ $domain->id }}">{{ $lmaas_extra_charge ?? 0
                                                                        }}</span>
                                                                </div> --}}


                                                                <div>
                                                                    <strong>
                                                                        @if (Auth::user()->domainStatus == 7)
                                                                            Reactivation Charges:
                                                                        @elseif (Auth::user()->domainStatus == 8)
                                                                            restorable Charges:
                                                                        @else
                                                                            Extra Charges:
                                                                        @endif
                                                                    </strong>
                                                                    ₹ <span
                                                                        class="lmaas_temp_extra_charges">{{ $lmaas_extra_charge ?? 0 }}</span>
                                                                </div>
                                                                <div style="display: none;"><strong>Amount:</strong> ₹
                                                                    <span class="lmaas_temp_server_amount"
                                                                        data-domain="{{ $domain->id }}">0.00</span>
                                                                </div>
                                                                <div style="display: none;"><strong>Tax (18%):</strong> ₹
                                                                    <span class="lmaas_temp_server_price_tax"
                                                                        data-domain="{{ $domain->id }}">0.00</span>
                                                                </div>
                                                                <div style="display: none;"><strong>Total:</strong> ₹ <span
                                                                        class="lmaas_temp_server_price_total"
                                                                        data-domain="{{ $domain->id }}">0.00</span>
                                                                </div>
                                                                <input type="hidden" name="lmaas_temp_server_price_taxper"
                                                                    class="server_price_taxper" data-domain="{{ $domain->id }}">
                                                                <input type="hidden" name="period_lmaas" class="period"
                                                                    data-domain="{{ $domain->id }}">
                                                            </td>
                                                        </tr>
                                                    @endif
                                                @endif
                                            </tbody>
                                        </table>
                                        <div class="m-2 d-flex justify-content-end">
                                            <div
                                                style="background-color: #1563AA; color: #fff; padding: 10px; border-radius: 8px; width: 300px;">
                                                <div style="display: flex; justify-content: space-between;">
                                                    <span> Cost Without Gst :</span> <span>₹<span
                                                            id="total-amount">0.00</span></span>
                                                </div>
                                                <div style="display: flex; justify-content: space-between;">
                                                    <span id="Discount">Discount (at ) :</span> <span>₹<span
                                                            id="total-discount">0.00</span></span>
                                                </div>
                                                <div style="display: flex; justify-content: space-between;">
                                                    {{-- <span>Total Extra Charges:</span> --}}
                                                    <span>
                                                        @if (Auth::user()->domainStatus == 7)
                                                            Reactivation Charges :
                                                        @elseif (Auth::user()->domainStatus == 8)
                                                            Restorable Charges :
                                                        @else
                                                            Extra Charges :
                                                        @endif
                                                    </span>
                                                    <span>₹<span id="extra-charges">0.00</span></span>
                                                </div>

                                                <div style="display: flex; justify-content: space-between;">
                                                    <span>Amount after Discount :</span> <span>₹<span
                                                            id="all-total-amount">0.00</span></span>
                                                </div>
                                                <div style="display: flex; justify-content: space-between;">
                                                    <span>GST Tax (at 18%) :</span> <span>₹<span
                                                            id="total-gst">0.00</span></span>
                                                </div>
                                                <div style="display: flex; justify-content: space-between;">
                                                    <span>Total Price :</span> <span>₹<span
                                                            id="grand-total">0.00</span></span>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="text-end">
                                            <button type="submit" class="btn btn-primary">Submit</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    {{--
    <script type="module" src="https://pay.billdesk.com/jssdk/v1/dist/billdesksdk/billdesksdk.esm.js"></script>
    <script nomodule="" src="https://pay.billdesk.com/jssdk/v1/dist/billdesksdk.js"></script> --}}
    <script src="https://code.jquery.com/jquery-latest.min.js"></script>
    {{--
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> --}}
    <script type="module" src="https://uat1.billdesk.com/merchant-uat/sdk/dist/billdesksdk/billdesksdk.esm.js"></script>
    </script>
    <script nomodule="" src="https://uat1.billdesk.com/merchant-uat/sdk/dist/billdesksdk.js"></script>
    <script src="https://code.jquery.com/jquery-latest.min.js"></script>
    <link href="https://uat1.billdesk.com/merchant-uat/sdk/dist/billdesksdk/billdesksdk.css" rel="stylesheet">


    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css"
        integrity="sha384-HSMxcRTRxnN+Bdg0JdbxYKrThecOKuH5zCYotlSAcp1+c8xmyTe9GYg1l9a69psu" crossorigin="anonymous">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>

    <script src="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"
        integrity="sha384-aJ21OjlMXNL5UyIl/XNwTMqvzeRMZH2w8c5cRVpzpU8Y5bApTppSuUkhZXN0VxHd" crossorigin="anonymous">
        </script>

    {{--
    <script type="module" src="https://uat1.billdesk.com/merchant-uat/sdk/dist/billdesksdk/billdesksdk.esm.js"></script>
    <script nomodule="" src="https://uat1.billdesk.com/merchant-uat/sdk/dist/billdesksdk.js"></script>
    <link href="https://uat1.billdesk.com/merchant-uat/sdk/dist/billdesksdk/billdesksdk.css" rel="stylesheet"> --}}


    <script>
        function showError(message) {
            $('#errorAlert').removeClass('d-none').html(message);
            setTimeout(() => {
                document.getElementById("errorAlert").classList.add("d-none");
            }, 3000);

        }

        function hideError() {
            $('#errorAlert').addClass('d-none').html('');
        }


        $('.checkDomain').on('change', function () {
            if ($(this).is(':checked')) {
                
                domainChecked = true;
            } else {
                
                domainChecked = false;
            }
        });
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $('#DomainSubmit').on('submit', function (e) {
                e.preventDefault();
                let transaction_type = $('#transaction_type').val();
                let discountAmount = $('#discountAmount').val();
                let discountPercent = $('#discountPercent').val();



                // alert(transaction_type);
                let formData = {};
                formData['transaction_type'] = transaction_type;
                formData['discountAmount'] = discountAmount;
                formData['discountPercent'] = discountPercent;
                let isValid = true;
                let domainChecked = false;
                let dnsChecked = false;
                let ewaasChecked = false;
                let lmaasChecked = false;

                let totalAmount = $('#grand-total').text();
                formData['amount'] = totalAmount;

                let DomainExpiryDateOld = $(this).find('.domainExpiryDate').text().trim();
                if (DomainExpiryDateOld !== '') {
                    formData['domainExpiryDateOld'] = DomainExpiryDateOld;
                }

                // DOMAIN
                $('.Domain').each(function () {
                    let checkbox = $(this).find('.checkDomain');
                    if (checkbox.is(':checked')) {
                        domainChecked = true;
                        $(this).find('input, select, textarea').each(function () {
                            if ($(this).attr('name')) {
                                formData[$(this).attr('name')] = $(this).val();
                            }
                        });
                        // let DomainExpiryDateOld = $(this).find('.domainExpiryDate').text();
                        // if (DomainExpiryDateOld !== '') {
                        //     formData['domainExpiryDateOld'] = DomainExpiryDateOld;
                        // }
                        let newExpiryDate = $(this).find('#newDomainExpiryDate').text();
                        if (newExpiryDate !== '') {
                            formData['newDomainExpiryDate'] = newExpiryDate;
                        }
                        formData['domain_price'] = $(this).find('.domain_price').text().trim();
                        formData['domain_extra_charges'] = $(this).find('.domain_extra_charges')
                            .text().trim();
                        formData['domain_amount'] = $(this).find('.domain_amount').text().trim();
                        formData['domain_price_tax'] = $(this).find('.domain_price_tax').text()
                            .trim();
                        formData['domain_price_total'] = $(this).find('.domain_server_price_total')
                            .text().trim();
                    }
                });
                // DNS
                $('.DNS').each(function () {
                    let checkbox = $(this).find('.checkDNS');
                    if (checkbox.is(':checked')) {
                        dnsChecked = true;
                        $(this).find('input, select, textarea').each(function () {
                            if ($(this).attr('name')) {
                                formData[$(this).attr('name')] = $(this).val();
                            }
                        });
                        let DNS_expiry_date = $(this).find('.DNS_expiry_date').text().trim();
                        if (DNS_expiry_date !== '') {
                            formData['DNS_expiry_date'] = DNS_expiry_date;
                        }
                        let newExpiryDate = $(this).find('.new-expiry-date_DNS').text();
                        if (newExpiryDate !== '') {
                            formData['New_DNS_Date'] = newExpiryDate;
                        }
                        formData['domain_name_server_price'] = $(this).find(
                            '.domain_name_server_price').text().trim();
                        formData['domain_name_extra_charges'] = $(this).find(
                            '.domain_name_extra_charges')
                            .text().trim();
                        formData['domain_name_server_amount'] = $(this).find(
                            '.domain_name_server_amount').text().trim();
                        formData['domain_name_server_price_tax'] = $(this).find(
                            '.domain_name_server_price_tax').text()
                            .trim();
                        formData['domain_name_server_price_total'] = $(this).find(
                            '.domain_name_server_price_total')
                            .text()
                            .trim();

                    }
                });

                // EWAAS
                $('.ewaas').each(function () {
                    let checkbox = $(this).find('.checkEwaas');
                    if (checkbox.is(':checked')) {
                        ewaasChecked = true;
                        $(this).find('input, select, textarea, td').each(function () {
                            if ($(this).attr('name')) {
                                formData[$(this).attr('name')] = $(this).val();
                            }
                        });

                        let ewaas_expiry_date = $(this).find('.ewaas_expiry_date').text().trim();
                        if (ewaas_expiry_date !== '') {
                            formData['ewaas_expiry_date'] = ewaas_expiry_date;
                        }
                        let newExpiryDate = $(this).find('.new-expiry-date_ewaas').text();
                        if (newExpiryDate !== '') {
                            formData['new_expiry_date_ewaas'] = newExpiryDate;
                        }
                        formData['ewaas_temp_server_price'] = $(this).find(
                            '.ewaas_temp_server_price').text().trim();
                        formData['ewaas_temp_extra_charges'] = $(this).find(
                            '.ewaas_temp_extra_charges')
                            .text().trim();
                        formData['ewaas_temp_server_amount'] = $(this).find(
                            '.ewaas_temp_server_amount').text().trim();
                        formData['ewaas_temp_server_price_tax'] = $(this).find(
                            '.ewaas_temp_server_price_tax').text()
                            .trim();
                        formData['ewaas_temp_server_price_total'] = $(this).find(
                            '.ewaas_temp_server_price_total')
                            .text()
                            .trim();

                    }
                });

                // LMAAS
                $('.lmaas').each(function () {
                    let checkbox = $(this).find('.checkLmaas');
                    if (checkbox.is(':checked')) {
                        lmaasChecked = true;
                        $(this).find('input, select, textarea, td').each(function () {
                            if ($(this).attr('name')) {
                                formData[$(this).attr('name')] = $(this).val();
                            }
                        });
                        let lmaas_expiry_date = $(this).find('.lmaas_expiry_date').text().trim();
                        if (lmaas_expiry_date !== '') {
                            formData['lmaas_expiry_date'] = lmaas_expiry_date;
                        }
                        let newExpiryDate = $(this).find('.new-expiry-date_lmaas').text();
                        if (newExpiryDate !== '') {
                            formData['new_expiry_date_lmaas'] = newExpiryDate;
                        }
                        formData['lmaas_temp_server_price'] = $(this).find(
                            '.lmaas_temp_server_price').text().trim();
                        formData['lmaas_temp_extra_charges'] = $(this).find(
                            '.lmaas_temp_extra_charges')
                            .text().trim();
                        formData['lmaas_temp_server_amount'] = $(this).find(
                            '.lmaas_temp_server_amount').text().trim();
                        formData['lmaas_temp_server_price_tax'] = $(this).find(
                            '.lmaas_temp_server_price_tax').text()
                            .trim();
                        formData['lmaas_temp_server_price_total'] = $(this).find(
                            '.lmaas_temp_server_price_total')
                            .text()
                            .trim();

                    }
                });

                function parseDateDMY(dateStr) {
                    if (!dateStr || !dateStr.includes('/')) {
                        console.log('Invalid or empty date string:', dateStr);
                        return null; // or handle accordingly
                    }

                    const [day, month, year] = dateStr.split('/');
                    return new Date(`${year}-${month}-${day}`);
                }


                if (domainChecked) {
                    // alert("hi");
                    let domainDate = parseDateDMY(formData.newDomainExpiryDate);
                    // alert(domainDate);
                    if (dnsChecked) {
                        let dnsDate = parseDateDMY(formData.New_DNS_Date);
                        if (dnsDate > domainDate) {
                            // alert(dnsDate > domainDate);
                            // showError('New DNS Expiry Date must be before Domain Expiry Date.');
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'New DNS Expiry Date must be less than or equal to Domain Expiry Date.',
                            });
                            isValid = false;
                        }
                    }
                    if (ewaasChecked) {
                        let ewaasDate = parseDateDMY(formData.new_expiry_date_ewaas);
                        if (ewaasDate > domainDate) {
                            // alert(ewaasDate > domainDate);
                            // showError('New EWAAS Expiry Date must be after Domain Expiry Date.');
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'New EWAAS Expiry Date must be less than or equal to Domain Expiry Date.',
                            });

                            isValid = false;
                        }
                    }
                    if (lmaasChecked) {
                        let lmaasDate = parseDateDMY(formData.new_expiry_date_lmaas);
                        if (lmaasDate > domainDate) {
                            // showError('New LMAAS Expiry Date must less than or equal to Domain Expiry Date.');
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'New LMAAS Expiry Date must be less than or equal to Domain Expiry Date.',
                            });

                            isValid = false;
                        }
                    }
                }
                if (!domainChecked) {

                    let domainDate = parseDateDMY(formData.domainExpiryDateOld);
                    if (dnsChecked) {
                        let dnsDate = parseDateDMY(formData.New_DNS_Date);
                        if (dnsDate > domainDate) {
                            // alert(dnsDate);
                            // alert( domainDate);
                            // showError('DNS Expiry Date must be less than or equal to Domain Expiry Date.');
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'DNS Expiry Date must be less than or equal to Domain Expiry Date.',
                            });
                            isValid = false;
                        }
                    }
                    if (ewaasChecked) {
                        let ewaasDate = parseDateDMY(formData.new_expiry_date_ewaas);
                        if (ewaasDate > domainDate) {
                            // showError(
                            // 'EWAAS Expiry Date must be less than or equal to Domain Expiry Date.');
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'EWAAS Expiry Date must be less than or equal to Domain Expiry Date.',
                            });
                            isValid = false;
                        }
                    }
                    if (lmaasChecked) {
                        let lmaasDate = parseDateDMY(formData.new_expiry_date_lmaas);
                        if (lmaasDate > domainDate) {
                            // showError(
                            // 'LMAAS Expiry Date must be less than or equal to Domain Expiry Date.');
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'LMAAS Expiry Date must be less than or equal to Domain Expiry Date.',
                            });
                            isValid = false;
                        }
                    }
                }
                if (!isValid) {
                    return;
                }


                // alert("12");
                $.ajax({
                    url: "{{ route('createBilldeskOrder') }}",
                    type: "POST",
                    dataType: "json",
                    data: formData,
                    success: function (response) {
                        console.log(response);

                        //alert(response.mid);
                        if (response.status == 'success') {
                            var flow_config = {
                                merchantId: response.mid,
                                bdOrderId: response.orderId,
                                authToken: response.otoken,
                                childWindow: false,
                                returnUrl: response.ru,
                                retryCount: 3,
                                prefs: {
                                    "payment_categories": ["card", "nb", "upi"],
                                    // "allowed_bins": ["459150", "525211"]
                                },
                                netBanking: {
                                    "showPopularBanks": "Y",
                                    "popularBanks": ["Kotak Bank", " AXIS Bank [Retail]"],
                                }
                            }
                            var theme_config = {
                                sdkPrimaryColor: response.sdkPrimaryColor,
                                sdkAccentColor: response.sdkAccentColor,
                                sdkBackgroundColor: response.sdkBackgroundColor,
                                sdkBannerColor: response.sdkBannerColor
                            }
                            var config = {
                                responseHandler: responseHandler,
                                merchantLogo: response.logo,
                                flowConfig: flow_config,
                                flowType: "payments",
                                themeConfig: theme_config
                            }
                            $('#overlay').hide();

                            window.loadBillDeskSdk(config);
                        } else if (response.status == 'error') {
                            Swal.fire({
                                icon: 'error',
                                text: 'Please try again',
                                showConfirmButton: true,
                            })
                        }
                    },


                });

            });
        });
    </script>

    <script>
        $(document).ready(function () {
            $(document).ready(function () {
                $('.service_duration').each(function () {
                    if ($(this).val() !== "") {
                        $(this).trigger('change');
                    }
                });
            });
            $(document).on("change", ".service_duration", function () {
                let priceId = $(this).val();
                let domainId = $(this).data('domain');
                if (!priceId) return;
                $.ajax({
                    url: "{{ url('getExtensionPrices') }}/" + priceId,
                    type: "GET",
                    dataType: "json",
                    success: function (response) {
                        if (response.status === true) {
                            let extraCharge = parseFloat($(
                                `.domain_extra_charges`).text()) || 0;
                            let renewalCharge = parseFloat(response.data.renewal_charge) || 0;
                            // alert(renewalCharge);
                            let payableCharge = renewalCharge + extraCharge;
                            // alert( payableCharge  );
                            let gst = (response.data.service_tax * payableCharge) / 100;

                            let total = payableCharge + gst;
                            $(`.new-expiry-date_D`).text(response.data.new_expiry_date);
                            $(`.domain_price`).text(renewalCharge.toFixed(2));
                            $(`.domain_amount`).text(payableCharge.toFixed(2));
                            $(`.domain_price_tax`).text(gst.toFixed(2));
                            $(`.domain_server_price_total`).text(total.toFixed(2));
                            $(`.domain_price_taxper`).val(18);
                            $(`.new_domain_year`).val(response.data.year);
                            $(`.periodDomain`).val(response.data.year);
                            $(`.domain_server_price_taxper`).val(18);
                            calculateTotalAmount();

                        } else {
                            alert(response.message);
                        }
                    }
                });
            });
        });


        $(document).ready(function () {
            $(document).ready(function () {
                $('.service_domain_name').each(function () {
                    if ($(this).val() !== "") {
                        $(this).trigger('change');
                    }
                });
            });
            $(document).on("change", ".service_domain_name", function () {
                var priceId = $(this).val();
                var domainId = $(this).data('domain');
                if (!priceId) return;
                $.ajax({
                    url: "{{ url('service_domain_name') }}/" + priceId,
                    type: "GET",
                    dataType: "json",
                    success: function (response) {
                        if (response.status === true) {
                            let extraCharge = parseFloat($(
                                `.domain_name_extra_charges[data-domain="${domainId}"]`)
                                .text()) || 0;

                            let name_servers_price_renewal_charge = parseFloat(response.data
                                .name_servers_price_renewal_charge) || 0;
                            let payableCharge = name_servers_price_renewal_charge + extraCharge;
                            let gst = (response.data.service_tax * payableCharge) / 100;
                            let total = payableCharge + gst;

                            // console.log("Extra Charge:", extraCharge);
                            // console.log("Name Servers Price Renewal Charge:",
                            //     name_servers_price_renewal_charge);
                            // console.log("Payable Charge:", payableCharge);
                            // console.log("GST (18%):", gst);
                            // console.log("Total Amount:", total);


                            $(`.new-expiry-date_DNS`).text(response.data.new_expiry_date_DNS);
                            $(`.domain_name_server_price[data-domain="${domainId}"]`).text(
                                name_servers_price_renewal_charge
                                    .toFixed(2));
                            $(`.domain_name_server_amount[data-domain="${domainId}"]`).text(
                                payableCharge
                                    .toFixed(2));
                            $(`.domain_name_server_price_tax[data-domain="${domainId}"]`).text(
                                gst.toFixed(
                                    2));
                            $(`.domain_name_server_price_total[data-domain="${domainId}"]`)
                                .text(total
                                    .toFixed(2));

                            $(`.domain_name_server_price_taxper[data-domain="${domainId}"]`)
                                .val(18);
                            $(`.period[data-domain="${domainId}"]`).val(response.data.years);

                            $(`.dns_year`).val(response.data.years);
                            calculateTotalAmount();
                        } else {
                            alert(response.message);
                        }
                    }
                });
            });
        });

        $(document).ready(function () {
            $(document).ready(function () {
                $('.ewaas_temp').each(function () {
                    if ($(this).val() !== "") {
                        $(this).trigger('change');
                    }
                });
            });
            $(document).on("change", ".ewaas_temp", function () {
                var priceId = $(this).val();
                var domainId = $(this).data('domain');
                if (!priceId) return;
                $.ajax({
                    url: "{{ url('ewaas_temp') }}/" + priceId,
                    type: "GET",
                    dataType: "json",
                    success: function (response) {
                        if (response.status === true) {
                            let extraCharge = parseFloat($(
                                `.ewaas_temp_extra_charges[data-domain="${domainId}"]`)
                                .text()) || 0;

                            // console.log("Extra Charge:", extraCharge);
                            let ewaas_price_renewal_charge = parseFloat(response.data
                                .ewaas_price_renewal_charge) || 0;
                            let payableCharge = ewaas_price_renewal_charge + extraCharge;
                            let gst = (response.data.service_tax * payableCharge) / 100;
                            let total = payableCharge + gst;

                            $(`.new-expiry-date_ewaas`).text(response.data.new_expiry_date);
                            $(`.ewaas_temp_server_price[data-domain="${domainId}"]`).text(
                                ewaas_price_renewal_charge
                                    .toFixed(2));
                            $(`.ewaas_temp_server_amount[data-domain="${domainId}"]`).text(
                                payableCharge
                                    .toFixed(2));
                            $(`.ewaas_temp_server_price_tax[data-domain="${domainId}"]`).text(
                                gst.toFixed(
                                    2));
                            $(`.ewaas_temp_server_price_total[data-domain="${domainId}"]`).text(
                                total
                                    .toFixed(2));

                            $(`.ewaas_temp_server_price_taxper[data-domain="${domainId}"]`).val(
                                18);
                            $(`.period[data-domain="${domainId}"]`).val(response.data.years);
                            $(`.ewaas_year`).val(response.data.years);
                            calculateTotalAmount();
                        } else {
                            alert(response.message);
                        }
                    }
                });
            });
        });
        $(document).ready(function () {
            $(document).ready(function () {
                $('.lmaas_temp').each(function () {
                    if ($(this).val() !== "") {
                        $(this).trigger('change');
                    }
                });
            });
            $(document).on("change", ".lmaas_temp", function () {
                var priceId = $(this).val();
                var domainId = $(this).data('domain');
                if (!priceId) return;
                $.ajax({
                    url: "{{ url('lmaas_temp') }}/" + priceId,
                    type: "GET",
                    dataType: "json",
                    success: function (response) {
                        if (response.status === true) {
                            let extraCharge = parseFloat($(
                                `.lmaas_temp_extra_charges[data-domain="${domainId}"]`)
                                .text()) || 0;
                            let lmaas_price_renewal_charge = parseFloat(response.data
                                .lmaas_price_renewal_charge) || 0;
                            let payableCharge = lmaas_price_renewal_charge + extraCharge;
                            let gst = (response.data.service_tax * payableCharge) / 100;
                            let total = payableCharge + gst;
                            $(`.new-expiry-date_lmaas`).text(response.data.new_expiry_date);
                            $(`.lmaas_temp_server_price[data-domain="${domainId}"]`).text(
                                lmaas_price_renewal_charge
                                    .toFixed(2));
                            $(`.lmaas_temp_server_amount[data-domain="${domainId}"]`).text(
                                payableCharge
                                    .toFixed(2));
                            $(`.lmaas_temp_server_price_tax[data-domain="${domainId}"]`).text(
                                gst.toFixed(
                                    2));
                            $(`.lmaas_temp_server_price_total[data-domain="${domainId}"]`).text(
                                total
                                    .toFixed(2));
                            $(`.lmaas_temp_server_price_taxper[data-domain="${domainId}"]`).val(
                                18);
                            $(`.period[data-domain="${domainId}"]`).val(response.data.years);
                            $(`.lmaas_year`).val(response.data.years);
                            calculateTotalAmount();
                        } else {
                            alert(response.message);
                        }
                    }
                });
            });
        });



        // $(document).ready(function() {
        //     $('input[class="domain-checkbox"]').trigger('change');

        //     $(document).on('change', 'input[class="domain-checkbox"]', function() {
        //         var checkedCount = $('input[class="domain-checkbox"]:checked').length;
        //         if (checkedCount > 0) {
        //             $('#add-server-smt-btn').show();
        //             $('#total-amount-btn').show();
        //         } else {
        //             $('#add-server-smt-btn').hide();
        //             $('#total-amount-btn').hide();
        //         }
        //     });
        // });
    </script>



    <script>
        function calculateTotalAmount() {
            let total = 0;
            let totalDiscountAmont = 0;
            let extraCharges = 0;
            let allTotalAmount = 0;
            let totalGst = 0;
            let selectedServices = [];


            let years = [];

            $('.checkDNS:checked, .checkDomain:checked, .checkEwaas:checked, .checkLmaas:checked').each(function () {
                let row = $(this).closest('tr');
                let serviceId = $(this).val() || $(this).data('domain');
                let serviceName = $(this).attr('name') || '';

                // get hidden year input values from each row
                let domain_year = row.find('input.new_domain_year').val() || '';
                let dns_year = row.find('input.dns_year').val() || '';
                let ewaas_year = row.find('input.ewaas_year').val() || '';
                let lmaas_year = row.find('input.lmaas_year').val() || '';

                // collect all years to check uniqueness
                if (domain_year) years.push(domain_year);
                if (dns_year) years.push(dns_year);
                if (ewaas_year) years.push(ewaas_year);
                if (lmaas_year) years.push(lmaas_year);

                let totalSelector = row.find('[class*="_server_price_total"], .server_price_total, .price-total');
                let price = parseFloat(totalSelector.text()) || 0;
                total += price;


                let totalDiscount = row.find('[class*="_server_price"], .server_price, .domain_price');

                let price1 = parseInt(totalDiscount.text()) || 0;
                console.log(price1);
                totalDiscountAmont += price1;





                let getExtraCharges = row.find(
                    '.domain_extra_charges, .domain_name_extra_charges, .ewaas_temp_extra_charges, .lmaas_temp_extra_charges'
                );
                let priceExtra = parseFloat(getExtraCharges.text()) || 0;
                extraCharges += priceExtra;



                let getGst = row.find('[class*="_server_price_tax"], .domain_price_tax');
                priceGst = parseFloat(getGst.text()) || 0;

                totalGst += priceGst;
                // console.log(totalDiscountAmont);





                selectedServices.push({
                    name: serviceName,
                });
            });



            // console.log(selectedServices); 
            let uniqueYears = [...new Set(years)];
            let finalYear = '';
            if (uniqueYears.length === 1) {
                finalYear = uniqueYears[0];
            }
            if (total > 0) {
                $.ajax({
                    url: '/get-discount',
                    method: 'POST',
                    data: {
                        services: selectedServices,
                        total: total,
                        year: finalYear,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function (response) {
                        let discountPercent = response.discount && response.discount.discount ?
                            parseFloat(response.discount.discount) :
                            0;

                        $('#discountPercent').val(discountPercent);
                        let discountAmount = (totalDiscountAmont * discountPercent) / 100;
                        $('#discountAmount').val(discountAmount);

                        // console.log(discountAmount);


                        let setAllTotalAmount = totalDiscountAmont + extraCharges;




                        // let allTotalAmount = setAllTotalAmount - discountAmount;
                        let allTotalAmount = setAllTotalAmount - discountAmount;
                        let taxAmount = allTotalAmount * 0.18; // 18% tax

                        let totalGst = taxAmount;
                        let totalWithTax = allTotalAmount + taxAmount;

                        // let grandTotal = Math.ceil(total - discountAmount);
                        // let grandTotal = totalWithTax
                        let grandTotal = Math.ceil(totalWithTax);






                        // update HTML

                        $('#Discount').text(`Discount (at ${discountPercent}%):`);
                        $('#total-amount').text(totalDiscountAmont.toFixed(2));
                        $('#total-discount').text(discountAmount.toFixed(2)); // show discount amount
                        $('#extra-charges').text(extraCharges.toFixed(2));
                        $('#all-total-amount').text(allTotalAmount.toFixed(2));
                        $('#total-gst').text(totalGst.toFixed(2));
                        $('#grand-total').text(grandTotal.toFixed(2));
                        $('#total-amount-btn').show();
                        $('.myButton').show();
                    },
                    error: function (xhr) {
                        console.log("Error fetching discount:", xhr);
                        // alert('Failed to fetch discount from server.');
                    }
                });
            } else {
                // Reset totals
                $('#total-amount').text("0.00");
                $('#total-discount').text("0.00");
                $('#total-gst').text("0.00");
                $('#grand-total').text("0.00");
                $('#total-amount-btn').hide();
                $('.myButton').hide();
            }
        }

        $(document).on('change', '.checkDomain', calculateTotalAmount);
        $(document).on('change', '.checkDNS', calculateTotalAmount);
        $(document).on('change', '.checkEwaas', calculateTotalAmount);
        $(document).on('change', '.checkLmaas', calculateTotalAmount);
        $(document).on('change', 'select', calculateTotalAmount);
    </script>




    {{--
    <script>
        function calculateTotalAmount() {
            let total = 0;
            $('.checkDNS:checked, .checkDomain:checked, .checkEwaas:checked, .checkLmaas:checked').each(function () {
                let row = $(this).closest('tr');
                let domainId = $(this).val() || $(this).data('domain');
                let totalSelector = row.find('[class*="_server_price_total"], .server_price_total, .price-total');
                let price = parseFloat(totalSelector.text()) || 0;
                // console.log(totalSelector);
                total += price;
            });
            if (total > 0) {
                $('#total-amount').text(total.toFixed(2));
                $('#total-amount-btn').show();
                $('.myButton').show();
            } else {
                $('#total-amount').text("0.00");
                $('#total-amount-btn').hide();
                $('.myButton').hide();
            }
        }


        $(document).on('change', '.checkDomain', calculateTotalAmount);
        $(document).on('change', '.checkDNS', calculateTotalAmount);
        $(document).on('change', '.checkEwaas', calculateTotalAmount);
        $(document).on('change', '.checkLmaas', calculateTotalAmount);
        $(document).on('change', 'select', calculateTotalAmount);
    </script> --}}



    <script>
        $(document).ready(function () {
            var csrfToken = $('input[name="_token"]').val();
            $('#add-server-smt-btn').click(function () {
                let dataToSend = {
                    _token: csrfToken,
                    domains: []
                };
                var invalidSelection = false;
                $('.domain-checkbox:checked').each(function () {
                    var domainId = $(this).val();
                    var selectedYearId = $(`select[name='years[${domainId}]']`).val();
                    alert(selectedYearId);
                    if (!selectedYearId) {
                        alert('Please select renewal years for all selected domains.');
                        invalidSelection = true;
                        return false;
                    }
                    dataToSend.domains.push({
                        domain_id: domainId,
                        year_price_id: selectedYearId,
                    });
                });

                alert('1');

                if (invalidSelection || dataToSend.domains.length === 0) {
                    return;
                }

                $.ajax({
                    // url: "{{ route('createBilldeskOrder') }}",
                    type: "POST",
                    dataType: "json",
                    data: dataToSend,
                    success: function (response) {
                        if (response.status === 'success') {
                            var flow_config = {
                                merchantId: response.mid,
                                bdOrderId: response.orderId,
                                authToken: response.otoken,
                                childWindow: false,
                                returnUrl: response.ru,
                                retryCount: 3,
                                prefs: {
                                    "payment_categories": ["card", "nb", "upi"],
                                },
                                netBanking: {
                                    "showPopularBanks": "Y",
                                    "popularBanks": ["Kotak Bank", " AXIS Bank [Retail]"],
                                }
                            };

                            var theme_config = {
                                sdkPrimaryColor: response.sdkPrimaryColor,
                                sdkAccentColor: response.sdkAccentColor,
                                sdkBackgroundColor: response.sdkBackgroundColor,
                                sdkBannerColor: response.sdkBannerColor
                            };

                            var config = {
                                responseHandler: responseHandler,
                                merchantLogo: response.logo,
                                flowConfig: flow_config,
                                flowType: "payments",
                                themeConfig: theme_config
                            };

                            $('#overlay').hide();
                            window.loadBillDeskSdk(config);

                        } else if (response.status === 'error') {
                            Swal.fire({
                                icon: 'error',
                                text: 'Please try again',
                                showConfirmButton: true,
                            });
                        }
                    },
                    error: function () {
                        alert('Something went wrong. Please try again.');
                    }
                });
            });

        });
    </script>
    <script>
        $(document).on("change", '#service_duration', function () {
            $.ajax({
                url: "{{ url('getExtensionPrices') }}" + '/' + $(this).val(),
                dataType: "json",
                type: "get",
                success: function (response) {
                    if (response.status == true) {
                        var payablecharge = parseFloat(response.data.renewal_charge) + parseFloat(
                                {{ $extra_charge ?? 0 }});
                        $('#server_price').val(response.data.renewal_charge);
                        $('#server_amount').val(payablecharge);
                        var server_price_gst_percent = (18 * payablecharge) / 100;
                        $('#server_price_tax').val(server_price_gst_percent);
                        $('#server_price_taxper').val(18);
                        $('#period').val(response.data.year);
                        $('#server_price_total').val(parseFloat(payablecharge) + parseFloat(
                            server_price_gst_percent));
                        $('#amount').val(parseFloat(payablecharge) + parseFloat(
                            server_price_gst_percent));
                    } else if (response.status == false) {
                        alert(response.message);
                    }
                },
            });
        });

        $(document).ready(function () {

            // setTimeout(function() {
            //     Show the button after 3 seconds
            //     $('.myButton').show();
            // }, 3000);

            $('body').on('submit', '.myButton1', function (e) {

                alert('2');
                e.preventDefault();
                $('#overlay').show();
                var current = $(this);
                var data = current.serialize();
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                $.ajax({
                    // url: "{{ route('createBilldeskOrder') }}",
                    dataType: "json",
                    type: "post",
                    data: data,
                    success: function (response) {
                        if (response.status == 'success') {
                            var flow_config = {
                                merchantId: response.mid,
                                bdOrderId: response.orderId,
                                authToken: response.otoken,
                                childWindow: false,
                                returnUrl: response.ru,
                                retryCount: 3,
                                prefs: {
                                    "payment_categories": ["card", "nb", "upi"],
                                    // "allowed_bins": ["459150", "525211"]
                                },
                                netBanking: {
                                    "showPopularBanks": "Y",
                                    "popularBanks": ["Kotak Bank", " AXIS Bank [Retail]"],
                                }
                            }
                            var theme_config = {
                                sdkPrimaryColor: response.sdkPrimaryColor,
                                sdkAccentColor: response.sdkAccentColor,
                                sdkBackgroundColor: response.sdkBackgroundColor,
                                sdkBannerColor: response.sdkBannerColor
                            }
                            var config = {
                                responseHandler: responseHandler,
                                merchantLogo: response.logo,
                                flowConfig: flow_config,
                                flowType: "payments",
                                themeConfig: theme_config
                            }
                            $('#overlay').hide();

                            window.loadBillDeskSdk(config);

                        } else if (response.status == 'error') {
                            Swal.fire({
                                icon: 'error',
                                text: 'Please try again',
                                showConfirmButton: true,
                            })
                        }
                    },
                });

            });
        });

        var responseHandler = function (txn) {
            console.log("callback received status:: ", txn.status)
            console.log("callback received response:: ", txn.response)
        }
    </script>
@endsection