@extends('layouts.UserLayout')
@section('content')
@php
@endphp
<!-- Content wrapper -->
<div class="container-xxl flex-grow-1 container-p-y" xmlns="http://www.w3.org/1999/html">
    @if(Session::has('message'))
        <p class="alert text-dark {{ Session::get('alert-class', 'alert-success') }}">{{ Session::get('message') }}</p>
    @endif
  <div class="row">
    <div class="col-md-12">
      <div class="card mb-4 mt-5">
          <h5 class="card-header bg-info mb-4">Domain Renewal</h5>
          <div class="card-body">
              <div class="row ">
                  <!-- Basic List group -->
                  <div class="col-lg-12 mb-4 align-content-center  ">
                      <small class="fw-semibold"></small>
                      <div class="demo-inline-spacing mt-3 px-5">
                         <form id="domainRenewal" method="post" action="">
                             @csrf
                             <div class="row mb-3">
                                 <label class="col-md-12 text-center " for="basic-default-city">Your Domain Name :  {{Auth::user()->domainName}} </label>
                             </div>

                             <div class="col-6 my-2">
                                 <label class="form-label">Renewal Years</label>
                                 <select id="service_duration" name="year" class="form-control year" required>
                                     <option value="" class="form-control">Select years</option>
                                     @foreach($renew_prices as $price)
                                         <option value="{{$price->id}}" class="form-control">{{($price->year == 1)?$price->year. ' Year': $price->year.' Years'}} </option>
                                     @endforeach
                                 </select>
                             </div>

                             <div class="col-6 my-2">
                                 <label class="form-label">Price</label>
                                 <input type="text" class="form-control" name="server_price" id="server_price"  value="" readonly/>
                             </div>
                             <div class="col-6 my-2">
                                 <label class="form-label"> Taxes ( 18.00 % )</label>
                                 <input type="text" class="form-control" name="server_price_tax" id="server_price_tax"  value="" readonly/>
                             </div>
                             <div class="col-6 my-2">
                                 <label class="form-label">Total Amount</label>
                                 <input type="text" class="form-control" name="server_price_total" id="server_price_total" value="" readonly/>
                             </div>
                             <div class="row mb-3">
                                 <div class="col-12 mt-3 float-end">
                                     <label class="form-label"></label>
                                     <a href="{{url()->previous()}}"> <input type="button" class="btn btn-danger mr-3" id="back" name="back" value="Back"/></a>
                                     <button type="submit" class="btn btn-success ml-4" id="add-server-smt-btn" >Renew Domain</button>
                                 </div>
                             </div>

                         </form>
                      </div>

                  </div>
                  <!--/ Basic List group -->
              </div>
          </div>

      </div>
    </div>
  </div>
</div>
<!-- Content wrapper -->

@endsection
@section("js")
    <script>
        $(document).on("change",'#service_duration',function(){
            $.ajax({
                url: "{{ url('getExtensionPrices') }}"+'/'+$(this).val(),
                dataType : "json",
                type: "get",
                success : function(response) {

                    if(response.status == true) {
                        $('#server_price').val(response.data.price);
                        var server_price_gst_percent = (18*response.data.price)/100;
                        $('#server_price_tax').val(server_price_gst_percent);
                        $('#server_price_total').val(parseFloat(response.data.price)+parseFloat(server_price_gst_percent));
                    } else if(response.status == false) {
                        alert(response.message);
                    }

                },
            });
        });


        $('#domainRenewal').validate({
            submitHandler:function(form)
            {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url:"{{url('domainRenewal')}}",
                    type:'POST',
                    dataType:'json',
                    data:$("#domainRenewal").serialize(),
                    cache: false,
                    beforeSend: function(){
                        $(".loader-area").show();
                    },
                    success:function(res)
                    {
                        if(res.status == true)
                        {
                            Swal.fire({
                                icon: 'success',
                                text: 'You domain has been renewed successfully.',
                                showConfirmButton: true,
                            }).then(function () {
                                window.location.href = "{{ url('user-dashboard')}}";
                            });
                        }else if(res.status == false)
                        {
                            Swal.fire({
                                icon: 'error',
                                text: res.msg,
                                showConfirmButton: true,
                            })
                        }
                    },
                    complete: function(){
                        $(".submit").prop('disabled',false);
                    },
                });
            }
        });
    </script>
@endsection
