@extends('layouts.UserLayout')
@section('content')
@php
@endphp
<!-- Content wrapper -->
<div class="container-xxl flex-grow-1 container-p-y">
    @if(Session::has('message'))
        <p class="alert text-dark {{ Session::get('alert-class', 'alert-danger') }}">{{ Session::get('message') }}</p>
    @endif
    <div class="row">
        <!-- Domain Status Table Start-->
        <div class="col-12 my-3 mt-5">
            <!-- File input -->
            <div class="card">
                <h5 class="card-header bg-info mb-3">Documents Upload  </h5>

                <div class="card-body">
                    <div class="table-responsive text-nowrap">
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th>Document</th>
                                <th>Action</th>
                                <th>Status</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach(\Illuminate\Support\Facades\DB::table('document_category')->get() as $doc)
                                <tr>
                                    @if($doc->id!=3)
                                        <td>
                                            {{$doc->title}}<span>&nbsp; <a href="{{url('format_pdf/'.$doc->id)}}"> Required format</a></span>
                                        </td>
                                    @else
                                        <td>
                                            {{$doc->title}}<span>&nbsp; <a href="{{asset('Annexure-C.pdf')}}" target="_blank"> Required format</a></span>
                                        </td>
                                    @endif
                                    <td>
                                        <form action="" class="userDocsForm" method="post" enctype="multipart/form-data">
                                            <meta name="csrf-token" content="{{ csrf_token() }}" />
                                            <input type="hidden" name="category_id" value="{{$doc->id}}">
                                            <div class="row row-{{$doc->id}} mb-3">
                                                <div class="col-6">
                                                    <input name="file" class="form-control file-{{$doc->id}}" type="file" id="formFileMultiple" required  />
                                                </div>
                                                <div class="col-4 btn-{{$doc->id}}">
                                                    <div class="">
                                                        <button type="submit" class=" submit-{{$doc->id}} btn btn-primary">Upload</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>
                                    </td>
                                    <td>

                                        <div class="row rowStatus-{{$doc->id}} mb-3">

                                        </div>
                                    </td>


                                </tr>

                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="col-12 mt-3">
                        <label class="form-label"></label>
                        <a href="{{url()->previous()}}"> <input type="button" class="btn btn-danger ml-3" id="back" name="back" value="Back"/></a>
                        <a href="{{url('user-submit-documents')}}" class="btn btn-success mr-4" id="add-server-smt-btn" >Submit</a>
                        <button class="btn btn-info mr-4" id="skipDocUpload" >Skip</button>
                    </div>
                </div>
            </div>
        </div>
        <!-- Domain Status Table End-->
    </div>
</div>
<!-- Content wrapper -->

@endsection
@section("js")
    <script type="text/javascript">
        function getData(){
            $.ajax({
                url: "{{ url('userDocsList') }}",
                dataType : "json",
                type: "get",
                success : function(response) {

                    if(response.status == true) {
                        console.log(response.data);
                        $.each( response.data, function( key, value ) {
                            $('.view-'+value.document_category_id).remove();
                            $('.submit-'+value.document_category_id).hide();
                            $('.file-'+value.document_category_id).hide();

                            $('.row-'+value.document_category_id).append(
                                ' <div class="col-4 view-'+value.document_category_id+'">\n' +
                                '                                    <div class="">\n' +
                                '                                        <a href="{{url('user/docs/')}}'+'/'+value.path+'" target="_blank" >'+value.name+'</a>\n' +
                                '                                    </div>\n' +
                                '                                </div>'
                            );

                            if (value.status == 1){
                                $('.rowStatus-'+value.document_category_id).text(
                                   'Pending Approval'
                                );
                                $('.file-'+value.document_category_id).show();
                                $('.submit-'+value.document_category_id).show();
                            }else if (value.status == 0){
                                $('.view-'+value.document_category_id).hide();
                                $('.submit-'+value.document_category_id).show();
                                $('.file-'+value.document_category_id).show();
                                $('.rowStatus-'+value.document_category_id).text(
                                   'Rejected'+'\n('+value.remarks+')'
                                );
                            }else {
                                $('.rowStatus-'+value.document_category_id).text(
                                    'Approved'
                                );
                            }

                        });

                    } else if(response.status == false) {

                        alert(response.message);

                    }

                },
            });
        }
        $(document).ready(function (e) {
            getData();
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $('.userDocsForm').submit(function(e) {
                e.preventDefault();
                // $(".submit").text('processing...');
                var formData = new FormData(this);
                $.ajax({
                    type:'POST',
                    url: "{{ url('userDocsUpload')}}",
                    data: formData,
                    cache:false,
                    contentType: false,
                    processData: false,
                    beforeSubmit: function(){
                        $(".loader-area").show();
                    },
                    success: (data) => {
                        this.reset();
                        if (data.status==true){
                            Swal.fire({
                                icon: 'success',
                                text: 'File has been uploaded successfully!',
                                showConfirmButton: true,
                            });
                        }else if(data.status==false){
                            Swal.fire({
                                icon: 'error',
                                text: data.error,
                                showConfirmButton: true,
                            });
                        }else {
                            alert('Something Went Wrong! Please try again');
                        }
                        // $(".submit").text('Uploaded');
                        getData();
                        console.log(data);
                    },
                    error: function(data){
                        console.log(data);
                    }
                });
            });
        });

        $(document).on('click','#skipDocUpload',function(){
            if (confirm('All documents are mandatory. Applicant has to upload all the documents within 30 days from the date of payment, Otherwise the application will be rejected automatically.')) {
                window.location.href = "{{ url('user-application-preview')}}";
            }
        });
    </script>
@endsection
