@extends('layouts.UserLayout')
@section('content')
<!-- <link href="https://uat1.billdesk.com/merchant-uat/sdk/dist/billdesksdk/billdesksdk.css"rel="stylesheet"> -->
<link href="https://pay.billdesk.com/jssdk/v1/dist/billdesksdk/billdesksdk.css"rel="stylesheet">

@php
@endphp
<!-- Content wrapper -->
<div class="container-xxl flex-grow-1 container-p-y" xmlns="http://www.w3.org/1999/html">
  <div class="row">
    <div class="col-md-12">
      <div class="card mb-4 mt-5">
          <h5 class="card-header bg-info mb-4">Name Server Update Payment</h5>
          <div class="card-body">
              <div class="row ">
                  <!-- Basic List group -->
                  <div class="col-lg-12 mb-4 mb-xl-0">
                      <small class=" fw-semibold"></small>
                      <!-- <form method="get" action="{{route('billdesk.initiate.payment')}}" >
                          @csrf -->

                    <form method="post" id="editdomainform">
                        @csrf

                          <div class="demo-inline-spacing mt-3">
                              <div class="list-group">
                                  <ul class="list-group">
                                      <input type="hidden" class="form-control" name="dns_price" id="dns_price"  value="50" readonly/>
                                      <input type="hidden" class="form-control" name="dns_taxper" id="dns_taxper"  value="18" readonly/>
                                      <input type="hidden" class="form-control" name="dns_tax" id="dns_tax"  value="9" readonly/>
                                      <input type="hidden" class="form-control" name="amount" id="amount"  value="59" readonly/>
                                      <input type="hidden" class="form-control" name="domain_name" id="domain_name"  value="{{Auth::user()->domainName}}" readonly/>
                                      <input type="hidden" class="form-control" name="transaction_type" id="transaction_type"  value="userNameServerUpdate" readonly/>
                                      <input type="hidden" class="form-control" name="remark" id="remark"  value="Name Server Update Fee" readonly/>
                                      <li class="list-group-item ">Domain Name : {{Auth::user()->domainName}}</li>
                                      <li class="list-group-item ">Primary Name Server : {{\Illuminate\Support\Facades\Session::get('data')['primary_name_server']}}</li>
                                      <li class="list-group-item ">Secondary Name Server : {{Session::get('data')['secondary_name_server1']}}</li>
                                      <li class="list-group-item ">Amount : ₹50</li>
                                      <li class="list-group-item ">Tax( 18.00 % ) : ₹9</li>
                                      <li class="list-group-item ">Total Amount : ₹59</li>
                                  </ul>
                              </div>
                          </div>
                          <div class="col-12 mt-3">
                              <label class="form-label"></label>
                              <a href="{{url()->previous()}}"> <input type="button" class="btn btn-danger ml-3" id="back" name="back" value="Back"/></a>
                              <button type="submit" class="btn btn-success mr-4 myButton" style="display:none"  >Make Payment</button>
                          </div>
                      </form>
                  </div>
                  <!--/ Basic List group -->
              </div>
          </div>

      </div>
    </div>
  </div>
</div>
<!-- Content wrapper -->

@endsection
@section("js")
<!-- 
<script type="module" src="https://uat1.billdesk.com/merchant-uat/sdk/dist/billdesksdk/billdesksdk.esm.js"></script></script>
<script nomodule="" src="https://uat1.billdesk.com/merchant-uat/sdk/dist/billdesksdk.js"></script> -->

<script type="module" src="https://pay.billdesk.com/jssdk/v1/dist/billdesksdk/billdesksdk.esm.js"></script></script>
<script nomodule="" src="https://pay.billdesk.com/jssdk/v1/dist/billdesksdk.js"></script> 


<script src="https://code.jquery.com/jquery-latest.min.js"></script>

<script type="text/javascript">

$(document).ready(function() {

  setTimeout(function () {
    $('.myButton').show();
  }, 1000);
        
$('body').on('submit', '#editdomainform', function(e) {
  e.preventDefault();
  $('#overlay').show();

  var current = $(this);		
  var data = current.serialize();
  $.ajaxSetup({
    headers: {
      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
    }
  });

  $.ajax({
    url: "{{route('createBilldeskOrder')}}",
    dataType : "json",
    type: "post",
    data : data,
    success : function(response) {
    if(response.status == 'success') {

var flow_config ={
merchantId:response.mid,
bdOrderId: response.orderId,
authToken: response.otoken,
childWindow: false,
returnUrl: response.ru, 
retryCount: 3,
prefs: {
 "payment_categories": ["card", "nb","upi"],
//"payment_categories": ["upi"],
// "allowed_bins": ["459150", "525211"]
 },
netBanking:{
 "showPopularBanks" : "Y",
 "popularBanks": ["Kotak Bank"," AXIS Bank [Retail]"],
}
} 

var theme_config = {
 sdkPrimaryColor: response.sdkPrimaryColor,
 sdkAccentColor: response.sdkAccentColor,
 sdkBackgroundColor: response.sdkBackgroundColor,
 sdkBannerColor: response.sdkBannerColor
}

var config = {
responseHandler: responseHandler,
merchantLogo: response.logo,
flowConfig: flow_config,
flowType: "payments",
themeConfig: theme_config
}

$('#overlay').hide();

window.loadBillDeskSdk(config);

} else if(response.status == 'error') {
        Swal.fire({
            icon: 'error',
            text: 'Please try again',
            showConfirmButton: true,
        })
      }
    },
  });
});

});

var responseHandler = function (txn) {
 console.log("callback received status:: ",txn.status)
 console.log("callback received response:: ",txn.response)
}

</script> 

@endsection
