@extends('layouts.UserLayout')
@section('content')

<style>
    
    p {
    margin-top: 0;
    margin-bottom: 0rem !important;
    }

    strong{
        color:red !important;
    }

</style>

<div class="container-xxl flex-grow-1 container-p-y">
    @if(Session::has('message'))
        <p class="alert text-dark {{ Session::get('alert-class', 'alert-danger') }}">{{ Session::get('message') }}</p>
    @endif
    <div class="row">
        <div class="col-12 my-3 mt-5">
            <div class="card">
                <h5 class="card-header bg-info mb-3">
                    <p style="float:left">Documents Upload</p>
                    <p style="float:right;color:#fff">{{\Illuminate\Support\Facades\Auth::user()->domainName}}</p>  
                 </h5>
                <div class="card-body">
                    
                    <p><b>Note: Download document first then upload duly signed  and stamped document</b></p>
                    <p><b>Hard copy of Letter of Undertaking should be submitted within 10 days</b></p>
                    <div class="table-responsive text-nowrap mt-2">
                    <table class="table table-striped table-bordered dataTable no-footer">
              <thead class="table-secondary">
                            <tr>
                                <th>Documents to be Downloaded <span style="font-weight:700!important">(Only pdf allowed,max size 2mb) </span></th>
                                <th>Documents to be Uploaded</th>
                                <th style="display:none" class="doc_status">Status</th>
                            </tr>
                            </thead>
                            <tbody>
                            @php
                                $ext = DB::table('domain_extensions')->where('id',Auth::user()->domainExtensionID)->first();
                                $ids  = explode(",",$ext->doc_ids);
                            @endphp

                            @foreach(\Illuminate\Support\Facades\DB::table('document_category')->whereIn('id',$ids)->get() as $key=> $doc)
                                    <tr>
                                    @if($doc->title == 'Letter of Undertaking' || $doc->title == 'Application Letter')
                                        <td>
                                        @if($doc->title == 'Application Letter')
                                            {{$doc->title}} <strong>*</strong>
                                            <span>&nbsp; <a href="{{url('format_pdf/'.$doc->id)}}"> {{($doc->description!=null)?$doc->description:'	download format'}}
                                            <i class="fa fa-download" aria-hidden="true"></i> </a>
                                            <br>
                                            (On institute’s letter head duly signed and stamped by head of the institute)

                                        @else
                                        {{$doc->title}} <strong>*</strong>
                                        <span>&nbsp; <a href="{{url('format_pdf/'.$doc->id)}}"> {{($doc->description!=null)?$doc->description:'	download format'}}
                                        <i class="fa fa-download" aria-hidden="true"></i> </a>
                                        @endif</span>

                                        </td>
                                        @elseif($doc->title == 'Letter of Authorization')
                                            <td>
                                                {{$doc->title}} <strong>*</strong><span>&nbsp; <a href="{{url('format_pdf/'.$doc->id)}}"> {{($doc->description!=null)?$doc->description:'	download format'}}
                                                <i class="fa fa-download" aria-hidden="true"></i> </a></span>
                                            </td>
                                        @else
                                        <td>
                                            {{$doc->title}} 

                                            @if($doc->title!="Address Proof")
                                            <strong>*</strong>
                                            @endif
                                            
                                        </td>
                                       @endif
                                    <td>
                                        <form action="" class="userDocsForm" method="post" enctype="multipart/form-data">
                                            <meta name="csrf-token" content="{{ csrf_token() }}" />
                                            <input type="hidden" name="category_id" value="{{$doc->id}}">
                                            <div class="row row-{{$doc->id}} mb-3">
                                                @if($doc->title=="Affiliation Letter")
                                                        <!-- <div class="col-6 mb-2 btn-rdo">
                                                            <label>
                                                                <input type="radio" name="file_type" value="online"  required> Online Verify
                                                            </label>
                                                        </div>
                                                        <div class="col-6 mb-2 btn-rdo">
                                                            <label>
                                                                <input type="radio" name="file_type" value="file" required>
                                                                Upload Docs
                                                            </label>
                                                        </div> -->

                                                    <!-- <div style="display: none; display: flex" id="file-option" > -->
                                                        <div class="col-6">
                                                            <input name="file" class="form-control file-{{$doc->id}}" type="file" id="formFileMultiple" required  />
                                                        </div>
                                                        <div class="col-4 btn-{{$doc->id}}" style="">
                                                          
                                                                <button type="button" class="uploaddocnew submit-{{$doc->id}} btn btn-primary" data-id="{{$key}}" data-name="{{$doc->title}}">Upload</button>
                                                      
                                                        </div>
                                                    <!-- </div> -->

                                                    <div style="display: none;" id="online-option" >
                                                        <div class="col-6">
                                                            <div class="row">

                                                            <div class="col-8">
                                                            <input name="affiliation_number" class="form-control" style="" type="text" id="onlineContent" placeholder="Affiliation Number" required />
                                                            </div>

                                                            <div class="col-4">
                                                            <button type="button" class="btn btn-success" id="onlineverify" style="">Verify</button>
                                                            </div>

                                                            </div>
                                                            <ul id="suggestionList"></ul>
                                                        </div>

                                                    </div>
                                                @else
                                                    <div class="col-6">
                                                        <input name="file" class="form-control file-{{$doc->id}}" type="file" id="formFileMultiple" required  />
                                                    </div>
                                                  @if($doc->title == 'Letter of Undertaking'  || $doc->title == 'Application Letter')
                                                    <div class="col-4 btn-{{$doc->id}}">
                                                        <div class="">
                                                            <button type="button" class="uploaddoc  submit-{{$doc->id}} btn btn-primary" data-id="{{$key}}" data-name="{{$doc->title}}">Upload</button>
                                                        </div>
                                                    </div>
                                                    @else
                                                    <div class="col-4 btn-{{$doc->id}}">
                                                        <div class="">
                                                            <button type="button" class="uploaddocnew  submit-{{$doc->id}} btn btn-primary" data-id="{{$key}}" data-name="{{$doc->title}}">Upload</button>
                                                        </div>
                                                    </div>


                                                    @endif
                                                @endif
                                            </div>
                                        </form>
                                    </td>

                                    <td class="doc_status" style="display:none">
                                        <div class="row rowStatus-{{$doc->id}} mb-3" >
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                    @if(isset($mode) && $mode=='renew')
                    <div class="col-12 mt-3">
                        <a href="{{url('renew-domain')}}" class="btn btn-success mr-4">Renew Domain</a>
                    </div>
                    @else
                    <div class="col-12 mt-3">
                        <label class="form-label"></label>
                        <a href="{{url()->previous()}}"> <input type="button" class="btn btn-danger ml-3" id="back" name="back" value="Back"/></a>
                        <a href="{{url('user-submit-documents')}}" class="btn btn-success mr-4 document_submit_button" id="add-server-smt-btn"  >Submit</a>
                        <!-- <button class="btn btn-info mr-4" id="skipDocUpload" >Skip</button> -->
                        <button type="button" class="btn btn-success document_submit_button_disabled" disabled style="display:none">Submit</button>
                        
                    </div>
                    @endif
                </div>
            </div>
        </div>
        <!-- Domain Status Table End-->
    </div>
</div>
<!-- Content wrapper -->

@endsection
@section("js")
    <script type="text/javascript">
        function getData(){
            $.ajax({
                url: "{{ url('userDocsList') }}",
                dataType : "json",
                type: "get",
                success : function(response) {
                    if(response.status == true) {
                        console.log(response.data);
                        if(response.data.length!=0){
                            $('.doc_status').show();
                        }else{
                            $('.doc_status').hide();
                            
                        }if(response.data.length==1 || response.data[0].document_category_id!=13){
                            $('.doc_status').hide();
                        }
                        $.each( response.data, function( key, value ) {
                            $('.view-'+value.document_category_id).remove();
                            $('.submit-'+value.document_category_id).hide();
                            $('.file-'+value.document_category_id).hide();
                            if(value.path!=null){
                                if(value.upload_type==1){
                                    $('.row-'+value.document_category_id).append(
                                    ' <div class="col-4 view-'+value.document_category_id+'">\n' +
                                    '                                    <div class="">\n' +
                                    '                                        Name: '+value.name+'\n' +
                                    '                                    </div>\n' +
                                        '                                    <div class="">\n' +
                                        '                                        Address : '+value.remarks+'\n' +
                                        '                                    </div>\n' +
                                    '                                    <div class="">\n' +
                                    '                                        Affiliation Number: '+value.path+'\n' +
                                    '                                    </div>\n' +
                                    '                                <span style="color:green">Online verified</span> </div>'
                                    );
                                }
                                if(value.upload_type==2){
                                    $('.row-'+value.document_category_id).append(
                                    ' <div class="col-4 view-'+value.document_category_id+'">\n' +
                                    '                                    <div class="">\n' +
                                    '                                        <a href="{{url('/user/docs/')}}/{{Auth::user()->id}}'+'/'+value.path+'" target="_blank" >'+value.name+'</a>\n' +
                                    '                                    </div>\n' +
                                    '                                </div>'
                                    );
                                }
                            }else{
                                $('.row-'+value.document_category_id).append(
                                ' <div class="col-4 view-'+value.document_category_id+'">\n' +
                                '                                    <div class="">\n' +
                                '                                       Document Verified\n' +
                                '                                    </div>\n' +
                                '                                </div>'
                                );
                            }

                            if (value.status == 1){
                                $('.rowStatus-'+value.document_category_id).text(
                                   'Pending Approval'
                                );
                                $('.file-'+value.document_category_id).show();
                                $('.submit-'+value.document_category_id).show();

                                $('.submit-'+value.document_category_id).text('Uploaded');
                                $('.submit-'+value.document_category_id).removeClass('btn btn-primary');
                                $('.submit-'+value.document_category_id).addClass('btn btn-success');
                                
                            }else if (value.status == 0){
                                $('.view-'+value.document_category_id).show();
                                $('.submit-'+value.document_category_id).show();
                                $('.file-'+value.document_category_id).show();
                                $('.rowStatus-'+value.document_category_id).text(
                                   'Rejected'+'\n('+value.remarks+')'
                                );
                            }else {
                                if(value.upload_type==1){
                                    // $('.btn-rdo').hide();
                                }
                                if(value.upload_type==2){
                                    $('.rowStatus-'+value.document_category_id).text(
                                        'Approved'
                                    );
                                }
                            }
                        });
                    } else if(response.status == false) {
                        alert(response.message);
                    }
                },
            });
        }

        function checkAllDocument(){

            $.ajax({
                url: "{{ url('checkanydocumentrequired') }}",
                dataType : "json",
                type: "get",
                success : function(response) {
                    if(response.status == true) {
                       
                        $('.document_submit_button').show();
                        $('.document_submit_button_disabled').hide();

                    } else if(response.status == false) {
                       
                        $('.document_submit_button').hide();
                        $('.document_submit_button_disabled').show();

                    }
                },
            });

        }

        $(document).ready(function (e) {
            getData();

            checkAllDocument();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $('.uploaddoc').click(function(e) {
                e.preventDefault();
                var msg=$(this).attr('data-name');


                if(msg=='Application Letter'){
                    var confirms = "Application Letter has been submitted on Institute's Letter Head?";
                }else{
                    var confirms =msg+ ' has been submitted on stamp paper?';
                }

                        Swal.fire({
                            title: 'Confirmation',
                            text: confirms,
                            icon: 'question',
                            showCancelButton: true,
                            confirmButtonText: 'Yes',
                            cancelButtonText: 'No'
                        }).then((result) => {
                            if (result.isConfirmed) {

                var id=$(this).attr('data-id');
                var formData = new FormData($('.userDocsForm')[id]);
                $.ajax({
                    type:'POST',
                    url: "{{ url('userDocsUpload')}}",
                    data: formData,
                    cache:false,
                    contentType: false,
                    processData: false,
                    beforeSubmit: function(){
                        $(".loader-area").show();
                    },
                    success: (data) => {
                        // this.reset();
                        if (data.status==true){
                            Swal.fire({
                                icon: 'success',
                                text: 'File has been uploaded successfully!',
                                showConfirmButton: true,
                            });
                        }else if(data.status==false){
                            Swal.fire({
                                icon: 'error',
                                text: data.error,
                                showConfirmButton: true,
                            });
                        }else {
                            alert('Something Went Wrong! Please try again');
                        }
                        // $(".submit").text('Uploaded');
                        getData();
                        checkAllDocument();
                        console.log(data);
                    },
                    error: function(data){
                        console.log(data);
                    }
                });

                            }
                        });
            //     if(confirm(confirms)){
               
            //    }
            });

            //For Non Prompt alert
            $('.uploaddocnew').click(function(e) {
                e.preventDefault();

                        

                var id=$(this).attr('data-id');
                var formData = new FormData($('.userDocsForm')[id]);
                $.ajax({
                    type:'POST',
                    url: "{{ url('userDocsUpload')}}",
                    data: formData,
                    cache:false,
                    contentType: false,
                    processData: false,
                    beforeSubmit: function(){
                        $(".loader-area").show();
                    },
                    success: (data) => {
                        // this.reset();
                        if (data.status==true){
                            Swal.fire({
                                icon: 'success',
                                text: 'File has been uploaded successfully!',
                                showConfirmButton: true,
                            });
                        }else if(data.status==false){
                            Swal.fire({
                                icon: 'error',
                                text: data.error,
                                showConfirmButton: true,
                            });
                        }else {
                            alert('Something Went Wrong! Please try again');
                        }
                        // $(".submit").text('Uploaded');
                        getData();
                        checkAllDocument();
                        console.log(data);
                    },
                    error: function(data){
                        console.log(data);
                    }
                });

                            
                        });
            
        });
        $(document).on('click','#skipDocUpload',function(){
            if (confirm('All documents are mandatory. Applicant has to upload all the documents within 30 days from the date of payment, Otherwise the application will be rejected automatically.')) {
                window.location.href = "{{ url('user-application-preview')}}";
            }
        });

        $(document).ready(function() {
            $(document).on('change', 'input[name="file_type"]', function() {
                var selectedOption = $(this).val();
                if (selectedOption === 'file') {
                    $('#file-option').show();
                    $('#online-option').hide();
                } else if (selectedOption === 'online') {
                    $('#file-option').hide();
                    $('#online-option').show();
                } else {
                    $('#file-option').hide();
                    $('#online-option').hide();
                }
            });


        });




$(document).ready(function() {
    {{--$('#onlineContent').keyup(function() {--}}
    {{--    var query = $(this).val();--}}
    {{--    var v_token = "{{csrf_token()}}";--}}

    {{--    if (query.length === 7) {--}}
    {{--        $.ajax({--}}
    {{--            type: "GET",--}}
    {{--            url: "{{ url('/school_affilation_suggestion')}}",--}}
    {{--            data: { query: query, _token: v_token },--}}
    {{--            success: function(data) {--}}
    {{--                var suggestions = data;--}}
    {{--                if (suggestions.length > 0) {--}}
    {{--                    var selectedSchool = suggestions[0].school_name;--}}
    {{--                    var confirmMessage = 'As per the entered Affiliation No., your School/Institute Name is : ' + selectedSchool + ' Kindly confirm?' ;--}}
    {{--                    Swal.fire({--}}
    {{--                        title: 'Confirmation',--}}
    {{--                        text: confirmMessage,--}}
    {{--                        icon: 'question',--}}
    {{--                        showCancelButton: true,--}}
    {{--                        confirmButtonText: 'Yes',--}}
    {{--                        cancelButtonText: 'No'--}}
    {{--                    }).then((result) => {--}}
    {{--                        if (result.isConfirmed) {--}}
    {{--                            var school_name = suggestions[0].school_name;--}}
    {{--                            var aff_no = suggestions[0].aff_no;--}}
    {{--                            $.ajax({--}}
    {{--                                type:"POST",--}}
    {{--                                url:"{{ url('/school_affilation_save')}}",--}}
    {{--                                data:{school_name:school_name,aff_no:aff_no,_token: v_token},--}}
    {{--                                success:function(data) {--}}
    {{--                                    if (data.status) {--}}
    {{--                                        Swal.fire({--}}
    {{--                                            title: 'Verified',--}}
    {{--                                            text: 'Your Affiliation number is verified.',--}}
    {{--                                            icon: 'success'--}}
    {{--                                        }).then(() => {--}}
    {{--                                            location.reload(); // Reload the page--}}
    {{--                                        });;--}}
    {{--                                    } else {--}}
    {{--                                        Swal.fire({--}}
    {{--                                            title: 'Error',--}}
    {{--                                            text: 'Failed to verify your number.',--}}
    {{--                                            icon: 'error'--}}
    {{--                                        });--}}
    {{--                                    }--}}
    {{--                                }--}}
    {{--                            });--}}
    {{--                        } else {--}}
    {{--                            // User canceled, handle accordingly--}}
    {{--                            $('#onlineContent').val(''); // Clear the input field--}}
    {{--                        }--}}
    {{--                    });--}}
    {{--                }else {--}}
    {{--                    $('#onlineContent').val('');--}}
    {{--                    Swal.fire({--}}
    {{--                        title: 'Error',--}}
    {{--                        text: 'No data found for the provided number.',--}}
    {{--                        icon: 'error'--}}
    {{--                    });--}}
    {{--                }--}}
    {{--            }--}}
    {{--        });--}}
    {{--    }--}}
    {{--});--}}

    $('#onlineverify').click(function() {
        var query = $('#onlineContent').val();
        var v_token = "{{csrf_token()}}";
        if (query.length>=0) {
            $.ajax({
                type: "GET",
                url: "{{ url('/school_affilation_suggestion')}}",
                data: { query: query, _token: v_token },
                success: function(data) {
                    var suggestions = data;
                    if (suggestions.length > 0) {
                        
                        var matchname="{{Auth::user()->institute}}";

                        var selectedSchool = suggestions[0].school_name;

                        if(matchname==selectedSchool){
                        var confirmMessage = 'As per the entered Affiliation No.' + suggestions[0].aff_no + ', your School/Institute Name is: ' + selectedSchool + ', ' + suggestions[0].address + '.\n       Kindly confirm?' ;
                        Swal.fire({
                            title: 'Confirmation',
                            text: confirmMessage,
                            icon: 'question',
                            showCancelButton: true,
                            confirmButtonText: 'Yes',
                            cancelButtonText: 'No'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                var school_name = suggestions[0].school_name;
                                var address = suggestions[0].address;
                                var aff_no = suggestions[0].aff_no;
                                $.ajax({
                                    type:"POST",
                                    url:"{{ url('/school_affilation_save')}}",
                                    data:{school_name:school_name,address:address,aff_no:aff_no,_token: v_token},
                                    success:function(data) {
                                        if (data.status) {
                                            Swal.fire({
                                                title: 'Verified',
                                                text: 'Your Affiliation number is verified.',
                                                icon: 'success'
                                            }).then(() => {
                                                location.reload(); 
                                            });;
                                        } else {
                                            Swal.fire({
                                                title: 'Error',
                                                text: 'Failed to verify your number.',
                                                icon: 'error'
                                            });
                                        }
                                    }
                                });
                            } else {
                                // User canceled, handle accordingly
                                $('#onlineContent').val(''); // Clear the input field
                            }
                        });
                    }else{

                        $('#onlineContent').val('');
                        Swal.fire({
                            title: 'Error',
                            text: 'No data found for the Affiliation number provided.',
                            icon: 'error'
                        });

                    }
                    }else {
                        $('#onlineContent').val('');
                        Swal.fire({
                            title: 'Error',
                            text: 'No data found for the Affiliation number provided.',
                            icon: 'error'
                        });
                    }
                }
            });
        }
    });
});

    </script>
@endsection
