@extends('layouts.UserLayout')
@section('content')
@php
@endphp

<style>

p {
    margin-top: 0;
    margin-bottom: 0rem !important;
}

li.list-group-item {
    color: #000000;
}
.heading {
    font-size: 20px;
}
</style>

<div class="container-xxl flex-grow-1 container-p-y">

    <div class="card mb-4">
        <h5 class="card-header bg-info mb-3">
        <p style="float:left">Application Details - Preview</p> 
        <p style="float:right;color:#fff">{{\Illuminate\Support\Facades\Auth::user()->domainName}}</p> 
     </h5>

     @if(Session::has('message'))
          <p class="alert text-dark {{ Session::get('alert-class', 'alert-success') }}">{{ Session::get('message') }}</p>
      @endif
      
        <div class="card-body">
            <div class="row ">
                <div class="col-lg-12 mb-4 mb-xl-0">
                    <small class=" fw-semibold heading">Academic Institution Details
                        @if(\Illuminate\Support\Facades\Auth::user()->domainStatus < 5)
                            <a href="{{url('add-contact-details')}}" class="btn btn-info btn-sm"  ><i class="bx bx-edit"></i> Edit</a>
                        @endif
                    </small>
                    <div class="demo-inline-spacing mt-3">
                        <div class="list-group">
                            <ul class="list-group">
                                <li class="list-group-item ">Institute Address : {{$user_contact_details->address?? '' }}</li>
                                <li class="list-group-item ">Institute State : {{$user_contact_details->state?? '' }}</li>
                                <li class="list-group-item ">Institute City : {{$user_contact_details->city?? '' }}</li>
                                <li class="list-group-item ">Institute Pin code: {{$user_contact_details->pincode?? '' }}</li>
                                <li class="list-group-item ">Institute Phone : 
                                   
                                    @if(isset($user_contact_details->prefix_phone))
                      0{{$user_contact_details->prefix_phone?? '' }}-{{$user_contact_details->phone?? '' }}
                                    @else
                                    N.A
                                
                          @endif
                                </li>
                                <li class="list-group-item ">Institute GST : {{$user_contact_details->gst_no?? 'N.A' }}</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <hr class="m-0" />
        <div class="card-body">
            <div class="row">
                <div class="col-lg-6">
                    <small class=" fw-semibold heading">Head Of Institute Details</small>
                    <div class="demo-inline-spacing mt-3">
                        <ul class="list-group">
                            <li class="list-group-item ">Head Of Institute : {{json_decode($user_contact_details->institution_head_detail)->name?? '' }}</li>
                            <li class="list-group-item ">Designation : {{json_decode($user_contact_details->institution_head_detail)->designation?? '' }}</li>
                            <li class="list-group-item ">Email : {{json_decode($user_contact_details->institution_head_detail)->email?? '' }}</li>
                            <li class="list-group-item ">Phone No : 

                            @if($user_contact_details->institution_head_detail!=null)

@if(isset(json_decode($user_contact_details->institution_head_detail)->prefix_phone))
0{{json_decode($user_contact_details->institution_head_detail)->prefix_phone?? '' }}-{{json_decode($user_contact_details->institution_head_detail)->phone?? '' }}
              @else
              N.A
          
    @endif

   @endif

                            </li>
                            <li class="list-group-item ">Mobile No : {{json_decode($user_contact_details->institution_head_detail)->mobile?? '' }}</li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-6 mb-4 mb-xl-0">
                    <small class=" fw-semibold heading">Administrative Contact Details</small>
                    <div class="demo-inline-spacing mt-3">
                        <div class="list-group">
                            <ul class="list-group">
                                <li class="list-group-item ">Name : {{json_decode($user_contact_details->administrative_detail)->name?? '' }}</li>
                                <li class="list-group-item ">Designation : {{json_decode($user_contact_details->administrative_detail)->designation?? '' }}</li>
                                <li class="list-group-item ">Email : {{json_decode($user_contact_details->administrative_detail)->email?? '' }}</li>
                                <li class="list-group-item ">Phone No :
                                @if($user_contact_details->administrative_detail!=null)

@if(isset(json_decode($user_contact_details->administrative_detail)->prefix_phone))
0{{json_decode($user_contact_details->administrative_detail)->prefix_phone?? '' }}-{{json_decode($user_contact_details->administrative_detail)->phone?? '' }}
              @else
              N.A
          
    @endif

   @endif
                                </li>
                                <li class="list-group-item ">Mobile No : {{json_decode($user_contact_details->administrative_detail)->mobile?? '' }}</li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!--/ Basic List group -->
            </div>
        </div>
        <hr class="m-0" />
        <div class="card-body">
            <div class="row">
                <!-- Basic List group -->
                <div class="col-lg-6">
                    <small class=" fw-semibold heading">Billing Contact Details
                        @if(\Illuminate\Support\Facades\Auth::user()->domainStatus == 6)
                            <a href="{{url('add-contact-details')}}" class="btn btn-info btn-sm"  ><i class="bx bx-edit"></i> Edit</a>
                        @endif
                    </small>
                    <div class="demo-inline-spacing mt-3">
                        <ul class="list-group">
                            <li class="list-group-item ">Name : {{json_decode($user_contact_details->billing_contact_detail)->name?? '' }}</li>
                            <li class="list-group-item ">Designation : {{json_decode($user_contact_details->billing_contact_detail)->designation?? '' }}</li>
                            <li class="list-group-item ">Email : {{json_decode($user_contact_details->billing_contact_detail)->email?? '' }}</li>
                            <li class="list-group-item ">Phone No : 
                                
                            @if($user_contact_details->billing_contact_detail!=null)

@if(isset(json_decode($user_contact_details->billing_contact_detail)->prefix_phone))
0{{json_decode($user_contact_details->billing_contact_detail)->prefix_phone?? '' }}-{{json_decode($user_contact_details->billing_contact_detail)->phone?? '' }}
              @else
              N.A
          
    @endif

   @endif

                        </li>
                            <li class="list-group-item ">Mobile No : {{json_decode($user_contact_details->billing_contact_detail)->mobile?? '' }}</li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-6 mb-4 mb-xl-0">
                    <small class=" fw-semibold heading">Technical Details
                        @if(\Illuminate\Support\Facades\Auth::user()->domainStatus == 6)
                            <a href="{{url('add-contact-details?tab=5')}}" class="btn btn-info btn-sm"  ><i class="bx bx-edit"></i> Edit</a>
                        @endif
                    </small>
                    <div class="demo-inline-spacing mt-3">
                        <div class="list-group">
                            <ul class="list-group">
                                <li class="list-group-item ">Name : {{json_decode($user_contact_details->technical_detail)->name?? '' }}</li>
                                <li class="list-group-item ">Designation : {{json_decode($user_contact_details->technical_detail)->designation?? '' }}</li>
                                <li class="list-group-item ">Email : {{json_decode($user_contact_details->technical_detail)->email?? '' }}</li>
                                <li class="list-group-item ">Phone No : 
                                
                                @if($user_contact_details->technical_detail!=null)

@if(isset(json_decode($user_contact_details->technical_detail)->prefix_phone))
0{{json_decode($user_contact_details->technical_detail)->prefix_phone?? '' }}-{{json_decode($user_contact_details->technical_detail)->phone?? '' }}
              @else
              N.A
          
    @endif

   @endif

                            </li>
                                <li class="list-group-item ">Mobile No : {{json_decode($user_contact_details->technical_detail)->mobile?? '' }}</li>
                            </ul>
                        </div>
                    </div>
                </div>
                <!--/ Basic List group -->
                <!-- List group with Badges & Pills -->
                <!--/ List group with Badges & Pills -->
            </div>
        </div>
        <hr class="m-0" />
        <div class="card-body">
            <div class="row">
                <!-- Basic List group -->
                <div class="col-lg-6">
                    <small class=" fw-semibold heading">DNS Name Server
                     @if(isset($user_name_server->server_type))
                     @if($user_name_server->server_type != 1)
                     <a href="{{url('dns-name-server')}}" class="btn btn-info btn-sm"  ><i class="bx bx-edit"></i> Edit</a>
                     @endif
                     @else
                     <a href="{{url('dns-name-server')}}" class="btn btn-info btn-sm"  ><i class="bx bx-edit"></i> Edit</a>
                     @endif
                     </small>
                    <div class="demo-inline-spacing mt-3">
                        <ul class="list-group">
                            <li class="list-group-item ">Primary Server : {{$user_name_server->primary_name_server?? '' }} {{($user_name_server->primary_name_server_ip)?? '' }}</li>
                            <li class="list-group-item ">Secondary Name Server 1 : {{$user_name_server->secondary_name_server1?? '' }} {{($user_name_server->secondary_name_server1_ip)?? '' }}</li>
                            <li class="list-group-item ">Secondary Name Server 2 : {{$user_name_server->secondary_name_server2?? '' }} {{($user_name_server->secondary_name_server2_ip)?? '' }}</li>
                            <li class="list-group-item ">Secondary Name Server 3 : {{$user_name_server->secondary_name_server3?? '' }} {{($user_name_server->secondary_name_server3_ip)?? '' }}</li>
                            <li class="list-group-item ">Secondary Name Server 4 : {{$user_name_server->secondary_name_server4?? '' }} {{($user_name_server->secondary_name_server4_ip)?? '' }}</li>
                            <li class="list-group-item ">Secondary Name Server 5 : {{$user_name_server->secondary_name_server5?? '' }} {{($user_name_server->secondary_name_server5_ip)?? '' }}</li>

                        </ul>
                    </div>
                </div>

                <!--/ Basic List group -->
                <!-- List group with Badges & Pills -->
                <!--/ List group with Badges & Pills -->
            </div>
        </div>
        <hr class="m-0" />
        <div class="card-body">
            <div class="row ">
                <div class="col-lg-12 mb-4 mb-xl-0">
                @if(\Illuminate\Support\Facades\Auth::user()->domainStatus < 5 && \Illuminate\Support\Facades\Auth::user()->domainStatus > 2)
                    <small class=" fw-semibold heading">Uploaded Documents Details <a href="{{url('upload-documents')}}" class="btn btn-info btn-sm"  ><i class="bx bx-edit"></i> Edit</a></small>
                @endif

                @if(\Illuminate\Support\Facades\Auth::user()->domainStatus==10)
                <small class=" fw-semibold heading">Uploaded Documents Details <a href="{{url('upload-documents')}}" class="btn btn-info btn-sm"  ><i class="bx bx-edit"></i> Edit</a></small>
                @endif
                
                    <div class="demo-inline-spacing mt-3">
                        <div class="table-responsive">

                            <form method="post" id="departmentForm">
                                {!! csrf_field() !!}
                                <table class="table table-striped table-bordered dataTable no-footer" style="border-radius: 10px">
                                <thead class="table-secondary">
                                    <tr>
                                        <th>File Name</th>
                                        <th>File Link</th>
                                        <th>Action</th>
                                        <th>Remarks</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($userdocuments as $userdoc)
                                        <tr>
                                            <td>{{$userdoc->title?? '' }}</td>
                                            @if($userdoc->upload_type==1)
                            <td>Name : {{$userdoc->name}} <br> Affiliation Number : {{$userdoc->path}}</td>
                          @endif
                          @if($userdoc->upload_type==2)
                           <td><a href="{{url('/user/docs')?? '' }}/{{Auth::user()->id}}/{{$userdoc->path?? '' }}" target="_blank">View Document</a></td>
                          @endif
                                            <!-- <td>@if($userdoc->upload_type==2)<a href="{{url('user/docs')?? '' }}/{{$userdoc->path?? '' }}" target="_blank">View Document</a>@endif</td> -->
                                            <td>
                                                @if($userdoc->status==1)
                                                   Pending Approval
                                                @elseif($userdoc->status==2)
                                                    Approved
                                                @else
                                                    Rejected
                                                @endif
                                            </td>
                                            <td>
                                            @if($userdoc->status!=2)
                                                {{$userdoc->remarks?? '' }}
                                            @else
                                               
                                            @endif
                                            </td>

                                        </tr>
                                    @endforeach

                                    </tbody>
                                </table>
                            </form>
                        </div>
                    </div>
                </div>
                <!--/ Basic List group -->
            </div>
        </div>
        <hr class="m-0" />
        <div class="card-body">
            <div class="row">
                <div class="col-12 mt-3 px-1">
                    <label class="form-label"></label>
                    <a href="{{url()->previous() }}"> <input type="button" class="btn btn-danger mr-4" id="back" name="back" value="Back"/></a>
                    @if(Auth::user()->domainStatus < 5)
                        <button class="btn btn-success ml-3" id="userApplicationSubmit" >Final Submit</button>
                    @endif

                </div>
            </div>
        </div>

    </div>


</div>
<!-- Content wrapper -->

@endsection
@section("js")

<script>
       
       @if(session('message'))

       @if(session('message')=='The Payment is Successfully done.')

            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: '{{ session('message') }}',
                customClass: {
                    container: 'alert-container'
                }
            }); 
              
        @endif
    
        @endif

</script>

    <script>
        $(document).on('click','#userApplicationSubmit',function(){
            if (confirm('Are you sure you want to submit application ?')) {
                $.ajax({
                    url: "{{url('userApplicationSubmit')}}",
                    dataType : "json",
                    type: "GET",
                    success : function(response) {
                        if(response.status == true) {
                            Swal.fire({
                                icon: 'success',
                                text: 'Your application has been submitted successfully. Domain will be allocated after verification of your payment and documents.',
                                showConfirmButton: true,
                                // showCancelButton: true,
                            }).then(function () {
                                window.location.href = "{{url('user-dashboard')}}";
                            });
                        }else if(response.status == false){
                            Swal.fire({
                                icon: 'error',
                                text: response.message,
                                showConfirmButton: true,
                                // showCancelButton: true,
                            }).then(function () {
                                window.location.href = "{{url('upload-documents')}}";
                            });
                        }
                        else {
                            window.location.href = "{{url('user-dashboard')}}";
                        }
                    },
                });
                return false;
            }
        });
    </script>
@endsection
