@extends('layouts.UserLayout')
@section('content')

<div class="content-wrapper">
    <section class="apply-domain-content mt-3 pt-5">
        <div class="container">
        <div class="card p-4">
            <div class="apply-domain-inner">
                <div>
                    <h4>Feedback Form</h4>
                    
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif
                    <div id="err" style="color: ">
                        @if(session()->has('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                        @endif
                    </div>
                </div>
                
                <div class=" row">
                    <form action="{{route('user.user_rmrk_sumbit')}}" method="post">
                        @csrf
                        <div class="row">
                        <div class="col-md-6">
                            <label for="name">Name</label>
                            <input type="text" class="form-control textbox_allow" id="name" name="name" placeholder="Enter name">
                            @error('name')
                            <p style="color: red;">{{ $message }}</p>
                            @enderror
                        </div>
                        <div class="col-md-6">
                            <label for="email">Email</label>
                            <input type="email" class="form-control" id="email" name="email" placeholder="Enter email">
                            @error('email')
                            <p style="color: red;">{{ $message }}</p>
                            @enderror
                        </div>
                        <div class="col-md-12 mt-3">
                            <label for="exampleInputPassword1">Remark</label>
                            <textarea class="form-control textbox_allow" id="remark" name="remark" rows="5" cols="5"></textarea>
                            @error('remark')
                            <p style="color: red;">{{ $message }}</p>
                            @enderror
                        </div>
                        </div>
                        <button type="submit" class="btn btn-primary  mt-3">Submit</button>
                    </form>
                </div>
            </div>
        </div>
        </div>
    </section>
</div>
<!-- Content wrapper -->


@endsection
@section("js")

<script>
    $( document ).ready(function() {
    $('.textbox_allow').on('keypress',function(e){
                                var regex=new RegExp("^[a-zA-Z0-9 ]");
                                var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
                                if(!regex.test(key)){
                                    e.preventDefault();
                                    return false;
                                }
                                });
                            });
</script>
@endsection