<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Admin\Master\PassportAuthController;
use App\Http\Controllers\Api\Admin\Master\StateController;
use App\Http\Controllers\Api\Admin\Master\CityController;
use App\Http\Controllers\Api\Admin\Master\ModuleController;
use App\Http\Controllers\Api\Admin\Master\ProgramController;
use App\Http\Controllers\Api\Admin\Master\LanguageController;
use App\Http\Controllers\Api\Admin\Master\PaymentGatewaySettingController;
use App\Http\Controllers\Api\Admin\Master\EmailSettingController;
use App\Http\Controllers\Api\Admin\Master\DocumentController;
use App\Http\Controllers\Api\Admin\Master\DiscountController;
use App\Http\Controllers\Api\Admin\Master\InstitutionController;
use App\Http\Controllers\Api\Admin\Master\BoardController;
use App\Http\Controllers\Api\Admin\PageManagementController;
use App\Http\Controllers\Api\Admin\WebsettingController;
use App\Http\Controllers\Api\Admin\Master\DomainController;
use App\Http\Controllers\Api\Admin\AdminReportController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

Route::any('billdeskresponse', [PassportAuthController::class, 'billdeskresponse']);

Route::any('domainrestore/{id}', [PassportAuthController::class, 'domainrestore']);
Route::any('domainRestoreReport/{id}', [PassportAuthController::class, 'domainRestoreReport']);

Route::any('hold/{id}', [PassportAuthController::class, 'hold']);

Route::any('skipdns/{id}', [PassportAuthController::class, 'skipdns']);

Route::post('logins', [PassportAuthController::class, 'login']);
  
Route::middleware('auth:api')->group(function () {

    //For the state
    Route::get('get-user', [PassportAuthController::class, 'userInfo']);
    Route::get('region', [StateController::class, 'RegionList']);
    Route::post('region-add', [StateController::class, 'regionAdd']);
    Route::post('region-update', [StateController::class, 'regionUpdate']);
    Route::post('region-delete', [StateController::class, 'regionDelete']);
    Route::post('region-search', [StateController::class, 'regionSearch']);
    
    //For the city
    Route::get('cities', [CityController::class, 'cityList']);
    Route::post('city-add', [CityController::class, 'cityAdd']);
    Route::post('city-update', [CityController::class, 'cityUpdate']);
    Route::post('city-delete', [CityController::class, 'cityDelete']);
    Route::get('state-list', [CityController::class, 'citystateList']);
    Route::post('city-filter', [CityController::class, 'cityFilter']);

    //For the Module
    Route::get('module', [ModuleController::class, 'moduleList']);
    Route::post('module-add', [ModuleController::class, 'moduleAdd']);
    Route::post('module-update', [ModuleController::class, 'moduleUpdate']);
    Route::post('module-delete', [ModuleController::class, 'moduleDelete']);
    Route::post('module-search', [ModuleController::class, 'moduleSearch']);
    

    //For the program
    Route::get('program', [ProgramController::class, 'programList']);
    Route::post('program-add', [ProgramController::class, 'programAdd']);
    Route::post('program-update', [ProgramController::class, 'programUpdate']);
    Route::post('program-delete', [ProgramController::class, 'programDelete']);
    Route::post('program-filter', [ProgramController::class, 'programFilter']);
    Route::get('program-module-list', [ProgramController::class, 'programModuleList']);

    
    //For the Language
    Route::get('language', [LanguageController::class, 'languageList']);
    Route::post('language-add', [LanguageController::class, 'languageAdd']);
    Route::post('language-update', [LanguageController::class, 'languageUpdate']);
    Route::post('language-delete', [LanguageController::class, 'languageDelete']);
    Route::post('language-search', [LanguageController::class, 'languageSearch']);
    

    //For the Payment Gateway Setting
    Route::get('payment-gateway', [PaymentGatewaySettingController::class, 'PaymentGatewayList']);
    Route::post('payment-gateway-add', [PaymentGatewaySettingController::class, 'PaymentGatewayAdd']);
    Route::post('payment-gateway-update', [PaymentGatewaySettingController::class, 'PaymentGatewayUpdate']);
    Route::post('payment-gateway-delete', [PaymentGatewaySettingController::class, 'PaymentGatewayDelete']);
    Route::post('payment-gateway-search', [PaymentGatewaySettingController::class, 'PaymentGatewaySearch']);
    

    //For the Email Settings
    Route::get('email', [EmailSettingController::class, 'EmailList']);
    Route::post('email-add', [EmailSettingController::class, 'EmailAdd']);
    Route::post('email-update', [EmailSettingController::class, 'EmailUpdate']);
    Route::post('email-delete', [EmailSettingController::class, 'EmailDelete']);
    Route::post('email-search', [EmailSettingController::class, 'EmailSearch']);
    
    Route::get('email-content', [EmailSettingController::class, 'EmailContent']);
    Route::post('email-content-update', [EmailSettingController::class, 'EmailContentUpdate']);

    //For the Document Master
    Route::get('document-master', [DocumentController::class, 'DocumentMasterList']);
    Route::post('document-master-add', [DocumentController::class, 'DocumentMasterAdd']);
    Route::post('document-master-update', [DocumentController::class, 'DocumentMasterUpdate']);
    Route::post('document-master-delete', [DocumentController::class, 'DocumentMasterDelete']);
    Route::post('document-master-search', [DocumentController::class, 'DocumentMasterSearch']);
    

    //For the Document Master
    Route::get('discount', [DiscountController::class, 'discountList']);
    Route::post('discount-add', [DiscountController::class, 'discountAdd']);
    Route::post('discount-update', [DiscountController::class, 'discountUpdate']);
    Route::post('discount-delete', [DiscountController::class, 'discountDelete']);
    Route::get('extension-list', [DiscountController::class, 'ExtensionList']);
    Route::post('discount-search',[DiscountController::class,'discountsearch']);
    Route::post('document-master-search', [DocumentController::class, 'DocumentMasterSearch']);

    
    //For the Institution Details
    Route::get('institute', [InstitutionController::class, 'instituteList']);
    Route::post('institute-add', [InstitutionController::class, 'instituteAdd']);
    Route::post('institute-update', [InstitutionController::class, 'instituteUpdate']);
    Route::post('institute-delete', [InstitutionController::class, 'instituteDelete']);
    Route::post('institute-filter', [InstitutionController::class, 'instituteFilter']);
    Route::get('board-list', [InstitutionController::class, 'boardList']);

    //For the Board
    Route::get('board', [BoardController::class, 'BoardList']);
    Route::post('board-add', [BoardController::class, 'BoardAdd']);
    Route::post('board-update', [BoardController::class, 'BoardUpdate']);
    Route::post('board-delete', [BoardController::class, 'BoardDelete']);
    Route::post('board-search', [BoardController::class, 'BoardSearch']);
    
    //home Page section management
    //News section
    Route::get('news-section', [PageManagementController::class, 'NewsSectionView']);
    Route::post('add-news-section', [PageManagementController::class, 'addNewsSection']);
    Route::post('change-news-status', [PageManagementController::class, 'ChangeNewsStatus']);
    Route::post('delete-news', [PageManagementController::class, 'DeleteNews']);
    Route::post('update-news-section', [PageManagementController::class, 'updateNewsSection']);
    
    //Offer section
    Route::get('offer-section', [PageManagementController::class, 'OfferSectionView']);
    Route::post('add-offer-section', [PageManagementController::class, 'AddOfferSection']);
    Route::post('change-offer-status', [PageManagementController::class, 'ChangeOfferStatus']);
    Route::post('delete-offer', [PageManagementController::class, 'deleteOffer']);
    Route::post('update-offer-section', [PageManagementController::class, 'updateOfferSection']);
    
    //Tip of the days section
    Route::get('tod-section', [PageManagementController::class, 'TodSectionView']);
    Route::post('change-tod-status', [PageManagementController::class, 'changeTodStatus']);
    Route::post('update-tod-section', [PageManagementController::class, 'updateTodSection']);
    
    
    
    Route::post('users-details-list', [WebsettingController::class, 'UsersDeatilsList']);
    Route::post('user-details', [WebsettingController::class, 'userDetails']);
    Route::post('user-doc-details-view', [WebsettingController::class, 'userDocDetailsView']);
    
    Route::get('admin-view-setting', [WebsettingController::class, 'AdminSettingView']);
    Route::post('admin-update-setting', [WebsettingController::class, 'AdminUpdateSettings']);
    
    Route::get('dns-view-details', [WebsettingController::class, 'DnsViewDetails']);
    Route::post('dns-update-details', [WebsettingController::class, 'DnsUpdateDetails']);
    Route::post('dns-add-price', [WebsettingController::class, 'DnsAddPrice']);
    Route::post('dns-update-price', [WebsettingController::class, 'DnsUpdatePrice']);
    Route::post('dns-delete-price', [WebsettingController::class, 'DnsDeletePrice']);
    
    Route::get('domain-setting-view-price', [WebsettingController::class, 'DomainSettingViewPrice']);
    Route::post('domain-add-price-setting', [WebsettingController::class, 'DomainAddPriceSetting']);
    Route::post('domain-update-price-setting', [WebsettingController::class, 'DomainUpdatePriceSetting']);
    Route::post('domain-delete-price-setting', [WebsettingController::class, 'DeleteDomainPriceSetting']);
    
    Route::post('deleted-users-details-view', [WebsettingController::class, 'DeletedUserDetailsView']);
    Route::post('deleted-users-details-search', [WebsettingController::class, 'DeletedUserDetailsSearch']);
    
    Route::post('search', [WebsettingController::class, 'Search']);
    
    
    Route::get('domain-extension-view', [WebsettingController::class, 'DomainExtensionView']);
    
    Route::get('domain-main-category', [WebsettingController::class, 'DomainMainCategory']);
    
    //add and update
    Route::post('domain-add-extension', [WebsettingController::class, 'AddDomainExtension']);
    Route::post('domain-delete-extension', [WebsettingController::class, 'DeleteDomainExtension']);
    
    Route::get('admin-view-list', [WebsettingController::class, 'AdminListView']);
    Route::post('admin-add', [WebsettingController::class, 'AdminAdd']);
    Route::post('admin-update', [WebsettingController::class, 'AdminUpdate']);
    Route::post('admin-search', [WebsettingController::class, 'AdminSearch']);
    Route::post('admin-delete', [WebsettingController::class, 'AdminDelete']);
    
    Route::get('admin-dashboard', [PageManagementController::class, 'adminDashboard']);
    
    //Domain Contact Details
    
    Route::post('update-institution-detail', [DomainController::class, 'updateInstitutionDetail']);
    Route::post('update-institution-head-detail', [DomainController::class, 'updateInstitutionHeadDetail']);
    Route::post('update-administrative-detail', [DomainController::class, 'updateAdministrativeDetail']);
    Route::post('update-billing-detail', [DomainController::class, 'updateBillingDetail']);
    Route::post('update-technical-detail', [DomainController::class, 'updateTechnicalDetail']);
    
    
    Route::post('user-dns-detail', [WebsettingController::class, 'UserDnsDetail']);
    Route::post('update-user-dns-detail', [WebsettingController::class, 'updateUserDnsNameServer']);
    
    Route::post('admin-user-view-docs', [WebsettingController::class, 'AdminUsersViewDoc']);
    Route::post('admin-update-doc', [WebsettingController::class, 'AdminUpdateDoc']);
    Route::post('delete-domain', [\App\Http\Controllers\admin\WebSettingController::class, 'delete_domain']);
    

    //admin report list route
    
    Route::post('report-creation-list', [AdminReportController::class, 'ReportCreationList']);
    Route::post('hold-application-list', [AdminReportController::class, 'HoldApplicationList']);
    Route::post('pending-restore-list', [AdminReportController::class, 'PendingRestoreList']);
    Route::post('pending-renew-list', [AdminReportController::class, 'PendingRenewList']);
    Route::post('domain-list', [AdminReportController::class, 'DomainList']);
    Route::post('hindi-domain-list', [AdminReportController::class, 'HindiDomainList']);
    
    Route::post('no-zone-list', [AdminReportController::class, 'NoZoneList']);
    Route::post('payment-list', [AdminReportController::class, 'PaymentList']);
    Route::post('document-rejected-list', [AdminReportController::class, 'DocumentRejectedList']);
    Route::post('domain-no-dns-list', [AdminReportController::class, 'DomainNoDnsList']);
    Route::post('nixi-payment-list', [AdminReportController::class, 'NixiPaymentList']);
    Route::post('admin-logout', [PassportAuthController::class, 'AdminLogout']);
    
});