<?php

use App\Http\Controllers\admin\EmailSettingsController;
use App\Http\Controllers\admin\master\DiscountController;
use App\Http\Controllers\admin\PageManagementController;
use App\Http\Controllers\admin\PaymentGatewaySettingsController;
use App\Http\Controllers\BulkUpdateController;
use App\Http\Controllers\DomainController;
use App\Http\Controllers\ImportZoneController;
use App\Http\Controllers\PayController;
use App\Http\Controllers\ResourceRecordController;
use App\Http\Controllers\SearchController;
use App\Http\Controllers\ServerController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\SyncServersController;
use App\Http\Controllers\user\HomeController;
use App\Http\Controllers\user\TestController;
use App\Http\Controllers\user\MigrateController;
use App\Http\Controllers\user\UserController;
use App\Http\Controllers\ZoneController;
use App\Http\Middleware\AjaxRequestOnly;
use App\Http\Middleware\User;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\admin\AdminController;
use App\Http\Controllers\admin\master\CityController;
use App\Http\Controllers\admin\master\AlgoController;
use App\Http\Controllers\admin\master\StateController;
use App\Http\Controllers\admin\master\ModuleController;
use App\Http\Controllers\admin\master\ProgramController;
use App\Http\Controllers\admin\master\PrivilegeController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\admin\master\DocController;
use App\Http\Controllers\admin\master\AdminsController;
use App\Http\Controllers\admin\master\BoardController;
use App\Http\Controllers\admin\master\BardController;
use App\Http\Controllers\Billdesk\Controller;
use App\Console\Commands\ProBINDPushZones;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use JagdishJP\Billdesk\Http\Controllers\PaymentController;
use Illuminate\Support\Facades\Session;
use App\Library\EPP;
use Larapack\Settings\Setting;
use App\Http\Controllers\LoginHistoryReportController;
use App\Models\Zone;
use App\Http\Controllers\Billdesk\CustomController;
use App\Http\Controllers\admin\BulkDomainController;
use App\Http\Controllers\BulkController;
use Illuminate\Support\Facades\Mail;
use App\Components\MailManager;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
/
*/

Route::get('/test-mail', function () {
    $view = 'front.email.user-domain-enquiry'; // This should exist in your `resources/views/front/email/` folder and be a Blade file.

    $data = [
        'email' => 'gaurav.intileo@gmail.com', 
        'subject' => 'Test Email Subject',
        'name' => 'John Doe',
        'emailVerificationLink' => 'https://example.com/verify-email?token=123456',
        'message' => 'This is a test email sent using PHPMailer.',
        'content'=> 'This is the content of the email.',
        'attachments' => [], // Optional: can include file contents
        'ccMails' => ['another@example.com'], // Optional
    ];

    $mailer = MailManager::getInstance();

    $status = $mailer->mailSender($view, $data);

    return $status === true ? 'Email sent successfully.' : $status;
});

Route::get('/testing-mail', function () {
    try {
        Mail::raw('This is a test email from Laravel (web route).', function ($message) {
            $message->to('gaurav.intileo@gmail.com')
                    ->subject('Test Email from Web');
        });

        return 'Email sent successfully!';
    } catch (\Exception $e) {
        return 'Email sending failed: ' . $e->getMessage();
    }
});




Route::get('/', function () {
    $data=[];
    $data['offers']=[];
    return view('front.home',$data);
});
Route::any('/billdeskresponse', [CustomController::class, 'billdeskresponse'])->name('billdeskresponse');


Route::post('/chat', [App\Http\Controllers\ChatController::class, 'sendMessage']);
Route::get('/forgot', [HomeController::class, 'forgot'])->name('forgot');
Route::get('/forgot-pass/{token}', [HomeController::class, 'forgotpass']);
Route::post('/forgotsend', [HomeController::class, 'forgotsend'])->middleware('throttle:20,1');
Route::post('/changeforgotpass', [HomeController::class, 'changeforgotpass'])->middleware('throttle:20,1');

// Route::get('/renew-domain-test',function(){
//   $epp = new Epp();
//   $result = $epp->renewDomain('testdomain.ac.in','2026-12-14',1);
//   dd($result);
// });
//  Route::get('/hold-domain',function(){
//   $epp = new Epp();
//     $result = $epp->domainStatusUpdate('nict.ac.in','clientHold','add');
//   dd($result);
//  });
Route::get('/check-epp-login', [TestController::class, 'checkEppLogin']);
Route::get('/test-hindi-domain/{domainName}/{extension}', [TestController::class, 'testHindiDomainAvailability']);



Route::get('/apply-domain', function () {
    return view('front.apply-domain');
})->name('apply-domain');

Route::get('/policy', function () {
    return view('front.policy');
})->name('policy');

Route::get('/guidelines', function () {
    return view('front.guidelines');
})->name('guidelines');

Route::get('/privacy-policy', function () {
    return view('front.privacy-policy');
})->name('privacy-policy');

Route::get('/screen-reader', function () {
    return view('front.screen-reader');
})->name('screen-reader');

Route::get('/tariff', [DomainController::class,'tariff'])->name('tariff');
Route::get('tariff/ajaxcall', [DomainController::class, 'ajaxcall'])->name('tariff.ajaxcall');

Route::get('/tariff_register', [DomainController::class,'tariff_register'])->name('tariff_register');
Route::get('/tariff_renewal', [DomainController::class,'tariff_renewal'])->name('tariff_renewal');
Route::get('/tariff_dns', [DomainController::class,'tariff_dns'])->name('tariff_dns');
Route::get('/tariff_vas', [DomainController::class,'tariff_vas'])->name('tariff_vas');

Route::get('/contact-us', function () {
    return view('front.contact-us');
})->name('contact-us');

Route::get('/terms-conditions', function () {
    return view('front.terms-conditions');
})->name('terms-conditions');

Route::get('/website-policy', function () {
    return view('front.website-policy');
})->name('website-policy');

Route::get('/idn-terms-policy', function () {
    return view('front.idn-policy');
})->name('idn-terms-policy');

Route::get('/download-documents', function () {
    return view('front.download-doc');
})->name('download-documents');

Route::get('/vas', function () {
    return view('front.value-added-services');
})->name('vas');

Route::get('/e-wass-front', function () {
    return view('front.e-waas-front');
})->name('e-wass-front');

Route::get('/e-wass', function () {   
 $url = 'https://vas.registry.ernet.in/School1/?type=ewaas&token=' . urlencode(Auth::user()->auth_token);
 return redirect()->to($url);
})->name('e-wass');

Route::post('/createBilldeskOrder', [HomeController::class, 'createBilldeskOrder'])->name('createBilldeskOrder');
Route::post('/get-discount', [HomeController::class, 'getDiscount'])->name('get-discount');



Route::any('/getTransInfo/{id}', [HomeController::class, 'getTransInfo'])->name('getTransInfo');

Route::get('/colleges', function () {return view('front.colleges');})->name('colleges');

Route::any('/handleBulkTransactions', [BulkController::class, 'handleBulkTransactions'])->name('handleBulkTransactions');

Route::get('/schools', function () {return view('front.schools');})->name('schools');
Route::get('/universities', function () {return view('front.universities');})->name('universities');
Route::get('/others', function () {return view('front.others');})->name('others');

Route::post('apply-domain-agreement',[DomainController::class,'applyDomainAgreement'])->middleware('throttle:3,1');
Route::post('userDomainEnquiry',[DomainController::class,'userDomainEnquiry']);
Route::post('checkemailexits',[DomainController::class,'checkemailexits']);

Route::get('/aboutus.aspx', function () {
    return redirect()->to("https://www.registry.ernet.in");
});

Route::post('checkDomainAvailability',[DomainController::class,'checkDomainAvailability'])->middleware('throttle:3,1');
Route::get('translateDomainName',[DomainController::class,'translateDomainName']);
Route::get('/user-email-verification/{id}', [HomeController::class, 'user_email_verification']);
Route::get('/getExtensionByLang', [DomainController::class, 'getExtensionByLang']);

Route::post('/googleAuth', [HomeController::class, 'googleAuth'])->name('googleAuth');
Route::get('/google-auth-otp', [HomeController::class, 'google_auth_otp'])->name('google-auth-otp');
Route::get('/useraccesstokenupdate', [HomeController::class, 'useraccesstokenupdate'])->name('useraccesstokenupdate');
Route::get('/validateGoogleAuth', function () {
    return view('google2fa.index');
})->name('validateGoogleAuth');


Route::get('/validateGoogleAuthold', function () {
    return view('google2fa.otp');
})->name('validateGoogleAuthold');

Route::post('/usersavegoogleauth', [HomeController::class, 'usersavegoogleauth'])->name('usersavegoogleauth');

Route::post('/user-create-password', [HomeController::class, 'user_create_password'])->name('user-create-password');

Route::get('/googleauthregister', [HomeController::class, 'googleauthregister'])->name('user.googleauthregister');

Route::get('/user-login', [HomeController::class, 'user_login'])->name('user.login');
Route::any('/googleAuthLogin', [HomeController::class, 'googleAuthLogin'])->name('googleAuthLogin');
Route::post('custom-login', [HomeController::class, 'customLogin'])->name('login.custom');

Route::get('/visitor', function () {
    $count=DB::table('visitor_counter')->count();
    $html="Visitor Counter : $count";
    dd($html);
});

Route::get('/downloadinvoice/{id}', [HomeController::class, 'downloadinvoice'])->name('downloadinvoice');
Route::get('/user-forgot-password', [HomeController::class, 'user_forgot_password'])->name('user.forgot-password');
Route::get('/user-reset-password/{id}', [HomeController::class, 'user_reset_password']);
Route::get('/getCityByState/{id}', [UserController::class, 'getCityByState']);
Route::get('/getpincode', [HomeController::class, 'getpincode']);

Route::get('/capturefinger', [App\Http\Controllers\admin\AdminController::class, 'capturefinger'])->name('admin.capturefinger');
Route::post('capturefinger/add', [AdminController::class, 'add'])->name('capturefinger.add');
Route::get('/accesstokenupdate', [App\Http\Controllers\admin\AdminController::class, 'accesstokenupdate'])->name('admin.accesstokenupdate');
Route::get('/matchfinger', [App\Http\Controllers\admin\AdminController::class, 'matchfinger'])->name('admin.matchfinger');

Route::get('/checkzonedata', [App\Http\Controllers\admin\WebSettingController::class, 'checkzonedata'])->name('admin.checkzonedata');

Route::get('/homepagedashboard', [App\Http\Controllers\admin\AdminController::class, 'autologin'])->name('admin.homepagedashboard');

Route::get('/e-wass', function () {
    $url = 'https://vas.registry.ernet.in/test-portal/public/autologin?token=' . urlencode(Auth::user()->auth_token);
    return redirect()->to($url);
})->name('e-wass');

Route::post('/colleges-cat', [HomeController::class, 'collegescat'])->name('collegescat');
Route::post('/schools-cat', [HomeController::class, 'schoolscat'])->name('schoolscat');
Route::post('/universities-cat', [HomeController::class, 'universitiescat'])->name('universitiescat');

Route::get('/checkDNSMatch', [UserController::class, 'checkDNSMatch'])->name('checkDNSMatch');

Route::get('/autologinDomainAbhi/{id}', [MigrateController::class, 'autologinDomain'])->name('autologinDomain');
Route::get('/checkTransaction', [MigrateController::class, 'checkTransaction'])->name('checkTransaction');
Route::get('/holdManaualDomain/{id}', [MigrateController::class, 'holdManaualDomain'])->name('holdManaualDomain');

Route::get('/pendingPaymentCheck', [MigrateController::class, 'pendingPaymentCheck'])->name('pendingPaymentCheck');


Route::middleware(['auth','user'])->group(function () {

    Route::get('/publish', [UserController::class, 'Publish'])->name('publish');

    Route::get('/ewaaspublish', [UserController::class, 'ewaasPublish'])->name('ewaaspublish');

    Route::get('/colleges', function () {
        $userprojects =  DB::table('projects')->where('user_id','=', Auth::id())->get();
        $temp_publish_data = DB::table('users')->where('id','=', Auth::id())->first();
        if($userprojects){
            $projects=$userprojects;
        }else{
            $projects=[];
        }
        return view("front.colleges", compact('projects','temp_publish_data'));
    })->name('colleges');

    Route::get('/schools', function (Request $request) {
        $userprojects =  DB::table('projects')->where('user_id','=', Auth::id())->get();
        $temp_publish_data = DB::table('users')->where('id','=', Auth::id())->first();
        if($userprojects){
            $projects=$userprojects;
        }else{
            $projects=[];
        }
        return view("front.schools", compact('projects','temp_publish_data'));
    })->name('schools');

    Route::get('/universities', function () {
        Session::put('current_url', "universities");
        $userprojects =  DB::table('projects')->where('user_id','=', Auth::id())->get();
        $temp_publish_data = DB::table('users')->where('id','=', Auth::id())->first();
        if($userprojects){
            $projects=$userprojects;
        }else{
            $projects=[];
        }
        return view("front.universities", compact('projects','temp_publish_data'));
        
    })->name('universities');


    Route::get('/others', function () {return view('front.others');})->name('others');

    Route::get('/getVasPaymentHistory', [UserController::class, 'getVasPaymentHistory']);
    Route::get('/user_pay_vas', [UserController::class, 'user_pay_vas_ajaxcall'])->name('user_pay_vas.ajaxcall');

    Route::get('/getVasServerPrice/{id}', [UserController::class, 'getVasServerPrice'])->name('getVasServerPrice');

    Route::get('/projects', [HomeController::class, 'projects'])->name('projects');
    
    Route::get('/l-mass', function () {
        $url = 'https://vas.registry.ernet.in/test-portal/public/autologin?type=lmaas&token=' . urlencode(Auth::user()->auth_token);
        return redirect()->to($url);
    })->name('l-mass');

    Route::post('/removeproject', [HomeController::class, 'removeProject'])->name('removeProject');
    Route::get('/removeprojectstatus', [HomeController::class, 'removeprojectstatus'])->name('removeprojectstatus');
    Route::get('/verifyremoveproject', [HomeController::class, 'verifyremoveproject'])->name('verifyremoveproject');

    Route::get('/publishprojectstatus', [HomeController::class, 'publishprojectstatus'])->name('publishprojectstatus');
    Route::post('/publishproject', [HomeController::class, 'publishproject'])->name('publishproject');
    Route::get('/verifypublishproject', [HomeController::class, 'verifypublishproject'])->name('verifypublishproject');
    
    Route::get('/createLmassClone', [HomeController::class, 'createLmassClone'])->name('createLmassClone');
    Route::get('/importLmassDb', [HomeController::class, 'importLmassDb'])->name('importLmassDb');

    Route::get('/createEwaasClone', [HomeController::class, 'createEwaasClone'])->name('createEwaasClone');
    Route::get('/importEwaasDb', [HomeController::class, 'importEwaasDb'])->name('importEwaasDb');
    
    Route::get('/removeprojectstatusewaas', [HomeController::class, 'removeprojectstatusewaas'])->name('removeprojectstatusewaas');
    Route::get('/verifyremoveprojectewaas', [HomeController::class, 'verifyremoveprojectewaas'])->name('verifyremoveprojectewaas');
    Route::post('/removeprojectewaas', [HomeController::class, 'removeprojectewaas'])->name('removeprojectewaas');

    Route::get('/publishprojectstatusewaas', [HomeController::class, 'publishprojectstatusewaas'])->name('publishprojectstatusewaas');
    Route::get('/verifypublishprojectewaas', [HomeController::class, 'verifypublishprojectewaas'])->name('verifypublishprojectewaas');
    Route::post('/publishprojectewaas', [HomeController::class, 'publishprojectewaas'])->name('publishprojectewaas');

    Route::get('/unpublishprojectstatusewaas', [HomeController::class, 'unpublishprojectstatusewaas'])->name('unpublishprojectstatusewaas');
    Route::get('/verifyunpublishprojectewaas', [HomeController::class, 'verifyunpublishprojectewaas'])->name('verifyunpublishprojectewaas');
    Route::post('/unpublishprojectewaas', [HomeController::class, 'unpublishprojectewaas'])->name('unpublishprojectewaas');

    Route::get('/createProjectDBOnly', [HomeController::class, 'createProjectDBOnly'])->name('createProjectDBOnly');

    Route::get('/unpublishprojectstatus', [HomeController::class, 'unpublishprojectstatus'])->name('unpublishprojectstatus');
    Route::get('/verifyunpublishproject', [HomeController::class, 'verifyunpublishproject'])->name('verifyunpublishproject');
    Route::post('/unpublishproject', [HomeController::class, 'unpublishproject'])->name('unpublishproject');

    Route::get('/user-dashboard', [UserController::class, 'user_dashboard'])->name('user.dashboard');
    Route::get('/domainContactDetailsList', [UserController::class, 'domainContactDetailsList']);

    Route::get('/format_pdf/{id}', [UserController::class, 'format_pdf']);
    Route::get('/getPaymentHistory', [UserController::class, 'getPaymentHistory']);
    Route::get('/user_pay', [UserController::class, 'user_pay_ajaxcall'])->name('user_pay.ajaxcall');

    Route::get('/add-contact-details', [UserController::class, 'add_contact_details']);
    Route::get('/verifyGst', [UserController::class, 'verifyGst']);
    Route::get('/update-contact-details', [UserController::class, 'add_contact_details']);
    Route::post('/updateInstitutionDetail', [UserController::class, 'updateInstitutionDetail'])->name('updateInstitutionDetail');
    Route::post('/updateInstitutionHeadDetail', [UserController::class, 'updateInstitutionHeadDetail'])->name('updateInstitutionHeadDetail');
    Route::post('/updateAdministrativeDetail', [UserController::class, 'updateAdministrativeDetail'])->name('updateAdministrativeDetail');
    Route::post('/updateBillingDetail', [UserController::class, 'updateBillingDetail'])->name('updateBillingDetail');
    Route::post('/updateTechnicalDetail', [UserController::class, 'updateTechnicalDetail'])->name('updateTechnicalDetail');
    Route::get('/upload-documents', [UserController::class, 'upload_documents'])->name('upload-documents');
    Route::post('/userDocsUpload', [UserController::class, 'userDocsUpload'])->name('userDocsUpload');
    Route::get('/userDocsList', [UserController::class, 'userDocsList'])->name('userDocsList');


    // Route::get('/user-submit-documents', [UserController::class, 'user_submit_documents'])->name('admin.user-submit-documents');

    Route::match(['get', 'post'], '/user-submit-documents', [UserController::class, 'user_submit_documents'])->name('admin.user-submit-documents');

    Route::match(['get', 'post'], '/get_date_ex', [UserController::class, 'getNewDomainExpiry'])->name('admin.getNewDomainExpiry');


    Route::get('/checkanydocumentrequired', [UserController::class, 'checkanydocumentrequired'])->name('admin.checkanydocumentrequired');

    Route::get('/school_affilation_suggestion', [UserController::class, 'schoolAffilationGet']);
    Route::post('/school_affilation_save', [UserController::class, 'schoolAffilationSave']);

    Route::get('/dns-name-server', [UserController::class, 'dns_name_server'])->name('dns-name-server');
    Route::get('/getNameServerPrice/{id}', [UserController::class, 'getNameServerPrice'])->name('getNameServerPrice');
    Route::post('/addDnsNameServerErnet', [UserController::class, 'addDnsNameServerErnet'])->name('addDnsNameServerErnet');
    Route::post('/addDnsNameServerUser', [UserController::class, 'addDnsNameServerUser'])->name('addDnsNameServerUser');

    Route::get('/dns-name-server-payment', [UserController::class, 'dns_name_server_payment'])->name('dns-name-server-payment');
    Route::get('/domain-payment', [UserController::class, 'domain_payment'])->name('domain-payment');
    Route::get('/domain-payment-dns-skip', [UserController::class, 'domain_payment_dns_skip'])->name('domain-payment-dns-skip');
    Route::get('/user-application-preview', [UserController::class, 'userApplicationPreview'])->name('user-application-preview');
    Route::get('/userApplicationSubmit', [UserController::class, 'userApplicationSubmit'])->name('userApplicationSubmit');
    
    Route::get('/user-modify-dns-server-name', [UserController::class, 'user_modify_dns_server'])->name('user.modify-dns-server-name');
    Route::any('/apply-dns-for-server', [UserController::class, 'apply_dns_for_server'])->name('user.apply-dns-for-server');
    Route::get('/user-modification', [UserController::class, 'user_modification'])->name('user.modification');
    Route::get('/user-update-profile', [UserController::class, 'user_update_profile'])->name('user.update-profile');
    Route::get('/user-contact-us', [UserController::class, 'user_contact_us'])->name('user.contact-us');
    Route::get('/user-remark', [UserController::class, 'user_remark'])->name('user.remark');
    Route::post('/user-remark', [UserController::class, 'user_rmrk_sumbit'])->name('user.user_rmrk_sumbit');
    Route::get('/renew-domain', [UserController::class, 'user_renew_domain'])->name('user.renew-domain');
    Route::get('/getExtensionPrices/{id}', [UserController::class, 'getExtensionPrices'])->name('getExtensionPrices');
    Route::post('/domainRenewal', [UserController::class, 'domainRenewal'])->name('domainRenewal');

    Route::get('/service_domain_name/{id}', [UserController::class, 'service_domain_name'])->name('service_domain_name');
    Route::get('/ewaas_temp/{id}', [UserController::class, 'ewaas_temp'])->name('ewaas_temp');
      Route::get('/lmaas_temp/{id}', [UserController::class, 'lmaas_temp'])->name('lmaas_temp');
    


    Route::get('/modify-ernet-dns-record', [UserController::class, 'modify_ernet_dns_record'])->name('modify-ernet-dns-record');
    Route::post('/save-ernet-dns-record', [UserController::class, 'save_ernet_dns_record'])->name('save-ernet-dns-record');
    Route::get('/deleteRecord/{id}', [UserController::class, 'deleteRecord'])->name('deleteRecord');
    Route::get('/change_password', [UserController::class, 'change_password'])->name('change_password');
    Route::post('/verify_change_password', [UserController::class, 'verify_change_password'])->name('verify_change_password_user');

    $webhookPath  = Config::get('billdesk.webhook_path');
    $responsePath = Config::get('billdesk.response_path');

    Route::get(
        'billdesk/initiate/payment/{initiated_from?}/{test?}',
        function (Request $request, $initiated_from = 'HTML', $test = '') {
            $response_format = $initiated_from == 'app' ? 'JSON' : 'HTML';
            Session::put('payment_type',$request->all());
            Session::put('transaction_type',$request->transaction_type);
            return view('billdesk::payment', compact('test', 'response_format', 'request'));
        }
    )->name('billdesk.initiate.payment');

    Route::post('billdesk/payment/request', [PaymentController::class, 'handle'])->name('billdesk.payment.auth.request');

    Route::post($webhookPath, [Controller::class, 'webhook'])/* ->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]) */ ->name('billdesk.payment.webhook');
    Route::post($responsePath, [Controller::class, 'callback'])/* ->withoutMiddleware([\App\Http\Middleware\VerifyCsrfToken::class]) */ ->name('billdesk.payment.response.url');

    Route::get('signout', [UserController::class, 'signOut'])->name('signout');
});

/* end-user route end */

/* admin route start */

Route::any('bulkdomainpanel/',[AdminController::class,'login'])->name('bulk.login');

Route::any('ernetdash/',[AdminController::class,'login'])->name('admin.login');

Route::POST('ernetdash/login-request',[AdminController::class,'attemptLogin'])->name('admin.login-request');

Route::get('ernetdash/forgot', [AdminController::class, 'forgot'])->name('admin.forgot');
Route::get('ernetdash/forgot-pass/{token}', [AdminController::class, 'forgotpass']);
Route::post('ernetdash/forgotsend', [AdminController::class, 'forgotsend'])->middleware('throttle:20,1');
Route::post('ernetdash/changeforgotpass', [AdminController::class, 'changeforgotpass'])->middleware('throttle:20,1');


// Route::get('ernetdash/format_pdf/{id}', [BulkController::class, 'format_pdf']);

Route::post('/bulkUploadDomain', [BulkController::class, 'bulkUploadDomain'])->name('bulkUploadDomain');
Route::get('/bulkPreview', [BulkController::class, 'bulkPreview'])->name('bulkPreview');
Route::get('/bulkPreviewAjaxcall', [BulkController::class, 'bulkPreviewAjaxcall'])->name('bulkpreview.ajaxcall');
Route::get('/getTempDomain', [BulkController::class, 'getTempDomain'])->name('getTempDomain');
Route::post('/bulkDomainUpdate', [BulkController::class, 'bulkDomainUpdate'])->name('bulkDomainUpdate');
Route::post('/bulkDeleteDomain', [BulkController::class, 'bulkDeleteDomain'])->name('bulkDeleteDomain');
Route::get('/downloadFailedDomain', [BulkController::class, 'downloadFailedDomain'])->name('downloadFailedDomain');
Route::post('/bulkDomainFinalSubmit', [BulkController::class, 'bulkDomainFinalSubmit'])->name('bulkDomainFinalSubmit');
Route::post('/createBulkBilldeskOrder', [BulkController::class, 'createBulkBilldeskOrder'])->name('bulk.createBulkBilldeskOrder');

Route::get('domain/manage', [BulkController::class, 'ManageDomain'])->name('manage.domain');
Route::get('domain/incomplete', [BulkController::class, 'IncompleteDomain'])->name('incomplete.domain');
Route::get('domain/finalsubmitted', [BulkController::class, 'FinalSubmitted'])->name('finalsubmit.domain');

Route::get('domain/doc', [BulkController::class, 'Domaindoc'])->name('doc.domain');
Route::post('upload/doc', [BulkController::class, 'Uploaddoc'])->name('doc.upload');
Route::get('/bulkIncompleteAjaxcall', [BulkController::class, 'bulkIncompleteAjaxcall'])->name('bulkincomplete.ajaxcall');
Route::get('view/domain/{id}', [BulkController::class, 'viewDomain'])->name('view.domainData');
Route::get('proceedToCheckoutRegistration', [BulkController::class, 'proceedToCheckoutRegistration'])->name('proceedToCheckoutRegistration');

Route::get('payment_history', [BulkController::class, 'payment_history'])->name('payment_history');
Route::get('payment_history_ajaxcall', [BulkController::class, 'payment_history_ajaxcall'])->name('payment_history_ajaxcall');

Route::get('generateTransactions', [BulkController::class, 'generateTransactions'])->name('generateTransactions');

Route::get('/bulkActiveAjaxcall', [BulkController::class, 'bulkActiveAjaxcall'])->name('bulkactive.ajaxcall');

Route::get('/bulkdomain/update-contact-details/{id}', [BulkController::class, 'update_contact_details']);
Route::get('/bulkdomain/domainContactDetailsList/{id}', [BulkController::class, 'domainContactDetailsList']);
Route::get('/bulkdomain/upload-documents/{id}', [BulkController::class, 'upload_documents']);

Route::post('/bulkdomain/userDocsUpload', [BulkController::class, 'userDocsUpload'])->name('userDocsUpload');
Route::get('/bulkdomain/userDocsList/{id}', [BulkController::class, 'userDocsList'])->name('userDocsList');
Route::get('/bulkdomain/user-submit-documents/{id}', [BulkController::class, 'user_submit_documents'])->name('user-submit-documents');
Route::get('/bulkdomain/userApplicationSubmit/{id}', [BulkController::class, 'userApplicationSubmit'])->name('userApplicationSubmit');
Route::get('/upload/domain', [BulkController::class, 'uploadDomain'])->name('upload.domain');

Route::get('/bulkdomain/declaration', [BulkController::class, 'bulkdomainDeclaration'])->name('bulkdomainDeclaration');
Route::post('/bulkdomain/bulkDomainVerifyDeclaration', [BulkController::class, 'bulkDomainVerifyDeclaration'])->name('bulkDomainVerifyDeclaration');
Route::get('ernetdash/bulkdomainformat_pdf/{id}', [BulkController::class, 'bulkdomainformat_pdf']);


Route::prefix('ernetdash')->middleware('check.user_agent:admin')->group(function () {

    
    Route::get('/bulkorgdetails', [BulkDomainController::class, 'bulkorgdetails'])->name('bulkorgdetails');
    Route::get('/bulkorgdetails_ajaxcall', [BulkDomainController::class, 'bulkorgdetails_ajaxcall'])->name('bulkorgdetails.ajaxcall');
    
    Route::get('/bulkdomainRenewal', [BulkDomainController::class, 'bulkorgdetails'])->name('bulkorgdetails');
    Route::get('/bulkdomainRegistration', [BulkDomainController::class, 'bulkdomainRegistration'])->name('bulkdomainRegistration');
    Route::get('/bulkdomainRegistration_ajaxcall', [BulkDomainController::class, 'bulkdomainRegistration_ajaxcall'])->name('bulkdomainRegistration.ajaxcall');

    Route::post('/bulkdomain/registerDomain', [BulkDomainController::class, 'registerDomain'])->name('bulkdomain.registerDomain');

    Route::post('/updateInstitutionDetail', [AdminController::class, 'updateInstitutionDetail'])->name('ernetdash.updateInstitutionDetail');
    Route::post('/updateInstitutionHeadDetail', [AdminController::class, 'updateInstitutionHeadDetail'])->name('ernetdash.updateInstitutionHeadDetail');
    Route::post('/updateAdministrativeDetail', [AdminController::class, 'updateAdministrativeDetail'])->name('ernetdash.updateAdministrativeDetail');
    Route::post('/updateBillingDetail', [AdminController::class, 'updateBillingDetail'])->name('ernetdash.updateBillingDetail');
    Route::post('/updateTechnicalDetail', [AdminController::class, 'updateTechnicalDetail'])->name('ernetdash.updateTechnicalDetail');
    
    Route::get('/view_mx_records/{id}', [App\Http\Controllers\admin\WebSettingController::class, 'view_mx_records'])->name('admin.view_mx_records');

    Route::get('/update-contact-details/{id}', [AdminController::class, 'add_contact_details']);
    Route::get('/domainContactDetailsList/{id}', [AdminController::class, 'domainContactDetailsList']);

    Route::get('/test', [\App\Http\Controllers\admin\EppController::class, 'test'])->name('test');

    Route::get('/admin-register', [App\Http\Controllers\admin\AdminController::class, 'admin_register'])->name('admin.register');
    Route::get('/admin-forgot-password', [App\Http\Controllers\admin\AdminController::class, 'admin_forgot_password'])->name('admin.forgot-password');
    Route::group(['middleware'=>['admin']], function()
    {

        Route::get('/getDashboardData', [App\Http\Controllers\admin\HomeController::class, 'getDashboardData'])->name('admin.getDashboardData');
        
        Route::get('reset_googleauth', [App\Http\Controllers\admin\AdminController::class, 'reset_googleauth'])->name('domain.reset_googleauth');
        Route::get('hardcopy_received', [App\Http\Controllers\admin\AdminController::class, 'hardcopy_received'])->name('domain.hardcopy_received');

        Route::post('/verify_change_password', [App\Http\Controllers\admin\AdminController::class, 'verify_change_password'])->name('verify_change_password');
        Route::get('changepassword', [App\Http\Controllers\admin\AdminController::class, 'changepassword'])->name('admin.changepassword');
        Route::get('logout', [App\Http\Controllers\admin\AdminController::class, 'logout'])->name('admin.logout');
        Route::get('/admin-dashboard', [App\Http\Controllers\admin\HomeController::class, 'admin_dashboard'])->name('admin.dashboard');
        Route::get('/admin-dashboard-data', [App\Http\Controllers\admin\HomeController::class, 'admin_dashboard_data'])->name('admin.dashboard-data');
        Route::get('/rejected-payment', [App\Http\Controllers\admin\HomeController::class, 'admin_dashboard_data'])->name('admin.rejected-payment');
        Route::get('/payment-approval', [App\Http\Controllers\admin\HomeController::class, 'admin_dashboard_data'])->name('admin.payment-approval');
        Route::get('/pending-creations', [App\Http\Controllers\admin\HomeController::class, 'admin_dashboard_data'])->name('admin.pending-creations');
        Route::get('/pending-renewal', [App\Http\Controllers\admin\HomeController::class, 'admin_dashboard_data'])->name('admin.pending-renewal');
        Route::get('/pending-restorable-domains', [App\Http\Controllers\admin\HomeController::class, 'admin_dashboard_data'])->name('admin.pending-restorable-domains');
        Route::get('/active-domain', [App\Http\Controllers\admin\HomeController::class, 'admin_dashboard_data'])->name('admin.active-domain');
        Route::get('/expired-domains', [App\Http\Controllers\admin\HomeController::class, 'admin_dashboard_data'])->name('admin.expired-domains');
        Route::get('/hold-domains', [App\Http\Controllers\admin\HomeController::class, 'admin_dashboard_data'])->name('admin.hold-domains');
        Route::get('/pending-dns-updation', [App\Http\Controllers\admin\HomeController::class, 'admin_dashboard_data'])->name('admin.pending-dns-updation');
        Route::get('/rejected-documented-list', [App\Http\Controllers\admin\HomeController::class, 'admin_dashboard_data'])->name('admin.rejected-documented-list');
        Route::get('/dns', [App\Http\Controllers\admin\HomeController::class, 'admin_dashboard_data'])->name('admin.dns');
        Route::get('/hindi-domain', [App\Http\Controllers\admin\HomeController::class, 'admin_dashboard_data'])->name('admin.hindi-domain');

        Route::get('/setting', [App\Http\Controllers\admin\WebSettingController::class, 'admin_setting_view'])->name('admin.setting-view');
        Route::post('/setting', [App\Http\Controllers\admin\WebSettingController::class, 'admin_add_settings'])->name('admin.add-setting');
        Route::post('/settingbyemail', [App\Http\Controllers\admin\WebSettingController::class, 'admin_add_setting_byemail'])->name('admin.add-setting-byemail');
        Route::get('/loginadminreport', [LoginHistoryReportController::class, 'index']);
        Route::get('/loginadminreport/ajaxcall', [LoginHistoryReportController::class, 'ajaxcall'])->name('loginadmin.report.ajaxcall');
        
        Route::get('/loginuserreport', [LoginHistoryReportController::class, 'user_index']);
        Route::get('/loginuserreport/ajaxcall', [LoginHistoryReportController::class, 'user_ajaxcall'])->name('loginuser.report.ajaxcall');
        
        Route::get('/dns-details-view', [App\Http\Controllers\admin\WebSettingController::class, 'admin_dns_details_view'])->name('admin.dns-details-view');
        Route::post('/dns-details-add', [App\Http\Controllers\admin\WebSettingController::class, 'admin_dns_details_add'])->name('admin.dns-details-add');
        Route::post('/dns-details-update', [App\Http\Controllers\admin\WebSettingController::class, 'admin_dns_details_update'])->name('admin.dns-details-update');
        Route::get('/dns-details-delete', [App\Http\Controllers\admin\WebSettingController::class, 'admin_dns_details_add'])->name('admin.dns-details-delete');

        Route::post('/dns-price-add', [App\Http\Controllers\admin\WebSettingController::class, 'admin_dns_price_add'])->name('admin.dns-price-add');
        Route::get('/get-price-data', [App\Http\Controllers\admin\WebSettingController::class, 'admin_get_price_data'])->name('admin.get-price-data');
        Route::post('/dns-price-update', [App\Http\Controllers\admin\WebSettingController::class, 'admin_dns_price_update'])->name('admin.dns-price-update');
        Route::get('/dns-price-delete', [App\Http\Controllers\admin\WebSettingController::class, 'admin_dns_price_delete'])->name('admin.dns-price-delete');

        Route::get('/price-setting', [App\Http\Controllers\admin\WebSettingController::class, 'admin_domain_price_setting_view'])->name('admin.price-setting-view');
        Route::post('/price-setting', [App\Http\Controllers\admin\WebSettingController::class, 'admin_add_domain_price_setting'])->name('admin.add-price-setting');
        Route::get('/get-price-setting', [App\Http\Controllers\admin\WebSettingController::class, 'admin_get_domain_price'])->name('admin.get-domain-price');
        Route::post('/update-price-setting', [App\Http\Controllers\admin\WebSettingController::class, 'admin_upadate_domain_price'])->name('admin.update-domain-price');
        Route::post('/delete-price-setting', [App\Http\Controllers\admin\WebSettingController::class, 'admin_delete_domain_price'])->name('admin.delete-domain-price');




        Route::get('service_discount/ajaxcall', [App\Http\Controllers\admin\WebSettingController::class, 'service_discount_ajaxcall'])->name('service_discount.ajaxcall');
            Route::post('service_discount/store', [App\Http\Controllers\admin\WebSettingController::class, 'service_discount_store'])->name('service_discount.store');
            Route::get('service_discount/edit', [App\Http\Controllers\admin\WebSettingController::class, 'service_discount_edit'])->name('service_discount.edit');
            Route::post('service_discount/update', [App\Http\Controllers\admin\WebSettingController::class, 'service_discount_update'])->name('service_discount.update');
            Route::post('service_discount/destroy', [App\Http\Controllers\admin\WebSettingController::class, 'service_discount_destroy'])->name('service_discount.destroy');

        Route::get('/domain-extension', [App\Http\Controllers\admin\WebSettingController::class, 'admin_domain_extension_view'])->name('admin.domain-extension-view');
        Route::post('/domain-extension', [App\Http\Controllers\admin\WebSettingController::class, 'admin_add_domain_extension'])->name('admin.add-domain-extension');
        Route::post('/get-domain-extension', [App\Http\Controllers\admin\WebSettingController::class, 'admin_get_domain_extension_data'])->name('admin.get-domain-extension-data');
        Route::post('/delete-domain-extension', [App\Http\Controllers\admin\WebSettingController::class, 'admin_delete_domain_extension_data'])->name('admin.delete-domain-extension-data');
        Route::get('/add-domain-ext', [App\Http\Controllers\admin\WebSettingController::class, 'add_domain_ext'])->name('admin.add-domain-ext');
        Route::post('/domain_ext', [App\Http\Controllers\admin\WebSettingController::class, 'domain_ext'])->name('domain_ext.save');
        Route::get('/edit-domain-ext/{id}', [App\Http\Controllers\admin\WebSettingController::class, 'edit_domain_ext'])->name('admin.edit-domain-ext');
        Route::post('/update_domain_ext', [App\Http\Controllers\admin\WebSettingController::class, 'update_domain_ext'])->name('update_domain_ext.save');
        Route::get('/domain-ext-data', [App\Http\Controllers\admin\WebSettingController::class, 'domain_ext_data'])->name('admin.domain-ext-data');

        Route::get('/admin-user', [App\Http\Controllers\admin\WebSettingController::class, 'admin_user_view'])->name('admin.admin-user-view');
        Route::post('/admin-user', [App\Http\Controllers\admin\WebSettingController::class, 'admin_user'])->name('admin.admin-user');
        Route::post('/admin-user-privilege', [App\Http\Controllers\admin\WebSettingController::class, 'admin_get_user_privilege'])->name('admin.get-user-privilege');
        Route::post('/admin-update-user-privilege', [App\Http\Controllers\admin\WebSettingController::class, 'admin_upadate_user_privilege'])->name('admin.update-user-privilege');
        Route::post('/admin-delete-user-privilege', [App\Http\Controllers\admin\WebSettingController::class, 'admin_delete_user_privilege'])->name('admin.delete-user-privilege');

        Route::post('/delete_domain', [App\Http\Controllers\admin\WebSettingController::class, 'delete_domain'])->name('admin.delete_domain');
        Route::post('/edit-domain', [App\Http\Controllers\admin\WebSettingController::class, 'editDomain'])->name('admin.edit_domain');
        Route::post('/update_domain_renewal_status', [App\Http\Controllers\admin\WebSettingController::class, 'update_domain_renewal_status'])->name('admin.update_domain_renewal_status');




        //neelu july 10
        // Route::post('/update_domain_renewal_status_domain', [App\Http\Controllers\admin\WebSettingController::class, 'update_domain_renewal_status_domain'])->name('admin.update_domain_renewal_status_domain');

        // Route::post('/update_domain_renewal_status_dns', [App\Http\Controllers\admin\WebSettingController::class, 'update_domain_renewal_status_dns'])->name('admin.update_domain_renewal_status_dns');

        // Route::post('/update_domain_renewal_status_lmaas', [App\Http\Controllers\admin\WebSettingController::class, 'update_domain_renewal_status_lmaas'])->name('admin.update_domain_renewal_status_lmaas');


        // Route::post('/update_domain_renewal_status_ewaas', [App\Http\Controllers\admin\WebSettingController::class, 'update_domain_renewal_status_ewaas'])->name('admin.update_domain_renewal_status_ewaas');


Route::post('/renew-all-services', [App\Http\Controllers\admin\WebSettingController::class, 'update_all_renewals'])->name('renew.all.services');



        Route::post('/send_invoice', [App\Http\Controllers\admin\WebSettingController::class, 'sendInvoice'])->name('admin.send_invoice');
        Route::get('/admin-find-users-details-rejected-doc', [App\Http\Controllers\admin\WebSettingController::class, 'admin_find_users_details_view_rejected_doc'])->name('admin.find-users-details-view-rejected-doc');
        Route::get('/admin-find-users-details-cooling-period', [App\Http\Controllers\admin\WebSettingController::class, 'admin_find_users_details_cooling_period_view'])->name('admin.find-users-details-cooling-period-view');
        
        Route::post('/movedomainFromDelete', [App\Http\Controllers\admin\WebSettingController::class, 'movedomainFromDelete'])->name('admin.movedomainFromDelete');
        Route::post('/restoreFromIncDeletedUsers', [App\Http\Controllers\admin\WebSettingController::class, 'restoreFromIncDeletedUsers'])->name('admin.restoreFromIncDeletedUsers');
          Route::get('/admin-incusers-details-deleted/{id}', [App\Http\Controllers\admin\WebSettingController::class, 'admin_incusers_details_view_deleted'])->name('admin.incdeletedusers-details-view');


        Route::get('rejected/ajaxcall', [App\Http\Controllers\admin\WebSettingController::class, 'rejected_ajaxcall'])->name('rejected.ajaxcall');
        Route::get('deletedusers/ajaxcall', [App\Http\Controllers\admin\WebSettingController::class, 'deletedusers_ajaxcall'])->name('deletedusers.ajaxcall');
        Route::get('pendingcreation/ajaxcall', [App\Http\Controllers\admin\WebSettingController::class, 'pendingcreation_ajaxcall'])->name('pendingcreation.ajaxcall');
        Route::get('finduser/ajaxcall', [App\Http\Controllers\admin\WebSettingController::class, 'finduser_ajaxcall'])->name('finduser.ajaxcall');
        Route::get('/admin-find-users-details', [App\Http\Controllers\admin\WebSettingController::class, 'admin_find_users_details_view'])->name('admin.find-users-details-view');
        Route::get('/admin-deleted-users-details', [App\Http\Controllers\admin\WebSettingController::class, 'admin_deleted_users_details_view'])->name('admin.deleted-users-details');
        Route::get('/admin-users-details/{id}', [App\Http\Controllers\admin\WebSettingController::class, 'admin_users_details_view'])->name('admin.users-details-view');

        Route::get('/admin-users-details-deleted/{id}', [App\Http\Controllers\admin\WebSettingController::class, 'admin_users_details_view_deleted'])->name('admin.deletedusers-details-view');

        Route::any('/user-dns-edit/{id}', [App\Http\Controllers\admin\WebSettingController::class, 'user_dns_edit'])->name('admin.user_dns_edit');
        Route::post('/updateUserDnsNameServer', [App\Http\Controllers\admin\WebSettingController::class, 'updateUserDnsNameServer'])->name('admin.updateUserDnsNameServer');
        Route::get('/admin-users-details-doc/{id}', [App\Http\Controllers\admin\WebSettingController::class, 'admin_users_details_view_doc'])->name('admin.users-details-view-doc');
        Route::get('/admin-users-details-rejected-doc/{id}', [App\Http\Controllers\admin\WebSettingController::class, 'admin_users_details_view_rejected_doc'])->name('admin.users-details-view-rejected-doc');
        Route::get('/admin-update-name-server', [App\Http\Controllers\admin\WebSettingController::class, 'admin_update_name_server_view'])->name('admin.update-name-server');
        Route::post('/admin_update_doc', [App\Http\Controllers\admin\WebSettingController::class, 'admin_update_doc'])->name('admin.docupdate');

        Route::post('/updateuserdocument', [App\Http\Controllers\admin\WebSettingController::class, 'updateuserdocument'])->name('admin.updateuserdocument');

        Route::get('extension_prices/ajaxcall', [App\Http\Controllers\admin\WebSettingController::class, 'extension_prices_ajaxcall'])->name('extension_prices.ajaxcall');

        Route::post('/registerUserDomain', [App\Http\Controllers\admin\WebSettingController::class, 'registerUserDomain'])->name('registerUserDomain');

        /*Master Controller start*/
        Route::get('/admin-add-state-city', [App\Http\Controllers\admin\MasterController::class, 'admin_add_state_city_view'])->name('admin.add-state-city-view');

        /*extensions start*/
        Route::get('/extensions', [App\Http\Controllers\admin\MasterController::class, 'admin_extensions_view'])->name('admin.extensions-view');
        Route::post('/add-extensions', [App\Http\Controllers\admin\MasterController::class, 'admin_add_extensions'])->name('admin.add-extensions');
        Route::post('/get-extensions', [App\Http\Controllers\admin\MasterController::class, 'admin_get_extensions'])->name('admin.get-extension-data');
        Route::post('/update-extensions', [App\Http\Controllers\admin\MasterController::class, 'admin_update_extension'])->name('admin.update-extension-data');
        Route::post('/delete-extension', [App\Http\Controllers\admin\MasterController::class, 'admin_delete_extension'])->name('admin.delete-domain-extension');
        /*extensions end*/

        Route::get('/language', [App\Http\Controllers\admin\MasterController::class, 'admin_language_view'])->name('admin.language-view');
        Route::post('/add-language', [App\Http\Controllers\admin\MasterController::class, 'admin_add_language'])->name('admin.add-language');
        Route::post('/get-language', [App\Http\Controllers\admin\MasterController::class, 'admin_get_language'])->name('admin.get-languages-data');
        Route::post('/update-language', [App\Http\Controllers\admin\MasterController::class, 'admin_update_language'])->name('admin.update-languages-data');
        Route::post('/delete-language', [App\Http\Controllers\admin\MasterController::class, 'admin_delete_language'])->name('admin.delete-languages-name');

        Route::get('/admin-add-user-privileges', [App\Http\Controllers\admin\MasterController::class, 'admin_add_user_privileges_view'])->name('admin.add-user-privileges-view');
        Route::get('/admin-add-payment-gatway', [App\Http\Controllers\admin\MasterController::class, 'admin_add_payment_gatway_view'])->name('admin.add-payment-gatway-view');

        Route::get('/documents', [App\Http\Controllers\admin\MasterController::class, 'admin_documents_view'])->name('admin.document-view');
        Route::post('/add-documents', [App\Http\Controllers\admin\MasterController::class, 'admin_add_document'])->name('admin.add-document');
        Route::post('/get-document', [App\Http\Controllers\admin\MasterController::class, 'admin_get_document'])->name('admin.get-document-data');
        Route::post('/update-document', [App\Http\Controllers\admin\MasterController::class, 'admin_update_document'])->name('admin.update-document-data');
        Route::post('/delete-document', [App\Http\Controllers\admin\MasterController::class, 'admin_delete_document'])->name('admin.delete-document-name');

        Route::get('admins', [AdminsController::class, 'index']);
        Route::post('admins/save', [AdminsController::class, 'save'])->name('admins.save');
        Route::get('admins/get', [AdminsController::class, 'get'])->name('admins.adminsid');
        Route::post('admins/update', [AdminsController::class, 'update'])->name('admins.update');
        Route::post('admins/delete', [AdminsController::class, 'deleteById'])->name('admins.delete');
        Route::get('admins/ajaxcall', [AdminsController::class, 'ajaxcall'])->name('admins.ajaxcall');

        Route::get('boards', [BoardController::class, 'index']);
        Route::post('boards/save', [BoardController::class, 'save'])->name('boards.save');
        Route::get('boards/get', [BoardController::class, 'get'])->name('boards.boardsid');
        Route::post('boards/update', [BoardController::class, 'update'])->name('boards.update');
        Route::post('boards/delete', [BoardController::class, 'deleteById'])->name('boards.delete');
        Route::get('boards/ajaxcall', [BoardController::class, 'ajaxcall'])->name('boards.ajaxcall');
        Route::post('boards/import', [BoardController::class, 'import'])->name('boards.import');

        Route::get('/servicereport', [ReportController::class, 'servicereport']);
        Route::get('/servicereportajax', [ReportController::class, 'servicereportajax']);

        Route::get('/reports/user-feedback-report', [ReportController::class, 'user_feedback']);
        Route::get('/userfeedbackajax', [ReportController::class, 'user_feedback_ajax']);

        Route::get('/reports/pending', [ReportController::class, 'pending']);
        Route::get('/pendingajax', [ReportController::class, 'pendingajax']);
        Route::get('/pendingexport', [ReportController::class, 'pendingexport']);

        Route::get('/reports/hardcopy', [ReportController::class, 'hardcopy']);
        Route::get('/hardcopyajax', [ReportController::class, 'hardcopyajax']);
        Route::get('/hardcopyexport', [ReportController::class, 'hardcopyexport']);

        Route::get('/incompleteexport', [ReportController::class, 'incompleteexport']);
        Route::get('/deletedexport', [ReportController::class, 'deletedexport']);
        Route::get('/coolingexport', [ReportController::class, 'coolingexport']);

        Route::get('/reports/hold', [ReportController::class, 'hold']);
        Route::get('/holdajax', [ReportController::class, 'holdajax']);
        Route::get('/holdexport', [ReportController::class, 'holdexport']);

        Route::post('/updatePaymentRecord', [ReportController::class, 'updatePaymentRecord'])->name('domain.updatepayment');

        Route::post('/domain/unhold', [ReportController::class, 'domainunhold'])->name('domain.unhold');
        Route::post('/domain/hold', [ReportController::class, 'domainhold'])->name('domain.hold');
        Route::post('/domain/changepassword', [ReportController::class, 'changepassword'])->name('domain.change_password');

        Route::get('/reports/expired', [ReportController::class, 'expired']);
        Route::get('/expiredajax', [ReportController::class, 'expiredajax']);
        Route::get('/expiredexport', [ReportController::class, 'expiredexport']);

        Route::get('/reports/pendingrestore', [ReportController::class, 'pendingrestore']);
        Route::get('/pendingrestoreajax', [ReportController::class, 'pendingrestoreajax']);
        Route::get('/pendingrestoreexport', [ReportController::class, 'pendingrestoreexport']);

        Route::get('/reports/pendingrenew', [ReportController::class, 'pendingrenew']);
        Route::get('/pendingrenewajax', [ReportController::class, 'pendingrenewajax']);
        Route::get('/pendingrenewexport', [ReportController::class, 'pendingrenewexport']);

        Route::get('/reports/domain', [ReportController::class, 'domain']);
        Route::get('/domainajax', [ReportController::class, 'domainajax']);
        Route::get('/domainexport', [ReportController::class, 'domainexport']);

        Route::get('/reports/renewdomain', [ReportController::class, 'renewdomain']);
        Route::get('/renewdomainajax', [ReportController::class, 'renewdomainajax']);
        
        Route::get('/renewdomainexport', [ReportController::class, 'renewdomainexport']);

        Route::get('/reports/dailyreport', [ReportController::class, 'dailyreport']);
        Route::get('/dailyreportajax', [ReportController::class, 'dailyreportajax']);
        
        Route::get('/dailyreportexport', [ReportController::class, 'dailyreportexport']);

        Route::get('/reports/bulkdomain', [ReportController::class, 'bulkdomain']);
        Route::get('/bulkdomainajax', [ReportController::class, 'bulkdomainajax']);

        Route::get('/reports/activity', [ReportController::class, 'activity']);
        Route::get('/activityajax', [ReportController::class, 'activityajax']);
        Route::get('/activityexport', [ReportController::class, 'activityexport']);

        Route::get('/reports/domainhi', [ReportController::class, 'domainhi']);
        Route::get('/domainhiajax', [ReportController::class, 'domainhiajax']);
        Route::get('/domainhiexport', [ReportController::class, 'domainhiexport']);

        Route::get('/reports/nozone', [ReportController::class, 'nozone']);
        Route::get('/nozoneajax', [ReportController::class, 'nozoneajax']);
        Route::get('/nozoneexport', [ReportController::class, 'nozoneexport']);
        
        Route::get('/reports/payment', [ReportController::class, 'payment']);
        Route::get('/paymentajax', [ReportController::class, 'paymentajax']);
        Route::get('/gettotalamount', [ReportController::class, 'gettotalamount']);
        Route::get('/paymentexport', [ReportController::class, 'paymentexport']);

        Route::get('/reports/billdeskpayment', [ReportController::class, 'billdeskpayment']);
        Route::get('/billdeskpaymentajax', [ReportController::class, 'billdeskpaymentajax']);
        Route::get('/billdeskgettotalamount', [ReportController::class, 'billdeskgettotalamount']);
        
        Route::get('/billdeskpaymentexport', [ReportController::class, 'billdeskpaymentexport']);

        Route::get('/reports/failedpayment', [ReportController::class, 'failedpayment']);
        Route::get('/failedpaymentajax', [ReportController::class, 'failedpaymentajax']);

        Route::get('/reports/vas', [ReportController::class, 'vas']);
        Route::get('/vasajax', [ReportController::class, 'vasajax']);
        Route::get('/vasexport', [ReportController::class, 'vasexport']);
        Route::post('/reports/whoisajaxtest', [ReportController::class, 'whoisajax'])->name('reports.whoisajaxtest');

        Route::get('/reports/whois', [ReportController::class, 'whois']);
        
        Route::get('/reports/expire', [ReportController::class, 'expire']);
        Route::get('/expireajax', [ReportController::class, 'expireajax']);
        Route::get('/expireexport', [ReportController::class, 'expireexport']);

        Route::get('/reports/rejected', [ReportController::class, 'rejected']);
        Route::get('/rejectedajax', [ReportController::class, 'rejectedajax']);
        Route::get('/rejectedexport', [ReportController::class, 'rejectedexport']);

        Route::get('/reports/nodnsrecord', [ReportController::class, 'nodnsrecord']);
        Route::get('/nodnsrecordajax', [ReportController::class, 'nodnsrecordajax']);
        Route::get('/nodnsrecordexport', [ReportController::class, 'nodnsrecordexport']);

        Route::get('/reports/nixi-payment-report', [ReportController::class, 'NixiPayment']);
        Route::get('/nixi-payment-ajax', [ReportController::class, 'NixiPaymentAjax']);
        Route::get('/nixi-gettotalamount', [ReportController::class, 'Nixigettotalamount']);
        
        Route::get('board', [BardController::class, 'index']);
        Route::post('board/save', [BardController::class, 'save'])->name('board.save');
        Route::get('board/get', [BardController::class, 'get'])->name('board.boardid');
        Route::post('board/update', [BardController::class, 'update'])->name('board.update');
        Route::post('board/delete', [BardController::class, 'deleteById'])->name('board.delete');
        Route::get('board/ajaxcall', [BardController::class, 'ajaxcall'])->name('board.ajaxcall');
        Route::post('board/import', [BardController::class, 'import'])->name('board.import');

        Route::get('region', [StateController::class, 'index']);
        Route::post('region/save', [StateController::class, 'save'])->name('region.save');
        Route::get('region/get', [StateController::class, 'get'])->name('region.regionid');
        Route::post('region/update', [StateController::class, 'update'])->name('region.update');
        Route::post('region/delete', [StateController::class, 'deleteById'])->name('region.delete');
        Route::get('region/ajaxcall', [StateController::class, 'ajaxcall'])->name('region.ajaxcall');

        Route::get('city', [CityController::class, 'index']);
        Route::post('city/save', [CityController::class, 'save'])->name('city.save');
        Route::get('city/get', [CityController::class, 'get'])->name('city.get');
        Route::post('city/update', [CityController::class, 'update'])->name('city.update');
        Route::post('city/delete', [CityController::class, 'deleteById'])->name('city.delete');
        Route::get('city/ajaxcall', [CityController::class, 'ajaxcall'])->name('city.ajaxcall');

        Route::get('algos', [AlgoController::class, 'index']);
        Route::post('algos/save', [AlgoController::class, 'save'])->name('algos.save');
        Route::get('algos/get', [AlgoController::class, 'get'])->name('algos.get');
        Route::post('algos/update', [AlgoController::class, 'update'])->name('algos.update');
        Route::post('algos/delete', [AlgoController::class, 'deleteById'])->name('algos.delete');
        Route::get('algos/ajaxcall', [AlgoController::class, 'ajaxcall'])->name('algos.ajaxcall');

        Route::get('module', [ModuleController::class, 'index']);
        Route::post('module/save', [ModuleController::class, 'save'])->name('module.save');
        Route::get('module/get', [ModuleController::class, 'get'])->name('module.moduleid');
        Route::post('module/update', [ModuleController::class, 'update'])->name('module.update');
        Route::post('module/delete', [ModuleController::class, 'deleteById'])->name('module.delete');
        Route::get('module/ajaxcall', [ModuleController::class, 'ajaxcall'])->name('module.ajaxcall');

        Route::get('program', [ProgramController::class, 'index']);
        Route::post('program/save', [ProgramController::class, 'save'])->name('program.save');
        Route::get('program/get', [ProgramController::class, 'get'])->name('program.get');
        Route::post('program/update', [ProgramController::class, 'update'])->name('program.update');
        Route::post('program/delete', [ProgramController::class, 'deleteById'])->name('program.delete');
        Route::get('program/ajaxcall', [ProgramController::class, 'ajaxcall'])->name('program.ajaxcall');

        Route::get('userprivilege', [PrivilegeController::class, 'userprivilege'])->name('user.userprivilege');
        Route::post('handleprivilege', [PrivilegeController::class, 'handleprivilege'])->name('handleprivilege');
        Route::get('userprivilege/ajaxcall', [PrivilegeController::class, 'privilegeajaxcall'])->name('privilege.ajaxcall');

        Route::get('doc', [DocController::class, 'index']);
        Route::post('doc/save', [DocController::class, 'save'])->name('doc.save');
        Route::get('doc/get', [DocController::class, 'get'])->name('doc.docid');
        Route::post('doc/update', [DocController::class, 'update'])->name('doc.update');
        Route::post('doc/delete', [DocController::class, 'deleteById'])->name('doc.delete');
        Route::get('doc/ajaxcall', [DocController::class, 'ajaxcall'])->name('doc.ajaxcall');

        Route::get('discount', [DiscountController::class, 'index']);
        Route::post('discount/save', [DiscountController::class, 'save'])->name('discount.save');
        Route::get('discount/get', [DiscountController::class, 'get'])->name('discount.get');
        Route::post('discount/update', [DiscountController::class, 'update'])->name('discount.update');
        Route::post('discount/delete', [DiscountController::class, 'deleteById'])->name('discount.delete');
        Route::get('discount/ajaxcall', [DiscountController::class, 'ajaxcall'])->name('discount.ajaxcall');

        //Home page news section
        Route::get('/news-section-view', [PageManagementController::class, 'news_section_view'])->name('admin.news-section-view');
        Route::post('/add-news-section', [PageManagementController::class, 'add_news_section'])->name('admin.add-news-section');
        Route::post('/change-news-status', [PageManagementController::class, 'change_news_status'])->name('admin.change-news-status');
        Route::post('/delete-news', [PageManagementController::class, 'delete_news'])->name('admin.delete-news');
        Route::post('/get-news', [PageManagementController::class, 'get_news'])->name('admin.get-news');
        Route::post('/update-news-section', [PageManagementController::class, 'updateNewsSection'])->name('admin.update-news-section');

        //Home page offer section
        Route::get('/offer-section-view', [PageManagementController::class, 'offer_section_view'])->name('admin.offer-section-view');
        Route::post('/add-offer-section', [PageManagementController::class, 'add_offer_section'])->name('admin.add-offer-section');
        Route::post('/change-offer-status', [PageManagementController::class, 'change_offer_status'])->name('admin.change-offer-status');
        Route::post('/delete-offer', [PageManagementController::class, 'delete_offer'])->name('admin.delete-offer');
        Route::post('/get-offer', [PageManagementController::class, 'get_offer'])->name('admin.get-offer');
        Route::post('/update-offer-section', [PageManagementController::class, 'updateOfferSection'])->name('admin.update-offer-section');

        //Tip Of The Day(TOD) Section
        Route::get('/tod-section-view', [PageManagementController::class, 'tod_section_view'])->name('admin.tod-section-view');
        Route::post('/change-tod-status', [PageManagementController::class, 'change_tod_status'])->name('admin.change-tod-status');
        Route::post('/get-tod', [PageManagementController::class, 'get_tod'])->name('admin.get-tod');
        Route::post('/update-tod-section', [PageManagementController::class, 'updateTodSection'])->name('admin.update-tod-section');

        //Admin->Web settings-> Email setting route
        Route::match(['get','post'],'/email-setting-view', [App\Http\Controllers\admin\WebSettingController::class, 'emailSettingView'])->name('admin.email-settings-view');
        Route::post('/change-email-setting-status', [App\Http\Controllers\admin\WebSettingController::class, 'changeEmailSettingStatus'])->name('admin.change-email-setting-status');
        Route::post('/update-email-setting', [App\Http\Controllers\admin\WebSettingController::class, 'updateEmailSetting'])->name('admin.update-email-setting');

        Route::post('/save-ernet-dns-record', [\App\Http\Controllers\admin\WebSettingController::class, 'save_ernet_dns_record'])->name('save-ernet-dns-record');

        Route::get('/rejectedexport1', [App\Http\Controllers\admin\WebSettingController::class, 'rejectedexport1'])->name('admin.rejectedexport1');

        Route::get('/activedomainexport', [App\Http\Controllers\admin\WebSettingController::class, 'activedomainexport'])->name('admin.activedomainexport');

        //Admin->payment getway list
        Route::get('/payment-gateway-view', [PaymentGatewaySettingsController::class, 'index'])->name('admin.payment-gateway-view');
        Route::post('/payment-gateway-view/save', [PaymentGatewaySettingsController::class, 'save'])->name('gateway.save');
        Route::get('/payment-gateway-view/ajaxcall', [PaymentGatewaySettingsController::class, 'ajaxcall'])->name('gateway.ajaxcall');
        Route::get('/payment-gateway-view/get', [PaymentGatewaySettingsController::class, 'get'])->name('gateway.regionid');
        Route::post('/payment-gateway-view/update', [PaymentGatewaySettingsController::class, 'update'])->name('gateway.update');
        Route::post('/payment-gateway-view/delete', [PaymentGatewaySettingsController::class, 'deleteById'])->name('gateway.delete');

        //Admin->payment getway list
        Route::get('/email-setting-view', [EmailSettingsController::class, 'index'])->name('admin.email-setting-view');
        Route::post('/email-setting/save', [EmailSettingsController::class, 'save'])->name('emaiSetting.save');
        Route::get('/email-setting/ajaxcall', [EmailSettingsController::class, 'ajaxcall'])->name('emaiSetting.ajaxcall');
        Route::get('/email-setting/get', [EmailSettingsController::class, 'get'])->name('emaiSetting.regionid');
        Route::post('/email-setting/update', [EmailSettingsController::class, 'update'])->name('emaiSetting.update');
        Route::post('/email-setting/delete', [EmailSettingsController::class, 'deleteById'])->name('emaiSetting.delete');

        //Admin->payment(The List of User Payment )
        Route::get('payments', [\App\Http\Controllers\admin\WebSettingController::class, 'userPayment'])->name('admin.payment-view');
        Route::get('payment/ajaxcall', [\App\Http\Controllers\admin\WebSettingController::class, 'ajaxcallPayment'])->name('payment.ajaxcall');
        Route::get('userInvoice', [\App\Http\Controllers\admin\WebSettingController::class, 'userInvoice']);
        Route::get('userParticularInvoice', [\App\Http\Controllers\admin\WebSettingController::class, 'userParticularInvoice']);

        
        // zone management admin
        Route::get('search',
            [SearchController::class, 'index'])
            ->name('search.index');
        Route::get('search/results',
            [SearchController::class, 'search'])
            ->name('search.results');
        /**
         * ------------------------------------------
         * Servers
         * ------------------------------------------.
         */
        // DataTables Ajax route.
        Route::middleware(AjaxRequestOnly::class)
            ->get('servers/data',
                [ServerController::class, 'data'])
            ->name('servers.data');

        // Our special delete confirmation route - uses the show/details view.
        Route::get('servers/{server}/delete',
            [ServerController::class, 'delete'])
            ->name('servers.delete');

        // Pre-baked resource controller actions for index, create, store,
        // show, edit, update, destroy
        Route::resource('servers', ServerController::class);

        /**
         * ------------------------------------------
         * Zones
         * ------------------------------------------.
         */
        // DataTables Ajax route.
        Route::middleware(AjaxRequestOnly::class)
            ->get('zones/data',
                [ZoneController::class, 'data'])
            ->name('zones.data');

        // Pre-baked resource controller actions for index, create, store,
        // show, edit, update, destroy
        Route::resource('zones', ZoneController::class);

        /**
         * ------------------------------------------
         * ResourceRecords
         * ------------------------------------------.
         */
        // DataTables Ajax route.
        Route::middleware(AjaxRequestOnly::class)
            ->get('zones/{zone}/records/data',
                [ResourceRecordController::class, 'data'])
            ->name('zones.records.data');

        // Our special delete confirmation route - uses the show/details view.
        Route::get('zones/{zone}/records/{record}/delete',
            [ResourceRecordController::class, 'delete'])
            ->name('zones.records.delete');

        // Pre-baked resource controller actions for index, create, store,
        // show, edit, update, destroy
        Route::resource('zones.records', ResourceRecordController::class);

        /**
         * ------------------------------------------
         * Settings
         * ------------------------------------------.
         */
        Route::get('settings',
            [SettingsController::class, 'index'])
            ->name('settings.index');

        Route::put('settings',
            [SettingsController::class, 'update'])
            ->name('settings.update');

        /**
         * ------------------------------------------
         * Tools
         * ------------------------------------------.
         */

        // Push DNS servers tool
        Route::get('tools/push',
            [SyncServersController::class, 'index'])
            ->name('tools.view_updates');

        Route::post('tools/push',
            [SyncServersController::class, 'sync'])
            ->name('tools.push_updates');

        // Bulk update tool
        Route::get('tools/update',
            [BulkUpdateController::class, 'index'])
            ->name('tools.bulk_update');
        Route::post('tools/update',
            [BulkUpdateController::class, 'update'])
            ->name('tools.do_bulk_update');

        // Zone import tool
        Route::get('tools/import',
            [ImportZoneController::class, 'index'])
            ->name('tools.import_zone');
        Route::post('tools/import',
            [ImportZoneController::class, 'store'])
            ->name('tools.import_zone_post');

    });
});

