<?php
$route =\Route::currentRouteAction();
$routeDatArr=explode('\\',$route);
//$ext = explode('@',array_last(explode('\\',$route)));
$routeData=explode('@',end($routeDatArr));
list($controller, $action) = explode('@', end($routeDatArr));
?>
    <!DOCTYPE html>
<!-- beautify ignore:start -->
<html lang="en" class="light-style layout-menu-fixed" dir="ltr" data-theme="theme-default" data-assets-path="<?php echo e(asset('user/assets/')); ?>" data-template="vertical-menu-template-free" >
<head>
    <meta charset="utf-8" />
    <meta
        name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"
    />

    <title><?php echo e($title); ?></title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('user/assets/img/favicon/favicon.ico')); ?>" />

    <!-- Fonts -->
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet"
    />

    <!-- Icons. Uncomment required icon fonts -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/vendor/fonts/boxicons.css')); ?>" />

    <!-- Core CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('user/assets/vendor/css/core.css')); ?>" class="template-customizer-core-css" />
    <link rel="stylesheet" href="<?php echo e(asset('user/assets/vendor/css/theme-default.css')); ?>" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="<?php echo e(asset('user/assets/css/demo.css')); ?>" />

    <!-- Vendors CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('user/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('user/assets/vendor/css/pages/page-auth.css')); ?>" />
    <!-- Helpers -->
    <script src="<?php echo e(asset('user/assets/vendor/js/helpers.js')); ?>"></script>
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/sweetalert2.min.css')); ?>" />
    <script src="<?php echo e(asset('/assets/js/sweetalert2.min.js')); ?>"></script>
</head>

<body oncontextmenu="return false;">

<div class="container-xxl">
    <div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner">
            <!-- Register -->
            <div class="card">
                <div class="card-body">
                    <!-- Logo -->
                    <div class="app-brand justify-content-center">
                        <a href="" class="app-brand-link gap-2">
                  <span class="app-brand-logo demo">
                     <img style="    height: 50px;    width: auto;" src="<?php echo e(asset('user/assets/img/logo.png')); ?>">
                  </span>
                        </a>
                    </div>
                    <div class="col-md mb-4 mb-md-0">
                            <?php if(Session::has('message')): ?>
                                <p class="alert text-dark <?php echo e(Session::get('alert-class', 'alert-danger')); ?>"><?php echo e(Session::get('message')); ?></p>
                            <?php endif; ?>
                            <?php if($errors->any()): ?>
                                    <ul>
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="alert alert-danger" role="alert"><?php echo e($error); ?>!</div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                            <?php endif; ?>
                    </div>
                    <br>
                    <form id="formAuthentication" class="mb-3" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label for="email" class="form-label">Username (DomainName)</label>
                            <input
                                type="text"
                                class="form-control specialchars"
                                id="email"
                                name="email"
                                placeholder="Enter your DomainName"
                                autofocus
                                required
                            />
                        </div>
                        <div class="mb-3 form-password-toggle">
                            <div class="d-flex justify-content-between">
                                <label class="form-label" for="password">Password</label>
                                <a href="<?php echo e(url('forgot')); ?>">
                                    <small>Forgot Password?</small>
                                </a>

                           
                            </div>
                            <div class="input-group input-group-merge">
                                <input
                                    type="password"
                                    id="password"
                                    class="form-control passwordchars"
                                    name="password"
                                    placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                    aria-describedby="password"
                                    required
                                />
                                <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                            </div>
                        </div>
                        <div class="mb-3 d-none">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="remember" id="remember-me" />
                                <!-- <label class="form-check-label" for="remember-me"> Remember Me </label> -->
                            </div>
                        </div>
                        <div class="mb-3">
                            <button class="btn btn-primary d-grid w-100" type="submit">Login</button>
                        </div>
                    </form>
                    <p class="text-center">
                        <span>New on our platform?</span>
                        <a href="<?php echo e(url('')); ?>">
                            <span>Create an account</span>
                        </a>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo e(asset('user/assets/vendor/libs/jquery/jquery.js')); ?>"></script>
<script src="<?php echo e(asset('user/assets/vendor/libs/popper/popper.js')); ?>"></script>
<script src="<?php echo e(asset('user/assets/vendor/js/bootstrap.js')); ?>"></script>
<script src="<?php echo e(asset('user/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js')); ?>"></script>
<script src="<?php echo e(asset('user/assets/vendor/js/menu.js')); ?>"></script>
<script src="<?php echo e(asset('user/assets/js/main.js')); ?>"></script>
<script async defer src="<?php echo e(asset('assets/js/buttons.js')); ?>"></script>
<script src="<?php echo e(asset('/assets/js/jquery.min.js')); ?>"></script>
<!-- jquery-validation -->
<script src="<?php echo e(asset('assets/plugins/jquery-validation/jquery.validate.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/jquery-validation/additional-methods.min.js')); ?>"></script>



<script type="text/javascript">
     
$(document).ready(function(){

$('.specialchars').on('keypress',function(e){

    var regex = /^[a-zA-Z0-9.\- ]+$/;
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});


$('.passwordchars').on('keypress',function(e){

var regex=new RegExp("^[a-zA-Z@#!$0-9 ]");
var key=String.fromCharCode(!e.charCode ? e.which :e.charCode);
if(!regex.test(key)){
    e.preventDefault();
    return false;
}

});

$("#formAuthentication").validate({
              rules:
              {
                email:{
                  required: true
                  
                },
                password:{
                  required: true,
                  minlength: 5
                }
              },
              messages:
              {
                 email:
                 {
                    required: "Please enter valid Email",
                    minlength:'Please enter valid Email'
                 },
                 password:
                 {
                   required: "Please enter valid password",
                   minlength: "Please enter valid password"
                 }
              },
              submitHandler:function (form)
              {
                
                   $.ajax({
                      url:"<?php echo e(route('googleAuthLogin')); ?>",
                      type:'POST',
                      dataType:'json',
                      data:$("#formAuthentication").serialize(),
                      
                      
                      success:function(data)
                      {
                        
                        if(data.status=='success')
                        {
                            
                          window.location="<?php echo e(route('google-auth-otp')); ?>";
                        }
                        else if(data.status=='googleauth_register')
                        {
                            
                            Swal.fire({
                            title: 'Confirmation',
                            text: 'Please Register for Google Authauthenticator App?',
                            icon: 'question',
                            showCancelButton: true,
                            confirmButtonText: 'Yes',
                            cancelButtonText: 'No'
                            
                        }).then((result) => {
                            if (result.isConfirmed) {
                              
                            window.location="<?php echo e(route('user.googleauthregister')); ?>";
                                             
                         } else
                         {
                            window.location="<?php echo e(route('user.login')); ?>";
                         }
                        });

                        }
                        
                        else if(data.status=='samelogin')
                        {
                           Swal.fire({
                            title: 'Confirmation',
                            text: 'Are you sure, you want to proceed?',
                            icon: 'question',
                            showCancelButton: true,
                            confirmButtonText: 'Yes',
                            cancelButtonText: 'No'
                            
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $.ajaxSetup({
                                                headers: {
                                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                                }
                                            });
                    
                                        $.ajax({
                                            url: "<?php echo e(route('useraccesstokenupdate')); ?>",
                                            dataType : "json",
                                            type: "get",
                                            data : {},
                                            success : function(response) {
                                                
                                                if(response.status == 'success') {
                                                     
                                                     window.location="<?php echo e(route('google-auth-otp')); ?>";
                                                                                    
                                                } else if(response.status == 'error') {
                                                    
                                                    window.location="<?php echo e(route('user.login')); ?>";
                                                    
                                                } 
                                          },
                                        });
                             
                         } else
                         {
                            window.location="<?php echo e(route('user.login')); ?>";
                         }
                        });

                        }
                        else
                        {
                          Swal.fire({
                            title: "Error!",
                            text: data.message,
                            icon: "error"
                          });
                        }
                      },
                      complete:function()
                      {
                        $("#login-btn").prop('disabled',false);
                        $('.cs-process-loader').hide();
                      }
                   });
                
              }
          });

});

</script>

</body>
</html>
<?php /**PATH /var/www/html/ernet/resources/views/user/pages/login.blade.php ENDPATH**/ ?>