<?php $__env->startSection('content'); ?>
<!-- Content wrapper -->
<div class="container-xxl flex-grow-1 container-p-y">
  <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"></span> Dashboard </h4>
  <div class="row">
    <!-- Domain Status Table Start-->
      <?php if(Session::has('message')): ?>
          <p class="alert text-dark <?php echo e(Session::get('alert-class', 'alert-success')); ?>"><?php echo e(Session::get('message')); ?></p>
      <?php endif; ?>
    <div class="col-12 my-3">
      <h5 class="card-header bg-info">Domain Status </h5>
      <div class="card">
        <div class="card-body">
          <div class="table-responsive text-nowrap">
            <table class="table table-striped table-bordered dataTable no-footer">
              <thead class="table-secondary">
                <tr>
                  <th>Domain</th>
                  <th>Status</th>
                  <th>Last update</th>
                  <th>Domain Expiry Date</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                <?php
                     if(Auth::user()->domainStatus==6){
                        $ex=\Carbon\Carbon::parse(Auth::user()->domainExpiryDate);
                        $years=\Carbon\Carbon::now()->diffInYears($ex);
                        $allowyear=9-$years;
                     }else{
                         $allowyear=0;
                     }
                ?>

                  <td>
                    <strong>
                      <?php if(Auth::user()->domainStatus > 5): ?>
                      <a style="color:#000" href="<?php echo e(url('user-application-preview')); ?>" > <?php echo e(\Illuminate\Support\Facades\Auth::user()->domainName); ?>

                      <?php if(Auth::user()->domainLangID==3): ?>
                      <?php echo e((Auth::user()->domainPunycode)); ?>

                      <?php endif; ?>
                    </a>
                      <?php else: ?>
                      <?php echo e(\Illuminate\Support\Facades\Auth::user()->domainName); ?>

                      <?php if(Auth::user()->domainLangID==3): ?>
                      <?php echo e((Auth::user()->domainPunycode)); ?>

                      <?php endif; ?>
                       <?php endif; ?></strong>
                  </td>
                   <td>
                       <?php if(Auth::user()->domainStatus == 0): ?>
                           <a href="<?php echo e(url('add-contact-details')); ?>">Contact Details Pending <i class="bx bx-edit"></i></a>
                       <?php elseif(Auth::user()->domainStatus == 1): ?>
                            <a href="<?php echo e(url('dns-name-server')); ?>">DNS Details Pending <i class="bx bx-edit"></i></a>
                       <?php elseif(Auth::user()->domainStatus == 2): ?>
                            <a href="<?php echo e(url('dns-name-server-payment')); ?>">Payment Pending <i class="bx bx-edit"></i></a>
                       <?php elseif(Auth::user()->domainStatus == 3): ?>
                           <a href="<?php echo e(url('upload-documents')); ?>">Documents Upload Pending <i class="bx bx-edit"></i></a>
                       <?php elseif(Auth::user()->domainStatus == 4 && Auth::user()->applicationDate != ''): ?>
                           <!-- <a href="<?php echo e(url('upload-documents')); ?>">Document Modification Required <i class="bx bx-edit"></i></a> -->
                       <?php elseif(Auth::user()->domainStatus == 4 && Auth::user()->applicationDate == ''): ?>
                           <a href="<?php echo e(url('user-application-preview')); ?>">Application Preview<i class="bx bx-edit"></i></a>
                       <?php elseif(Auth::user()->domainStatus == 5): ?>
                           Domain Application Successfully Submitted
                       <?php elseif(Auth::user()->domainStatus == 6): ?>
                           <a class="text-success" href="<?php echo e(url('user-application-preview')); ?>" >Active</a>
                       <?php elseif(Auth::user()->domainStatus == 7): ?>
                       <b class="text-danger">Domain Hold</b>
                       <?php elseif(Auth::user()->domainStatus == 8): ?>
                       <b class="text-danger">Pending Restorable</b>
                       <?php elseif(Auth::user()->domainStatus == 10): ?>
                           <b class="text-success">Applied for Renewal</b>
                       <?php elseif(Auth::user()->domainStatus == 11): ?>
                       <b class="text-danger">Pending Restorable</b>
                       <?php endif; ?>
                     
                       <!-- <?php if($renewshowdate < $todaydate): ?>

                       <?php if(Auth::user()->domainStatus != 10 ): ?>
                      
                       <a href="<?php echo e(url('renew-domain')); ?>" style="float:right">Renew Domain</a>
                       <?php endif; ?>
                       <?php endif; ?> -->

                       
                       <?php if(Auth::user()->domainStatus != 10 && Auth::user()->domainStatus>=6): ?>
                      
                       <a href="<?php echo e(url('renew-domain')); ?>" style="float:right">Renew Domain</a>

                       <?php endif; ?>

                        <?php if((Auth::user()->domainStatus == 4 &&  Auth::user()->document_status==1 ) || (Auth::user()->domainStatus == 10 &&  Auth::user()->document_status==1)): ?>
                           <a href="<?php echo e(url('upload-documents')); ?>">Document Modification Required <i class="bx bx-edit"></i></a>
                        <?php endif; ?>
                   </td>
                  <td><?php echo e(\Carbon\Carbon::parse(Auth::user()->updated_at)->format('d/m/Y g:i A')); ?></td>
                  <td>
                  <?php if(Auth::user()->domainExpiryDate!=null): ?>
                  <?php echo e(\Carbon\Carbon::parse(Auth::user()->domainExpiryDate)->format('d/m/Y g:i A')); ?>

                  <?php endif; ?>
                  </td>
                  
                </tr>
              </tbody>
            </table>
              <?php if(Auth::user()->domainStatus == 5): ?>
                  <div class="col-12 mt-3 px-1">
                      <a href="<?php echo e(url('user-application-preview')); ?>" class="btn btn-info ml-3" id="add-server-smt-btn" >Preview Application</a>
                      <a href="<?php echo e(url('signout')); ?>" class="btn btn-danger ml-3">Logout</a>
                  </div>
              <?php endif; ?>

          </div>
        </div>
      </div>
    </div>
    <!-- Domain Status Table End-->
  </div>
</div>
<!-- Content wrapper -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection("js"); ?>

<script>
       
       <?php if(session('message')): ?>
           
          <?php if(session('message')=='The Payment is Successfully done.'): ?>
          
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: '<?php echo e(session('message')); ?>',
                customClass: {
                    container: 'alert-container'
                }
            });

           <?php endif; ?>

        <?php endif; ?>

</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.UserLayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/ernet/resources/views/user/pages/index.blade.php ENDPATH**/ ?>