<?php $__env->startSection('content'); ?>

<?php

$action='';

$userid=Auth::guard('admin')->user()->id;

$edit=$del=$add=true;
$priv=getUserHasRoleProgram($userid,18);

if($priv!=null){
    $edit=$priv->modify_priv==1 ?true:false;
    $del=$priv->del_priv==1 ?true:false;
    $add=$priv->add_priv==1 ?true:false;
}
$head_name = get_heading_name(18);
   if($head_name!=null){
       $heading_name= $head_name;
   }else
   {
      $heading_name="Domain Price Details";
   }

?>

<div class="container-xxl flex-grow-1 container-p-y">
    <div class="row">
        <div class="col-12 my-2">
            <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"></span><?php echo e($heading_name); ?></h4>
            <div class="card">
                <div class="card-body">
                    <div class="row">
                        <div class="col-xl-12">
                            <div class="nav-align-top mb-4">
                                <ul class="nav nav-tabs nav-fill" role="tablist">
                                    <li class="nav-item">
                                        <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#navs-justified-prices" aria-controls="navs-justified-prices" aria-selected="true">
                                            Domain Prices
                                        </button>
                                    </li>
                                    <li class="nav-item">
                                        <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#navs-justified-discounts" aria-controls="navs-justified-discounts" aria-selected="false">
                                            Service Discounts
                                        </button>
                                    </li>
                                </ul>

                                <div class="tab-content" style="box-shadow: none">
                                    <!-- Domain Prices Tab -->
                                    <div class="tab-pane fade show active" id="navs-justified-prices" role="tabpanel">
                                        <div class="card mb-4" style="box-shadow: none">
                                            <h5 class="card-header">Domain Price List
                                                <?php if($add): ?> <button class="btn btn-info float-end" data-bs-toggle="modal" data-bs-target="#add_price_modal"> + Add Price</button> <?php endif; ?>
                                            </h5>
                                            <div class="card-body">
                                                <div class="table-responsive text-nowrap">
                                                    <table class="table table-striped table-bordered dataTable no-footer" id="dataTable" width="100%" cellspacing="0">
                                                        <thead class="table-secondary">
                                                            <tr>
                                                                <th>S. No.</th>
                                                                <th>Domain Language</th>
                                                                <th>Years</th>
                                                                <th>Registration Price</th>
                                                                <th>Renewal Charge</th>
                                                                <th>Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody></tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Service Discounts Tab -->
                                    <div class="tab-pane fade" id="navs-justified-discounts" role="tabpanel">
                                        <div class="card mb-4" style="box-shadow: none">
                                            <h5 class="card-header">Service Discount List
                                                <?php if($add): ?> <button class="btn btn-info float-end" data-bs-toggle="modal" data-bs-target="#add_discount_modal"> + Add Discount</button> <?php endif; ?>
                                            </h5>
                                            <div class="card-body">
                                                <div class="table-responsive text-nowrap">
                                                    <table class="table table-striped table-bordered dataTable no-footer" id="discountTable" width="100%" cellspacing="0">
                                                        <thead class="table-secondary">
                                                            <tr>
                                                                <th>S.No.</th>
                                                                <th>Period (Years)</th>
                                                                <th>Services</th>
                                                                <th>Discount (%)</th>
                                                                <th>Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody></tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Domain Price Modals -->
<div class="modal fade add_price_modal" id="add_price_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Add Domain Prices</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form role="form" id="add_price_form" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="me-md-3 mb-4">
                        <label class="form-label">Domain Language <span class="text-danger">*</span></label>
                        <select class="form-control" name="domain_extension" id="domain_extension" required>
                            <option value="1">English</option>
                            <option value="2">Hindi</option>
                        </select>
                    </div>
                    <div class="me-md-3 mb-4">
                        <label class="form-label">Years <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="years" id="years" required>
                    </div>
                    <div class="me-md-3 mb-4">
                        <label class="form-label">Registration Price <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="price" id="price" required>
                    </div>
                    <div class="me-md-3 mb-4">
                        <label class="form-label">Renewal Charge <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="renewal_charge" id="renewal_charge" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button class="btn btn-primary d-grid" id="add_price_btn" name="action" value="submit">Add</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade update_price_modal" id="update_price_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Update Domain Prices</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form role="form" id="update_price_form" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <input type="hidden" name="price_id" id="price_id">
                    <div class="me-md-3 mb-4">
                        <label class="form-label">Domain Language <span class="text-danger">*</span></label>
                        <select class="form-control update_extension" name="domain_extension" id="">
                            <option value="1">English</option>
                            <option value="2">Hindi</option>
                        </select>
                    </div>
                    <div class="me-md-3 mb-4">
                        <label class="form-label">Years <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="years" id="update_years" required>
                    </div>
                    <div class="me-md-3 mb-4">
                        <label class="form-label">Registration Price <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="price" id="update_price" required>
                    </div>
                    <div class="me-md-3 mb-4">
                        <label class="form-label">Renewal Charge <span class="text-danger">*</span></label>
                        <input type="number" class="form-control" name="renewal_charge" id="update_renewal_charge" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button class="btn btn-primary d-grid" id="update_price_btn" name="action" value="submit">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Service Discount Modals -->
<div class="modal fade" id="add_discount_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Add Service Discount</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form role="form" id="add_discount_form" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="me-md-3 mb-4">
                        <label class="form-label">Period (Years) <span class="text-danger">*</span></label>
                        <select class="form-control" name="period" id="period" required>
                            <?php for($i=1; $i<=10; $i++): ?>
                                <option value="<?php echo e($i); ?>"><?php echo e($i); ?> Year<?php echo e($i>1?'s':''); ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    
                    <div class="me-md-3 mb-4">
                        <label class="form-label">Services <span class="text-danger">*</span></label>
                        <div class="form-check">
                            <input class="form-check-input service-check" type="checkbox" name="services[]" value="domain" id="domain_check">
                            <label class="form-check-label" for="domain_check">Domain</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input service-check" type="checkbox" name="services[]" value="nameserver" id="nameserver_check">
                            <label class="form-check-label" for="nameserver_check">Nameserver</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input service-check" type="checkbox" name="services[]" value="waas" id="waas_check">
                            <label class="form-check-label" for="waas_check">WaaS</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input service-check" type="checkbox" name="services[]" value="lmaas" id="lmaas_check">
                            <label class="form-check-label" for="lmaas_check">L-MaaS</label>
                        </div>
                    </div>
                    
                    <div class="me-md-3 mb-4">
                        <label class="form-label">Discount (%) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control valid-per" name="discount" id="discount" min="0" max="100" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button class="btn btn-primary" id="add_discount_btn" name="action" value="submit">Add</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="edit_discount_modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Edit Service Discount</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form role="form" id="edit_discount_form" method="POST">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="discount_id" id="edit_discount_id">
                <div class="modal-body">
                    <div class="me-md-3 mb-4">
                        <label class="form-label">Period (Years) <span class="text-danger">*</span></label>
                        <select class="form-control" name="period" id="edit_period" required>
                            <?php for($i=1; $i<=10; $i++): ?>
                                <option value="<?php echo e($i); ?>"><?php echo e($i); ?> Year<?php echo e($i>1?'s':''); ?></option>
                            <?php endfor; ?>
                        </select>
                    </div>
                    
                    <div class="me-md-3 mb-4">
                        <label class="form-label">Services <span class="text-danger">*</span></label>
                        <div class="form-check">
                            <input class="form-check-input service-check" type="checkbox" name="services[]" value="domain" id="edit_domain_check">
                            <label class="form-check-label" for="edit_domain_check">Domain</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input service-check" type="checkbox" name="services[]" value="nameserver" id="edit_nameserver_check">
                            <label class="form-check-label" for="edit_nameserver_check">Nameserver</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input service-check" type="checkbox" name="services[]" value="waas" id="edit_waas_check">
                            <label class="form-check-label" for="edit_waas_check">WaaS</label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input service-check" type="checkbox" name="services[]" value="lmaas" id="edit_lmaas_check">
                            <label class="form-check-label" for="edit_lmaas_check">L-MaaS</label>
                        </div>
                    </div>
                    
                    <div class="me-md-3 mb-4">
                        <label class="form-label">Discount (%) <span class="text-danger">*</span></label>
                        <input type="number" class="form-control valid-per" name="discount" id="edit_discount" min="0" max="100" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button class="btn btn-primary" id="edit_discount_btn" name="action" value="submit">Update</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection("js"); ?>
<script>
$(document).ready(function() {
    // Initialize Domain Price Table
    var table = $('#dataTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "<?php echo e(route('extension_prices.ajaxcall')); ?>",
            type: "GET",
            datatype: "json",
            data: function(d){
                d.ext_id = $('#hi').val();
            }
        },
        columns: [
            { data: 'id' },
            { data: 'ext', orderable: false },
            { data: 'year', orderable: false },
            { data: 'price', orderable: false },
            { data: 'renewal_charge', orderable: false },
            { data: 'Action', orderable: false },
        ]
    });

    // Initialize Service Discount Table
    var discountTable = $('#discountTable').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "<?php echo e(route('service_discount.ajaxcall')); ?>",
            type: "GET",
            datatype: "json"
        },
        columns: [
            { data: 'id' },
            { data: 'period' },
            { data: 'services', orderable: false },
            { data: 'discount' },
            { data: 'action', orderable: false }
        ]
    });

    // Domain Price Form Handling
    $('#add_price_form').validate({
        rules: {
            years: { maxlength: 2 },
            price: { maxlength: 35 },
            renewal_charge: { maxlength: 35 },
        },
        messages: {
            years: { required: "This field is required" },
            price: { required: "This field is required" },
            renewal_charge: { required: "This field is required" },
        },
        submitHandler: function(form) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(Route('admin.add-price-setting')); ?>",
                type: 'POST',
                dataType: 'json',
                data: $(form).serialize(),
                beforeSend: function() {
                    $("#add_price_btn").prop('disabled', true);
                },
                success: function(res) {
                    if(res.status == 'success') {
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            text: res.message,
                            showConfirmButton: true,
                        }).then(function() {
                            window.location = "<?php echo e(route('admin.price-setting-view')); ?>";
                        });
                    } else if(res.status == 'errors') {
                        $.each(res.message, function(i, message) {
                            $('#'+i).after('<span class="Description_error" style="color:red">'+message+'</span>');
                        });
                    } else {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            text: res.message,
                            showConfirmButton: true,
                        });
                    }
                },
                complete: function() {
                    $("#add_price_btn").prop('disabled', false);
                }
            });
        }
    });

    // Service Discount Form Handling
    $('#add_discount_form').validate({
        rules: {
            'services[]': { required: true },
            discount: { required: true, min: 0, max: 100 }
        },
        messages: {
            'services[]': "Please select at least one service",
            discount: {
                required: "Please enter discount percentage",
                min: "Discount cannot be negative",
                max: "Discount cannot exceed 100%"
            }
        },
        submitHandler: function(form) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('service_discount.store')); ?>",
                type: 'POST',
                dataType: 'json',
                data: $(form).serialize(),
                beforeSend: function() {
                    $("#add_discount_btn").prop('disabled', true);
                },
                success: function(res) {
                    if(res.status == 'success') {
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            text: res.message,
                            showConfirmButton: true,
                        }).then(function() {
                            $('#add_discount_modal').modal('hide');
                            discountTable.ajax.reload();
                        });
                    } else {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            text: res.message,
                            showConfirmButton: true,
                        });
                    }
                },
                complete: function() {
                    $("#add_discount_btn").prop('disabled', false);
                }
            });
        }
    });

    // Edit Discount
    $('body').on('click', '.edit-discount', function() {
        var discountId = $(this).data('id');
        $.ajax({
            url: "<?php echo e(route('service_discount.edit')); ?>",
            type: 'GET',
            data: { id: discountId },
            success: function(res) {
                if(res.status == 'success') {
                    var discount = res.discount;
                    $('#edit_discount_id').val(discount.id);
                    $('#edit_period').val(discount.period);
                    $('#edit_discount').val(discount.discount);
                    
                    // Uncheck all checkboxes first
                    $('.service-check').prop('checked', false);
                    
                    // Check the appropriate checkboxes
                    var services = discount.services.split(',');
                    services.forEach(function(service) {
                        $('#edit_' + service.trim() + '_check').prop('checked', true);
                    });
                    
                    $('#edit_discount_modal').modal('show');
                }
            }
        });
    });

    // Update Discount
    $('#edit_discount_form').validate({
        rules: {
            'services[]': { required: true },
            discount: { required: true, min: 0, max: 100 }
        },
        messages: {
            'services[]': "Please select at least one service",
            discount: {
                required: "Please enter discount percentage",
                min: "Discount cannot be negative",
                max: "Discount cannot exceed 100%"
            }
        },
        submitHandler: function(form) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "<?php echo e(route('service_discount.update')); ?>",
                type: 'POST',
                dataType: 'json',
                data: $(form).serialize(),
                beforeSend: function() {
                    $("#edit_discount_btn").prop('disabled', true);
                },
                success: function(res) {
                    if(res.status == 'success') {
                        Swal.fire({
                            position: 'center',
                            icon: 'success',
                            text: res.message,
                            showConfirmButton: true,
                        }).then(function() {
                            $('#edit_discount_modal').modal('hide');
                            discountTable.ajax.reload();
                        });
                    } else {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            text: res.message,
                            showConfirmButton: true,
                        });
                    }
                },
                complete: function() {
                    $("#edit_discount_btn").prop('disabled', false);
                }
            });
        }
    });

    // Delete Discount
    $('body').on('click', '.delete-discount', function() {
        var discountId = $(this).data('id');
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: "<?php echo e(route('service_discount.destroy')); ?>",
                    type: 'POST',
                    data: { 
                        _token: "<?php echo e(csrf_token()); ?>",
                        id: discountId 
                    },
                    success: function(res) {
                        if(res.status == 'success') {
                            Swal.fire(
                                'Deleted!',
                                res.message,
                                'success'
                            );
                            discountTable.ajax.reload();
                        } else {
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                text: res.message,
                                showConfirmButton: true,
                            });
                        }
                    }
                });
            }
        });
    });

    // Existing Domain Price Functions
    $('body').on('click', '.update', function() {
        var price_id = $(this).attr('data-id');
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: "<?php echo e(Route('admin.get-domain-price')); ?>",
            type: 'GET',
            dataType: 'json',
            data: {price_id: price_id},
            success: function(res) {
                if(res.status == 'success') {
                    var price = res.price;
                    $('#price_id').val(price.id);
                    $('.update_extension option[value="' + price.domain_extension_id + '"]').attr('selected', true);
                    $('#update_years').val(price.year);
                    $('#update_price').val(price.price);
                    $('#update_renewal_charge').val(price.renewal_charge);
                    $("#update_price_modal").modal('show');
                } else {
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        text: res.message,
                        showConfirmButton: true,
                    });
                }
            }
        });
    });

    $('body').on('click', '.delete-dns-price', function() {
        var domain_price_id = $(this).attr('data-id');
        Swal.fire({
            title: 'Are you sure?',
            text: "You won't be able to revert this!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, delete it!'
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "<?php echo e(Route('admin.delete-domain-price')); ?>",
                    type: 'POST',
                    dataType: 'json',
                    data: {domain_price_id: domain_price_id},
                    success: function(res) {
                        if(res.status == 'success') {
                            Swal.fire(
                                'Deleted!',
                                'Price has been deleted.',
                                'success'
                            );
                            window.location = "<?php echo e(route('admin.price-setting-view')); ?>";
                        } else {
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                text: res.message,
                                showConfirmButton: true,
                            });
                        }
                    }
                });
            }
        });
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.AdminLayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/ernet/resources/views/admin/pages/domain-extension-price-setting.blade.php ENDPATH**/ ?>