<!DOCTYPE html>
<html
    lang="en"
    class="light-style customizer-hide"
    dir="ltr"
    data-theme="theme-default"
    data-assets-path="../assets/"
    data-template="vertical-menu-template-free"
>
<head>
    <meta charset="utf-8" />
    <meta
        name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0"
    />

    <title><?php echo e($title); ?></title>

    <meta name="description" content="" />

    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('user/assets/img/favicon/favicon.ico')); ?>" />

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
        href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&display=swap"
        rel="stylesheet"
    />

    <link rel="stylesheet" href="../assets/vendor/fonts/boxicons.css" />

    <link rel="stylesheet" href="<?php echo e(asset('user/assets/vendor/css/core.css')); ?>" class="template-customizer-core-css" />
    <link rel="stylesheet" href="<?php echo e(asset('user/assets/vendor/css/theme-default.css')); ?>" class="template-customizer-theme-css" />
    <link rel="stylesheet" href="<?php echo e(asset('user/assets/css/demo.css')); ?>" />

    <link rel="stylesheet" href="<?php echo e(asset('user/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('user/assets/vendor/css/pages/page-auth.css')); ?>" />
    <script src="<?php echo e(asset('user/assets/vendor/js/helpers.js')); ?>"></script>
</head>

<body>
<div class="container-xxl">
    <div class="authentication-wrapper authentication-basic container-p-y">
        <div class="authentication-inner">
            <div class="card">
                <div class="card-body">
                    <div class="app-brand justify-content-center">
                        <a href="<?php echo e(url('/')); ?>" class="app-brand-link gap-2">
                  <span class="app-brand-logo demo">
                   <img style="    height: 50px;    width: auto;" src="<?php echo e(asset('user/assets/img/logo.png')); ?>">
                  </span>

                        </a>
                    </div>

                    <?php if(Session::has('message')): ?>
                        <p class="alert text-center text-dark <?php echo e(Session::get('alert-class', 'alert-info')); ?>"><?php echo e(Session::get('message')); ?></p>
                    <?php endif; ?>
                    <?php if($errors->any()): ?>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <p class="alert alert-danger" role="alert"><?php echo e($error); ?>!</p>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    <p class="app-brand-text text-body  text-center ">Create Password</p>
                    <form class="mb-3" action="<?php echo e(url('googleAuth')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input name="userid" type="hidden" value="<?php echo e($user->id); ?>">
                        <div class="mb-3">
                            <label for="username" class="form-label">Username</label>
                            <input
                                type="text"
                                class="form-control"
                                id="username"
                                name="username"
                                value="<?php echo e($user->domainName); ?>"
                                placeholder="Enter your username"
                                readonly
                            />
                        </div>
                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="text" value="<?php echo e($user->email); ?>" class="form-control" id="email" name="email" placeholder="Enter your email" readonly/>
                        </div>
                        <div class="mb-3 form-password-toggle">
                            <label class="form-label" for="password">Password</label>
                            <div class="input-group input-group-merge" data-tip="This is the text of the tooltip2">
                                <input
                                    type="password"
                                    id="password"
                                    class="form-control password-input"
                                    name="password"
                                    placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                    aria-describedby="password"
                                    required
                                />
                            </div>
                            <!-- <span class="text-info" style="font-size:13px" >
                                  Password should contains numbers, letters, and special characters.
                                </span> -->
                                <!-- <span id="password-strength"></span> -->
                              <span id="password-hint" class="text-info" style="font-size:13px" >
                              Password should contains numbers, letters, and special characters.
                             </span>

                        </div>
                        <div class="mb-3 form-password-toggle">
                            <label class="form-label" for="password">Confirm Password</label>
                            <div class="input-group input-group-merge">
                                <input
                                    type="password"
                                    id="password"
                                    class="form-control"
                                    name="password_confirmation"
                                    placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                    aria-describedby="password"
                                    required
                                />
                                <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                            </div>
                        </div>










                        <button class="btn btn-primary d-grid w-100">Create Password</button>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>

<script src="<?php echo e(asset('user/assets/vendor/libs/jquery/jquery.js')); ?>"></script>
<script src="<?php echo e(asset('user/assets/vendor/libs/popper/popper.js')); ?>"></script>
<script src="<?php echo e(asset('user/assets/vendor/js/bootstrap.js')); ?>"></script>
<script src="<?php echo e(asset('user/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js')); ?>"></script>
<script src="<?php echo e(asset('user/assets/vendor/js/menu.js')); ?>"></script>
<script src="<?php echo e(asset('user/assets/js/main.js')); ?>"></script>
<script async defer src="https://buttons.github.io/buttons.js"></script>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
        <script>

            $(window).on('load', function() {
                $('#exampleModalCenter').modal('show');
            });
            $('#closeModal').click(function() {
                $('#exampleModalCenter').modal('hide');
            });


$(document).ready(function() {

  $('.password-input').on('input', function() {
    var password = $(this).val();
    
    var strength = checkPasswordStrength(password);
        
    var hint = getPasswordHint(strength);
    $('#password-hint').text('' + hint);
  });
});

function checkPasswordStrength(password) {
  var strength = '';
  
  if (password.length >= 8) {
    strength += 'Length: Strong, ';
  } else {
    strength += 'Length: Weak, ';
  }
  
  if (/[A-Z]/.test(password)) {
    strength += 'Uppercase: Strong, ';
  } else {
    strength += 'Uppercase: Weak, ';
  }
  
  if (/[a-z]/.test(password)) {
    strength += 'Lowercase: Strong, ';
  } else {
    strength += 'Lowercase: Weak, ';
  }
  
  if (/\d/.test(password)) {
    strength += 'Number: Strong, ';
  } else {
    strength += 'Number: Weak, ';
  }
  
  if (/[^A-Za-z0-9]/.test(password)) {
    strength += 'Special character: Strong';
  } else {
    strength += 'Special character: Weak';
  }
  
  return strength;
}

function getPasswordHint(strength) {
  if (strength.includes('Weak')) {
    return 'Your password is weak. Please make sure it has at least 8 characters, including one uppercase letter, one lowercase letter, one number, and one special character.';
  } else if (strength.includes('Strong')) {
    return 'Your password is strong.';
  } else {
    return 'Your password is okay, but it can be stronger. Try including at least 8 characters, including one uppercase letter, one lowercase letter, one number, and one special character.';
  }
}


</script>

</body>
</html>
<?php /**PATH /var/www/html/ernet/resources/views/user/pages/register.blade.php ENDPATH**/ ?>