<?php $__env->startSection('content'); ?>

    <?php

    $action = '';

    $userid = Auth::guard('admin')->user()->id;

    $edit = $del = $add = true;
    $priv = getUserHasRoleProgram($userid, 15);

    if ($priv != null) {
        $edit = $priv->modify_priv == 1 ? true : false;
        $del = $priv->del_priv == 1 ? true : false;
        $add = $priv->add_priv == 1 ? true : false;
    }
    $head_name = get_heading_name(15);
    if ($head_name != null) {
        $heading_name = $head_name;
    } else {
        $heading_name = "DNS Server Prices Details ";
    }


                                            ?>

    <div class="content-wrapper">
        <div class="container-xxl flex-grow-1 container-p-y">
            <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light"></span>DNS Server Prices Details </h4>
            <div class="card mb-4">
                <div class="card-body">
                    <form role="form" id="add_dns_form" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-4 mb-3">
                                <label class="form-label">Primary Name Server <span class="text-danger">*</span></label>
                                <input type="text" class="form-control ipadddress" name="primary_name_server" id="add_name"
                                    value="<?php echo e($getDNSData->primary_name_server); ?>" maxlength="35" required>
                            </div>
                            <?php $__currentLoopData = json_decode($getDNSData->secondary_name_server); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Secondary Name Server <?php echo e($key + 1); ?></label>
                                    <input type="text" class="form-control ipadddress" name="secondary_name_server[]"
                                        id="secondary_name_server<?php echo e($key); ?>" value="<?php echo e($value); ?>" maxlength="35">
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="my-3">
                            <?php if($add): ?>
                                <button class="btn btn-success d-grid float-end" id="add_dns_btn" name="action"
                                    value="submit">Submit</button>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card mb-4">
                <h5 class="card-header">
                    <!-- DNS Server Cost Details   -->
                    <?php if($add): ?><button class="btn btn-info float-end " data-bs-toggle="modal"
                    data-bs-target="#add_price_modal"> + Add Price</button><?php endif; ?>
                </h5>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class=" table table-striped table-bordered dataTable no-footer">
                            <thead class="table-secondary">
                                <tr>
                                    <!-- <th>Id</th> -->
                                    <th>Years</th>
                                    <th>DNS Service Cost</th>
                                    <th>DNS Renewal Charge</th>
                                    <th>WaaS Service Cost</th>
                                    <th>WaaS Renewal Charge</th>
                                    <th>LMaaS Service Cost</th>
                                    <th>LMaaS Renewal Charge</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $getDNSPrice; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin_user_list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <!-- <td><?php echo e($admin_user_list->id); ?></td> -->
                                        <td><?php echo e($admin_user_list->years); ?></td>
                                        <td><?php echo e($admin_user_list->price); ?></td>
                                        <td><?php echo e($admin_user_list->name_servers_price_renewal_charge); ?></td>
                                        <td><?php echo e($admin_user_list->vas_price); ?></td>
                                        <td><?php echo e($admin_user_list->ewaas_price_renewal_charge); ?></td>
                                        <td><?php echo e($admin_user_list->lmaas_price); ?></td>
                                        <td><?php echo e($admin_user_list->lmaas_price_renewal_charge); ?></td>
                                        <td>
                                            <?php if($edit): ?>
                                                <i class="fa fa-edit text-info fs-3 me-md-3 kp-edit-user"
                                                    data-id="<?php echo e($admin_user_list->id); ?>" data-bs-toggle="modal"
                                                    data-bs-target="#update_price_modal"></i>
                                            <?php endif; ?>
                                            <?php if($del): ?>
                                                <i class="fa fa-trash text-danger fs-3 delete-dns-price"
                                                    data-id="<?php echo e($admin_user_list->id); ?>"></i>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- / Content -->
        <!-- Modal -->
        <div class="modal fade add_price_modal" id="add_price_modal" data-bs-backdrop="static" data-bs-keyboard="false"
            tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel">Add DNS Prices</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    
                    <form role="form" id="add_price_form" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">

                            <div class="me-md-3 mb-4">
                                <label class="form-label">Years</label>
                                <input type="number" class="form-control" name="years" id="years"
                                    onKeyPress="if(this.value.length==2) return false;">
                            </div>
<div class="row">
                            <div class="col-md-6 mb-4">
                                <label class="form-label">DNS Price</label>
                                <input type="number" class="form-control" name="price" id="price"
                                    onKeyPress="if(this.value.length==5) return false;" min="0">
                            </div>
                            <!-- ✅ New Field: DNS Charge -->
                            <div class="col-md-6 mb-4">
                                <label class="form-label">DNS Charge</label>
                                <input type="number" class="form-control" name="dns_charge" id="dns_charge"
                                    onKeyPress="if(this.value.length==5) return false;" min="0">
                            </div>
</div>
<div class="row">
                            <div class="col-md-6 mb-4">
                                <label class="form-label">WaaS Price</label>
                                <input type="number" class="form-control" name="vas_price" id="vas_price"
                                    onKeyPress="if(this.value.length==5) return false;" min="0">
                            </div>

                            <!-- ✅ New Field: WaaS Charge -->
                            <div class="col-md-6 mb-4">
                                <label class="form-label">WaaS Charge</label>
                                <input type="number" class="form-control" name="waas_charge" id="waas_charge"
                                    onKeyPress="if(this.value.length==5) return false;" min="0">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-4">
                                <label class="form-label">LMaaS Price</label>
                                <input type="number" class="form-control" name="lmaas_price" id="lmaas_price"
                                    onKeyPress="if(this.value.length==5) return false;" min="0">
                            </div>
                            <!-- ✅ New Field: LMaaS Charge -->
                            <div class="col-md-6 mb-4">
                                <label class="form-label">LMaaS Charge</label>
                                <input type="number" class="form-control" name="lmaas_charge" id="lmaas_charge"
                                    onKeyPress="if(this.value.length==5) return false;" min="0">
                            </div>
                        </div>
                    </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button class="btn btn-primary d-grid" id="add_price_btn" name="action"
                                value="submit">Add</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
        <div class="modal fade update_price_modal" id="update_price_modal" data-bs-backdrop="static"
            data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel">Update DNS Prices</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <form role="form" id="update_price_form" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div class="me-md-3  mb-4">
                                <label class="form-label">Years </label>
                                <input type="number" class="form-control" name="years" id="update_years"
                                    onKeyPress="if(this.value.length==2) return false;">
                                <input type="hidden" class="form-control" name="price_id" id="update_price_id">
                            </div>

<div class="row">
                            <div class="col-md-6 mb-4">
                                <label class="form-label">DNS Price</label>
                                <input type="number" class="form-control" name="price" id="update_price"
                                    onKeyPress="if(this.value.length==5) return false;" min="0">
                            </div>

                            <div class="col-md-6 mb-4">
                                <label class="form-label">DNS Renew Charge</label>
                                <input type="number" class="form-control" name="r_dns_charge" id="r_dns_charge"
                                    onKeyPress="if(this.value.length==5) return false;" min="0">
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-4">
                                <label class="form-label">WaaS Price</label>
                                <input type="number" class="vas_price form-control" name="vas_price" id=""
                                    onKeyPress="if(this.value.length==5) return false;" min="0">
                            </div>

                            <div class="col-md-6 mb-4">
                                <label class="form-label">WaaS Renew Charge</label>
                                <input type="number" class="form-control" name="r_waas_charge" id="r_waas_charge"
                                    onKeyPress="if(this.value.length==5) return false;" min="0">
                            </div>
                        </div>
                         <div class="row">
                            <div class="col-md-6 mb-4">
                                <label class="form-label">LMaaS Price</label>
                                <input type="number" class="form-control lmaas_price" name="lmaas_price" id=""
                                    onKeyPress="if(this.value.length==5) return false;" min="0">
                            </div>
                            <div class="col-md-6 mb-4">
                                <label class="form-label">LMaaS Renew Charge</label>
                                <input type="number" class="form-control" name="r_lmaas_charge" id="r_lmaas_charge"
                                    onKeyPress="if(this.value.length==5) return false;" min="0">
                            </div>
                        </div>

                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button class="btn btn-primary d-grid" id="update_price_btn" name="action"
                                value="submit">Update</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection("js"); ?>
    <script>
        $(document).ready(function () {

            $('.ipadddress').on('keypress', function (e) {

                var regex = new RegExp("^[a-zA-Z0-9.]");
                var key = String.fromCharCode(!e.charCode ? e.which : e.charCode);
                if (!regex.test(key)) {
                    e.preventDefault();
                    return false;
                }

            });


            $('#add_dns_form').validate({
                rules: {
                    primary_name_server: { required: true, maxlength: 35, },

                },
                messages:
                {
                    primary_name_server: { required: "Please enter primary name server", maxlength: "Not more than 35 character" },
                },
                submitHandler: function (form) {

                    var regexm = /^[a-zA-Z0-9.]+$/;

                    // if (!regexm.test($('#secondary_name_server0').val())) {
                    //     alert('Special Characters not allowed');
                    //   return false;
                    // }

                    // if (!regexm.test($('#secondary_name_server1').val())) {
                    //     alert('Special Characters not allowed');
                    //   return false;
                    // }

                    if ($('#secondary_name_server2').val() !== null) {

                        //     if (!regexm.test($('#secondary_name_server2').val())) {
                        //     alert('Special Characters not allowed');
                        //   return false;
                        // }

                    }


                    if ($('#secondary_name_server3').val() !== null) {

                        // if (!regexm.test($('#secondary_name_server3').val())) {
                        // alert('Special Characters not allowed');
                        // return false;
                        // }

                    }


                    if ($('#secondary_name_server4').val() !== null) {

                        // if (!regexm.test($('#secondary_name_server4').val())) {
                        // alert('Special Characters not allowed');
                        // return false;
                        // }

                    }







                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(Route('admin.dns-details-add')); ?>",
                        type: 'POST',
                        dataType: 'json',
                        data: $("#add_dns_form").serialize(),
                        cache: false,
                        beforeSend: function () {
                            $("#add_dns_btn").prop('disabled', true);
                            $(".loader-area").show();
                        },
                        success: function (res) {
                            if (res.status == 'success') {
                                Swal.fire({
                                    position: 'center',
                                    icon: 'success',
                                    text: res.message,
                                    showConfirmButton: true,
                                    timer: 6000,
                                });
                                window.location = "<?php echo e(route('admin.dns-details-view')); ?>";
                            } else if (res.status == 'error') {
                                Swal.fire({
                                    position: 'center',
                                    icon: 'error',
                                    text: res.message,
                                    showConfirmButton: true,
                                });

                            }
                            else {
                                Swal.fire({
                                    position: 'center',
                                    icon: 'error',
                                    text: 'All fields are required',
                                    showConfirmButton: false,
                                });
                            }
                        },
                        complete: function () {
                            $("form").trigger("reset");
                            $("#add_dns_btn").prop('disabled', false);
                        },
                    });
                }
            });

            $('.kp-edit-user').click(function () {
                var price_id = $(this).attr('data-id');
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    url: "<?php echo e(Route('admin.get-price-data')); ?>",
                    type: 'GET',
                    dataType: 'json',
                    data: { price_id: price_id },
                    cache: false,
                    beforeSend: function () {
                        $("#update_price_btn").prop('disabled', true);
                        $(".loader-area").show();
                    },
                    success: function (res) {
                        if (res.status == 'success') {
                            var price = res.price;
                            //  console.log(price);
                             
                            $('#update_price_id').attr('value', price.id);
                            $('#update_years').attr('value', price.years);
                            $('#update_price').attr('value', price.price);
                            $('.vas_price').attr('value', price.vas_price);
                            $('.lmaas_price').attr('value', price.lmaas_price);
                            $('#r_dns_charge').attr('value', price.name_servers_price_renewal_charge);
                            $('#r_waas_charge').attr('value', price.ewaas_price_renewal_charge);
                            $('#r_lmaas_charge').attr('value', price.lmaas_price_renewal_charge);
                            $(".update_price_modal").modal('show');
                        }
                        else {
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                text: res.message,
                                showConfirmButton: false,
                            });
                        }
                    },
                    complete: function () {
                        $("form").trigger("reset");
                        $("#update_price_btn").prop('disabled', false);
                    },
                });
            });

            $('#add_price_form').validate({
                rules: {
                    years: { maxlength: 35, },
                    price: { required: true },
                },
                messages:
                {
                    years: { required: "Please choose role" },
                    price: { required: "Please choose role" },
                },
                submitHandler: function (form) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(Route('admin.dns-price-add')); ?>",
                        type: 'POST',
                        dataType: 'json',
                        data: $("#add_price_form").serialize(),
                        cache: false,
                        beforeSend: function () {
                            $(".loader-area").show();
                        },
                        success: function (res) {
                            if (res.status == 'success') {
                                Swal.fire({
                                    position: 'center',
                                    icon: 'success',
                                    text: res.message,
                                    showConfirmButton: true,
                                });
                                window.location = "<?php echo e(route('admin.dns-details-view')); ?>";
                            }
                            else {
                                Swal.fire({
                                    position: 'center',
                                    icon: 'error',
                                    text: 'All fields are required',
                                    showConfirmButton: true,
                                });
                            }
                        },
                        complete: function () {
                            $("form").trigger("reset");
                            $("#update_admin_user_btn").prop('disabled', false);
                        },
                    });
                }
            });
            $('#update_price_form').validate({
                rules: {
                    primary_name_server: { required: true, maxlength: 35, },
                    price: { required: true },
                    vas_price: { required: true },
                },
                messages:
                {
                    primary_name_server: { required: "Please enter primary name server", maxlength: "Not more than 35 character" },
                },
                submitHandler: function (form) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                    $.ajax({
                        url: "<?php echo e(Route('admin.dns-price-update')); ?>",
                        type: 'POST',
                        dataType: 'json',
                        data: $("#update_price_form").serialize(),
                        cache: false,
                        beforeSend: function () {
                            $(".loader-area").show();
                            $("#update_price_btn").prop('disabled', true);
                        },
                        success: function (res) {
                            if (res.status == 'success') {
                                Swal.fire({
                                    position: 'center',
                                    icon: 'success',
                                    text: res.message,
                                    showConfirmButton: true,
                                });
                                window.location = "<?php echo e(route('admin.dns-details-view')); ?>";
                            }
                            else {
                                Swal.fire({
                                    position: 'center',
                                    icon: 'error',
                                    text: 'All fields are required',
                                    showConfirmButton: true,
                                });
                            }
                        },
                        complete: function () {
                            $("form").trigger("reset");
                            $("#update_price_btn").prop('disabled', false);
                        },
                    });
                }
            });

            $('.delete-dns-price').click(function () {
                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        var price_id = $(this).attr('data-id');
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        $.ajax({
                            url: "<?php echo e(Route('admin.dns-price-delete')); ?>",
                            type: 'GET',
                            dataType: 'json',
                            data: { price_id: price_id },
                            cache: false,
                            beforeSend: function () {
                                $(".loader-area").show();
                            },
                            success: function (res) {
                                if (res.status == 'success') {
                                    Swal.fire(
                                        'Deleted!',
                                        'Price has been deleted.',
                                        'success'
                                    )
                                    window.location = "<?php echo e(route('admin.dns-details-view')); ?>";
                                }
                                else {
                                    Swal.fire({
                                        position: 'center',
                                        icon: 'error',
                                        text: 'All fields are required',
                                        showConfirmButton: true,
                                    });
                                }
                            },
                            complete: function () {
                                $("form").trigger("reset");
                                $("#update_price_setting_btn").prop('disabled', false);
                            },
                        });
                    }
                });
            });

        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.AdminLayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/ernet/resources/views/admin/pages/dns-setting.blade.php ENDPATH**/ ?>