<?php
namespace App\Components;
use App\Models\Admin;
use Auth;
class AdminManager
{
	public static $_instance;

    public static function getInstance() {
        if ( !(self::$_instance instanceof self) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
	
	public function getAdminById($id)
	{
		return Admin::find($id);
	}
	
	public function checkAdminCount($name, $id = null) {
		return Admin::where(['name' => $name])->first();
	}

	public function create($data) {
		$status = Admin::create($data);
		
		if($status)
		{

			return true;			
		}
		return false;
	}
	
	public function updateById($id, $data) {
		$obj = $this->getAdminById($id);
		$clone = $obj->replicate();
		$status = $obj->update($data);
		
		if($status)
		{			
			return true;	
		}
		
		return false;
	}
	
	public function deleteById($id)
	{
		$obj = $this->getAdminById($id);
		
		$clone = $obj->replicate();
		
		if($obj->delete())
		{
			
			return true;
		}
		
		return false;
	}
}
