<?php
namespace App\Components;
use App\Models\Board;
use Auth;
class BoardManager
{
	public static $_instance;

    public static function getInstance() {
        if ( !(self::$_instance instanceof self) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
	
	public function getBoardById($id)
	{
		return Board::find($id);
	}
	
	public function checkBoardCount($name, $id = null) {
		return Board::where(['name' => $name])->first();
	}

	public function create($data) {
		$status = Board::create($data);
		
		if($status)
		{

			return true;			
		}
		return false;
	}
	
	public function updateById($id, $data) {
		$obj = $this->getBoardById($id);
		$clone = $obj->replicate();
		$status = $obj->update($data);
		
		if($status)
		{			
			return true;	
		}
		
		return false;
	}
	
	public function deleteById($id)
	{
		$obj = $this->getBoardById($id);
		
		$clone = $obj->replicate();
		
		if($obj->delete())
		{
			
			return true;
		}
		
		return false;
	}
}
