<?php
namespace App\Components;
use App\Models\Doc;
use Auth;
class DocManager
{
	public static $_instance;

    public static function getInstance() {
        if ( !(self::$_instance instanceof self) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
	
	public function getDocById($id)
	{
		return Doc::find($id);
	}
	
	public function checkDocCount($name, $id = null) {
		return Doc::where(['name' => $name])->first();
	}

	public function create($data) {
		$status = Doc::create($data);
		
		if($status)
		{

			return true;			
		}
		return false;
	}
	
	public function updateById($id, $data) {
		$obj = $this->getDocById($id);
		$clone = $obj->replicate();
		$status = $obj->update($data);
		
		if($status)
		{
			
			// $this->historyStore($id, $obj, $clone, 'Update');
			
			return true;
			
		}
		
		return false;
	}
	
	public function deleteById($id)
	{
		$obj = $this->getDocById($id);
		
		$clone = $obj->replicate();
		
		if($obj->delete())
		{
			
			return true;
		}
		
		return false;
	}
	
	private function historyStore($id, $obj, $clone, $mode)
	{
			$string = 'id = '.$id.', new description = '.$obj->name.', old description = '.$clone->name;
            $string.=' ';
			$data = ['name' => "Doc Master", 'data' => $string, 'user_id' => Auth::user()->id, 'mode' => $mode];
			\App\Models\HistoryReport::create($data);			
	}
}
