<?php
namespace App\Components;
use App\Models\EmailSetting;
use Auth;
class EmailSettingManager
{
	public static $_instance;

    public static function getInstance() {
        if ( !(self::$_instance instanceof self) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
	
	public function getStateById($id)
	{
		return EmailSetting::find($id);
	}
	
	public function checkStateCount($name, $id = null) {
		return EmailSetting::where(['name' => $name])->first();
	}

	public function create($data) {
		$status = EmailSetting::create($data);
		
		if($status)
		{

			return true;			
		}
		return false;
	}
	
	public function updateById($id, $data) {
		$obj = $this->getStateById($id);
		$clone = $obj->replicate();
		$status = $obj->update($data);
		
		if($status)
		{
			
			// $this->historyStore($id, $obj, $clone, 'Update');
			
			return true;
			
		}
		
		return false;
	}
	
	public function deleteById($id)
	{
		$obj = $this->getStateById($id);
		
		$clone = $obj->replicate();
		
		if($obj->delete())
		{
			
			return true;
		}
		
		return false;
	}
	
	private function historyStore($id, $obj, $clone, $mode)
	{
			$string = 'id = '.$id.', new description = '.$obj->name.', old description = '.$clone->name;
            $string.=' ';
			$data = ['name' => "State Master", 'data' => $string, 'user_id' => Auth::user()->id, 'mode' => $mode];
			\App\Models\HistoryReport::create($data);			
	}
}
