<?php
namespace App\Components;
use App\Models\City;
use Auth;
class PrivilegeManager
{
	public static $_instance;

    public static function getInstance() {
        if ( !(self::$_instance instanceof self) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
	
	public function getCityById($id)
	{
		return City::find($id);
	}
	
	public function checkCityCount($name, $id = null) {
		return City::where(['name' => $name])->first();
	}

	public function create($data) {
		$status = City::create($data);
		
		if($status)
		{

			return true;			
		}
		return false;
	}
	
	public function updateById($id, $data) {
		$obj = $this->getCityById($id);
		$clone = $obj->replicate();
		$status = $obj->update($data);
		
		if($status)
		{
						
			return true;
			
		}
		
		return false;
	}
	
	public function deleteById($id)
	{
		$obj = $this->getCityById($id);
		
		$clone = $obj->replicate();
		
		if($obj->delete())
		{
			
			return true;
		}
		
		return false;
	}
	
	private function historyStore($id, $obj, $clone, $mode)
	{
			$string = 'id = '.$id.', new description = '.$obj->name.', old description = '.$clone->name;
            $string.=' ';
			$data = ['name' => "City Master", 'data' => $string, 'user_id' => Auth::user()->id, 'mode' => $mode];
			\App\Models\HistoryReport::create($data);			
	}
}
