<?php
namespace App\Components;
use App\Models\Program;
use Auth;
class ProgramManager
{
	public static $_instance;

    public static function getInstance() {
        if ( !(self::$_instance instanceof self) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
	
	public function getProgramById($id)
	{
		return Program::find($id);
	}
	
	public function checkProgramCount($name, $id = null) {
		return Program::where(['name' => $name])->first();
	}

	public function create($data) {
		$status = Program::create($data);
		
		if($status)
		{

			return true;			
		}
		return false;
	}
	
	public function updateById($id, $data) {
		$obj = $this->getProgramById($id);
		$clone = $obj->replicate();
		$status = $obj->update($data);
		
		if($status)
		{
						
			return true;
			
		}
		
		return false;
	}
	
	public function deleteById($id)
	{
		$obj = $this->getProgramById($id);
		
		$clone = $obj->replicate();
		
		if($obj->delete())
		{
			
			return true;
		}
		
		return false;
	}
	
	private function historyStore($id, $obj, $clone, $mode)
	{
			$string = 'id = '.$id.', new description = '.$obj->name.', old description = '.$clone->name;
            $string.=' ';
			$data = ['name' => "Program Master", 'data' => $string, 'user_id' => Auth::user()->id, 'mode' => $mode];
			\App\Models\HistoryReport::create($data);			
	}
}
