<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Throwable;
use App\Library\EPP;
use App\Components\MailManager;

class DomainOnHold extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:domainHold';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try {

            // ->subDays(1)
            $users = DB::table('users')
                ->whereDate('domainExpiryDate','=',Carbon::now()->format('Y-m-d'))
                ->where('domainStatus',6)->get();
            $data = [];

            $titlefromadmin=getmisc();

            foreach ($users as $user){

                $data['email'] = $user->email;
                $data['name'] = $user->name;
                $data['subject'] = ' Your Domain ('.$user->domainName .') is on Hold';
                $data['hold_price'] = DB::table('misc_settings')->first()->reactivation_price;
                $data['content'] = $titlefromadmin->email_hold;
                $data['ccMails']=getCCMail($user->id);

                $updated_date = date('Y-m-d H:i:s');
                $user = User::find($user->id);
                $user->domainStatus = 7;
                $user->updated_at = $updated_date;
                $user->save();

                $epp=new EPP();

                $epp->domainStatusUpdate($user->domainName,'clientHold','add');
                

                try {

                    $view = 'front.email.domainOnHold';

                    $mailer = MailManager::getInstance();
        
                    $status=$mailer->mailSender($view, $data);

                } catch (Throwable $e) {
                Log::info($e);
                }

            }

        } catch (Throwable $e) {
            Log::info($e);
        }
    }
}
