<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Throwable;
use App\Library\EPP;
use App\Components\MailManager;

class DomainOnTempDelete extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:domainTempDeleted';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {

        $setting = DB::table('misc_settings')->first();

        $days=$setting->hold_domain_period;

        $users = DB::table('users')
                ->whereDate('domainExpiryDate','=',Carbon::now()->subDays($days)->format('Y-m-d'))
                ->where('domainStatus',7)->get();
        $data = [];

        $titlefromadmin=getmisc();

        foreach ($users as $user){
            $data['email'] = $user->email;
            $data['name'] = $user->name;
            $data['ccMails']=getCCMail($user->id);

            $data['subject'] = 'Your Domain ('.$user->domainName .') is already expired and is in Restorable Period';
            $data['hold_price'] = DB::table('misc_settings')->first()->hold_deduction_price;
            $data['content'] = $titlefromadmin->email_restorable;
            $updated_date = date('Y-m-d H:i:s');
            $user = User::find($user->id);
            $user->domainStatus = 8;
            $user->updated_at = $updated_date;
            $user->save();
        

            try {

                $epp=new EPP();

                $epp->domainStatusUpdate($user->domainName,'clientHold','rem');


                $res=$epp->deletedomain($user->domainName);

    

            $view = 'front.email.domainTempDelete';

            $mailer = MailManager::getInstance();

            $status=$mailer->mailSender($view, $data);


        } catch (Throwable $e) {
            Log::info($e);
        }

        }
    }
}
