<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Throwable;
use App\Components\MailManager;

class DomainTempExpireReminders extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:domainTempDeleteReminders';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try {
            $users = DB::table('users')->get();
            $settings = DB::table('misc_settings')->first();
            $data = [];
            foreach ($users as $user){
                $days=$setting->hold_domain_period+$setting->restorable_domain_reminder_period;
                if (Carbon::parse($user->domainExpiryDate)->addDays($days)->format('Y-m-d') == Carbon::now()->format('Y-m-d') && Carbon::parse($user->domainExpiryDate)->addDays($user->domainExpiryDate)->addDays($settings->restorable_domain_period)->format('Y-m-d') > Carbon::now()->format('Y-m-d') ){
                    $data['email'] = $user->email;
                    $data['name'] = $user->name;
                    $data['subject'] = 'Reminder - Your Domain ('.$user->domainName .') is on Pending Restore';

                    $titlefromadmin=getmisc();
           
                    $data['content'] = $titlefromadmin->pending_restore_reminders;
                    
                    $data['ccMails']=getCCMail($user->id);

                    try {

                        
                $view = 'front.email.domainTempDelete';

                $mailer = MailManager::getInstance();
    
                $status=$mailer->mailSender($view, $data);

                

                } catch (Throwable $e) {
                }

                }
                if (Carbon::parse($user->domainExpiryDate)->addDays($days*2)->format('Y-m-d') == Carbon::now()->format('Y-m-d') && Carbon::parse($user->domainExpiryDate)->addDays($settings->restorable_domain_period)->format('Y-m-d') > Carbon::now()->format('Y-m-d') ){
                    $data['email'] = $user->email;
                    $data['name'] = $user->name;
                    $data['subject'] = 'Reminder -  Your Domain is on Pending Restore';

                    $titlefromadmin=getmisc();
           
                    $data['content'] = $titlefromadmin->pending_restore_reminders;
                    

                    $data['ccMails']=getCCMail($user->id);

                    try {

                        $view = 'front.email.domainTempDelete';

                        $mailer = MailManager::getInstance();
            
                        $status=$mailer->mailSender($view, $data);
        
                    } catch (Throwable $e) {
                        
                    }

                }
                if (Carbon::parse($user->domainExpiryDate)->addDays($days*3)->format('Y-m-d') == Carbon::now()->format('Y-m-d') && Carbon::parse($user->domainExpiryDate)->addDays($settings->restorable_domain_period)->format('Y-m-d') > Carbon::now()->format('Y-m-d') ){
                    $data['email'] = $user->email;
                    $data['name'] = $user->name;
                    $data['subject'] = 'Reminder - Your Domain is On Pending Restore';

                    $titlefromadmin=getmisc();
           
                    $data['content'] = $titlefromadmin->pending_restore_reminders;
                    
                    $data['ccMails']=getCCMail($user->id);

                    try {

                        $view = 'front.email.domainTempDelete';

                        $mailer = MailManager::getInstance();
            
                        $status=$mailer->mailSender($view, $data);
        
                } catch (Throwable $e) {
                    
                }

                }
                if (Carbon::parse($user->domainExpiryDate)->addDays($days*4)->format('Y-m-d') == Carbon::now()->format('Y-m-d') && Carbon::parse($user->domainExpiryDate)->addDays($settings->restorable_domain_period)->format('Y-m-d') > Carbon::now()->format('Y-m-d') ){
                    $data['email'] = $user->email;
                    $data['name'] = $user->name;
                    $data['subject'] = 'Reminder -  Your Domain is On Pending Restore';

                    $titlefromadmin=getmisc();
           
                    $data['content'] = $titlefromadmin->pending_restore_reminders;
                    
                    $data['ccMails']=getCCMail($user->id);

                    try {

                        $view = 'front.email.domainTempDelete';

                        $mailer = MailManager::getInstance();
            
                        $status=$mailer->mailSender($view, $data);
        

                } catch (Throwable $e) {
                    
                }

                }
            }

        } catch (Throwable $e) {
            
        }
    }
}
