<?php

namespace App\Console\Commands;

use App\Models\User;
use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Throwable;
class OfferExpire extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'command:OfferExpire';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        try {
            $offers = DB::table('offers')
                ->whereDate('exp_date','=',Carbon::now()->subDays(1)->format('Y-m-d'))->get();
            
            foreach ($offers as $offer){
                
                $updated_date = date('Y-m-d H:i:s');

                DB::table('offers')->where('id',$offer->id)
                                   ->update([
                                    'status'=>'0',
                                    'updated_at'=>$updated_date
                                ]);
            }

        } catch (Throwable $e) {
            Log::info($e);
            return false;
        }
    }
}
