<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;

class RenewalApplicationReminder extends Command
{
    protected $signature = 'command:renewalreminder';
    protected $description = 'Send domain renewal reminders after expiry date and update status to HOLD after 30 days.';






    // public function handle()
    // {
    //     Log::info("Renewal reminder command started.");

    //     $users = DB::table('users')
    //         ->where('domainStatus', 10)
    //         ->whereNotNull('doc_clarification_date')
    //         ->get();

    //     foreach ($users as $user) {
    //         try {
    //             $updatedDate = Carbon::parse($user->doc_clarification_date);
    //             $now = Carbon::now();
    //             $daysAfterUpdated = $updatedDate->diffInDays($now, false);

    //             if ($daysAfterUpdated < 10) {
    //                 Log::info("{$user->email} - Less than 10 days after expiry.");
    //                 continue;
    //             }

    //             Log::info("{$user->email} - Days after expiry: {$daysAfterUpdated}");

    //             if (in_array($daysAfterUpdated, [10, 20, 30])) {
    //                 $content = getmisc()->renewal_application_mail;

    //                 $intro = "<p><strong>Domain Name:</strong> {$user->domainName}</p>";
    //                 $finalContent = $intro . $content;

    //                 Mail::send([], [], function ($message) use ($user, $finalContent) {
    //                     $message->to($user->email)
    //                         ->subject("Reminder: Domain renewal pending ({$user->domainName})")
    //                         ->html($finalContent);
    //                 });

    //                 Log::info("Reminder sent to: {$user->email}");
    //             }
    //         } catch (\Throwable $e) {
    //             Log::error("Error with {$user->email}: " . $e->getMessage());
    //         }
    //     }

    //     return Command::SUCCESS;
    // }



    public function handle()
    {
        Log::info("Renewal reminder command started.");

        $users = DB::table('users')
            ->where('domainStatus', 10)
            ->whereNotNull('doc_clarification_date')
            ->get();

        foreach ($users as $user) {
            try {

                $documentStatus = DB::table('user_documents')
                    ->where('user_id', $user->id)
                    ->whereIn('status', [0, 1, 2])
                    ->value('status');

                Log::info("neelu: { $documentStatus },gupta: { $documentStatus }");
                if ($documentStatus !== 0 && $documentStatus !== null) {

                    $expiryDate = Carbon::parse($user->domainExpiryDate);
                    $clarificationDate = Carbon::parse($user->doc_clarification_date);
                    $now = Carbon::now();

                    Log::info("Clarification Date: {$clarificationDate}, Current Date: {$now}");

                    $daysAfterClarification = $clarificationDate->diffInDays($now, false);
                    Log::info("Days after clarification for {$user->email}: {$daysAfterClarification}");

                    if (in_array($daysAfterClarification, [10, 20, 30])) {
                        Log::info("Preparing to send reminder mail to: {$user->email}");

                        $content = getmisc()->renewal_application_mail;
                        $intro = "<p><strong>Domain Name:</strong> {$user->domainName}</p>";
                        $finalContent = $intro . $content;

                        try {
                            Mail::send([], [], function ($message) use ($user, $finalContent) {
                                $message->to($user->email)
                                    ->cc('tejalt@ernet.in')
                                    ->subject("Reminder: Domain renewal pending ({$user->domainName})")
                                    ->html($finalContent);
                            });

                            Log::info("Reminder mail sent to: {$user->email}");
                        } catch (\Exception $e) {
                            Log::error("Mail error for {$user->email}: " . $e->getMessage());
                        }
                    }
                    $referenceDate = $expiryDate->greaterThan($clarificationDate) ? $expiryDate : $clarificationDate;
                    $daysAfterReference = $referenceDate->diffInDays($now, false);

                    if ($daysAfterReference === 31) {
                        DB::table('users')->where('id', $user->id)->update([
                            'domainStatus' => 7,
                            'domain_hold_date' => now(),
                        ]);
                        Log::info("Domain status set to HOLD (7) for: {$user->email}");
                    }


                    if ($user->domainStatus == 7 && $user->domain_hold_date) {
                        $holdDate = Carbon::parse($user->domain_hold_date);
                        $daysSinceHold = $holdDate->diffInDays($now);

                        if ($daysSinceHold >= 30) {
                            if ($user->paymentStatus == 3) {
                                Log::info("Payment done. Status remains HOLD for: {$user->email}");
                            } else {
                                DB::table('users')->where('id', $user->id)->update([
                                    'domainStatus' => 8,
                                ]);
                                Log::info("Payment NOT done. Status changed to 8 (Pending Restorable) for: {$user->email}");
                            }
                        }
                    }
                } else {
                    Log::info("Skipped {$user->email}: Document status is 0 or not found.");
                }
            } catch (\Exception $e) {
                Log::error("Error with {$user->email}: " . $e->getMessage());
            }
        }

        return Command::SUCCESS;
    }
}
