<?php
 
namespace App\Console\Commands;
 
use App\Components\MailManager;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use App\Models\User;
use App\Mail\ReminderMail;
use App\Mail\DeletedApplicationMail;


 
class SendReminderAndDeletionEmails extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'reminder:process-users';
 
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send reminder emails after 7 days and delete users after 10 days if documents are not submitted.';
 
    /**
     * Execute the console command.
     *
     * @return int
     */


 
    public function handle()
    {
        Log::info('Command started: reminder:process-users');
 
        $sevenDaysAgo = Carbon::now()->subDays(7);
        $threeDaysAfterReminder = Carbon::now()->subDays(3);
 
        $usersToRemind = DB::table('users')
            ->whereIn('domainStatus', [1, 2, 3, 4])
            ->whereIn('document_status', [0, 2])
            ->whereDate('created_at', '<=', $sevenDaysAgo)
            ->whereNull('reminder_mail_sent_at')
            ->get();
 
        foreach ($usersToRemind as $user) {
            try {
 
                $misc = getmisc();
 
                $content = $misc->reminder_mail;
 
                Mail::to($user->email)
                    ->cc(getCCMail($user->id))
                    ->queue(new ReminderMail($user, $content));
 
                DB::table('users')
                    ->where('id', $user->id)
                    ->update(['reminder_mail_sent_at' => now()]);
                Log::info('Reminder mail queued to: ' . $content);
 
                Log::info('Reminder mail queued to: ' . $user->email);
            } catch (\Throwable $e) {
                Log::error('Reminder mail failed for ' . $user->email . ' — ' . $e->getMessage());
            }
        }
 
        $usersToDelete = DB::table('users')
            ->whereIn('domainStatus', [1, 2, 3, 4])
            ->whereIn('document_status', [0, 2])
            ->whereNotNull('reminder_mail_sent_at')
            ->whereDate('reminder_mail_sent_at', '<=', $threeDaysAfterReminder)
            ->get();
 
        foreach ($usersToDelete as $user) {
            try {
 
                DB::table('inc_deleted_users')->insert([
                    'user_id' => $user->id,
                    'name' => $user->name,
                    'father_name' => $user->father_name,
                    'age' => $user->age,
                    'board' => $user->board,
                    'email' => $user->email,
                    'domainName' => $user->domainName,
                    'domainPunycode' => $user->domainPunycode,
                    'domainLangID' => $user->domainLangID,
                    'domainExtensionID' => $user->domainExtensionID,
                    'domainPeriod' => $user->domainPeriod,
                    'domainPrice' => $user->domainPrice,
                    'institute' => $user->institute,
                    'designation' => $user->designation,
                    'password' => $user->password,
                    'google2fa_secret' => $user->google2fa_secret,
                    'renew_years' => $user->renew_years,
                    'last_login_ip' => $user->last_login_ip,
                    'affilation_no' => $user->affilation_no,
                    'original_created_at' => $user->created_at,
                    'updated_at' => $user->created_at,
                    'deleted_at' => now(),
                ]);
 
                $misc = getmisc();
 
                $content = $misc->deleted_mail;
 
                Mail::to($user->email)
                    ->cc(getCCMail($user->id))
                    ->queue(new DeletedApplicationMail($user, $content));


 
                DB::table('users')->where('id', $user->id)->delete();
 
                Log::info('User deleted and deletion mail queued: ' . $user->email);
            } catch (\Throwable $e) {
                Log::error('Deletion mail failed for ' . $user->email . ' — ' . $e->getMessage());
            }
        }
 
        Log::info('Command finished: reminder:process-users');
        return 0;
    }
}
