<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
class AdminReportController extends Controller
{
    public function ReportCreationList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $search_arr = $request->search;
        $searchValue = $search_arr; // Search value
        $totalRecords = DB::table('users')->select('count(*) as allcount')->where('users.domainStatus',5);    
        if($request->from != null) {
        $start_date = $request->from;
        $totalRecords->where('users.created_at', '>=', $start_date);
        } 
        if($request->to != null) {
            $end_date = $request->to;
            $totalRecords->where('users.created_at', '<=', $end_date);     
        }
        if($searchValue!=null){
        $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        if($request->domain != null){
            $totalRecords->where('users.domainName', '=', $request->domain);
        }
        if($request->state != null){
            $totalRecords->where('user_contact_details.state', '=', $request->state)
                ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
        }
        $totalRecordswithFilter = $totalRecords->count();
        $records = DB::table('users')->select('users.*','user_contact_details.phone')
      ->where('users.domainStatus', 5)
      ->join('user_contact_details', 'users.id', 'user_contact_details.user_id')
      ->orderBy('users.id', 'desc');
        if($request->from != null) {
            $start_date = $request->from;
            $records->where('users.created_at', '>=', $start_date);
        }
        if($request->to != null) {
            $end_date = $request->to;
            $records->where('users.created_at', '<=', $end_date);     
        }
        if($searchValue!=null){
            $records->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        if($request->domain != null){
            $records->where('users.domainName', '=', $request->domain);
        }
        if($request->state != null){
            $records->where('user_contact_details.state', '=', $request->state)
                ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
        }
        $list = $records->limit($limit)->offset(($page - 1) * $limit)->get();
        if($list){
            return response()->json(['status' => 'success', 'report_list' => $list, 'report_count' => $totalRecordswithFilter], 200);
        }else{
            return response()->json(['status' => 'success', 'report_list' => "Data Not Found", 'report_count' => 0], 200);
        }
        
    }

    public function HoldApplicationList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $search_arr = $request->search;
        $searchValue = $search_arr;
        $totalRecords = DB::table('users')->select('count(*) as allcount')->where('users.domainStatus',7);
        if($request->from != null) {
        $start_date = $request->from;
        $totalRecords->where('users.created_at', '>=', $start_date);
        }
        if($request->to != null) {
            $end_date = $request->to;
            $totalRecords->where('users.created_at', '<=', $end_date);     
        }
        if($searchValue!=null){
        $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        if($request->domain != null){
            $totalRecords->where('users.domainName', '=', $request->domain);
        }
        if($request->state != null){
            $totalRecords->where('user_contact_details.state', '=', $request->state)
                ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
        }
        $totalRecordswithFilter = $totalRecords->count();
        $records = DB::table('users')->select('users.*','user_contact_details.phone')
      ->where('users.domainStatus', 7)
      ->join('user_contact_details', 'users.id', 'user_contact_details.user_id')
      ->orderBy('users.id', 'desc');
        if($request->from != null) {
            $start_date = $request->from;
            $records->where('users.created_at', '>=', $start_date);
        }
        if($request->to != null) {
            $end_date = $request->to;
            $records->where('users.created_at', '<=', $end_date);     
        }
        if($searchValue!=null){
            $records->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        if($request->domain != null){
            $records->where('users.domainName', '=', $request->domain);
        }
        if($request->state != null){
            $records->where('user_contact_details.state', '=', $request->state)
                ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
        }
        $list = $records->limit($limit)->offset(($page - 1) * $limit)->get();
        
        if($list){
            return response()->json(['status' => 'success', 'report_list' => $list, 'report_count' => $totalRecordswithFilter], 200);
        }else{
            return response()->json(['status' => 'success', 'report_list' => "Data Not Found", 'report_count' => 0], 200);
        }
    }

    public function PendingRestoreList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $search_arr = $request->search;
        $searchValue = $search_arr; 
        $totalRecords = DB::table('users')->select('count(*) as allcount')->where('users.domainStatus',8)->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
        if($request->from != null) {
        $start_date = $request->from;
        $totalRecords->where('users.domainExpiryDate', '>=', $start_date);
        }
        if($request->to != null) {
            $end_date = $request->to;
            $totalRecords->where('users.domainExpiryDate', '<=', $end_date);     
        }
        if($searchValue!=null){
        $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        if($request->domain != null){
            $totalRecords->where('users.domainName', '=', $request->domain);
        }
        if($request->state != null){
            $totalRecords->where('user_contact_details.state', '=', $request->state);
        }
        $totalRecordswithFilter = $totalRecords->count();
        $records = DB::table('users')->select('users.*','user_contact_details.phone')->where('users.domainStatus',8)->join('user_contact_details', 'users.id', 'user_contact_details.user_id')->orderBy('users.id', 'desc');

        

        if($request->from != null) {
            $start_date = $request->from;
            $records->where('users.domainExpiryDate', '>=', $start_date);
        }
        if($request->to != null) {
            $end_date = $request->to;
            $records->where('users.domainExpiryDate', '<=', $end_date);     
        }
        if($searchValue!=null){
            $records->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        if($request->domain != null){
            $records->where('users.domainName', '=', $request->domain);
        }
        if($request->state != null){
            $records->where('user_contact_details.state', '=', $request->state);
        }
        $list = $records->limit($limit)->offset(($page - 1) * $limit)->get();
        if($list){
            return response()->json(['status' => 'success', 'report_list' => $list, 'report_count' => $totalRecordswithFilter], 200);
        }else{
            return response()->json(['status' => 'success', 'report_list' => "Data Not Found", 'report_count' => 0], 200);
        }
    }

    public function PendingRenewList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $search_arr = $request->search;
        $searchValue = $search_arr; 
        $totalRecords = DB::table('users')->select('count(*) as allcount')->where('users.domainStatus',10)->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
        if($request->from != null) {
        $start_date = $request->from;
        $totalRecords->where('users.domainExpiryDate', '>=', $start_date);
        }
        if($request->to != null) {
            $end_date = $request->to;
            $totalRecords->where('users.domainExpiryDate', '<=', $end_date);     
        }
        if($searchValue!=null){
        $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        if($request->domain != null){
            $totalRecords->where('users.domainName', '=', $request->domain);
        }
        if($request->state != null){
            $totalRecords->where('user_contact_details.state', '=', $request->state);
        }
        $totalRecordswithFilter = $totalRecords->count();
        $records = DB::table('users')->select('users.*','user_contact_details.phone')->where('users.domainStatus',10)->join('user_contact_details', 'users.id', 'user_contact_details.user_id')->orderBy('users.id', 'desc');
        if($request->from != null) {
            $start_date = $request->from;
            $records->where('users.domainExpiryDate', '>=', $start_date);
        }
        if($request->to != null) {
            $end_date = $request->to;
            $records->where('users.domainExpiryDate', '<=', $end_date);     
        }
        if($searchValue!=null){
            $records->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        if($request->domain != null){
            $records->where('users.domainName', '=', $request->domain);
        }
        if($request->state != null){
            $records->where('user_contact_details.state', '=', $request->state);
        }
        $list = $records->limit($limit)->offset(($page - 1) * $limit)->get();
        
        if($list){
            return response()->json(['status' => 'success', 'report_list' => $list, 'report_count' => $totalRecordswithFilter], 200);
        }else{
            return response()->json(['status' => 'success', 'report_list' => "Data Not Found", 'report_count' => 0], 200);
        }
    }

    public function DomainList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $search_arr = $request->search;
        $searchValue = $search_arr;
        $totalRecords = DB::table('users')->select('count(*) as allcount')->where('users.domainStatus',6)->where('users.domainLangID',2)->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
        if($request->from != null) {
        $start_date = $request->from;
        $totalRecords->where('users.domainCreationDate', '>=', $start_date);
        }
        if($request->to != null) {
            $end_date = $request->to;
            $totalRecords->where('users.domainCreationDate', '<=', $end_date);     
        }
        if($searchValue!=null){
        $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        if($request->domain != null){
            $totalRecords->where('users.domainName', '=', $request->domain);
        }
        if($request->state != null){
            $totalRecords->where('user_contact_details.state', '=', $request->state);
        }
        if($request->period != null){
            $totalRecords->where('users.domainPeriod', '=', $request->period);
        }
        if($request->status != null){
            $totalRecords->where('users.type', '=', $request->status);
        }
        $totalRecordswithFilter = $totalRecords->count();
        $records = DB::table('users')->select('users.*','user_contact_details.phone')->where('users.domainStatus',6)->where('users.domainLangID', 2)->join('user_contact_details', 'users.id', 'user_contact_details.user_id')->orderBy('users.id', 'desc');
        
        if($request->from != null) {
            $start_date = $request->from;
            $records->where('users.domainCreationDate', '>=', $start_date);
        }
        if($request->to != null) {
            $end_date = $request->to;
            $records->where('users.domainCreationDate', '<=', $end_date);     
        }
        if($searchValue!=null){
            $records->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        if($request->domain != null){
            $records->where('users.domainName', '=', $request->domain);
        }
        if($request->state != null){
            $records->where('user_contact_details.state', '=', $request->state);
        }
        if($request->period != null){
            $records->where('users.domainPeriod', '=', $request->period);
        }
        if($request->status != null){
            $records->where('users.type', '=', $request->status);
        }
        $list = $records->limit($limit)->offset(($page - 1) * $limit)->get();
        if($list){
            return response()->json(['status' => 'success', 'report_list' => $list, 'report_count' => $totalRecordswithFilter], 200);
        }else{
            return response()->json(['status' => 'success', 'report_list' => "Data Not Found", 'report_count' => 0], 200);
        }
    }
    public function HindiDomainList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $search_arr = $request->search;
        $searchValue = $search_arr; 
        $totalRecords = DB::table('users')->select('count(*) as allcount')->where('users.domainStatus',6)->where('users.domainLangID',3)->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
        if($request->from != null) {
            $start_date = $request->from;
                $totalRecords->where('users.domainCreationDate', '>=', $start_date);
            }
        if($request->to != null) {
            $end_date = $request->to;
            $totalRecords->where('users.domainCreationDate', '<=', $end_date);     
        }
        if($searchValue!=null){
        $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        if($request->domain != null){
            $totalRecords->where('users.domainName', '=', $request->domain);
        }
        if($request->state != null){
            $totalRecords->where('user_contact_details.state', '=', $request->state);
        }
        if($request->period != null){
            $totalRecords->where('users.domainPeriod', '=', $request->period);
        }
        if($request->status != null){
            $totalRecords->where('users.type', '=', $request->status);
        }
        $totalRecordswithFilter = $totalRecords->count();
        $records = DB::table('users')->select('users.*','user_contact_details.phone')->where('users.domainStatus',6)->where('users.domainLangID', 3)->join('user_contact_details', 'users.id', 'user_contact_details.user_id')->orderBy('users.id', 'desc');
        if($request->from != null) {
            $start_date = $request->from;
            $records->where('users.domainCreationDate', '>=', $start_date);
        }  
        if($request->to != null) {
            $end_date = $request->to;
            $records->where('users.domainCreationDate', '<=', $end_date);     
        }
        if($searchValue!=null){
            $records->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        if($request->domain != null){
            $records->where('users.domainName', '=', $request->domain);
        }
        if($request->status != null){
            $records->where('users.type', '=', $request->status);
        }
        if($request->state != null){
            $records->where('user_contact_details.state', '=', $request->state);
        }
        if($request->period != null){
            $records->where('users.domainPeriod', '=', $request->period);
        }
        
        $list = $records->limit($limit)->offset(($page - 1) * $limit)->get();
        if($list){
            return response()->json(['status' => 'success', 'report_list' => $list, 'report_count' => $totalRecordswithFilter], 200);
        }else{
            return response()->json(['status' => 'success', 'report_list' => "Data Not Found", 'report_count' => 0], 200);
        }
    }

    public function NoZoneList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $search_arr = $request->search;
        $searchValue = $search_arr; 
        $totalRecords = DB::table('users')->select('count(*) as allcount')->where('users.domainStatus',6)
        ->where('users.zone_file',0)
        ->where('user_name_servers.server_type',1)->join('user_name_servers','user_name_servers.user_id','users.id')
        ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
    
        if($request->from != null) {
           $start_date = $request->from;
           $totalRecords->where('users.domainCreationDate', '>=', $start_date);
        }
        if($request->to != null) {
            $end_date = $request->to;
            $totalRecords->where('users.domainCreationDate', '<=', $end_date);     
        }
        
        if($searchValue!=null){
           $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        
        if($request->domain != null){
            $totalRecords->where('users.domainName', '=', $request->domain);
        }
    
        if($request->state != null){
            $totalRecords->where('user_contact_details.state', '=', $request->state);
        }
        
        $totalRecordswithFilter = $totalRecords->count();
    
        $records = DB::table('users')->select('users.*','user_contact_details.phone')
          ->where('users.domainStatus',6)
          ->where('users.zone_file',0)
          ->where('user_name_servers.server_type',1)->join('user_name_servers','user_name_servers.user_id','users.id')
          ->join('user_contact_details', 'users.id', 'user_contact_details.user_id')
          ->orderBy('users.id', 'desc');
    
          if($request->from != null) {
            $start_date = $request->from;
            $records->where('users.domainCreationDate', '>=', $start_date);
         }
            
         if($request->to != null) {
             $end_date = $request->to;
             $records->where('users.domainCreationDate', '<=', $end_date);     
         }
         
         if($searchValue!=null){
            $records->where('users.domainName', 'like', '%' .$searchValue . '%');
         }
         
         if($request->domain != null){
            $records->where('users.domainName', '=', $request->domain);
         }
    
         if($request->state != null){
            $records->where('user_contact_details.state', '=', $request->state);
        }
        
        $list = $records->limit($limit)->offset(($page - 1) * $limit)->get();
        
        if($list){
            return response()->json(['status' => 'success', 'report_list' => $list, 'report_count' => $totalRecordswithFilter], 200);
        }else{
            return response()->json(['status' => 'success', 'report_list' => "Data Not Found", 'report_count' => 0], 200);
        }
    }
    public function PaymentList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $countData = DB::table('transactions')->select('count(*) as allcount')
        ->join('users', 'users.id', 'transactions.user_id');
        if($request->domain_type != null) {
            if($request->domain_type==1){
                $countData->where('users.clarify',0)->whereIn('users.domainStatus',[2,3,1,4,0]);
            }elseif($request->domain_type==2){
                $countData->where('domainStatus','=',5);
            }elseif($request->domain_type==3){
                $countData->join('user_documents', 'users.id', '=', 'user_documents.user_id')->where('user_documents.status', '=', 0);
            }elseif($request->domain_type==4){
                $countData->where('domainStatus','=',10);
            }elseif($request->domain_type==5){
                $countData->where('domainStatus','=',7);
            }elseif($request->domain_type==6){
                $countData->where('domainStatus','=',8);
            }elseif($request->domain_type==7){
                $countData->where('users.domainExpiryDate', '<=', DB::raw('CURDATE()'))->whereBetween(DB::raw('DATEDIFF(users.domainExpiryDate, users.domainExpiryDate)'), [70, 75]);
            }elseif($request->domain_type==8){
                $countData->where('users.domainLangID','=',2)->whereIn('users.domainStatus',[6,10]);
            }elseif($request->domain_type==9){
                $countData->where('users.domainLangID','=',3)->where('users.domainStatus','=',6);
            }
        }
        if($request->from != null) {
            $start_date = $request->from;
            $countData->where('transactions.updated_at', '>=', $start_date);
        }
            
         if($request->to != null) {
             $end_date = $request->to;
             $countData->where('transactions.updated_at', '<=', $end_date);     
         }
         
         if($request->domain != null){
            $countData->where('users.domainName', '=', $request->domain);
         }
         if($request->period != null){
            $countData->where('users.domainPeriod', '=', $request->period);
         }
        $totalRecordswithFilter = $countData->select(DB::raw('count(*) as allcount'))->count();
        $totalRecords = $totalRecordswithFilter;
        
        $records = DB::table('transactions')
    ->join('users', 'transactions.user_id', '=', 'users.id')
    ->leftJoin('user_contact_details', 'transactions.user_id', '=', 'user_contact_details.user_id')
    ->select('transactions.*', 'users.*', 'user_contact_details.*')
    ->orderBy('transactions.id', 'desc');
            if($request->domain_type != null) {
                if($request->domain_type==1){
                    $records->where('clarify',0)->whereIn('domainStatus',[2,3,1,4,0]);
                }elseif($request->domain_type==2){
                    $records->where('domainStatus','=',5);
                }elseif($request->domain_type==3){
                    $records->join('user_documents', 'users.id', '=', 'user_documents.user_id')->where('user_documents.status', '=', 0);
                }elseif($request->domain_type==4){
                    $records->where('domainStatus','=',10);
                }elseif($request->domain_type==5){
                    $records->where('domainStatus','=',7);
                }elseif($request->domain_type==6){
                    $records->where('domainStatus','=',8);
                }elseif($request->domain_type==7){
                    $records->where('users.domainExpiryDate', '<=', DB::raw('CURDATE()'))->whereBetween(DB::raw('DATEDIFF(users.domainExpiryDate, users.domainExpiryDate)'), [70, 75]);
                }elseif($request->domain_type==8){
                    $records->where('users.domainLangID','=',2)->whereIn('users.domainStatus',[6,10]);
                }elseif($request->domain_type==9){
                    $records->where('users.domainLangID','=',3)->where('users.domainStatus','=',6);
                }
            }
            if($request->from != null) {
                $start_date = $request->from;
                $records->where('transactions.updated_at', '>=', $start_date);
            }
                
             if($request->to != null) {
                 $end_date = $request->to;
                 $records->where('transactions.updated_at', '<=', $end_date);     
             }
             
             if($request->domain != null){
                $records->where('users.domainName', '=', $request->domain);
             }
             if($request->period != null){
                $records->where('users.domainPeriod', '=', $request->period);
             }
        $list = $records->limit($limit)->offset(($page - 1) * $limit)->get();

        if($list){
            return response()->json(['status' => 'success', 'report_list' => $list, 'report_count' => $totalRecords], 200);
        }else{
            return response()->json(['status' => 'success', 'report_list' => "Data Not Found", 'report_count' => 0], 200);
        }
    }
    public function DocumentRejectedList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $search_arr = $request->search;
        $searchValue = $search_arr; 
        $totalRecordsQuery = DB::table('users')->select('count(*) as allcount')->where('users.clarify',1)->where('users.domainStatus','<','6');
        if ($request->from != null) {
            $start_date = $request->from;
            $totalRecordsQuery->where('users.created_at', '>=', $start_date);
        }
        if ($request->to != null) {
            $end_date = $request->to;
            $totalRecordsQuery->where('users.created_at', '<=', $end_date);
        }
        if ($searchValue != null) {
            $totalRecordsQuery->where('users.domainName', 'like', '%' . $searchValue . '%');
        }
        if ($request->domain != null) {
            $totalRecordsQuery->where('users.domainName', '=', $request->domain);
        }
        if ($request->state != null) {
            $totalRecordsQuery->where('user_contact_details.state', '=', $request->state)
                ->join('user_contact_details', 'users.id', '=', 'user_contact_details.user_id');
        }
        $totalRecords = $totalRecordsQuery->count();
        $records = DB::table('users')
            ->select('users.*','user_contact_details.phone')
            ->where('users.clarify',1)->where('users.domainStatus','<','6')
            ->join('user_contact_details', 'users.id', 'user_contact_details.user_id')
            ->orderBy('users.id', 'desc');

       
        
        if ($request->from != null) {
            $start_date = $request->from;
            $records->where('users.created_at', '>=', $start_date);
        }
        
        if ($request->to != null) {
            $end_date = $request->to;
            $records->where('users.created_at', '<=', $end_date);
        }
        
        if ($searchValue != null) {
            $records->where('users.domainName', 'like', '%' . $searchValue . '%');
        }
        
        if ($request->domain != null) {
            $records->where('users.domainName', '=', $request->domain);
        }
        
        if ($request->state != null) {
            $records->where('user_contact_details.state', '=', $request->state)
                ->join('user_contact_details', 'users.id', '=', 'user_contact_details.user_id');
        }
        
        $list = $records->limit($limit)->offset(($page - 1) * $limit)->get();
        
        if($list){
            return response()->json(['status' => 'success', 'report_list' => $list, 'report_count' => $totalRecords], 200);
        }else{
            return response()->json(['status' => 'success', 'report_list' => "Data Not Found", 'report_count' => 0], 200);
        }
        
    }
    public function DomainNoDnsList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $search_arr = $request->search;
        $searchValue = $search_arr; 
        $totalRecords = DB::table('users')->select('count(*) as allcount')
        ->where('user_name_servers.skip_status',1)->join('user_name_servers','user_name_servers.user_id','users.id')
        ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
    
        if($request->from != null) {
           $start_date = $request->from;
           $totalRecords->where('users.domainCreationDate', '>=', $start_date);
        }
           
        if($request->to != null) {
            $end_date = $request->to;
            $totalRecords->where('users.domainCreationDate', '<=', $end_date);     
        }
        
        if($searchValue!=null){
           $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        
        if($request->domain != null){
            $totalRecords->where('users.domainName', '=', $request->domain);
        }
    
        if($request->state != null){
            $totalRecords->where('user_contact_details.state', '=', $request->state);
        }
        
        $totalRecordswithFilter = $totalRecords->count();
    
        $records = DB::table('users')->select('users.*','user_contact_details.phone')
          #->where('users.domainStatus',3)
          #->where('users.zone_file',0)
          ->where('user_name_servers.skip_status',1)->join('user_name_servers','user_name_servers.user_id','users.id')
          ->join('user_contact_details', 'users.id', 'user_contact_details.user_id')
          ->orderBy('users.id', 'desc');
          if($request->from != null) {
            $start_date = $request->from;
            $records->where('users.domainCreationDate', '>=', $start_date);
         }
         if($request->to != null) {
             $end_date = $request->to;
             $records->where('users.domainCreationDate', '<=', $end_date);     
         }
         if($searchValue!=null){
            $records->where('users.domainName', 'like', '%' .$searchValue . '%');
         }
         if($request->domain != null){
            $records->where('users.domainName', '=', $request->domain);
         }
         if($request->state != null){
            $records->where('user_contact_details.state', '=', $request->state);
        }
        $list = $records->limit($limit)->offset(($page - 1) * $limit)->get();
        
        if($list){
            return response()->json(['status' => 'success', 'report_list' => $list, 'report_count' => $totalRecordswithFilter], 200);
        }else{
            return response()->json(['status' => 'success', 'report_list' => "Data Not Found", 'report_count' => 0], 200);
        }
        
    }


    public function NixiPaymentList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $countData = DB::table('transactions')->join('users', 'users.id', '=', 'transactions.user_id');
        if($request->domain_type != null) {
            if($request->domain_type==1){
                $countData->where('users.clarify',0)->whereIn('users.domainStatus',[2,3,1,4,0]);
            }elseif($request->domain_type==2){
                $countData->where('domainStatus','=',5);
            }elseif($request->domain_type==3){
                $countData->join('user_documents', 'users.id', '=', 'user_documents.user_id')->where('user_documents.status', '=', 0);
            }elseif($request->domain_type==4){
                $countData->where('domainStatus','=',10);
            }elseif($request->domain_type==5){
                $countData->where('domainStatus','=',7);
            }elseif($request->domain_type==6){
                $countData->where('domainStatus','=',8);
            }elseif($request->domain_type==7){
                $countData->where('users.domainExpiryDate', '<=', DB::raw('CURDATE()'))->whereBetween(DB::raw('DATEDIFF(users.domainExpiryDate, users.domainExpiryDate)'), [70, 75]);
            }elseif($request->domain_type==8){
                $countData->where('users.domainLangID','=',2)->whereIn('users.domainStatus',[6,10]);
            }elseif($request->domain_type==9){
                $countData->where('users.domainLangID','=',3)->where('users.domainStatus','=',6);
            }
        }
        if($request->from != null) {
            $start_date = $request->from;
            $countData->where('transactions.updated_at', '>=', $start_date);
            if ($request->from == $request->to) {
                $countData->orWhere('transactions.updated_at', '=', $start_date);
            }
        }
        if($request->trns_type != null){
            $countData->where('transactions.transaction_type', '=', $request->trns_type);
         }
         if($request->to != null) {
             $end_date = $request->to;
             $countData->where('transactions.updated_at', '<=', $end_date); 
             if ($request->from == $request->to) {
                $countData->orWhere('transactions.updated_at', '=', $end_date);
            }    
         }
         
         if($request->domain != null){
            $countData->where('users.domainName', '=', $request->domain);
         }
         

        $totalRecordswithFilter = $countData->select(DB::raw('count(*) as allcount'))->count();
        $totalRecords = $totalRecordswithFilter;
        $records = DB::table('transactions')->join('users', 'transactions.user_id', '=', 'users.id')->select('transactions.*', 'users.*')->orderBy('transactions.id', 'desc');
            if($request->domain_type != null) {
                if($request->domain_type==1){
                    $records->where('clarify',0)->whereIn('domainStatus',[2,3,1,4,0]);
                }elseif($request->domain_type==2){
                    $records->where('domainStatus','=',5);
                }elseif($request->domain_type==3){
                    $records->join('user_documents', 'users.id', '=', 'user_documents.user_id')->where('user_documents.status', '=', 0);
                }elseif($request->domain_type==4){
                    $records->where('domainStatus','=',10);
                }elseif($request->domain_type==5){
                    $records->where('domainStatus','=',7);
                }elseif($request->domain_type==6){
                    $records->where('domainStatus','=',8);
                }elseif($request->domain_type==7){
                    $records->where('users.domainExpiryDate', '<=', DB::raw('CURDATE()'))->whereBetween(DB::raw('DATEDIFF(users.domainExpiryDate, users.domainExpiryDate)'), [70, 75]);
                }elseif($request->domain_type==8){
                    $records->where('users.domainLangID','=',2)->whereIn('users.domainStatus',[6,10]);
                }elseif($request->domain_type==9){
                    $records->where('users.domainLangID','=',3)->where('users.domainStatus','=',6);
                }
            }
            if($request->from != null) {
                $start_date = $request->from;
                $records->where('transactions.updated_at', '>=', $start_date);
                if ($request->from == $request->to) {
                    $records->orWhere('transactions.updated_at', '=', $start_date);
                }
            }
                
             if($request->to != null) {
                 $end_date = $request->to;
                 $records->where('transactions.updated_at', '<=', $end_date); 
                 if ($request->from == $request->to) {
                    $records->orWhere('transactions.updated_at', '=', $end_date);
                }    
             }
             if($request->trns_type != null){
                $records->where('transactions.transaction_type', '=', $request->trns_type);
             }
             if($request->domain != null){
                $records->where('users.domainName', '=', $request->domain);
             }
    
        $list = $records->limit($limit)->offset(($page - 1) * $limit)->get();
        if($list){
            return response()->json(['status' => 'success', 'report_list' => $list, 'report_count' => $totalRecordswithFilter], 200);
        }else{
            return response()->json(['status' => 'success', 'report_list' => "Data Not Found", 'report_count' => 0], 200);
        }
        
    }


}

