<?php

namespace App\Http\Controllers\Api\Admin\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB,Validator;

class CityController extends Controller
{
    public function cityList(Request $request) 
	{
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        
        $cities = DB::table('cities')->join('regions', 'cities.region_id', '=', 'regions.id')->select('cities.*', 'regions.description as state_name')->limit($limit)->offset(($page - 1) * $limit)->get();
        $citiesCount = DB::table('cities')->count();
        if($cities){
            return response()->json(['status' => 'success', 'cities' => $cities,'CityCount'=>$citiesCount], 200);
        } else {
            return response()->json(['status' => 'success', 'cities' => []], 200);
        }
    }
    public function citystateList(Request $request) 
	{
        $regions = DB::table('regions')->get();
        if($regions){
            return response()->json(['status' => 'success', 'regions' => $regions], 200);
        } else {
            return response()->json(['status' => 'success', 'regions' => []], 200);
        }
    }
    public function cityAdd(Request $request)
	{
			if($request->isMethod('post'))
			{
				$params = $request->all();
				$messages = [
					'max' => 'Description should not be greater than 50 characters.',
				];
				$validator = Validator::make($params,[
					'name' =>'required|max:50|unique:cities,name',
                    'region_id'=>'required'
				], $messages);
				
				if($validator->fails())
				{
					return response()->json(['status'=>'errors', 'message' => $validator->errors()]);
				}
                $state = DB::table('regions')->where('id', $request->region_id)->first();
                if($state){
                    $data = [
                        'region_id' => $request->region_id,
                        'name' => $request->name,
                    ];
                    $save=DB::table('cities')->insert($data);
                    if($save){
                        return response()->json(['status'=>"success",'city' => "City Save successfully"], 200);
                    }
                }else{
                    return response()->json(['status' => 'error', 'message' => 'State not found'], 200);
                }
				return response()->json(array('status'=>'error', 'error' => 'Something Wrong'));
			}
			return redirect('home')->with('error', 'Not valid');
	}
    public function cityUpdate(Request $request){
        
			$params = $request->all();
			$messages = [
				'max' => 'Description should not be greater than 50 characters.',
			];
			$validator = Validator::make($params,[
				'name' =>'required|max:50',
                'region_id'=>'required'
			], $messages);
			
			if($validator->fails())
			{
				return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
			}
            $id =$request->id;
			$name =$request->name;
			$region_id = $request->region_id;

			$state = DB::table('cities')->where('id', $id)->first();
			if (!$state) {
                return response()->json(['status' => 'success', 'message' => 'City not found'], 200);
            }
			$update=DB::table('cities')->where('id', $id)->update(['name' => $name,'region_id'=>$region_id]);
			if($update){
			    return response()->json(['status' => 'success','message' => 'City updated successfully'],200);    
			}
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		
		
    }
    public function cityDelete(Request $request){
        $id = $request->id;
        $city = DB::table('cities')->where('id', $id)->first();
        
        if (!$city) {
            return response()->json(['status' => 'success', 'message' => 'City not found'], 200);
        }else{
            $status = DB::table('cities')->where('id', $id)->delete();
            if($status){
                return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
            }else{
                return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
            }
        }
        return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
    }

    public function cityFilter(Request $request){
        $state_id = $request->state_id;
        $searchTxt = $request->searchtxt;
         $regions=$request->regions;
        $query = DB::table('cities')->join('regions', 'cities.region_id', '=', 'regions.id')->select('cities.*', 'regions.description as state_name');;
        if ($state_id) {
            $query->where('cities.region_id', $state_id);
        }
        if ($searchTxt) {
            $query->where('cities.name', 'LIKE', "%$searchTxt%");
        }
          if($regions){
            $query->where('region.description', 'LIKE', "%$searchTxt%");
        }
        $cities = $query->get();

        if($cities){
            return response()->json(['status' => 'success', 'cities' => $cities], 200);
        } else {
            return response()->json(['status' => 'success', 'cities' => []], 200);
        }
    }
}
