<?php

namespace App\Http\Controllers\Api\Admin\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB,Validator;
class DiscountController extends Controller
{
    public function discountList(Request $request)
    {
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $discountData = DB::table('discounts')->limit($limit)->offset(($page - 1) * $limit)->get();
        $discountCount = DB::table('discounts')->count();
        if($discountData){
            return response()->json(['status' => 'success', 'discounts' => $discountData,'discountCount'=>$discountCount], 200);
        } else {
            return response()->json(['status' => 'success', 'discounts' => []], 200);
        }
    }
    public function discountAdd(Request $request){
        $params = $request->all();
        $messages = [
            'max' => 'Description should not be greater than 50 characters.',
        ];
        $validator = Validator::make($params,[
            'name' =>'required|max:50|unique:discounts,name',
            'discount'=>'required',
            'start_date'=>'required',
            'end_date'=>'required'
        ], $messages);
        if($validator->fails()){
            return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
        }
        $saved=DB::table('discounts')->insert([
            'name' => $request->name,
            'discount'=>$request->discount,
            'start_date' => $request->start_date,
            'end_date'=>$request->end_date,
            'extension'=>$request->extension== null? '': implode(',',$request->extension),
            'status'=>$request->status
        ]);
            if($saved){
                return response()->json(['status'=>"success",'message' => "Discounts Save successfully"], 200);
            }
            return response()->json(['status'=>'error', 'message' => 'Something Wrong'],404);
        
        return response()->json(['status'=>'error', 'message', 'Not valid'],404);
    }

    public function discountUpdate(Request $request){
        $params = $request->all();
        $messages = [
            'max' => 'Description should not be greater than 50 characters.',
        ];
        $validator = Validator::make($params,[
            'name' =>'required|max:50|unique:discounts,name,'.$request->id,
            'discount'=>'required',
            'start_date'=>'required',
            'end_date'=>'required'
        ], $messages);
        
        if($validator->fails())
        {
            return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
        }
        $id = $request->id;
        $discounts = DB::table('discounts')->where('id', $id)->first();
        if (!$discounts) {
            return response()->json(['status' => 'success', 'message' => 'discount not found'], 200);
        }
        
        $update=DB::table('discounts')->where('id',$id)->update([
            'name' => $request->name,
            'discount'=>$request->discount,
            'start_date' => $request->start_date,
            'end_date'=>$request->end_date,
            'extension'=>$request->extension== null? '': implode(',',$request->extension),
            'status'=>$request->status
        ]);
        if($update){
            return response()->json(['status' => 'success','message' => 'discounts updated successfully'],200);    
        }else{
            return response()->json(['status' => 'success', 'message' => 'Something Went Wrong Please Try again.'], 200);
        }
	}


    public function discountDelete(Request $request)
	{
        $message['status']='error';
        $message['message']='Invalid Request';
        $id = $request->languages_id;
        $discounts = DB::table('discounts')->where('id', $id)->first();
        if (!$discounts) {
            return response()->json(['status' => 'success', 'message' => 'discounts not found'], 200);
        }else{
            $status = DB::table('discounts')->where('id', $id)->delete();
            if($status){
                return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
            }else{
                return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
            }
        }
        return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
	}
    public function ExtensionList(Request $request) 
	{
        $extensions = DB::table('domain_extensions')->get();
        if($extensions){
            return response()->json(['status' => 'success', 'extensions' => $extensions], 200);
        } else {
            return response()->json(['status' => 'success', 'extensions' => []], 200);
        }
    }
    public function discountSearch(Request $request){
        $searchTxt=$request->searchtxt;
        $data=DB::table('discounts')->where('discounts.name', 'LIKE', "%$searchTxt%")->get();
        if($data){
            return response()->json(['status' => 'success', 'discounts' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'discounts' => []], 200);
        }
    }
    
}
