<?php

namespace App\Http\Controllers\Api\Admin\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB,Validator;
use Carbon\Carbon;
use App\Models\User;
class DomainController extends Controller
{
    public function updateInstitutionDetail(Request $request)
    {
        $user_id = $request->id;
        $data = [
            "address" => $request->input('address'),
            "state" => $request->input('state'),
            "city" => $request->input('city'),
            "pincode" => $request->input('pincode'),
            "phone" => $request->input('phone'),
            "gst_no" => $request->input('gst'),
        ];

        $added = DB::table('user_contact_details')->updateOrInsert(
                ['user_id' => $user_id],
                $data
            );
        if($added){
            return response()->json(['status' => 'success','message' => 'Institution Detail Added successfully'],200);    
        }else{
            return response()->json(['status' => 'success','message' => 'Somthing went wrong'],200);
        }
        
    }
    
    
    public function updateInstitutionHeadDetail(Request $request)
    {
        $user_id = $request->id;
        $data = $request->input('head');
        $added = DB::table('user_contact_details')->updateOrInsert(
                ['user_id' => $user_id],
                ['institution_head_detail' => $data]
            );
        if($added){
            return response()->json(['status' => 'success','message' => 'Institution Head Detail Added successfully'],200);    
        }else{
            return response()->json(['status' => 'success','message' => 'Somthing went wrong'],200);
        }
    }
    
    
    public function updateAdministrativeDetail(Request $request)
    {
        $user_id = $request->id;
        $data = $request->input('administrative');
        $added = DB::table('user_contact_details')->updateOrInsert(
                ['user_id' => $user_id],
                ['administrative_detail' => $data]
        );
        if($added){
            return response()->json(['status' => 'success','message' => 'Administrative Detail Added successfully'],200);    
        }else{
            return response()->json(['status' => 'success','message' => 'Somthing went wrong'],200);
        }
    }
    
    
    public function updateBillingDetail(Request $request)
    {
        $user_id = $request->id;
        $data = $request->input('billing');
        $added = DB::table('user_contact_details')->updateOrInsert(
                ['user_id' => $user_id],
                ['billing_contact_detail' => $data]
            );
        if($added){
            return response()->json(['status' => 'success','message' => 'Billing Detail Added successfully'],200);    
        }else{
            return response()->json(['status' => 'success','message' => 'Somthing went wrong'],200);
        }
    }
    public function updateTechnicalDetail(Request $request)
    {
        try {
            $user_id = $request->id;
            $data = $request->input('technical');
            DB::table('user_contact_details')->updateOrInsert(
                ['user_id' => $user_id],
                ['technical_detail' => $data]
            );
            $updated_date = Carbon::now();
            $user = User::find($user_id);
            if ($user->domainStatus == 0){
                $user->domainStatus = 1;
            }
            $user->updated_at = $updated_date;
            $added = $user->save();
            if($added){
                return response()->json(['status' => 'success','message' => 'Technical Details added successfully!'],200);    
            }else{
                return response()->json(['status' => 'success','message' => 'Somthing went wrong'],200);
            }
        } catch (Throwable $e) {
            return ['status'=>false, 'msg'=>$e->getMessage()];
        }
    }
}
