<?php

namespace App\Http\Controllers\Api\Admin\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB,Validator;
class EmailSettingController extends Controller
{
    public function EmailList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $data = DB::table('email_settings')->orderBy('id')->limit($limit)->offset(($page - 1) * $limit)->get();
        $dataCount = DB::table('email_settings')->count();
        if($data){
            return response()->json(['status' => 'success', 'emails' => $data,'dataCount' =>$dataCount], 200);
        } else {
            return response()->json(['status' => 'success', 'emails' => []], 200);
        }
    }
    public function EmailSearch(Request $request){
        $searchTxt=$request->searchtxt;
        $data=DB::table('email_settings')->where('email_settings.host_name', 'LIKE', "%$searchTxt%")->get();
        if($data){
            return response()->json(['status' => 'success', 'emails' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'emails' => []], 200);
        }
    }
    public function EmailAdd(Request $request){
        if($request->isMethod('post')){
            $params = $request->all();
            $validator = Validator::make($params,[
                    'host_name' =>'required',
					'port_number' =>'required',
                    'username' =>'required',
                    'password' =>'required',
                    'from_address' =>'required',
                    'from_name' =>'required',
            ]);
            if($validator->fails()){
                return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
            }
            $saved=DB::table('email_settings')->insert([
                    'host_name' => $request->host_name,
                    'port_number' => $request->port_number,
                    'username' => $request->username,
                    'password' => $request->password,
                    'from_address' => $request->from_address,
                    'from_name' => $request->from_name,
					'status'=>2
            ]);
            if($saved){
                return response()->json(['status'=>"success",'message' => "Email Save successfully"], 200);
            }
            return response()->json(['status'=>'error', 'message' => 'Something Wrong'],200);
        }
        return response()->json(['status'=>'error', 'message', 'Not valid'],200);
    }
    public function EmailUpdate(Request $request){
        $params = $request->all();
        $validator = Validator::make($params,[
            'host_name' =>'required',
            'port_number' =>'required',
            'username' =>'required',
            'password' =>'required',
            'from_address' =>'required',
            'from_name' =>'required',
            'status'=>'required'
        ]);
        if($validator->fails()){
            return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
        }
            $data = DB::table('email_settings')->where('id', $request->id)->first();
            if (!$data) {
                return response()->json(['status' => 'success', 'message' => 'Email not found'], 200);
            }
            $update=DB::table('email_settings')->where('id', $request->id)->update([
                'host_name' => $request->host_name,
                'port_number' => $request->port_number,
                'username' => $request->username,
                'password' => $request->password,
                'from_address' => $request->from_address,
                'from_name' => $request->from_name,
				'status'=>$request->status
            ]);
            if($update){
                return response()->json(['status' => 'success','message' => 'Email updated successfully'],200);    
            }else{
                return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
            }
        return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
    }
    public function EmailDelete(Request $request){
        $id = $request->id;
        $data = DB::table('email_settings')->where('id', $id)->first();
        if (!$data) {
            return response()->json(['status' => 'success', 'message' => 'Email not found'], 200);
        }else{
            $status = DB::table('email_settings')->where('id', $id)->delete();
            if($status){
                return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
            }else{
                return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
            }
        }
        return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
    }
    
    public function EmailContent(){
        $getSettingQry = DB::table('misc_settings')->first();
        $data['getSettingData'] = $getSettingQry;
        if($data){
            return response()->json(['status' => 'success', 'email_content' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'email_content' => []], 200);
        }
    }
    
    
    
    public function EmailContentUpdate(Request $request){
        $params = $request->all();
        $validator = Validator::make($params,[
            'email_90days' =>'required',
            'email_60days' =>'required',
            'email_45days' =>'required',
            'email_30days' =>'required',
            'email_15days' =>'required',
            'email_7days' =>'required',
            'email_hold'=>'required',
            'email_restorable'=>'required',
            'email_delete'=>'required',
            'email_registered'=>'required',
            'email_renewed'=>'required',
            'email_clarification'=>'required',
            'email_approved'=>'required',
            'email_nameserver'=>'required',
            
        ]);
        if($validator->fails()){
            return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
        }
            $data = DB::table('misc_settings')->first();
            if (!$data) {
                return response()->json(['status' => 'success', 'message' => 'Email not found'], 200);
            }
            $update=DB::table('misc_settings')->update([
                
                'email_90days' =>$request->email_90days,
                'email_60days' =>$request->email_60days,
                'email_45days' =>$request->email_45days,
                'email_30days' =>$request->email_30days,
                'email_15days' =>$request->email_15days,
                'email_7days' =>$request->email_7days,
                'email_hold'=>$request->email_hold,
                'email_restorable'=>$request->email_restorable,
                'email_delete'=>$request->email_delete,
                'email_registered'=>$request->email_registered,
                'email_renewed'=>$request->email_renewed,
                'email_clarification'=>$request->email_clarification,
                'email_approved'=>$request->email_approved,
                'email_nameserver'=>$request->email_nameserver,
                
            ]);
            if($update){
                return response()->json(['status' => 'success','message' => 'Email Setting updated successfully'],200);    
            }else{
                return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
            }
        return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
    }
}
