<?php

namespace App\Http\Controllers\Api\Admin\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
Use DB,Validator;
class ModuleController extends Controller
{
    public function moduleList(Request $request) 
	{
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $modules = DB::table('modules')->limit($limit)->offset(($page - 1) * $limit)->get();
        $modulesCount = DB::table('modules')->count();
        if($modules){
            return response()->json(['status' => 'success', 'modules' => $modules,'modulesCount'=>$modulesCount], 200);
        } else {
            return response()->json(['status' => 'success', 'modules' => []], 200);
        }
    }
    public function moduleSearch(Request $request){
        $searchTxt=$request->searchtxt;
        $data=DB::table('modules')->where('modules.menu', 'LIKE', "%$searchTxt%")->get();
        if($data){
            return response()->json(['status' => 'success', 'modules' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'modules' => []], 200);
        }
    }
    public function moduleAdd(Request $request){
        if($request->isMethod('post'))
        {
            $params = $request->all();
            $messages = [
                'max' => 'Description should not be greater than 50 characters.',
            ];
            $validator = Validator::make($params,[
                'menu' =>'required|max:50|unique:modules,menu',
            ], $messages);
            
            if($validator->fails())
            {
                return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
            }
            $saved=DB::table('modules')->insert([
                'menu' => $request->menu,
                'status' => 'active',
            ]);

            if($saved)
            {
                return response()->json(['status'=>"success",'module' => "module Save successfully"], 200);
            }
        
            return response()->json(['status'=>'error', 'error' => 'Something Wrong'],404);
        }
    
        return redirect('home')->with('error', 'Not valid');
    }

    public function moduleUpdate(Request $request)
	{
        $params = $request->all();
        $messages = [
            'max' => 'Description should not be greater than 50 characters.',
        ];
        $validator = Validator::make($params,['menu' =>'required|max:50',], $messages);
        if($validator->fails())
        {
            return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
        }
        $id = $request->id;
        $description = $request->menu;

        
        $modules = DB::table('modules')->where('id', $id)->first();
        if (!$modules) {
            return response()->json(['status' => 'success', 'message' => 'module not found'], 200);
        }
        $update=DB::table('modules')->where('id', $id)->update(['menu' => $description]);
        if($update){
            return response()->json(['status' => 'success','message' => 'module updated successfully'],200);    
        }
		
	}
    public function moduleDelete(Request $request)
	{
        $id = $request->id;
        $modules = DB::table('modules')->where('id', $id)->first();
        $module_id = DB::table('programs')->where('module_id', $id)->first();
        if (!$modules) {
            return response()->json(['status' => 'success', 'message' => 'Module not found'], 200);
        }else{
            if(!$module_id){
                $status = DB::table('modules')->where('id', $id)->delete();
                if($status){
                    return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
                }else{
                    return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
                }
            }else{
                return response()->json(array('status'=>'error', 'message' => 'Module has been used So You can not delete it'));
            }
        }
        return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
	}
}
