<?php

namespace App\Http\Controllers\Api\Admin\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB,Validator;
class ProgramController extends Controller
{
    public function programList(Request $request) 
	{
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $programs = DB::table('programs')->join('modules', 'programs.module_id', '=', 'modules.id')->select('programs.*', 'modules.menu as name')->limit($limit)->offset(($page - 1) * $limit)->get();
        $programsCount = DB::table('programs')->count();
        if($programs){
            return response()->json(['status' => 'success', 'programs' => $programs,'programsCount'=>$programsCount], 200);
        } else {
            return response()->json(['status' => 'success', 'programs' => []], 200);
        }
    }
    
    public function programModuleList() 
	{
        $modules = DB::table('modules')->get();
        $modulesCount = DB::table('modules')->count();
        if($modules){
            return response()->json(['status' => 'success', 'modules' => $modules,'modulesCount'=>$modulesCount], 200);
        } else {
            return response()->json(['status' => 'success', 'modules' => []], 200);
        }
    }
    
    
    
    public function programAdd(Request $request)
	{
			if($request->isMethod('post'))
			{
				$params = $request->all();
				$messages = [
					'max' => 'Description should not be greater than 50 characters.',
				];
				$validator = Validator::make($params,[
					'description' =>'required|max:50|unique:programs,description',
                    'module_id'=>'required',
				], $messages);
				
				if($validator->fails())
				{
					return response()->json(['status'=>'errors', 'message' => $validator->errors()]);
				}
                $modules = DB::table('modules')->where('id', $request->module_id)->first();
                if($modules){
                    $data = [
                        'description' => $request->description,
                        'module_id'=>$request->module_id,
                         'created_by'=>'super-admin',
                          'status'=>'active',
                    ];
                    $save=DB::table('programs')->insert($data);
                    if($save){
                        return response()->json(['status'=>"success",'program' => "Program Save successfully"], 200);
                    }
                }else{
                    return response()->json(['status' => 'error', 'message' => 'Program not found'], 200);
                }
				return response()->json(array('status'=>'error', 'error' => 'Something Wrong'));
			}
			return redirect('home')->with('error', 'Not valid');
	}
    public function programUpdate(Request $request){
			$params = $request->all();
			$messages = [
				'max' => 'Description should not be greater than 50 characters.',
			];
			$validator = Validator::make($params,[
                'description' =>'required|max:50',
                'module_id'=>'required',
			], $messages);
			
			if($validator->fails())
			{
				return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
			}
            $id =$request->id;
			$description = $request->description;
			$module_id = $request->module_id;

			$programs = DB::table('programs')->where('id', $id)->first();
			if (!$programs) {
                return response()->json(['status' => 'success', 'message' => 'Program not found'], 200);
            }
			$update=DB::table('programs')->where('id', $id)->update(['description' => $description,'module_id'=>$module_id]);
			if($update){
			    return response()->json(['status' => 'success','message' => 'Program updated successfully'],200);    
			}
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		
		
    }
    public function programDelete(Request $request){
        $id = $request->id;
        $programs = DB::table('programs')->where('id', $id)->first();
        
        if (!$programs) {
            return response()->json(['status' => 'success', 'message' => 'Program not found'], 200);
        }else{
            $status = DB::table('programs')->where('id', $id)->delete();
            if($status){
                return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
            }else{
                return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
            }
        }
        return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
    }
    public function programFilter(Request $request){
        $module_id = $request->module_id;
        $searchTxt = $request->searchtxt;
        $query = DB::table('programs')->join('modules', 'programs.module_id', '=', 'modules.id')->select('programs.*', 'modules.menu as name');
        if ($module_id) {
            $query->where('programs.module_id', $module_id);
        }
        if ($searchTxt) {
            $query->where('programs.description', 'LIKE', "%$searchTxt%");
        }
        $programs = $query->get();

        if($programs){
            return response()->json(['status' => 'success', 'programs' => $programs], 200);
        } else {
            return response()->json(['status' => 'success', 'programs' => []], 200);
        }
    }
    
}
