<?php

namespace App\Http\Controllers\Api\Admin\Master;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Region;
use App\Components\RegionManager;
use Illuminate\Support\Facades\Auth;
use DB,Validator;
class StateController extends Controller
{
    public function RegionList(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $data = DB::table('regions')->orderBy('id')->limit($limit)->offset(($page - 1) * $limit)->get();
        $dataCount = DB::table('regions')->count();
        if($data){
            return response()->json(['status' => 'success', 'regions' => $data,'dataCount'=>$dataCount], 200);
        } else {
            return response()->json(['status' => 'success', 'regions' => []], 200);
        }
    }
    public function regionSearch(Request $request){
        $searchTxt=$request->searchtxt;
        $data=DB::table('regions')->where('regions.description', 'LIKE', "%$searchTxt%")->get();
        if($data){
            return response()->json(['status' => 'success', 'regions' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'regions' => []], 200);
        }
    }
    public function regionAdd(Request $request){
        if($request->isMethod('post')){
            $params = $request->all();
            $messages = [
                'max' => 'Description should not be greater than 50 characters.',
            ];
            $validator = Validator::make($params,[
                'description' =>'required|max:50',
            ], $messages);
            
            if($validator->fails())
            {
                return response()->json(['status'=>'errors', 'message' => $validator->errors()]);
            }
            $description = $request->description;
            $saved=DB::table('regions')->insert([
                'description' => $description,
            ]);

            if($saved)
            {
                return response()->json(['status'=>"success",'region' => "State Save successfully"], 200);
            }
            
            return response()->json(['status'=>'error', 'error' => 'Something Wrong'],404);
        }
    
        return response()->json(['status'=>'error', 'error', 'Not valid'],404);
    }
    public function regionUpdate(Request $request)
	{
			$params = $request->all();
			$messages = [
				'max' => 'Description should not be greater than 50 characters.',
			];
			$validator = Validator::make($params,[
				'description' =>'required|max:50',
			], $messages);
			
			if($validator->fails())
			{
				return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
			}
			$id = $request->id;
			$description = $request->description;
			$state = DB::table('regions')->where('id', $id)->first();
			if (!$state) {
                return response()->json(['status' => 'success', 'message' => 'State not found'], 200);
            }
			$update=DB::table('regions')->where('id', $id)->update(['description' => $description]);
			if($update){
			    return response()->json(['status' => 'success','message' => 'State updated successfully'],200);    
			}
			//return response()->json(['status' => 'success','message' => 'Something went wrong please try again.'],404);
	}
	
    public function regionDelete(Request $request)
	{
        $id = $request->id;
        $state = DB::table('regions')->where('id', $id)->first();
        $region_id = DB::table('cities')->where('region_id', $id)->first();
        if (!$state) {
            return response()->json(['status' => 'success', 'message' => 'State not found'], 200);
        }else{
            if(!$region_id){
                $status = DB::table('regions')->where('id', $id)->delete();
                if($status){
                    return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
                }else{
                    return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
                }
            }else{
                return response()->json(array('status'=>'error', 'message' => 'State has been used So You can not delete it'));
            }
            
        }
        return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
	}
}

