<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use Hash;
use Illuminate\Support\Facades\Mail;
use App\Library\EPP;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;
class WebsettingController extends Controller
{
    
    public function AdminSettingView()
    {
        $data['title'] = 'Setting';
        $getSettingQry = DB::table('misc_settings')->first();
        if(!empty($getSettingQry))
        {
            $data['getSettingData'] = $getSettingQry;
        }
        else
        {
            $data['getSettingData']['reactivation_price']='';
            $data['getSettingData']['hold_deduction_price']='';
            $data['getSettingData']['service_tax']='';
            $data['getSettingData']['dns_price']='';
            $data['getSettingData']['primary_dns_name']='';
            $data['getSettingData']['secondary_dns_name']='';
            $data['getSettingData']['account_number']='';
            $data['getSettingData']['branch_name']='';
            $data['getSettingData']['email']='';
            $data['getSettingData']['email_address_one']='';
            $data['getSettingData']['email_address_two']='';

            $data['getSettingData']['interface']='';
            $data['getSettingData']['hostname']='';
            $data['getSettingData']['port']='';
            $data['getSettingData']['userid']='';
            $data['getSettingData']['password']='';
            $data['getSettingData']['logging']='';
            $data['getSettingData']['certificatefile']='';
            $data['getSettingData']['certificatepassword']='';
            $data['getSettingData']['verifypeer']='';
            $data['getSettingData']['verifypeername']='';
            $data['getSettingData']['allowselfsigned']='';
            $data['getSettingData']['status']='';
            $data['getSettingData']['created_by']='';
        }
       return response()->json(['status' => 'success', 'user_details' => $data], 200);
    }
    
    
    
    
    public function AdminUpdateSettings(Request $request){
        
        $created_date = date('Y-m-d H:i:s');
        $oldValues = DB::table('misc_settings')->where('id', 1)->first();
        $newValues = [
            'reactivation_price' => $request->input('reactivation_price', $oldValues->reactivation_price),
            'hold_deduction_price' => $request->input('hold_deduction_price', $oldValues->hold_deduction_price),
            'service_tax' => $request->input('service_tax', $oldValues->service_tax),
            'email_address_one' => $request->input('email_address_one', $oldValues->email_address_one),
            'email_address_two' => $request->input('email_address_two', $oldValues->email_address_two),
            'email_address_optional' => $request->input('email_address_optional', $oldValues->email_address_optional),
            'hold_domain_period' => $request->input('hold_domain_period', $oldValues->hold_domain_period),
            'restorable_domain_period' => $request->input('restorable_domain_period', $oldValues->restorable_domain_period),
            'hold_domain_reminder_period' => $request->input('hold_domain_reminder_period', $oldValues->hold_domain_reminder_period),
            'restorable_domain_reminder_period' => $request->input('restorable_domain_reminder_period', $oldValues->restorable_domain_reminder_period),
            'interface' => $request->input('interface', $oldValues->interface),
            'hostname' => $request->input('hostname', $oldValues->hostname),
            'port' => $request->input('port', $oldValues->port),
            'userid' => $request->input('userid', $oldValues->userid),
            'password' => $request->input('password', $oldValues->password),
            'logging' => $request->input('logging', $oldValues->logging),
            'certificatefile' => $request->input('certificatefile', $oldValues->certificatefile),
            'certificatepassword' => $request->input('certificatepassword', $oldValues->certificatepassword),
            'verifypeer' => $request->input('verifypeer', $oldValues->verifypeer),
            'verifypeername' => $request->input('verifypeername', $oldValues->verifypeername),
            'allowselfsigned' => $request->input('allowselfsigned', $oldValues->allowselfsigned),
            'status' => '1',
            'created_by' => 'super_admin',
            'updated_at' => $created_date,
        ];
    
        $product_id = DB::table('misc_settings')->updateOrInsert(['id' => 1], $newValues);
        
        if ($product_id > 0) {
            return response()->json(['status' => 'success', 'message' => "Setting has been updated successfully"], 200);
        } else {
            return response()->json(['status' => 'success', 'message' => "Something Went Wrong Please Try again."], 200);
        }
        
    }
    
    public function UsersDeatilsList(Request $request){
        $data['title'] = 'Find Users Details';
        #$data['domainStatus']=8;
        $data['domainStatus']='';
        $Query = DB::table('users');
        if ($request->has('name') && ! empty($request->name))
        {
            $Query->where('users.name', 'LIKE','%'. $request->name.'%');
        }
        if ($request->has('user_name') && ! empty($request->user_name))
        {
            $Query->where('users.domainName', 'LIKE','%'. $request->user_name.'%');
        }
        if ($request->has('institute_name') && ! empty($request->institute_name))
        {
            $Query->where('users.institute', 'LIKE','%'. $request->institute_name.'%');
        }
        if ($request->has('domainLangID') && ! empty($request->domainLangID))
        {
            // $lang = DB::table('domain_languages')->where('lang_code',$request->domainLangID)->first();
            $Query->where('users.domainLangID',  $request->domainLangID);
        }
        if ($request->has('status') && ! empty($request->status))
        {
            $Query->where('users.status', $request->status);
        }
        if ($request->has('lang') && ! empty($request->lang))
        {
            $lang = DB::table('domain_languages')->where('id',$request->lang)->first();
            $Query->where('users.domainLangID', $lang->id);
        }
        if ($request->has('domainStatus') && ! empty($request->domainStatus))
        {
            if ($request->domainStatus == 2){
                $Query->whereIn('users.domainStatus', [1,2,3,4]);
                $Query->where('users.clarify',0);
            }elseif ($request->domainStatus == 6){
                $Query->whereIn('users.domainStatus', [6,10]);
            }
            else{
                $Query->where('users.domainStatus', $request->domainStatus);
            }
            $data['domainStatus']=$request->domainStatus;
        }

        if ($request->creation_start_date != '' && $request->creation_end_date != '')
        {
            $start_date = Carbon::parse($request->creation_start_date);
            $end_date = Carbon::parse($request->creation_end_date);
            $Query->whereBetween('users.created_at', [$start_date->format('Y-m-d')." 00:00:00", $end_date->format('Y-m-d')." 23:59:59"]);
        }
        $data['creation_start_date']=$request->creation_start_date;
        $data['creation_end_date']=$request->creation_end_date;
	
        if ($request->expiry_start_date != '' && $request->expiry_end_date != '')
        {
            $start_date = Carbon::parse($request->expiry_start_date);
            $end_date = Carbon::parse($request->expiry_end_date);
            $Query->whereBetween('users.domainExpiryDate', [$start_date->format('Y-m-d')." 00:00:00", $end_date->format('Y-m-d')." 23:59:59"]);
        }
        $data['expiry_start_date']=$request->expiry_start_date;
        $data['expiry_end_date']=$request->expiry_end_date;

        $pagetext='Users Details List';

        if ($request->has('domaintext') && ! empty($request->domaintext))
        {
            $pagetext=$request->domaintext;
        }

        if ($request->has('domaintext') && $request->domaintext == 'Rejected')
        {
            $data['domaintext']='Rejected';
        }

        if ($request->has('domaintext') && $request->domaintext == 'No Zone Record')
        {
            $pagetext='Pending ERNET DNS Records';
            $Query->where('users.zone_file',0)
            ->where('user_name_servers.server_type',1)->join('user_name_servers','user_name_servers.user_id','users.id')
            ->select('users.*', 'user_name_servers.server_type', 'user_name_servers.user_id');
        }

        if ($request->has('domaintext') && $request->domaintext == 'Active ERNET DNS')
        {
            $pagetext='Active ERNET DNS';
            $Query->where('user_name_servers.server_type',1)->join('user_name_servers','user_name_servers.user_id','users.id')
            ->select('users.*', 'user_name_servers.server_type', 'user_name_servers.user_id');
        }

        if ($request->has('domaintext') && $request->domaintext == 'Without DNS')
        {
            $pagetext='Without DNS';
            $Query->where('user_name_servers.server_type','')->join('user_name_servers','user_name_servers.user_id','users.id');
        }
        if ($request->has('domaintext') && $request->domaintext == 'Cooling Period')
        {
            
            $pagetext='Cooling Period List';
            $Query->where('users.domainExpiryDate', '<=', DB::raw('CURDATE()'))
            ->whereBetween(DB::raw('DATEDIFF(users.domainExpiryDate, users.domainExpiryDate)'), [70, 75])
            ->select('*');
        }

        $Query->orderBy('users.id','desc');

        $data['domaintext']=$pagetext;
        
        $users = $Query->get();
        foreach ($users as $user){
            $userdocuments = DB::table('user_documents')->select('user_documents.*','document_category.title')->where('user_id',$user->id)->join('document_category','document_category.id','=','user_documents.document_category_id')->get();
            $user->is_doc_approved = 3;
            $user->pending_doc = 0;
            foreach ($userdocuments as $doc){
                if ($doc->status == 0){
                    $user->is_doc_approved = 0;
                    $user->pending_doc  = DB::table('user_documents')->where('user_id',$user->id)->where('status','=', 0)->count();
                     break;
                }elseif ($doc->status == 1){
                    $user->is_doc_approved = 1;
                     break;
                }else{
                    $user->is_doc_approved = 2;
                }
            }
        }

        $data['users_data']=$users;
        return response()->json(['status' => 'success', 'user_details' => $data], 200);
    }
    
    public function userDetails(Request $request){
        $id=$request->id;
        $data['user'] = DB::table('users')->where('id','=',$id)->first();
        $data['user_contact_details'] = DB::table('user_contact_details')->where('user_id','=',$id)->first();
        $data['user_name_server'] = DB::table('user_name_servers')->where('user_id','=',$id)->first();
        $data['payment'] = DB::table('transactions')->orderBy('id','DESC')->where('user_id','=',$id)->first();
        //$data['user_documents'] = DB::table('user_documents')->where('user_id','=',$id)->get();
        $userdocuments = DB::table('user_documents')->select('user_documents.*','document_category.title')->where('user_id',$id)->join('document_category','document_category.id','user_documents.document_category_id')->get();
        $data['title'] = 'Users Details';
        $data['userdocuments'] = $userdocuments;

        $is_approved = 1;
        foreach ($userdocuments as $doc){
            if ($doc->status == 1 || $doc->status == 0){
                $is_approved = 0;
                break;
            }else{
                $is_approved = 2;
            }

        }

        $data['is_approved'] = $is_approved;
        return response()->json(['status' => 'success', 'user_details' => $data], 200);
    }
    
    public function userDocDetailsView(Request $request){
        $id=$request->id;
        $data['title'] = 'Users Details';
        $data['user_contact_details'] = DB::table('user_contact_details')->where('user_id','=',$id)->first();
        $data['user_name_server'] = DB::table('user_name_servers')->where('user_id','=',$id)->first();
        $data['user_documents'] = DB::table('user_documents')->where('user_id','=',$id)->get();
        $userdocuments = DB::table('user_documents')->select('user_documents.*','document_category.title')->where('user_id',$id)->join('document_category','document_category.id','user_documents.document_category_id')->get();
        $data['userdocuments'] = $userdocuments;

        $is_approved = 1;
        foreach ($userdocuments as $doc){
            if ($doc->status == 1 || $doc->status == 0){
                $is_approved = 0;
                break;
            }else{
                $is_approved = 2;
            }
        }
        $data['is_approved'] = $is_approved;
        return response()->json(['status' => 'success', 'user_details' => $data], 200);
    }
    
    
    
    public function DnsViewDetails(){
        $data['title'] = 'DNS Details';
        $getSettingQry = DB::table('ernet_name_servers')->first();
        $dnsPrice = DB::table('ernet_name_servers_prices')->where('ernet_name_server_id','=', $getSettingQry->id)->orderBy('years','asc')->get();
        if(!empty($getSettingQry))
        {
            $data['getDNSData'] = $getSettingQry;
            $data['getDNSPrice'] = $dnsPrice;
        }else{
            $data['getDNSData']['primary_name_server']='';
            $data['getDNSData']['secondary_name_server']='';
        }
        return response()->json(['status' => 'success', 'user_details' => $data], 200);
    }
    
    public function DnsUpdateDetails(Request $request){
        $created_date = date('Y-m-d H:i:s');
        $data = [
            "primary_name_server" => $request->input('primary_name_server'),
            "secondary_name_server" => json_encode($request->input('secondary_name_server')),
            'updated_at'=> $created_date,
        ];
        $ernet = DB::table('ernet_name_servers')->first();
        $status = DB::table('ernet_name_servers')->updateOrInsert(['id' => $ernet->id],$data);
        if($status){
            return response()->json(['status' => 'success', 'message' => "Setting has been updated successfully"], 200);
        }else{
            return response()->json(['status' => 'success', 'message' => "Something Went Wrong Please Try again."], 200);
        }
        return response()->json(['status' => 'error', 'message' => "Invalid Request"], 200);
    }
    
    
    public function DnsAddPrice(Request $request){
        $validator = Validator::make($request->all(), [
            'years' => 'required|unique:ernet_name_servers_prices',
        ]);
        if ($validator->fails()) {
            return response()->json(['status'=>false ,'error'=>$validator->errors()->first()]);
        }
        $ernet_server = DB::table('ernet_name_servers')->first();
        if ($ernet_server == null){
            return response()->json(['status' => 'success', 'message' => "Add Server Name First"], 200);
        }

        $created_date = date('Y-m-d H:i:s');
        $data = [
            "years" => $request->input('years'),
            "price" => $request->input('price'),
            "ernet_name_server_id" => $ernet_server->id,
            'updated_at'=> $created_date,
        ];
        $status = DB::table('ernet_name_servers_prices')->updateOrInsert(['years' => $request->input('years')],$data);
        if($status){
            return response()->json(['status' => 'success', 'message' => "DNS Price has been Added successfully"], 200);
        }else{
            return response()->json(['status' => 'success', 'message' => "Something Went Wrong Please Try again."], 200);
        }
        return response()->json(['status' => 'error', 'message' => "Invalid Request"], 200);
    }
    
    public function DnsUpdatePrice(Request $request)
    {
        $created_date = date('Y-m-d H:i:s');
        $data = [
            "years" => $request->input('years'),
            "price" => $request->input('price'),
            'updated_at'=> $created_date,
        ];
        $status = DB::table('ernet_name_servers_prices')->updateOrInsert(['id' => $request->input('id')],$data);
        if($status){
            return response()->json(['status' => 'success', 'message' => "DNS Price has been Updated successfully"], 200);
            
        }else{
            return response()->json(['status' => 'success', 'message' => "Something Went Wrong Please Try again."], 200);
        }
        return response()->json(['status' => 'error', 'message' => "Invalid Request"], 200);
    }
    
    public function DnsDeletePrice(Request $request){
        if(!empty($request->id))
        {
            $status = DB::table('ernet_name_servers_prices')->where('id', $request->id)->delete();
            if($status)
            {
                return response()->json(['status' => 'success', 'message' => "Successfully Delete Domain Price"], 200);
            }
            else
            {
                return response()->json(['status' => 'success', 'message' => "Something Went Wrong Please Try again."], 200);
            }
        }
        return response()->json(['status' => 'error', 'message' => "Invalid Request"], 200);
    }
    
    
    public function DomainSettingViewPrice(Request $request)
    {
        $searchtext=$request->search_text;
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $data = DB::table('domain_extension_prices');
        if($request->search_text){
            $data->where('year',$searchtext);
        }
        $data->orderBy('id','desc')->limit($limit)->offset(($page - 1) * $limit);

        $dataCount = DB::table('domain_extension_prices');
        if($request->search_text && $request->search_text!=null){
            $dataCount->where('year',$searchtext);
        }
        $dtcount=$dataCount->count();
        if($data){
            return response()->json(['status' => 'success', 'domain_extension_prices' => $data->get(),'dataCount'=>$dtcount], 200);
        } else {
            return response()->json(['status' => 'success', 'domain_extensions' => []], 200);
        }
        
    }
    
    
    public function DomainAddPriceSetting(Request $request){
        $validator = Validator::make($request->all(), [
            'year' => 'required',
            'price'=>'required',
            'renewal_charge'=>'required',
        ]);
        if ($validator->fails()) {
            return response()->json(['status'=>false ,'error'=>$validator->errors()->first()]);
        }
        $created_date = date('Y-m-d H:i:s');
        $data = [
                'year'=>$request->input('year'),
                'price'=>$request->input('price'),
                'renewal_charge'=>$request->input('renewal_charge'),
                'vas_charges'=>$request->input('vas_charges'),
                'vas_renew_charges'=>$request->input('vas_renew_charges'),
                'created_at'=> $created_date,
        ];
        
        $status = DB::table('domain_extension_prices')->updateOrInsert($data);
        if($status){
            return response()->json(['status' => 'success', 'message' => "Setting has been Added successfully"], 200);
        }else{
            return response()->json(['status' => 'success', 'message' => "Something Went Wrong Please Try again."], 200);
        }
        return response()->json(['status' => 'error', 'message' => "Invalid Request"], 200);
    }
    
    public function DomainUpdatePriceSetting(Request $request){
        $created_date = date('Y-m-d H:i:s');
        $data = [
            'year'=>$request->input('year'),
            'price'=>$request->input('price'),
            'renewal_charge'=>$request->input('renewal_charge'),
            'vas_charges'=>$request->input('vas_charges'),
            'vas_renew_charges'=>$request->input('vas_renew_charges'),
            'updated_at'=> $created_date,
        ];
        $status = DB::table('domain_extension_prices')->updateOrInsert(['id' => $request->input('id')],$data);
        if($status){
            return response()->json(['status' => 'success', 'message' => "Setting has been updated successfully"], 200);
        }else{
            return response()->json(['status' => 'success', 'message' => "Something Went Wrong Please Try again."], 200);
        }
        return response()->json(['status' => 'error', 'message' => "Invalid Request"], 200);
    }
    
    public function DeleteDomainPriceSetting(Request $request){
        if(!empty($request->id)){
            $deleted_domain_price = DB::table('domain_extension_prices')->where('id', $request->id)->delete();
            if($deleted_domain_price){
                return response()->json(['status' => 'success', 'message' => "Successfully Delete Domain Price"], 200);
            }else{
                return response()->json(['status' => 'success', 'message' => "Something Went Wrong Please Try again"], 200);
            }
        }
        return response()->json(['status' => 'error', 'message' => "Invalid Request"], 200);
    }
    
    public function DomainExtensionView(Request $request){
        $searchtext=$request->search_text;
        
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $data = DB::table('domain_extensions')->select('domain_extensions.*','domain_main_category.domain_category_name')->join('domain_main_category','domain_main_category.id','domain_extensions.domain_main_category_id');
        if($request->search_text){
            $data->where('domain_extensions.domain_extension', 'LIKE', "%$searchtext%");
        }
        $data->orderBy('id','desc')->limit($limit)->offset(($page - 1) * $limit);
        //$data = DB::table('domain_extensions')->orderBy('id','desc')->limit($limit)->offset(($page - 1) * $limit)->get();
        $dataCount = DB::table('domain_extensions');
        if($request->search_text && $request->search_text!=null){
            $dataCount->where('domain_extension', 'LIKE', "%$searchtext%");
        }
        $dtcount=$dataCount->count();
        if($data){
            return response()->json(['status' => 'success', 'domain_extensions' => $data->get(),'dataCount'=>$dtcount], 200);
        } else {
            return response()->json(['status' => 'success', 'domain_extensions' => []], 200);
        }
    }
    
    
    
    //DomainExtensionSearch
    
    
    public function DomainMainCategory(Request $request){
        $data = DB::table('domain_main_category')->orderBy('id')->get();
        if($data){
            return response()->json(['status' => 'success', 'domain_category' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'domain_category' => []], 200);
        }
    }
    
    
    public function AddDomainExtension(Request $request){
        $extension_id = 0;
        if ($request->has('ext_id')){
            $extension_id = ($request->input('ext_id') != null)? $request->input('ext_id'): 0;
        }
        $docid = ($request->input('doc_ids') != null)? implode(',',$request->input('doc_ids')): '';
        $created_date = date('Y-m-d H:i:s');
        $status = DB::table('domain_extensions')
            ->updateOrInsert(
                ['id' => $extension_id],
                [
                    'domain_main_category_id'=>$request->main_category,
                    'domain_language_id'=>$request->regional_languages,
                    'domain_extension'=>$request->domain_extensions,
                    'status'=>$request->domain_status,
                    'doc_ids'=>$docid
                ]
            );
        if($status>=0)
        {
          return response()->json(['status' => 'success', 'message' => "Extension has been Saved successfully"], 200);
        }else{
             return response()->json(['status' => 'success', 'message' => "Something Went Wrong Please Try again."], 200);
        }
        return response()->json(['status' => 'error', 'message' => "Invalid Request"], 200);
    }
    public function DeleteDomainExtension(Request $request)
    {
        if(!empty($request->id)){
            $deleted_domain_price = DB::table('domain_extensions')->where('id', $request->id)->delete();
            if($deleted_domain_price){
                return response()->json(['status' => 'success', 'message' => "Extension Deleted successfully"], 200);
            }else{
                return response()->json(['status' => 'success', 'message' => "Something Went Wrong Please Try again."], 200);
            }
        }
        return response()->json(['status' => 'error', 'message' => "Invalid Request"], 200);
    }
    
    
    public function AdminListView(Request $request){
        $page = $request->has('page') ? $request->get('page') : 1;
        $limit = 15;
        $data = DB::table('admins')->orderBy('id')->limit($limit)->offset(($page - 1) * $limit)->get();
        $dataCount = DB::table('admins')->count();
        if($data){
            return response()->json(['status' => 'success', 'admins' => $data,'dataCount'=>$dataCount], 200);
        } else {
            return response()->json(['status' => 'success', 'admins' => []], 200);
        }
    }
    
    public function AdminSearch(Request $request){
        $searchTxt=$request->searchtxt;
        $data=DB::table('admins')->where('admins.username', 'LIKE', "%$searchTxt%")->get();
        if($data){
            return response()->json(['status' => 'success', 'search_result' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'search_result' => []], 200);
        }
    }
    
    public function AdminAdd(Request $request){
        if($request->isMethod('post')){
            $params = $request->all();
            $validator = Validator::make($params,[
                    'username' =>'required|max:50|unique:admins,username',
                    'name' =>'required',
                    'email'=>'required|email|unique:admins,email',
                    'mobile'=>'required|digits:10',
                    'password'=>'required|min:8',
                    'status'=>'required'
            ]);
            
            if($validator->fails())
            {
                return response()->json(['status'=>'errors', 'message' => $validator->errors()]);
            }
            
            $saved=DB::table('admins')->insert([
                'username'=>$request->username,
                    'name'=>$request->name,
                    'email'=>$request->email,
                    'mobile'=>$request->mobile,
                    'password'=>Hash::make($request->password),
                    'status'=>$request->status
            ]);

            if($saved)
            {
                return response()->json(['status'=>"success",'admins' => "New Admin Save successfully"], 200);
            }
            
            return response()->json(['status'=>'error', 'error' => 'Something Wrong'],404);
        }
        return response()->json(['status'=>'error', 'error', 'Not valid'],404);
    }
    
    public function AdminUpdate(Request $request)
	{
		$params = $request->all();
		$validator = Validator::make($params,[
			'name' =>'required',
                'email'=>'required|email',
                'mobile'=>'required|digits:10',
                'status'=>'required'
		]);
		
		if($validator->fails())
		{
			return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
		}
		$id = $request->id;
		$admins = DB::table('admins')->where('id', $id)->first();
		if (!$admins) {
            return response()->json(['status' => 'success', 'message' => 'admin not found'], 200);
        }
		$update=DB::table('admins')->where('id', $id)->update([
		    'name'=>$request->name,
            'email'=>$request->email,
            'mobile'=>$request->mobile,
            'status'=>$request->status
	    ]);
		if($update){
		    return response()->json(['status' => 'success','message' => 'Admin Details updated successfully'],200);    
		}
		return response()->json(['status' => 'success','message' => 'Something went wrong please try again.'],404);
	}
	
	public function AdminDelete(Request $request)
	{
        $id = $request->id;
        $admins = DB::table('admins')->where('id', $id)->first();
        if (!$admins) {
            return response()->json(['status' => 'success', 'message' => 'Admin not found'], 200);
        }else{
            $status = DB::table('admins')->where('id', $id)->delete();
            if($status){
                return response()->json(array('status'=>'success', 'message' => 'Admin Details Delete successfully.'));
            }else{
                return response()->json(array('status'=>'success', 'message' => 'Something went wrong please try again.'));
            }
        }
        return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
	}
	
	
    public function DeletedUserDetailsView(Request $request)
    {
	if($request->status==0){
$Query = DB::table('deleted_users')->where('status','=',$request->status);
}else{
$Query = DB::table('deleted_users');
}
        
        if ($request->has('name') && ! empty($request->name))
        {
            $Query->where('name', 'LIKE','%'. $request->name.'%');
        }
        if ($request->has('user_name') && ! empty($request->user_name))
        {
            $Query->where('domainName', 'LIKE','%'. $request->user_name.'%');
        }
        if ($request->has('institute_name') && ! empty($request->institute_name))
        {
            $Query->where('institute', 'LIKE','%'. $request->institute_name.'%');
        }
    
        if ($request->has('start_date') && ! empty($request->start_date))
        {
            $end_date = date('Y-m-d');
            if ($request->has('end_date') && ! empty($request->end_date))
            {
                $start_date = Carbon::parse($request->start_date);
                $end_date = Carbon::parse($request->end_date);
                $Query->whereBetween('created_at', [$start_date->format('Y-m-d')." 00:00:00", $end_date->format('Y-m-d')." 23:59:59"]);
            }
        }
        $pagetext='Users Details List';
        $data['domaintext']=$pagetext;
        $users = $Query->get();
        $data['users_data']=$users;
        if($data){
            return response()->json(['status' => 'success', 'search_result' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'search_result' => []], 200);
        }
    }
    
    
    public function DeletedUserDetailsSearch(Request $request){
        $searchTxt=$request->searchtxt;
        $Query=DB::table('deleted_users')->where('deleted_users.name', 'LIKE', "%$searchTxt%")->orWhere('deleted_users.domainName','LIKE', "%$searchTxt%")->orWhere('deleted_users.institute','LIKE', "%$searchTxt%")->get();
        
        $pagetext='Users Details List';
        $data['domaintext']=$pagetext;
        $users = $Query;
        $data['users_data']=$users;
        if($data){
            return response()->json(['status' => 'success', 'search_result' => $data], 200);
        } else {
            return response()->json(['status' => 'success', 'search_result' => []], 200);
        }
    }
    


    public function UserDnsDetail(Request $request)
    {
        $id=$request->id;
        $data['title'] = 'Users Name Server Update';
        $user_dns = DB::table('user_name_servers')->where('id','=', $id)->first();
        $user = DB::table('users')->where('id','=', $user_dns->user_id)->first();
        $data['ernet_name_server'] = DB::table('ernet_name_servers')->where('status','=',1)->first();
        $data['ernet_name_server_prices'] = DB::table('ernet_name_servers_prices')->where('ernet_name_server_id','=',$data['ernet_name_server']->id)->orderBy('years','asc')->get();
        $data['user_name_server'] = $user_dns;
        $data['dns_security_extension'] = DB::table('dns_security-extension')->where('user_dns_server_id','=',$user_dns->id)->get();
        $data['user'] = $user;
        if($data){
            return response()->json(['status' => 'success', 'user_details' => $data], 200);
        }else{
            return response()->json(['status' => 'success', 'user_details' => []], 200);
        }
        
    }

	public function updateUserDnsNameServer(Request $request)
    {
        
        $type = 0;
        try {
            $user_id = $request->input('id');
            $request->validate([
                'primary_name_server' => 'required',
            ]);
            //dd($request->all());
            $data = [
                "user_id" => $user_id,
                "server_type" => 2,
                "primary_name_server" => $request->input('primary_name_server'),
                "primary_name_server_ip" => ($request->input('primary_name_server_ip')== null)? '': implode('.',$request->input('primary_name_server_ip')) ,
                "secondary_name_server1" => $request->input('secondary_name_server1'),
                "secondary_name_server2" => $request->input('secondary_name_server2'),
                "secondary_name_server3" => $request->input('secondary_name_server3'),
                "secondary_name_server4" =>  $request->input('secondary_name_server4'),
                "secondary_name_server5" =>$request->input('secondary_name_server5'),
                "ernet_name_server_duration_year" => null,
                "secondary_name_server1_ip" => ($request->input('secondary_name_server1_ip')== null)? '': implode('.',$request->input('secondary_name_server1_ip')) ,
                "secondary_name_server2_ip" => ($request->input('secondary_name_server2_ip')== null)? '': implode('.',$request->input('secondary_name_server2_ip')) ,
                "secondary_name_server3_ip" => ($request->input('secondary_name_server3_ip')== null)? '': implode('.',$request->input('secondary_name_server3_ip')) ,
                "secondary_name_server4_ip" => ($request->input('secondary_name_server4_ip')== null)? '': implode('.',$request->input('secondary_name_server4_ip')) ,
                "secondary_name_server5_ip" => ($request->input('secondary_name_server5_ip')== null)? '': implode('.',$request->input('secondary_name_server5_ip')) ,
                "primary_name_server_ip6" => ($request->input('primary_name_server_ip6')== null)? '': implode(':',$request->input('primary_name_server_ip6')) ,
                "secondary_name_server1_ip6" => ($request->input('secondary_name_server1_ip6')== null)? '': implode(':',$request->input('secondary_name_server1_ip6')) ,
                "secondary_name_server2_ip6" => ($request->input('secondary_name_server2_ip6')== null)? '': implode(':',$request->input('secondary_name_server2_ip6')) ,
                "secondary_name_server3_ip6" => ($request->input('secondary_name_server3_ip6')== null)? '': implode(':',$request->input('secondary_name_server3_ip6')) ,
                "secondary_name_server4_ip6" => ($request->input('secondary_name_server4_ip6')== null)? '': implode(':',$request->input('secondary_name_server4_ip6')) ,
                "secondary_name_server5_ip6" => ($request->input('secondary_name_server5_ip6')== null)? '': implode(':',$request->input('secondary_name_server5_ip6'))
            ];
            $user_dns = DB::table('user_name_servers')->where('user_id','=', $user_id)->first();
            if ($user_dns == null){
                $dns_id = DB::table('user_name_servers')
                    ->insertGetId(
                        $data
                    );
                if ($request->input('enable_dnsse') == 'yes'){
                    if($request->input('dnsse')!=null){
                        
                        // foreach ($request->input('dnsse') as $dnssec){
                        //     $dnssec['user_dns_server_id'] = $dns_id;
                        //     DB::table('dns_security-extension')->insert($dnssec);
                        // }
                        
                        
                        foreach($request->input('dnsse') as $dnssec) {
                            DB::table('dns_security-extension')->create([
                                'user_dns_server_id' => $dns_id,
                                'key_tag' => $dnssec->key_tag,
                                'algorithm' => $dnssec->algorithm,
                                'digest_type'=>$dnssec->digest_type,
                                'digest'=>$dnssec->digest,
                                'status'=>1,
                                'created_at'=>date('Y-m-d H:i:s'),
                                'updated_at'=>date('Y-m-d H:i:s'),
                            ]);
                        }
                    }
                }
            }else{
                DB::table('user_name_servers')->updateOrInsert(
                    ['user_id' => $user_id],$data
                );
                DB::table('dns_security-extension')->where('user_dns_server_id',$user_dns->id)->delete();
                $dns_id = $user_dns->id;
                if ($request->input('enable_dnsse') == 'yes'){
                    if($request->input('dnsse')!=null){
                        
                        // foreach ($request->input('dnsse') as $dnssec){
                        //     $dnssec['user_dns_server_id'] = $user_dns->id;
                        //     DB::table('dns_security-extension')->insert($dnssec);
                        // }
                        
                        
                        foreach($request->input('dnsse') as $dnssec) {
                            DB::table('dns_security-extension')->create([
                                'user_dns_server_id' => $dns_id,
                                'key_tag' => $dnssec->key_tag,
                                'algorithm' => $dnssec->algorithm,
                                'digest_type'=>$dnssec->digest_type,
                                'digest'=>$dnssec->digest,
                                'status'=>1,
                                'created_at'=>date('Y-m-d H:i:s'),
                                'updated_at'=>date('Y-m-d H:i:s'),
                            ]);
                        }
                    }
                }
                $namserver=DB::table('user_name_servers')->where('user_id',$user_id)->first();

                $savedns=[
                    $namserver->primary_name_server,
                    $namserver->secondary_name_server1,
                ];
                $paramscreate=[
                    'ns1'=>[
                        'host'=>$namserver->primary_name_server,
                        'ip4'=>$namserver->primary_name_server_ip,
                        'ip6'=>$namserver->primary_name_server_ip6,
                    ],
                    'ns2'=>[
                        'host'=>$namserver->secondary_name_server1,
                        'ip4'=>$namserver->secondary_name_server1_ip,
                        'ip6'=>$namserver->secondary_name_server1_ip6,
                    ],
                ];
                if($namserver->secondary_name_server2!=null){
                    $paramscreate['ns3']=[
                        'host'=>$namserver->secondary_name_server2,
                        'ip4'=>$namserver->secondary_name_server2_ip,
                        'ip6'=>$namserver->secondary_name_server2_ip6,
                    ];
                    array_push($savedns,$namserver->secondary_name_server2);
                }
                if($namserver->secondary_name_server3!=null){
                    $paramscreate['ns4']=[
                        'host'=>$namserver->secondary_name_server3,
                        'ip4'=>$namserver->secondary_name_server3_ip,
                        'ip6'=>$namsever->secondary_name_server3_ip6,
                    ];
                    array_push($savedns,$namserver->secondary_name_server3);
                }
                if($namserver->secondary_name_server4!=null){
                    $paramscreate['ns5']=[
                        'host'=>$namserver->secondary_name_server4,
                        'ip4'=>$namserver->secondary_name_server4_ip,
                        'ip6'=>$namserver->secondary_name_server4_ip6,
                    ];
                    array_push($savedns,$namserver->secondary_name_server4);
                }
                if($namserver->secondary_name_server5!=null){
                    $paramscreate['ns6']=[
                        'host'=>$namserver->secondary_name_server5,
                        'ip4'=>$namserver->secondary_name_server5_ip,
                        'ip6'=>$namserver->secondary_name_server5_ip6,
                    ];
                    array_push($savedns,$namserver->secondary_name_server5);
                }
                $epp=new EPP();
                $user = User::find($user_id);
                $respone=$epp->domainInfo($user->domainName);
                $xml = new \SimpleXMLElement($respone);
                $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                $xmlElement = new \SimpleXMLElement($respone);
                $xmlElement->registerXPathNamespace('secDNS', 'urn:ietf:params:xml:ns:secDNS-1.1');
                $dsDataArray = [];
                $dsDataElements = $xmlElement->xpath('//secDNS:dsData');
                if($dsDataElements!=null){
                    foreach ($dsDataElements as $dsDataElement) {
                        $dsDataArray[] = [
                            'keyTag' => (string) $dsDataElement->children('secDNS', true)->keyTag,
                            'alg' => (string) $dsDataElement->children('secDNS', true)->alg,
                            'digestType' => (string) $dsDataElement->children('secDNS', true)->digestType,
                            'digest' => (string) $dsDataElement->children('secDNS', true)->digest
                        ];
                    }
                    $res=$epp->domainremDNSSEC($user->domainName,$dsDataArray);
                }
                $nameservers = $xml->xpath('//domain:hostObj');
                $remNSD = array();
                foreach ($nameservers as $nameserver) {
                    $remNSD[] = (string) $nameserver;
                }
                $remNS = array_diff($remNSD, $savedns);
                $saveNS = array_diff($savedns, $remNSD);
                $res=$epp->domainupdateNameServer($user->domainName,$paramscreate,$saveNS,$remNS);
                $dsdtaas=DB::table('dns_security-extension')->where('user_dns_server_id',$namserver->id)->get();
                $addDsData=[];
                if($dsdtaas!=null){
                    foreach ($dsdtaas as $name) {
                        if($name->key_tag!=null || $name->key_tag!=''){
                            $addDsData[] = [
                                'keyTag' => $name->key_tag,
                                'alg' => $name->algorithm,
                                'digestType' => $name->digest_type=='SHA1'?"1":'',
                                'digest' => $name->digest,
                            ];
                        }
                    }
                }
                $res=$epp->domainupdateDNSSEC($user->domainName,$addDsData);
            }
            $type = 2;
            $user = User::find($user_id);
            $user->updated_at = date('Y-m-d H:i:s');
            $user->save();
            return response()->json(array('status'=>'success', 'server_type'=> $type, 'message' => 'updated successfully.'));
        }catch (Throwable $e) {
            return response()->json(array('status'=>false, 'server_type'=> $type, 'message'=>$e->getMessage()));
        }
    }
    
    
    public function AdminUsersViewDoc(Request $request)
    {
        $id=$request->id;
        $data['title'] = 'Users Details';
        $data['user_contact_details'] = DB::table('user_contact_details')->where('user_id','=',$id)->first();
        $data['user_name_server'] = DB::table('user_name_servers')->where('user_id','=',$id)->first();
        $data['user_documents'] = DB::table('user_documents')->where('user_id','=',$id)->get();
        $userdocuments = DB::table('user_documents')->select('user_documents.*','document_category.title')->where('user_id',$id)->join('document_category','document_category.id','user_documents.document_category_id')->get();
        $data['userdocuments'] = $userdocuments;
        $is_approved = 1;
        foreach ($userdocuments as $doc){
            if ($doc->status == 1 || $doc->status == 0){
                $is_approved = 0;
                break;
            }else{
                $is_approved = 2;
            }
        }
        $data['is_approved'] = $is_approved;
        
        if($data){
            return response()->json(['status' => 'success', 'user_details' => $data], 200);
        }else{
            return response()->json(['status' => 'success', 'user_details' => []], 200);
        }
    }
    
    
    
    public function AdminUpdateDoc(Request $request)
	{
		try
		{
			if($request->isMethod('post'))
			{
                 $params = $request->all();
                 $is_rejected = true;
                 $user_info = '';
                $DocRemark = [];
                foreach($request->id as $key=> $docid){
                    
                    $doc = DB::table('user_documents')->where('id','=',$docid)->first();
                    $user_info = User::find($doc->user_id);

                   $params=[
                     'status'=>$request->status[$key],
                     'remarks'=>$request->remarks[$key],
                   ];
                    if ($request->status[$key] == 0){
                        if ($request->remarks[$key] == ''){
                            return response()->json(array('status'=>false, 'message' => 'remark mandatory for rejected document'));
                        }
                        $is_rejected = false;
                        $docdata = DB::table('user_documents')->where('id',$docid)->first();
                        $DocRemark[] = DB::table('document_category')->where('id',$docdata->document_category_id)->first()->title .' : '.$request->remarks[$key];
                    }
                    
                    $update=DB::table('user_documents')->where('id',$docid)->update($params);
                    $status=true;
                }
				if($status)
				{
			        if ($user_info->email != null){
                        if ($is_rejected){
                            $statusD=$user_info->domainStatus==10?"10":"5";
                            $updated_date = date('Y-m-d H:i:s');
                            $user = User::find($user_info->id);
                            $user->domainStatus = $statusD;
                            $user->updated_at = $updated_date;
                            $user->save();

                            $titlefromadmin=getmisc();
                            $data['content'] = $titlefromadmin->email_approved;
                            $data['title'] = 'The Application for domain ('.$user_info->domainName .') of ERNET is Approved ';
                            $data['email'] = $user_info->email;
                            $data['name'] = $user_info->name;

                            $sent=Mail::send('front.email.user-document-approved', $data, function($message)use($data) {
                                $message->to($data["email"], $data["name"])
                                    ->subject($data["title"]);
                            });
                            
                        }else{
                            $data = [];

                            $statusD=$user_info->domainStatus==10?"10":"4";
                            $updated_date = date('Y-m-d H:i:s');
                            $user = User::find($user_info->id);
                            $user->domainStatus = $statusD;
                            $user->clarify = 1;
                            $user->updated_at = $updated_date;
                            $user->save();

                            $titlefromadmin=getmisc();
                            $data['content'] = $titlefromadmin->email_clarification;
                            $data['title'] = 'Clarification Required in ERNET Application for Domain ('.$user_info->domainName .') Registration';
                            $data['email'] = $user_info->email;
                            $data['name'] = $user_info->name;
                            $data['docs'] = $DocRemark;
                            $sent=Mail::send('front.email.user-document-rejected', $data, function($message)use($data) {
                                $message->to($data["email"], $data["name"])
                                    ->subject($data["title"]);
                            });
                            
                        }
                    }
					return response()->json(array('status'=>'success','id'=>$docid, 'message' => 'updated successfully.'));
				}
				return response()->json(array('status'=>'error', 'error' => 'Something Wrong'));
			}
			return redirect('home')->with('error', 'Not valid');
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','error'=>$error));
		}
	}
}
