<?php

namespace App\Http\Controllers\Billdesk;

use App\Http\Controllers\Controller as BaseController;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use App\Library\EPP;
use App\Models\Zone;
use App\Services\Formatters\BINDFormatter;
use Illuminate\Support\Facades\Storage;
use phpseclib3\Net\SFTP;
use Throwable;
use Illuminate\Http\Request;
use Firebase\JWT\JWT;
use Config;
use \Firebase\JWT\Key;

class CustomController extends BaseController
{
    /**
     * @param Request $request
     *
     * @return Response
     */

     const BASEDIR = 'probind';

     const CONFIG_BASEDIR = self::BASEDIR.DIRECTORY_SEPARATOR.'configuration';
 
     const ZONE_BASEDIR = self::BASEDIR.DIRECTORY_SEPARATOR.'primary';
 
    public function billdeskresponse(Request $request)
    {

        $secretKey = Config::get('custom-billdesk.secretkey');

        $response = $request->transaction_response;
        $result=$response;

        try{

            $decodedresponse = JWT::decode($result, new Key($secretKey, 'HS256'));
      
        if ($decodedresponse->auth_status=='0300'){

            $trans=DB::table('transactions')->where('reference_id',$decodedresponse->orderid)->where('transaction_status','0002')->first();
            
            if($trans==null){

                Session::flash('message', 'The Payment not completed');
                Session::flash('alert-class', 'alert-success');
                return redirect('user-dashboard');

            }

            $payment_type = $trans->transaction_type;
            $user_id=$trans->user_id;

            $status=DB::table('transactions')->where('reference_id','=',$decodedresponse->orderid)->update(
                [
                    'transaction_status'=>'0300',
                    'transaction_id'=>$decodedresponse->transactionid,
                    'response'=>json_encode($decodedresponse)
                ]
            );

            if($status){

                if ($payment_type == 'domainRegister'){
                    $updated_date = date('Y-m-d H:i:s');
                    $user = User::find($user_id);
                    $user->domainStatus = 3;
                    $user->updated_at = $updated_date;
                    $user->save();
    
                    if($trans->dns!='' && $trans->dns!=null){

                        $nameserver=json_decode($trans->dns,true);
    
                        DB::table('user_name_servers')
                            ->updateOrInsert(
                            ['user_id' => $user_id],
                            $nameserver
                        );

                    }
                   
    
                    if(Session::get('dnsse_data')!=null){
    
                        $dns_id = DB::table('user_name_servers')->where('user_id','=', $user_id)->first()->id;
                        DB::table('dns_security-extension')->where('user_dns_server_id','=',$dns_id)->delete();
                        
                        foreach (Session::get('dnsse_data') as $dnssec){
                            $dnssec['user_dns_server_id'] = $dns_id;
                            DB::table('dns_security-extension')->insert($dnssec);
                        }
    
                    }
                    
                    Session::flash('message', 'The Payment is Successfully done.');
                    Session::flash('alert-class', 'alert-success');
                    Session::forget('payment_type');
                    return redirect('upload-documents');

                }elseif ($payment_type == 'domainRegisterWithNameServer'){
                    
                    $nameserver=json_decode($trans->dns);
                    
                    DB::table('user_name_servers')
                        ->updateOrInsert(
                            ['user_id' => $user_id],
                            [
                                  "user_id" => $user_id,
                                  "server_type" => $nameserver->server_type??1,
                                  "primary_name_server" => $nameserver->primary_name_server??'',
                                  "secondary_name_server1" => $nameserver->secondary_name_server1??'',
                                  "secondary_name_server2" => $nameserver->secondary_name_server2??'',
                                  "secondary_name_server3" => $nameserver->secondary_name_server3??'',
                                  "secondary_name_server4" => $nameserver->secondary_name_server4??'',
                                  "secondary_name_server5" => $nameserver->secondary_name_server5??'',
                                  "ernet_name_server_duration_year" => $nameserver->ernet_name_server_duration_year??1,
                            ]
    
                        );
        
                    $updated_date = date('Y-m-d H:i:s');
                    $user = User::find($user_id);
                    $user->domainStatus = 3;
                    $user->updated_at = $updated_date;
                    $user->save();
    
                    Session::forget('data');
                    Session::flash('message', 'The Payment is Successfully done.');
                    Session::flash('alert-class', 'alert-success');
                    return redirect('user-dashboard');
                }elseif ($payment_type == 'nameServerUpdate'){
                    $nameserver1=json_decode($trans->dns);
                    
                    DB::table('user_name_servers')
                        ->updateOrInsert(
                            ['user_id' => $user_id],
                            [
                                  "user_id" => $user_id,
                                  "server_type" => $nameserver1->server_type??1,
                                  "primary_name_server" => $nameserver1->primary_name_server??'',
                                  "secondary_name_server1" => $nameserver1->secondary_name_server1??'',
                                  "secondary_name_server2" => $nameserver1->secondary_name_server2??'',
                                  "secondary_name_server3" => $nameserver1->secondary_name_server3??'',
                                  "secondary_name_server4" => $nameserver1->secondary_name_server4??'',
                                  "secondary_name_server5" => $nameserver1->secondary_name_server5??'',
                                  "ernet_name_server_duration_year" => $nameserver1->ernet_name_server_duration_year??1,
                            ]
                        );
    
                        $namserver=DB::table('user_name_servers')->where('user_id',$user_id)->first();
    
                        if($namserver!=null){
                            
                        $savedns=[
                            $namserver->primary_name_server,
                            $namserver->secondary_name_server1,
                        ];
                    
                        $paramscreate=[
                            'ns1'=>[
                                'host'=>$namserver->primary_name_server,
                                'ip4'=>$namserver->primary_name_server_ip,
                                'ip6'=>$namserver->primary_name_server_ip6,
                            ],
                            'ns2'=>[
                                'host'=>$namserver->secondary_name_server1,
                                'ip4'=>$namserver->secondary_name_server1_ip,
                                'ip6'=>$namserver->secondary_name_server1_ip6,
                            ],
                        ];
                    
                        if($namserver->secondary_name_server2!=null){
                            $paramscreate['ns3']=[
                                'host'=>$namserver->secondary_name_server2,
                                'ip4'=>$namserver->secondary_name_server2_ip,
                                'ip6'=>$namserver->secondary_name_server2_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server2);
                        }
                    
                        if($namserver->secondary_name_server3!=null){
                            $paramscreate['ns4']=[
                                'host'=>$namserver->secondary_name_server3,
                                'ip4'=>$namserver->secondary_name_server3_ip,
                                'ip6'=>$namserver->secondary_name_server3_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server3);
                        }
                    
                        if($namserver->secondary_name_server4!=null){
                            $paramscreate['ns5']=[
                                'host'=>$namserver->secondary_name_server4,
                                'ip4'=>$namserver->secondary_name_server4_ip,
                                'ip6'=>$namserver->secondary_name_server4_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server4);
                        }
                    
                        if($namserver->secondary_name_server5!=null){
                            $paramscreate['ns6']=[
                                'host'=>$namserver->secondary_name_server5,
                                'ip4'=>$namserver->secondary_name_server5_ip,
                                'ip6'=>$namserver->secondary_name_server5_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server5);
                        }
    
                        // $user = Auth::user();
    
                        // if($user->domainStatus>5){
                    
                        $epp=new EPP();
                    
                        $user = DB::table('users')->where('id',$user_id)->first();
                    
                        $respone=$epp->domainInfo($user->domainName);
                    
                        $xml = new \SimpleXMLElement($respone);
                    
                        $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                    
                        $nameservers = $xml->xpath('//domain:hostObj');
                    
                        $remNSD = array();
                        foreach ($nameservers as $nameserver) {
                         $remNSD[] = (string) $nameserver;
                        }
                        $res=$epp->domainupdateNameServerLatest($user->domainName,$paramscreate,$savedns,$remNSD);

    
                        $updated_date = date('Y-m-d H:i:s');
    
                        $status = DB::table('zones')
                        ->updateOrInsert(
                            ['user_id' => $user_id],
                            [
                                'server'=>$namserver->primary_name_server,
                                'user_id' => $user_id,
                                'domain'=>$user->domainPunycode,
                                'reverse_zone'=>1,
                                'custom_settings'=>0,
                                'refresh'=>0,
                                'retry'=>7200,
                                'expire'=>3628800,
                                'negative_ttl'=>0,
                                'default_ttl'=>345640,
                                'updated_at'=>$updated_date
                            ]
                        );
    
                        $zone=Zone::where('domain',$user->domainPunycode)->first();
           
    
                    }
                    Session::forget('data');
                    Session::flash('message', 'The Payment is Successfully done.');
                    Session::flash('alert-class', 'alert-success');
                    return redirect('user-dashboard');
                }elseif ($payment_type == 'userNameServerUpdate'){
                    
                    if($trans->dns!='' && $trans->dns!=null){

                        $nameserver=json_decode($trans->dns,true);
    
                        DB::table('user_name_servers')
                            ->updateOrInsert(
                            ['user_id' => $user_id],
                            $nameserver
                        );

                    }

                    $dns_record = DB::table('user_name_servers')->where('user_id','=', $user_id)->first();
    
                    $dns_id = $dns_record->id;
    
                    DB::table('dns_security-extension')->where('user_dns_server_id','=',$dns_id)->delete();
                    
                    if($trans->dnssec!='' && $trans->dnssec!=null && $trans->dnssec!='no' ){

                        $dnsexts=json_decode($trans->dnssec_data,true);

                        foreach ($dnsexts as $dnssec){
                            $dnssec['user_dns_server_id'] = $dns_id;
                            DB::table('dns_security-extension')->insert($dnssec);
                        }
    
                    }
    
                    $namserver=DB::table('user_name_servers')->where('user_id',$user_id)->first();
    
                    $savedns=[
                        $namserver->primary_name_server,
                        $namserver->secondary_name_server1,
                    ];
                
                    $paramscreate=[
                        'ns1'=>[
                            'host'=>$namserver->primary_name_server,
                            'ip4'=>$namserver->primary_name_server_ip,
                            'ip6'=>$namserver->primary_name_server_ip6,
                        ],
                        'ns2'=>[
                            'host'=>$namserver->secondary_name_server1,
                            'ip4'=>$namserver->secondary_name_server1_ip,
                            'ip6'=>$namserver->secondary_name_server1_ip6,
                        ],
                    ];
                
                    if($namserver->secondary_name_server2!=null){
                        $paramscreate['ns3']=[
                            'host'=>$namserver->secondary_name_server2,
                            'ip4'=>$namserver->secondary_name_server2_ip,
                            'ip6'=>$namserver->secondary_name_server2_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server2);
                    }
                
                    if($namserver->secondary_name_server3!=null){
                        $paramscreate['ns4']=[
                            'host'=>$namserver->secondary_name_server3,
                            'ip4'=>$namserver->secondary_name_server3_ip,
                            'ip6'=>$namserver->secondary_name_server3_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server3);
                    }
                
                    if($namserver->secondary_name_server4!=null){
                        $paramscreate['ns5']=[
                            'host'=>$namserver->secondary_name_server4,
                            'ip4'=>$namserver->secondary_name_server4_ip,
                            'ip6'=>$namserver->secondary_name_server4_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server4);
                    }
                
                    if($namserver->secondary_name_server5!=null){
                        $paramscreate['ns6']=[
                            'host'=>$namserver->secondary_name_server5,
                            'ip4'=>$namserver->secondary_name_server5_ip,
                            'ip6'=>$namserver->secondary_name_server5_ip6,
                        ];
                        array_push($savedns,$namserver->secondary_name_server5);
                    }
                
                    $epp=new EPP();
                
                    $user = DB::table('users')->where('id',$user_id)->first();
                
                    $respone=$epp->domainInfo($user->domainName);
                
                    $xml = new \SimpleXMLElement($respone);
    
                    $xmlElement = new \SimpleXMLElement($respone);
                    $xmlElement->registerXPathNamespace('secDNS', 'urn:ietf:params:xml:ns:secDNS-1.1');
                
                    $dsDataArray = [];
                    $dsDataElements = $xmlElement->xpath('//secDNS:dsData');
                
                    if($dsDataElements!=null){
                        foreach ($dsDataElements as $dsDataElement) {
                            $dsDataArray[] = [
                                'keyTag' => (string) $dsDataElement->children('secDNS', true)->keyTag,
                                'alg' => (string) $dsDataElement->children('secDNS', true)->alg,
                                'digestType' => (string) $dsDataElement->children('secDNS', true)->digestType,
                                'digest' => (string) $dsDataElement->children('secDNS', true)->digest
                            ];
                        }
                        $res=$epp->domainremDNSSEC($user->domainName,$dsDataArray);
                    }
                
                    $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                
                    $nameservers = $xml->xpath('//domain:hostObj');
                
                    $remNSD = array();
                    foreach ($nameservers as $nameserver) {
                     $remNSD[] = (string) $nameserver;
                    }
                
                    
                    $res=$epp->domainupdateNameServerLatest($user->domainName,$paramscreate,$savedns,$remNSD);
                    
                    $dsdtaas=DB::table('dns_security-extension')->where('user_dns_server_id',$namserver->id)->get();
    
                    $addDsData=[];
    
                    foreach ($dsdtaas as $name) {
                        if($name->key_tag!=null || $name->key_tag!=''){
                        $addDsData[] = [
                            'keyTag' => $name->key_tag,
                            'alg' => $name->algorithm,
                            'digestType' => $name->digest_type,
                            'digest' => $name->digest,
                        ];
                        }
                    }
    
                    $res=$epp->domainupdateDNSSEC($user->domainName,$addDsData);
    
                 
                    if($dns_record->server_type==2){
    
                        $zone=Zone::where('domain',$user->domainPunycode)->first();
           
                        if($zone!=null){
                            $this->deletezone($zone);
                        }
    
                    }
    
                    Session::forget('data');
                    Session::forget('dnsse_data');
                    Session::flash('message', 'The Payment is Successfully done.');
                    Session::flash('alert-class', 'alert-success');
                    return redirect('user-application-preview');
                }elseif ($payment_type == 'domainRenewal'){
                    $updated_date = date('Y-m-d H:i:s');
                    $user = User::find($user_id);

                    $domainPrice = $trans->total_amount;
                    $user->domainPrice = $domainPrice;
                    $user->domainStatus = 10;

                    if($user->renew_years==1){
                        $user->renew_years = $trans->period-1;
                    }else if($user->renew_years==2){
                        $user->renew_years = $trans->period-2;   
                    }else{
                        $user->renew_years = $trans->period;
                    }

                    $user->updated_at = $updated_date;
                    $user->save();
       
                    $user2 = User::find($user_id);

                    $epp=new EPP();
            
                    $expiryDate = Carbon::parse($user2->domainExpiryDate);
                    $currentDate = Carbon::now();
            
                    if ($currentDate->diffInDays($expiryDate) >= 40) {
                    
                        $futureDate = $expiryDate->addDays(40);
                    
                        $orderDate = $futureDate->format('Y-m-d\TH:i:s\.0\Z');
                    
                        $currentDateTime = Carbon::now('Asia/Kolkata');
                    
                        $outputDateTime = $currentDateTime->format('Y-m-d\TH:i:s\.0\Z');
                    
                        $epp->domainRestoreRequest($user2->domainName);
                    
                        $epp->domainRestoreReport($user2->domainName,$orderDate,$outputDateTime);
                    
                    }
                    
                    $activity=['user_id'=>$user2->id,'user_type'=>1,'user_name'=>$user2->name,'domainName'=>$user2->domainName,'status'=>'Renewal Application Submitted','ip_address'=>$request->ip()];
                    handleActivity($activity); 

                    Session::flash('message', 'The Payment is Successfully done.');
                    Session::flash('alert-class', 'alert-success');
                    return redirect('user-dashboard');
                }elseif ($payment_type == 'ewaas'){
                    Session::flash('message', 'The Payment is Successfully done.');
                    Session::flash('alert-class', 'alert-success');
                    return redirect('projects');
                }elseif ($payment_type == 'elmaas'){
                    Session::flash('message', 'The Payment is Successfully done.');
                    Session::flash('alert-class', 'alert-success');
                    return redirect('projects');
                }else{

                    Session::flash('message','Payment Not Completed due to payment type');
                    Session::flash('alert-class', 'alert-danger');
                    return redirect('user-dashboard');

                }

            }else{

                
                Session::flash('message','Payment Not Completed due to trans invalid');
                Session::flash('alert-class', 'alert-danger');
                return redirect('user-dashboard');

            }
           
        }else{
            Session::flash('message','Payment Not Completed due to unsuccess');
            Session::flash('alert-class', 'alert-danger');
            return redirect('user-dashboard');
        }

        }catch(\Throwable $e){

            Log::info($e);
            Session::flash('message','Payment Not Completed due to response invalid');
            Session::flash('alert-class', 'alert-danger');
            return redirect('user-dashboard');

        }

      
    }

    /**
     * @param Request $request
     *
     * @return string
     */
    public function webhook(Request $request)
    {
        $response = $request->handle();
        Log::info('Webhook Calling');
        Log::info($response);          
        return 'OK';
    }


    private function deletezone(Zone $zone){

        try {        

            $destinationFileName = $zone->domain;

           

            $destinationFileName1 = $zone->domain;

            $destinationServer1 = '202.141.18.85';
            $destinationUsername1 = 'ernet';
            $destinationPassword1 = '3rn3t@2023';
            $destinationFolder1 = '/var/zones/primary';

            $sftp1 = new SFTP($destinationServer1);

            if (!$sftp1->login($destinationUsername1, $destinationPassword1)) {
                throw new \Exception('SFTP login failed');
            }

            if (!$sftp1->chdir($destinationFolder1)) {
                throw new \Exception('Failed to change directory on the destination server');
            }

            if ($sftp1->file_exists($destinationFileName1)) {
                if (!$sftp1->delete($destinationFileName1)) {
                    throw new \Exception('Failed to delete the existing file on the destination server');
                }
            }


            $sftp1->disconnect();

            $destinationServer = '202.141.18.87';
            $destinationUsername = 'ernet';
            $destinationPassword = '3rn3t@2023';
            $destinationFolder = '/var/zones/primary';

            $sftp = new SFTP($destinationServer);

            if (!$sftp->login($destinationUsername, $destinationPassword)) {
                throw new \Exception('SFTP login failed');
            }

            if (!$sftp->chdir($destinationFolder)) {
                throw new \Exception('Failed to change directory on the destination server');
            }

            if ($sftp->file_exists($destinationFileName)) {
                if (!$sftp->delete($destinationFileName)) {
                    throw new \Exception('Failed to delete the existing file on the destination server');
                }
            }

            $sftp->disconnect();
            
        } catch (\Exception $e) {
            
        }

    }

    private function createzone(Zone $zone){
        $zone->increaseSerialNumber();
        $content = BINDFormatter::getZoneFileContent($zone);
        $path = self::ZONE_BASEDIR.DIRECTORY_SEPARATOR.$zone->domain;
        Storage::append($path, $content);

        try {        

          
            $destinationFileName = $zone->domain;

           

            $destinationFileName1 = $zone->domain;

            $destinationServer1 = '49.50.97.172';
            $destinationUsername1 = 'root';
            $destinationPassword1 = '54_n5dTe!V2';
            $destinationFolder1 = '/var/zones/primary';

            $sftp1 = new SFTP($destinationServer1,'2232');

            if (!$sftp1->login($destinationUsername1, $destinationPassword1)) {
                throw new \Exception('SFTP login failed');
            }

            if (!$sftp1->chdir($destinationFolder1)) {
                throw new \Exception('Failed to change directory on the destination server');
            }

            if ($sftp1->file_exists($destinationFileName1)) {
                if (!$sftp1->delete($destinationFileName1)) {
                    throw new \Exception('Failed to delete the existing file on the destination server');
                }
            }

            if (!$sftp1->put($destinationFileName1, $content)) {

            $sftp1->disconnect();

            $destinationServer = '49.50.97.169';
            $destinationUsername = 'root';
            $destinationPassword = 'y1BA8=W5@eK';
            $destinationFolder = '/var/zones/primary';

            $sftp = new SFTP($destinationServer,'2232');

            if (!$sftp->login($destinationUsername, $destinationPassword)) {
                throw new \Exception('SFTP login failed');
            }

            if (!$sftp->chdir($destinationFolder)) {
                throw new \Exception('Failed to change directory on the destination server');
            }

            if ($sftp->file_exists($destinationFileName)) {
                if (!$sftp->delete($destinationFileName)) {
                    throw new \Exception('Failed to delete the existing file on the destination server');
                }
            }

            if (!$sftp->put($destinationFileName, $content)) {
                throw new \Exception('Failed to transfer the file to the destination server');
            }

            $sftp->disconnect();

            }


            $sftp1->disconnect();

        } catch (\Exception $e) {
        }
    }

}
