<?php

namespace App\Http\Controllers;

use App\Mail\UserDomainEnquiryMail;
use App\Models\Domain;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Crypt;
use mysql_xdevapi\Collection;
use Validator;
use Session;
use Dedicated\GoogleTranslate\Translator;
use App\Library\EPP;
use App\Models\Zone;
use App\Services\Formatters\BINDFormatter;
use Illuminate\Support\Facades\Storage;
use Carbon\Carbon;
use App\Components\MailManager;


class DomainController extends Controller
{

    const BASEDIR = 'probind';

    const CONFIG_BASEDIR = self::BASEDIR.DIRECTORY_SEPARATOR.'configuration';

    const ZONE_BASEDIR = self::BASEDIR.DIRECTORY_SEPARATOR.'primary';

    
    public function getExtensionByLang(Request $request)
    {
        $exts = DB::table('domain_extensions')->where('domain_language_id',$request->input('lang_id'))->where('status','Active')->get();
        return ['status'=>true, 'data'=> $exts];
    }

    public function checkzone($domain){

        $domainName=$domain;
        $zone=Zone::where('domain',$domainName.'.')->first();
       
        $this->createzone($zone);
      
        dd('created');

    }

    private function createzone(Zone $zone){

        $zone->increaseSerialNumber();
        $content = BINDFormatter::getZoneFileContent($zone);
        $path = self::ZONE_BASEDIR.DIRECTORY_SEPARATOR.$zone->domain;
        Storage::append($path, $content);

    }

    public function checkDomainAvailability(Request $request)
    {
       
        $rules = [
            "extension" => 'required', 
        ];
        
        if ($request->lang == 2) {
            $rules['domainName'] = 'required|min:3|regex:/^[a-zA-Z0-9\s-]+$/';
        } else {
            $rules['domainName'] = ['required', 'min:3', 'regex:/^[\p{Devanagari}\s]+$/u'];
        }
        
        $validator = Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            Session::flash('message',$validator->errors()->first());
            return back();
        }

        $domainNames=trim($request->input('domainName'));
        $domainName = trim($request->input('domainName'));

        $domains = [];
        foreach ($request->input('extension') as $ext){
            $extension = DB::table('domain_extensions')->where('id','=', $ext)->first();

            $langs=  $request->input('lang')==2?1:2;

            $prices = DB::table('domain_extension_prices')->where('domain_extension_id',$langs)->orderBy('year','asc')->get();

            $ext_lang = DB::table('domain_languages')->where('id','=', $extension->domain_language_id)->first();
            if (strtolower($ext_lang->language_name) == 'english'){
                $domains['domainName'] = $domainName.'.'.$extension->domain_extension;
                $domains['domainPunycode'] = '' ;
            }else{
                $lang_id =  $request->input('lang');
                // $lang_data = DB::table('domain_languages')->where('id','=',$lang_id)->first();
                // $translator = new Translator();
                
                // $hindicount=DB::table('misc_settings')->increment('hindi_search');

                // $result = $translator->setSourceLang('en')
                //     ->setTargetLang($lang_data->lang_code)
                //     ->translate($domainName);
                $domainNames=$domainName;
                $domains['domainName'] = $domainName.'.'.$extension->domain_extension;
                $domains['domainPunycode'] = idn_to_ascii($domainName.'.'.$extension->domain_extension) ;
            }

            $domains['domainLangID'] = $ext_lang->id;
            $domains['domainExtensionID'] = $ext;
            $domains['domainPrice'] = $prices;
 
            $epp=new EPP();
            $dname=$domainNames.'.'.$extension->domain_extension;
            $res=$epp->checkDomainAvailability($dname);

            $dom = new \DOMDocument();
            $dom->loadXML($res);

            $availability = $dom->getElementsByTagNameNS('urn:ietf:params:xml:ns:domain-1.0', 'cd')->item(0)->getElementsByTagName('name')->item(0)->getAttribute('avail');
            
           #$availability=1;
            if (DB::table('users')->where('domainName','=',$domainNames.'.'.$extension->domain_extension)->count() == 0 && $availability == '1'){
                $domains['domainAvailability'] = true;
            }elseif($availability==1){
                $domains['domainAvailability'] = false;
                $record=DB::table('users')->where('domainName','=',$domainNames.'.'.$extension->domain_extension)->first();
                 
                if($record->domainStatus==0){

                $now = now(); 
                $minut = $now->diffInMinutes($record->created_at);

                $hours=480-$minut;
                $times=Carbon::now()->addMinute($hours);

                $formattime=date('h:i a',strtotime($times));
                $format=date('d/m/Y',strtotime($times));

                $domains['domainMessage'] = "This domain is temporarily reserved upto $formattime on $format."; 

                }

                
            }else{
                $domains['domainAvailability'] = false;
            }
            $data[] = $domains;
        }
        return view('front.apply-domain-result',compact('data'));

    }

    public function translateDomainName(Request $request)
    {
        $txt =  $request->input('domainName');
        $lang_id =  $request->input('domainLang');
        $lang_data = DB::table('domain_languages')->where('id','=',$lang_id)->first();
        $translator = new Translator();
        $result = $translator->setSourceLang('en')
            ->setTargetLang($lang_data->lang_code)
            ->translate($txt);
        return ['status'=>true , 'data'=>$result];

    }

    public function applyDomainAgreement(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "domain" => 'required',
            "domainDuration" => 'required',
            "domainLangID" => 'required',
            "domainExtensionID" => 'required',
        ]);
        if ($validator->fails()) {
            Session::flash('error',$validator->errors());
            return back();
        }
        $appliedDomain = $request->input('domain');
        $domainLangID = $request->input('domainLangID');
        $domainExtensionID = $request->input('domainExtensionID');
        $price = DB::table('domain_extension_prices')->where('id','=',$request->input('domainDuration'))->first();
        Session::put('domainName', $appliedDomain);
        Session::put('domainLangID', $domainLangID);
        Session::put('domainExtensionID', $domainExtensionID);
        Session::put('domainPeriod', $price->year);
        Session::put('domainPrice', $price->price);
        return view('front.apply-domain-agreement',compact('appliedDomain'));
    }

    public function userDomainEnquiry(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "contact_name" => 'required',
            "email" => 'required|email',
            "institute" => 'required',
            "designation" => 'required',
            "domainName" => 'required|unique:users',
        ]);
        if ($validator->fails()) {
            return response()->json(['status'=>false,'error'=>$validator->errors()->first()]);
        }

        if (Session::has('domainPrice')){

            $data = [
                "name" => $request->input('contact_name'),
                "father_name" => $request->input('father_name'),
                "age" => $request->input('age'),
                "board" => $request->input('board'),
                "domainName" => $request->input('domainName'),
                "domainPunycode" => idn_to_ascii($request->input('domainName')),
                "domainLangID" => Session::get('domainLangID'),
                "domainExtensionID" => Session::get('domainExtensionID'),
                "domainPeriod" => Session::get('domainPeriod'),
                "domainPrice" =>Session::get('domainPrice'),
                "email" => $request->input('email'),
                "institute" => $request->input('institute'),
                "designation" => $request->input('designation'),
                'affilation_no'=>$request->input('affilation_no'),
                "status" => 1,
            ];
    
    
            $user = User::create($data);
    
      
            $titlefromadmin=getmisc();
            $data['email'] = $request->input('email');
            $data['name'] = $request->input('contact_name');
            $data['subject'] = 'Domain User Email Verification with domain '.$request->input('domainName');
            $data['content'] = $titlefromadmin->email_nameserver;
            $user->emailVerificationLink = URL::to('user-email-verification/'.base64_encode($user->id));
            $data['emailVerificationLink']=URL::to('user-email-verification/'.base64_encode($user->id));
    
            Session::forget('domainPeriod');
            Session::forget('domainPrice');
            Session::forget('domainLangID');
            Session::forget('domainExtensionID');
    
    
            $view = 'front.email.user-domain-enquiry';

            $mailer = MailManager::getInstance();

            $status=$mailer->mailSender($view, $data);

           

        }
      
        return ['status'=> 'success'];
       
      
    }


    public function checkemailexits(Request $request)
    {
        $email = $request->email;
        $domain='';

        $matches = [];
        if (preg_match('/@(.+)$/', $email, $matches)) {
            $domain=$matches[1];
        }

        $records = dns_get_record($domain, DNS_MX);
    
        if(!empty($records)) {
            echo json_encode(['exists' => true]);
        } else {
            echo json_encode(['exists' => false]);
        }
    
    }

    public function domainAvailability(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "search" => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json(['status'=>'errors','error'=>$validator->errors()]);
        }
        $search  = $request->input('search');
        $data = [];
        if ($search == null){
            return $data;
        }
        $exts = DB::table('domain_extensions')->get();

        foreach ($exts as $ext){
            if (User::where('domain','=',$search.'.'.$ext->extension)->count() == 0){
                $data[] = $search.'.'.$ext->extension;
            }
        }
        return $data;
    }

    public function tariff(Request $request){
        $accharges=DB::table('domain_extension_prices')->select('domain_extension_prices.*')->where('domain_extension_prices.domain_extension_id',1)->orderBy('domain_extension_prices.year')->get();
        $acchargs=DB::table('domain_extension_prices')->select('domain_extension_prices.*')->where('domain_extension_prices.domain_extension_id',2)->orderBy('domain_extension_prices.year')->get();
        return view('front.tariff',['accharges'=>$accharges,'acchargs'=>$acchargs]);
    }

    public function tariff_dns(Request $request){
        $accharges=DB::table('ernet_name_servers_prices')->select('ernet_name_servers_prices.*')->orderBy('ernet_name_servers_prices.years')->get();
        return view('front.tariff_dns',['accharges'=>$accharges]);
    }

    public function tariff_vas(Request $request){
        $accharges=DB::table('ernet_name_servers_prices')->select('ernet_name_servers_prices.*')->orderBy('ernet_name_servers_prices.years')->get();
        return view('front.tariff_vas',['accharges'=>$accharges]);
    }
    

    public function tariff_register(Request $request){
        $accharges=DB::table('domain_extension_prices')->select('domain_extension_prices.*')->where('domain_extension_prices.domain_extension_id',1)->orderBy('domain_extension_prices.year')->get();
        $acchargs=DB::table('domain_extension_prices')->select('domain_extension_prices.*')->where('domain_extension_prices.domain_extension_id',2)->orderBy('domain_extension_prices.year')->get();
        return view('front.tariff_register',['accharges'=>$accharges,'acchargs'=>$acchargs]);
    }

    public function tariff_renewal(Request $request){
        $accharges=DB::table('domain_extension_prices')->select('domain_extension_prices.*')->where('domain_extension_prices.domain_extension_id',1)->where('domain_extension_prices.year','<',10)->orderBy('domain_extension_prices.year')->get();
        $acchargs=DB::table('domain_extension_prices')->select('domain_extension_prices.*')->where('domain_extension_prices.domain_extension_id',2)->where('domain_extension_prices.year','<',10)->orderBy('domain_extension_prices.year')->get();
        return view('front.tariff_renewal',['accharges'=>$accharges,'acchargs'=>$acchargs]);
    }
}
