<?php
namespace App\Http\Controllers;
use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Auth, Redirect;
use App\Models\LoginHistory;
use Illuminate\Http\Request;
use App\Models\User;
use Carbon\Carbon;
use App\Models\LoginHistoryAdmin;
class LoginHistoryReportController extends Controller
{
	public function index() 
	{
		return view('loginreport/index');
	}
	
	public function ajaxcall(Request $request)
	{
		 $draw = $request->get('draw');
		 $start = $request->get("start");
		 $rowperpage = $request->get("length");
		 $columnIndex_arr = $request->get('order');
		 $columnName_arr = $request->get('columns');
		 $order_arr = $request->get('order');
		 $search_arr = $request->get('search');
		 $columnIndex = $columnIndex_arr[0]['column']; // Column index
		 $columnName = $columnName_arr[$columnIndex]['data']; // Column name
		 $columnSortOrder = $order_arr[0]['dir']; // asc or desc
		 $searchValue = $search_arr['value']; // Search value
		 $countData = LoginHistoryAdmin::select('count(*) as allcount')
		 ->join('admins', 'admins.id', '=', 'admin_login.user_id') ;

		//  if($request->from != null && $request->to != null) {
		// 		$start_date = $request->from;
		// 		$end_date = $request->to;
		// 		$countData->whereDate('admin_login.created_at', '>=', $start_date);
		// 		$countData->whereDate('admin_login.created_at', '<=', $end_date);
		// }

		
		if($request->from != null) {
			$start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
	
			if ($request->from == $request->to) {
				$countData->whereDate('admin_login.created_at', '=', $start_date);
			}else{
				$countData->where('admin_login.created_at', '>=', $start_date);
			}
		}
		   
		if($request->to != null) {
			$end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
	
			if ($request->from == $request->to) {
				$end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
				$countData->whereDate('admin_login.created_at', '=', $end_date);
			}else{
				$countData->where('admin_login.created_at', '<=', $end_date);
			}
		}
			
		if($request->usersearch != null) {
			$countData->where('admin_login.user_id', $request->usersearch);
		}
		 
		if($searchValue != null) {
			$countData->where('admins.username', 'like', '%' .$searchValue . '%');
		}
		
		$totalRecordswithFilter = $countData->count();
		$totalRecords = $totalRecordswithFilter;
		 // Fetch records
		 $records = LoginHistoryAdmin::select('admin_login.*', 'admins.username')
		  ->join('admins', 'admins.id', '=', 'admin_login.user_id') 
		   ->skip($start)
		   ->orderBy('admin_login.id','desc')
		   ->take($rowperpage);


		//    if($request->from != null && $request->to != null) {
		// 		$start_date = $request->from;
		// 		$end_date = $request->to;
		// 		$records->whereDate('admin_login.created_at', '>=', $start_date);
		// 		$records->whereDate('admin_login.created_at', '<=', $end_date);
		// 	}

		
		if($request->from != null) {
			$start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
	
			if ($request->from == $request->to) {
				$records->whereDate('admin_login.created_at', '=', $start_date);
			}else{
				$records->where('admin_login.created_at', '>=', $start_date);
			}
		}
		   
		if($request->to != null) {
			$end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
	
			if ($request->from == $request->to) {
				$end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
				$records->whereDate('admin_login.created_at', '=', $end_date);
			}else{
				$records->where('admin_login.created_at', '<=', $end_date);
			}
		}


			if($request->usersearch != null) {
			$records->where('admin_login.user_id', $request->usersearch);
		}
			if($searchValue != null) {
				$records->where('admins.username', 'like', '%' .$searchValue . '%');
			}
			
		
		$list = $records->get();
		 $data_arr = array();
		 
		 foreach($list as $sno => $record){
			$id = $record->id;
			$check='';
			
			if($record->logout==1){
			    $check.=date('d-m-Y h:i:a', strtotime($record->logout_time));
			}
			
			$data_arr[] = array(
			  "id" => ++$start,
			  "user" => $record->username,
			  "login" =>date('d-m-Y h:i:a', strtotime($record->login_time)),
			  "logout" =>$check,
			  "duration_time" => $record->duration_time,
			  "total_duration_time" => $record->total_duration_time
			);
		 }
		 $response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordswithFilter,
			"aaData" => $data_arr
		 );
		 echo json_encode($response);
		 exit;
	}
	
	private function seconds2human($ss) {
		if($ss > 0) {
			
		
		$s = $ss%60;
		$m = floor(($ss%3600)/60);
		$h = floor(($ss%86400)/3600);
		$d = floor(($ss%2592000)/86400);
		$M = floor($ss/2592000);
		$time = '';
		if($M > 0)
		{
			return "$M months, $d days, $h hours, $m minutes, $s seconds";
		} 
		else if($d > 0)
		{
			return "$d days, $h hours, $m minutes, $s seconds";
		}
		else if($h > 0)
		{
			return "$h hours, $m minutes, $s seconds";
		}
		else if($m > 0)
		{
			return "$m minutes, $s seconds";
		}
		else if($s > 0)
		{
			return "$s seconds";
		}
		}
	}
	public function user_index() 
	{
		return view('loginreport/user');
	}
	
	public function user_ajaxcall(Request $request)
	{
		 $draw = $request->get('draw');
		 $start = $request->get("start");
		 $rowperpage = $request->get("length");
		 $columnIndex_arr = $request->get('order');
		 $columnName_arr = $request->get('columns');
		 $order_arr = $request->get('order');
		 $search_arr = $request->get('search');
		 $columnIndex = $columnIndex_arr[0]['column']; // Column index
		 $columnName = $columnName_arr[$columnIndex]['data']; // Column name
		 $columnSortOrder = $order_arr[0]['dir']; // asc or desc
		 $searchValue = $search_arr['value']; // Search value
		 $countData = LoginHistory::select('count(*) as allcount')
		 ->join('users', 'users.id', '=', 'login_history.user_id') ;
		//  if($request->from != null && $request->to != null) {
		// 		$start_date = $request->from;
		// 		$end_date = $request->to;
		// 		$countData->whereDate('login_history.created_at', '>=', $start_date);
		// 		$countData->whereDate('login_history.created_at', '<=', $end_date);
		// 	}


			if($request->from != null) {
				$start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
		
				if ($request->from == $request->to) {
					$countData->whereDate('login_history.created_at', '=', $start_date);
				}else{
					$countData->where('login_history.created_at', '>=', $start_date);
				}
			}
			   
			if($request->to != null) {
				$end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
		
				if ($request->from == $request->to) {
					$end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
					$countData->whereDate('login_history.created_at', '=', $end_date);
				}else{
					$countData->where('login_history.created_at', '<=', $end_date);
				}
			}
			
		if($request->usersearch != null) {
			$countData->where('login_history.user_id', $request->usersearch);
		}
		 
		if($searchValue != null) {
			$countData->where('users.domainName', 'like', '%' .$searchValue . '%');
		}
		
		$totalRecordswithFilter = $countData->count();
		$totalRecords = $totalRecordswithFilter;
		 // Fetch records
		 $records = LoginHistory::select('login_history.*', 'users.domainName')
		  ->join('users', 'users.id', '=', 'login_history.user_id') 
		   ->skip($start)
		   ->orderBy('login_history.id','desc')
		   ->take($rowperpage);


		//    if($request->from != null && $request->to != null) {
		// 		$start_date = $request->from;
		// 		$end_date = $request->to;
		// 		$records->whereDate('login_history.created_at', '>=', $start_date);
		// 		$records->whereDate('login_history.created_at', '<=', $end_date);
		// 	}

		if($request->from != null) {
			$start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
			if ($request->from == $request->to) {
				$records->whereDate('login_history.created_at', '=', $start_date);
			}else{
				$records->where('login_history.created_at', '>=', $start_date);
			}
		}
		   
		if($request->to != null) {
			$end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
			if ($request->from == $request->to) {
				$end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
				$records->whereDate('login_history.created_at', '=', $end_date);
			}else{
				$records->where('login_history.created_at', '<=', $end_date);
			}
		}

		if($request->usersearch != null) {
			$records->where('login_history.user_id', $request->usersearch);
		}
			if($searchValue != null) {
				$records->where('users.domainName', 'like', '%' .$searchValue . '%');
			}
			
		
		$list = $records->get();
		 $data_arr = array();
		 
		 foreach($list as $sno => $record){
			$id = $record->id;
			$check='';
			
			if($record->logout==1){
			    $check.=date('d-m-Y h:i:a', strtotime($record->logout_time));
			}
			
			$data_arr[] = array(
			  "id" => ++$start,
			  "user" => $record->domainName,
			  "login" =>date('d-m-Y h:i:a', strtotime($record->login_time)),
			  "logout" =>$check,
			  "duration_time" => $record->duration_time,
			  "total_duration_time" => $record->total_duration_time
			);
		 }
		 $response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordswithFilter,
			"aaData" => $data_arr
		 );
		 echo json_encode($response);
		 exit;
	}
}