<?php

namespace App\Http\Controllers;
use App\Mail\UserDomainEnquiryMail;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Auth, Redirect;
use App\Models\Domain;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Validator;
use Session,Hash;
use Carbon\Carbon;
use App\Library\EPP;
use Firebase\JWT\JWT;
use Config;
use \Firebase\JWT\Key;

class ReportController extends Controller
{

    public function changepassword(Request $request)
	{
		$rules = array(
            'newpassword' => ['required', 'min:8'],
            'conpassword'=>'required'
        );    
		
		$validator = Validator::make( $request->all(), $rules );

		if ( $validator->fails() ) 
		{
			return [
				'status' => 'error', 
				'message' => $validator->errors()->first()
			];
		}
		
		if($request->newpassword != $request->conpassword) {
			return [
				'status' => 'error', 
				'message' => 'The password confirmation does not match.'
			];
		}
		
		if(User::where('id', $request->domain_id)->update(['password' => Hash::make($request->newpassword)]))
		{
			return [
				'status' => 'success',
                'message'=>'Password Changed Successfully'
			];
		}
		
		return [
			'status' => 'error',
			'message' => 'Something wrong'
		];
	}

    public function servicereport(Request $request){
        return view('reports.servicereport',['status'=>$request->status,'pagetext'=>$request->pagetext]);
    }

    public function hardcopy(){
        return view('reports.hardcopy');
    }

    public function bulkdomain(Request $request){
        $user_id=$request->id;

        $admins=DB::table('admins')->where('role',2)->orderBy('name','asc')->get();
        return view('reports.bulkdomain',['admins'=>$admins,'selected_user_id' => $user_id]);
    }

    public function activity(){
        return view('reports.activity');
    }

    public function activityajax(Request $request){
         
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); 
        
        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');
        
        $columnIndex = $columnIndex_arr[0]['column'];
        $columnName = $columnName_arr[$columnIndex]['data']; 
        $columnSortOrder = $order_arr[0]['dir']; 
        $searchValue = $search_arr['value']; 
        
        $totalRecords = DB::table('application_activity_log')->select('*');
    
        if($request->from != null) {
            $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
            if ($request->from == $request->to) {
                $totalRecords->whereDate('application_activity_log.created_at', '=', $start_date);
            }else{
                $totalRecords->where('application_activity_log.created_at', '>=', $start_date);
            }
        }
           
        if($request->to != null) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->from == $request->to) {
                $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
                $totalRecords->whereDate('application_activity_log.created_at', '=', $end_date);
            }else{
                $totalRecords->where('application_activity_log.created_at', '<=', $end_date);
            }
        }
       
        if($searchValue!=null){
           $totalRecords->where('application_activity_log.domainName', 'like', '%' .$searchValue . '%');
        }
        
        if($request->domain != null){
            $totalRecords->where('application_activity_log.domainName', 'like', '%' .$request->domain . '%');
        }

            
        if($request->ip_address != null){
            $totalRecords->where('application_activity_log.ip_address',$request->ip_address);
        }
        

        if($request->user_id != null){
            $totalRecords->where('application_activity_log.user_id',$request->user_id);
        }
        
        $totalRecordswithFilter = $totalRecords->count();
    
        $list = $totalRecords->orderBy('id','desc')
        ->skip($start)
        ->take($rowperpage)
        ->get();

        $data_arr = array();
        
        foreach($list as $sno => $row){

           $data_arr[] = array(
               "id" => ++$start,
               'domain'=>$row->domainName,
               'user'=>$row->user_name,
               "type" => $row->user_type==1?"User":"Admin",
               'status'=>$row->status,
               'ip_address'=>$row->ip_address,
               "reg_date" =>date('d/m/Y h:i a',strtotime($row->created_at)), 
           );

        }
        
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" =>$totalRecordswithFilter,
           "iTotalDisplayRecords" =>$totalRecordswithFilter,
           "aaData" => $data_arr
        );
        
        echo json_encode($response);
        exit;
        
    }

    public function activityexport(Request $request){
    
        $list = DB::table('application_activity_log')->select('*');
    
        if($request->domain != null){
            $list->where('application_activity_log.domainName', 'like', '%' .$request->domain . '%');
        }

        if($request->ip_address != null){
            $list->where('application_activity_log.ip_address',$request->ip_address);
        }

        if($request->dd1 != null) {
            $start_date=Carbon::parse($request->dd1)->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $totalRecords->whereDate('application_activity_log.created_at', '=', $start_date);
            }else{
                $totalRecords->where('application_activity_log.created_at', '>=', $start_date);
            }
        }
           
        if($request->dd2 != null) {
            $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d');
                $totalRecords->whereDate('application_activity_log.created_at', '=', $end_date);
            }else{
                $totalRecords->where('application_activity_log.created_at', '<=', $end_date);
            }
        }
     
            $data = $list->get();

            $i = 0;

            $records = array(
                array("Application Activity Log"),
                array(
                    "S.NO.",
                    "Domain Name",
                    "Action By",
                    'User Type',
                    'Description',
                    'IP Address',
                    'Date'
                )
            );
            
            foreach ($data as $row) {

                $type=$row->user_type==1?"User":"Admin";

                $records[] = array(
                    ++$i,
                    $row->domainName,
                    $row->user_name,
                    $type,
                    $row->description,
                    $row->ip_address,
                    date('d-m-Y h:i a', strtotime($row->created_at)),
                );
            }

      
            $filename = "Application Activity Log-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;

    }
    
    public function bulkdomainajax(Request $request){
         
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); 
        
        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');
        
        $columnIndex = $columnIndex_arr[0]['column'];
        $columnName = $columnName_arr[$columnIndex]['data']; 
        $columnSortOrder = $order_arr[0]['dir']; 
        $searchValue = $search_arr['value']; 
        
        $totalRecords = DB::table('users')->select('users.*','admins.org_name as uploader_name')
        ->join('admins','admins.id','users.user_id')
        ->whereIn('users.domainStatus',[6,7,8,10])
        ->where('user_type',2);
    
        if($request->from != null) {
            $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
            if ($request->from == $request->to) {
                $totalRecords->whereDate('users.domainCreationDate', '=', $start_date);
            }else{
                $totalRecords->where('users.domainCreationDate', '>=', $start_date);
            }
        }
           
        if($request->to != null) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->from == $request->to) {
                $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
                $totalRecords->whereDate('users.domainCreationDate', '=', $end_date);
            }else{
                $totalRecords->where('users.domainCreationDate', '<=', $end_date);
            }
        }
       
        if($searchValue!=null){
           $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        
        if($request->domain != null){
            $totalRecords->where('users.domainName', 'like', '%' .$request->domain . '%');
        }

        if($request->user_id != null){
            $totalRecords->where('users.user_id',$request->user_id);
        }
    
    
        if($request->period != null){
            $totalRecords->where('users.domainPeriod', '=', $request->period);
        }
    
    
         if($request->ext != null){
        $domtype=$request->ext;
        $totalRecords->where('users.domainName', 'like', '%' .$domtype . '%');
        }
    
        
        if($request->status != null){
            $totalRecords->where('users.domainStatus', '=', $request->status);
        }
        
        $totalRecordswithFilter = $totalRecords->count();
    
    
        $list = $totalRecords->orderBy('id','desc')
        ->skip($start)
        ->take($rowperpage)
        ->get();

        $data_arr = array();
        
        foreach($list as $sno => $row){
        
            $view = '<a class="btn btn-outline-primary" data-toggle="tooltip" data-placement="top" title="View More" href="' . route('admin.users-details-view', ['id' => base64_encode($row->id)]) . '">View More</a>';
            
            $status='';

            if($row->domainStatus==6){
                $status='Active Domain';
            }elseif($row->domainStatus==7){
                $status='Hold Domain';
            }elseif($row->domainStatus==8){
                $status='Pending Restorable';
            }elseif($row->domainStatus==11){
                $status='Pending Restorable';
            }elseif($row->domainStatus==10){
                $status='Renewal Application';
            }

           $data_arr[] = array(
               "id" => ++$start,
               'uploader'=>$row->uploader_name,
               'domain'=>$row->domainName,
               'inst'=>$row->institute,
               "period" => $row->domainPeriod,
               "reg_date" =>$row->domainCreationDate!=null ? date('d/m/Y',strtotime($row->domainCreationDate)):"", 
               "expiry_date" =>$row->domainCreationDate!=null ? date('d/m/Y',strtotime($row->domainExpiryDate)):"",
               "domainStatus"=>$status, 
               'action'=>$view
           );
        }
        
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" =>$totalRecordswithFilter,
           "iTotalDisplayRecords" =>$totalRecordswithFilter,
           "aaData" => $data_arr
        );
        
        echo json_encode($response);
        exit;
        
    }

    public function hardcopyajax(Request $request){
         
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); 
        
        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');
        
        $columnIndex = $columnIndex_arr[0]['column'];
        $columnName = $columnName_arr[$columnIndex]['data']; 
        $columnSortOrder = $order_arr[0]['dir']; 
        $searchValue = $search_arr['value']; 
        
        $totalRecords = DB::table('users')
        ->select('*')
        ->whereIn('users.domainStatus',[6,7,8,10])
        ->whereIn('users.hard_copy',[1,2]);
       
        if($searchValue!=null){
           $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        
        if($request->domain != null){
            $totalRecords->where('users.domainName', 'like', '%' .$request->domain . '%');
        }
        
        if($request->hardcopy != null){
            $totalRecords->where('users.hard_copy', '=', $request->hardcopy);
        }
        
        $totalRecordswithFilter = $totalRecords->count();
    
        $list = $totalRecords
          ->orderBy('users.domainCreationDate', 'desc')
          ->skip($start)
          ->take($rowperpage)
          ->get();
        
        $data_arr = array();
        
        foreach($list as $sno => $row){
        
            $view = '<a class="btn btn-outline-primary" data-toggle="tooltip" data-placement="top" title="View More" href="' . route('admin.users-details-view', ['id' => base64_encode($row->id)]) . '"><i class="fa fa-edit"></i></a>';
            
           $data_arr[] = array(
               "id" => ++$start,
               'domain'=>$row->domainName,
               'inst'=>$row->institute,
               'phone'=>$row->email,
               "reg_date" =>date('d/m/Y',strtotime($row->domainCreationDate)), 
               "expiry_date" =>date('d/m/Y',strtotime($row->domainExpiryDate)), 
               "status"=>$row->hard_copy==1 ?"Hard Copy Not Received":"Hard Copy Received",
               'action'=>$view
           );
        }
        
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" =>$totalRecordswithFilter,
           "iTotalDisplayRecords" =>$totalRecordswithFilter,
           "aaData" => $data_arr
        );
        
        echo json_encode($response);
        exit;
        
    }

    public function hardcopyexport(Request $request){
    
        $list = DB::table('users')
        ->select('*')
        ->whereIn('users.domainStatus',[6,7,8,10])
        ->whereIn('users.hard_copy',[1,2]);
    
        if($request->domain != null){
            $list->where('users.domainName', 'like', '%' .$request->domain . '%');
        }
        
        if($request->hardcopy != null){
            $list->where('users.hard_copy', '=', $request->hardcopy);
        }
            
            $data = $list->get();

            $i = 0;

            $records = array(
                array("Domain Hard Copy List"),
                array(
                    "S.NO.",
                    "Domain Name",
                    "Institute Name",
                    'Email',
                    'Reg. Date',
                    'Expiry Date',
                    'Status'
                )
            );
            
            foreach ($data as $row) {

                $status=$row->hard_copy==1?"Hard Copy Not Received":"Hard Copy Received";

                $records[] = array(
                    ++$i,
                    $row->domainName,
                    $row->institute,
                    $row->email,
                    date('d-m-Y', strtotime($row->domainCreationDate)),
                    date('d-m-Y', strtotime($row->domainExpiryDate)),
                    $status
                );
            }

      
            $filename = "Domain Hard Copy List-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;

    }

    public function servicereportajax(Request $request){
         
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); 
        
        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');
        
        $columnIndex = $columnIndex_arr[0]['column'];
        $columnName = $columnName_arr[$columnIndex]['data']; 
        $columnSortOrder = $order_arr[0]['dir']; 
        $searchValue = $search_arr['value']; 
      
        $records = DB::table('projects')
        ->select('projects.user_id', 'projects.id', 'projects.project_name', 'projects.old_project_name', 'projects.db_name', 'projects.db_username', 'projects.db_password', 'projects.project_image', 'projects.vas_type', 'projects.status', 'projects.update_status', 'projects.created_at', 'users.domainName')
          ->join('users', 'users.id', 'projects.user_id');
          
          if($request->status==1){
            $records->where('projects.status',0)
            ->where('projects.vas_type','ewaas');
          }else if($request->status==2){
            $records->where('projects.status',1)
            ->where('projects.vas_type','ewaas');
          }else if($request->status==3){
            $records->where('projects.status',0)
            ->where('projects.vas_type','elmaas');
          }else if($request->status==4){
            $records->where('projects.status',1)
            ->where('projects.vas_type','elmaas');
          }
          
          if($request->from != null && $request->to != null) {
            $start_date = $request->from;
            $end_date = $request->to;
            if ($request->from != $request->to) {
                $records->where('projects.created_at', '>=', $start_date);
                $records->where('projects.created_at', '<=', $end_date);   
            }else{
                $records->where('projects.created_at', '=', $start_date);
            }
         }
            
         if($searchValue!=null){
            $records->where('users.domainName', 'like', '%' .$searchValue . '%');
         }
         
         if($request->domain != null){
            $records->where('users.domainName', 'like', '%' .$request->domain . '%');
         }
    
       

        $count=$records->count();

        $list = $records
        ->orderBy('projects.id', 'desc')
          ->skip($start)
          ->take($rowperpage)
          ->get();
                
        $data_arr = array();
        
        foreach($list as $sno => $row){

            $url="https://vas.registry.ernet.in/".$row->project_name;
            $temp='<a target="blank" href="'.$url.'" style="color:blue">'.$row->project_name.'</a>';

                $data_arr[] = array(
                    "id" => ++$start,
                    'domain'=>$row->domainName,
                    'temp'=>$temp,
                    "type" => $row->vas_type,
                    "date" =>date('d/m/Y',strtotime($row->created_at)), 
                );

            
        }
        
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" =>$count,
           "iTotalDisplayRecords" =>$count,
           "aaData" => $data_arr
        );
        
        echo json_encode($response);
        exit;
        
    }


    public function pending(){
        $states=DB::table('regions')->orderBy('description','asc')->get();
        return view('reports.pending',['states'=>$states]);
    }
    
    
    public function pendingajax(Request $request){
         
    $draw = $request->get('draw');
    $start = $request->get("start");
    $rowperpage = $request->get("length"); 
    
    $columnIndex_arr = $request->get('order');
    $columnName_arr = $request->get('columns');
    $order_arr = $request->get('order');
    $search_arr = $request->get('search');
    
    $columnIndex = $columnIndex_arr[0]['column']; 
    $columnName = $columnName_arr[$columnIndex]['data']; 
    $columnSortOrder = $order_arr[0]['dir']; // asc or desc
    $searchValue = $search_arr['value']; // Search value
    
    $totalRecords = DB::table('users')->select('count(*) as allcount')->where('users.domainStatus',5);    
    if($request->from != null) {

       $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
       if ($request->from == $request->to) {
        $totalRecords->whereDate('users.applicationDate', '=', $start_date);
        }else{
            $totalRecords->where('users.applicationDate', '>=', $start_date);
        }
    }
       
    if($request->to != null) {
        // $end_date = $request->to;
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');

        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $totalRecords->whereDate('users.applicationDate', '=', $end_date);
        }else{
            $totalRecords->where('users.applicationDate', '<=', $end_date);
        }
    }
    
    if($searchValue!=null){
       $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
    }
    
    if($request->domain != null){
        $totalRecords->where('users.domainName', 'like', '%' .$request->domain . '%');
    }

    if($request->state != null){
        $totalRecords->where('user_contact_details.state', '=', $request->state)
            ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
    }
    
    $totalRecordswithFilter = $totalRecords->count();

    $records = DB::table('users')->select('users.*','user_contact_details.phone')
      ->where('users.domainStatus', 5)
      ->join('user_contact_details', 'users.id', 'user_contact_details.user_id')
      ->orderBy('users.applicationDate', 'asc')
      ->skip($start)
      ->take($rowperpage);


      if($request->from != null) {
        $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
        if ($request->from == $request->to) {
            $records->whereDate('users.applicationDate', '=', $start_date);
        }else{
            $records->where('users.applicationDate', '>=', $start_date);
        }
     }
        
     if($request->to != null) {
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $records->whereDate('users.applicationDate', '=', $end_date);
        }else{
            $records->where('users.applicationDate', '<=', $end_date);         
        }  
     }
     
     if($searchValue!=null){
        $records->where('users.domainName', 'like', '%' .$searchValue . '%');
     }
     
     if($request->domain != null){
        #$records->where('users.domainName', '=', $request->domain);
        $records->where('users.domainName', 'like', '%' .$request->domain . '%');
     }

     if($request->state != null){
        $records->where('user_contact_details.state', '=', $request->state);
     }
    
    $list = $records->get();
    $data_arr = array();

    $user_id=Auth::guard('admin')->user()->id;
    $view_permission = '';
    $edit_permission = '';
    $delete_permission = '';
    if($user_id==1)
    {

              $view_permission = 1;
              $edit_permission = 1;
              $delete_permission = 1;
    }
    else
    {

    $permission = getUserHasRoleProgram($user_id,30);

    if(isset($permission))
    {
    
      $view_permission = $permission->view_priv??null;
      $edit_permission = $permission->modify_priv??null;
      $delete_permission = $permission->del_priv??null;
      
    
    }
    }
    
    foreach($list as $sno => $row){
        if($view_permission == 1)
        {
            $view = '<a class="btn btn-outline-primary" data-toggle="tooltip" data-placement="top" title="View More" href="' . route('admin.users-details-view', ['id' => base64_encode($row->id)]) . '">View More</a>';
        }else
        {
            $view = '<a class="btn btn-outline-primary" data-toggle="tooltip" data-placement="top" title="View More" href="#">View More</a>';
        }
    
       $data_arr[] = array(
           "id" => ++$start,
           'domain'=>$row->domainName,
           'inst'=>$row->institute,
           'phone'=>$row->phone,
           "period" => $row->domainPeriod,
           "date" =>date('d/m/Y',strtotime($row->applicationDate)),
           'action' => $view, 
       );
    }
    
    $response = array(
       "draw" => intval($draw),
       "iTotalRecords" =>$totalRecordswithFilter,
       "iTotalDisplayRecords" =>$totalRecordswithFilter,
       "aaData" => $data_arr
    );
    
    echo json_encode($response);
    exit;
    
    }
    
    public function pendingexport(Request $request){
    
        $list = DB::table('users')->select('users.*')->where('users.domainStatus', 5);
    
        if($request->dd1 != null) {
            $start_date=Carbon::parse($request->dd1)->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $list->whereDate('users.applicationDate', '=', $start_date);
            }else{
                $list->where('users.applicationDate', '>=', $start_date);
            }
         }
            
         if($request->dd2 != null) {
            $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d');
                $list->whereDate('users.applicationDate', '=', $end_date);
            }else{
                $list->where('users.applicationDate', '<=', $end_date);         
            }  
         }

         if($request->domain != null){
            $list->where('users.domainName', '=', $request->domain);
         }

         
         if($request->state != null){
            $list->where('user_contact_details.state', '=', $request->state)
                ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
          }
            
            $data = $list->get();

            $i = 0;

            $records = array(
                array("Pending Creation List"),
                array(
                    "S.NO.",
                    "Domain Name",
                    "Period (in years)",
                    'Institute Name',
                    'Application Date'
                )
            );
            
            foreach ($data as $row) {
                $records[] = array(
                    ++$i,
                    $row->domainName,
                    $row->domainPeriod,
                    $row->institute,
                    date('d-m-Y', strtotime($row->applicationDate))
                );
            }

      
            $filename = "Pending Creation List-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;

    }

    public function deletedexport(Request $request)
    {

        $deletedBy = $request->get('deleted_by');
        $is_active = $request->get('is_active');



        if ($deletedBy == '3') {
            $list = DB::table('inc_deleted_users');

            if ($request->name) {
                $list->where('name', 'LIKE', '%' . $request->name . '%');
            }

            if ($request->user_name) {
                $list->where('domainName', 'LIKE', '%' . $request->user_name . '%');
            }

            if ($request->institute_name) {
                $list->where('institute', 'LIKE', '%' . $request->institute_name . '%');
            }

            $data = $list->orderBy('id', 'desc')->get();

            $records = [
                ["Auto Deleted Domains"],
                ["S.NO.", "Applicant Name", "Domain Name", "Institute", "Deleted On", "Duration", "Action"]
            ];

            $i = 0;
            foreach ($data as $record) {
                $appdate = $record->deleted_at ? Carbon::parse($record->deleted_at)->format('d/m/Y') : 'NA';

                $records[] = [
                    ++$i,
                    $record->name,
                    $record->domainName,
                    $record->institute,

                    $appdate,
                    'N/A',
                    'Auto Deleted-Incomplete'
                ];
            }
        } else {
            $list = DB::table('deleted_users')->select('*');

            if ($request->start_date) {
                $start_date = Carbon::parse($request->start_date)->startOfDay();
                $list->where('created_at', '>=', $start_date);
            }

            if ($request->end_date) {
                $end_date = Carbon::parse($request->end_date)->endOfDay();
                $list->where('created_at', '<=', $end_date);
            }

            if ($request->name) {
                $list->where('name', 'LIKE', '%' . $request->name . '%');
            }

            if ($request->user_name) {
                $list->where('domainName', 'LIKE', '%' . $request->user_name . '%');
            }

            if ($request->institute_name) {
                $list->where('institute', 'LIKE', '%' . $request->institute_name . '%');
            }

            if (!is_null($is_active) && $is_active !== '') {
                $list->where('is_active', '=', $is_active);
            }

            if (!empty($deletedBy)) {
                $list->where('deleted_by', '=', $deletedBy);
            }

            $data = $list->orderBy('deleted_users.updated_at', 'desc')->get();

            $records = [
                ["Deleted Domains"],
                ["S.NO.", "Applicant Name", "Domain Name", "Email", "Institute", "status", "Creation Date", "Expiry Date", "Deleted On", "Duration (Years)"]
            ];

            $i = 0;
            foreach ($data as $row) {
                $appdate = $row->domainCreationDate ? Carbon::parse($row->domainCreationDate)->format('d/m/Y') : 'NA';
                $expdate = $row->domainExpiryDate ? Carbon::parse($row->domainExpiryDate)->format('d/m/Y') : '';
                $deldate = $row->created_at ? Carbon::parse($row->created_at)->format('d/m/Y') : $expdate;

                $years = ($row->domainCreationDate && $row->domainExpiryDate)
                    ? Carbon::parse($row->domainCreationDate)->diffInYears(Carbon::parse($row->domainExpiryDate))
                    : 'N/A';

                $statusText = 'N/A';
                if ($row->is_active == 1) {
                    $statusText = 'Active';
                } elseif ($row->is_active == 2) {
                    $statusText = 'Incomplete';
                }

                $records[] = [
                    ++$i,
                    $row->name,
                    $row->domainName,
                    $row->email ?? '—',
                    $row->institute,
                    $statusText,
                    $appdate,
                    $expdate,

                    $deldate,
                    $years
                ];
            }
        }


        $filename = "Deleted_Domains_" . now()->format('d-m-Y_H-i-s') . ".xls";
        header("Content-Type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"$filename\"");

        foreach ($records as $record) {
            echo implode("\t", $record) . "\n";
        }

        exit;
    }

    public function deletedexportOld(Request $request){
    
        $list = DB::table('deleted_users')->select('deleted_users.*');
    
        if($request->start_date != null) {
            $start_date=Carbon::parse($request->start_date)->format('Y-m-d H:i:s');
            if ($request->start_date == $request->end_date) {
                $list->whereDate('created_at', '=', $start_date);
            }else{
                $list->where('created_at', '>=', $start_date);
            }
        }
            
         if($request->end_date != null) {
            $end_date=Carbon::parse($request->end_date)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->from_date == $request->end_date) {
                $end_date=Carbon::parse($request->end_date)->endOfDay()->format('Y-m-d');
                $list->whereDate('created_at', '=', $end_date);
            }else{
                $list->where('created_at', '<=', $end_date);         
            }  
         }
         
         if ($request->has('name') && ! empty($request->name))
         {
             $list->where('name', 'LIKE','%'. $request->name.'%');
         }

         if ($request->has('user_name') && ! empty($request->user_name))
         {
             $list->where('domainName', 'LIKE','%'. $request->user_name.'%');
         }

         if ($request->has('institute_name') && ! empty($request->institute_name))
         {
             $list->where('institute', 'LIKE','%'. $request->institute_name.'%');
         }
            
            $data = $list->orderBy('deleted_users.updated_at','desc')->get();

            $i = 0;

            $records = array(
                array("Deleted Domain"),
                array(
                    "S.NO.",
                    "Applicant Name",
                    "Domain Name",
                    "Email",
                    "Institute Name",
                    'Domain Creation Date',
                    'Domain Expiry Date',
                    'Domain Deleted on',
                    'Domain Duration (In Years)'
                )
            );
            
            foreach ($data as $row) {

                if($row->domainCreationDate == Null){
                    $appdate='NA';
                }else{
                    $appdate=Carbon::parse($row->domainCreationDate)->format('d/m/Y');
                }
     
                $expdate='';
                $expdate=$row->domainExpiryDate!=null?Carbon::parse($row->domainExpiryDate)->format('d/m/Y'):'';
                
                $deldate=Carbon::parse($row->created_at)->format('d/m/Y');
     
                
                $domainCreationDate = Carbon::parse($row->domainCreationDate);
                $domainExpiryDate = Carbon::parse($row->domainExpiryDate);
    
                $diffInYears = $domainCreationDate->diffInYears($domainExpiryDate);


                $records[] = array(
                    ++$i,
                    $row->name,
                    $row->domainName,
                    $row->email,
                    $row->institute,
                    $appdate,
                    $expdate,
                    $deldate,
                    $diffInYears
                );
            }

            
            $filename = "Deleted Domain-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;

    }
    

    public function coolingexport(Request $request){
    
        $list = DB::table('deleted_users')
        ->select('deleted_users.*','user_contact_details.address as user_address','user_contact_details.mobile as user_mobile')
        ->join('user_contact_details','user_contact_details.user_id','deleted_users.user_id')
        ->where('deleted_users.status', '=', 0)
        ->whereDate('deleted_users.created_at','>=',Carbon::now()->subDays(5)->format('Y-m-d'));
    
        if($request->start_date != null) {
            $start_date=Carbon::parse($request->start_date)->format('Y-m-d H:i:s');
            if ($request->start_date == $request->end_date) {
                $list->whereDate('deleted_users.created_at', '=', $start_date);
            }else{
                $list->where('deleted_users.created_at', '>=', $start_date);
            }
        }
            
         if($request->end_date != null) {
            $end_date=Carbon::parse($request->end_date)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->from_date == $request->end_date) {
                $end_date=Carbon::parse($request->end_date)->endOfDay()->format('Y-m-d');
                $list->whereDate('deleted_users.created_at', '=', $end_date);
            }else{
                $list->where('deleted_users.created_at', '<=', $end_date);         
            }  
         }
         
         if ($request->has('name') && ! empty($request->name))
         {
             $list->where('deleted_users.name', 'LIKE','%'. $request->name.'%');
         }

         if ($request->has('user_name') && ! empty($request->user_name))
         {
             $list->where('domainName', 'LIKE','%'. $request->user_name.'%');
         }

         if ($request->has('institute_name') && ! empty($request->institute_name))
         {
             $list->where('institute', 'LIKE','%'. $request->institute_name.'%');
         }
            
            $data = $list->orderBy('deleted_users.updated_at','desc')->get();

            $i = 0;

            $records = array(
                array("Deleted Domain"),
                array(
                    "S.NO.",
                    "Applicant Name",
                    "Domain Name",
                    "Institute Name",
                    "Contact Details",
                    "Address",
                    'Domain Creation Date',
                    'Domain Expiry Date',
                    'Domain Deleted on',
                )
            );
            
            foreach ($data as $row) {

                if($row->domainCreationDate == Null){
                    $appdate='NA';
                }else{
                    $appdate=Carbon::parse($row->domainCreationDate)->format('d/m/Y');
                }
     
                $expdate='';
                $expdate=$row->domainExpiryDate!=null?Carbon::parse($row->domainExpiryDate)->format('d/m/Y'):'';
                
                $deldate=Carbon::parse($row->created_at)->format('d/m/Y');
                
                $domainCreationDate = Carbon::parse($row->domainCreationDate);
                $domainExpiryDate = Carbon::parse($row->domainExpiryDate);
    
                $diffInYears = $domainCreationDate->diffInYears($domainExpiryDate);

                $records[] = array(
                    ++$i,
                    $row->name,
                    $row->domainName,
                    $row->institute,
                    $row->email, 
                    $row->user_address,
                    $appdate,
                    $expdate,
                    $deldate,
                    $diffInYears
                );
            }

            
            $filename = "Cooling Period Domain-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;

    }
    
    


    public function incompleteexport(Request $request){
    
        $list = DB::table('users')->select('users.*')
        ->whereIn('users.domainStatus', [1,2,3,4])
        ->whereIn('document_status',[0,2]);
    
        if($request->creation_start_date != null) {
            $start_date=Carbon::parse($request->creation_start_date)->format('Y-m-d H:i:s');
            if ($request->creation_start_date == $request->creation_start_date) {
                $list->whereDate('users.applicationDate', '=', $start_date);
            }else{
                $list->where('users.applicationDate', '>=', $start_date);
            }
         }
            
         if($request->creation_end_date != null) {
            $end_date=Carbon::parse($request->creation_end_date)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->creation_start_date == $request->creation_end_date) {
                $end_date=Carbon::parse($request->creation_end_date)->endOfDay()->format('Y-m-d');
                $list->whereDate('users.applicationDate', '=', $end_date);
            }else{
                $list->where('users.applicationDate', '<=', $end_date);         
            }  
         }
         
         if($request->user_name != null){
            $list->where('users.domainName', '=', $request->user_name);
         }
            
            $data = $list->orderBy('users.updated_at','desc')->get();

            $i = 0;

            $records = array(
                array("Incomplete Application"),
                array(
                    "S.NO.",
                    "Domain Name",
                    "Institute Name",
                    "Email",
                    'Application Date',
                    'Registration Date',
                    "Payment Amount",
                    "Payment Date"
                )
            );
            
            foreach ($data as $row) {

                if($row->applicationDate == Null){
                    $appdate='NA';
                }else{
                    $appdate=Carbon::parse($row->applicationDate)->format('d-m-Y');
                }

                $payment=DB::table('transactions')->select('total_amount','created_at')
                ->whereIn('transaction_type',['domainRegister','domainRegisterWithNameServer'])
                ->where('user_id',$row->id)->where('transaction_status','0300')->first();

                $finaldate='Not Received';

                $paydate=null;

                if($payment!=null){
                    $finaldate=$payment->total_amount;
                    $paydate=date('d-m-Y',strtotime($payment->created_at));
                }

                $records[] = array(
                    ++$i,
                    $row->domainName,
                    $row->institute,
                    $row->email,
                    $appdate,
                    date('d-m-Y', strtotime($row->created_at)),
                    $finaldate,
                    $paydate
                );
            }

            
            $filename = "Incomplete Application-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;

    }
    


    public function hold(){
        $states=DB::table('regions')->orderBy('description','asc')->get();
        return view('reports.hold',['states'=>$states]);
    }
    
    
    public function holdajax(Request $request){
         
    $draw = $request->get('draw');
    $start = $request->get("start");
    $rowperpage = $request->get("length"); 
    
    $columnIndex_arr = $request->get('order');
    $columnName_arr = $request->get('columns');
    $order_arr = $request->get('order');
    $search_arr = $request->get('search');
    
    $columnIndex = $columnIndex_arr[0]['column']; 
    $columnName = $columnName_arr[$columnIndex]['data']; 
    $columnSortOrder = $order_arr[0]['dir']; 
    $searchValue = $search_arr['value']; 
    
    $totalRecords = DB::table('users')->select('count(*) as allcount')->where('users.domainStatus',7);

    if($request->from != null) {
        $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
        if ($request->from == $request->to) {
            $totalRecords->whereDate('users.domainExpiryDate', '=', $start_date);
        }else{
            $totalRecords->where('users.domainExpiryDate', '>=', $start_date);
        }
     }
        
     if($request->to != null) {
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $totalRecords->whereDate('users.domainExpiryDate', '=', $end_date);
        }else{
            $totalRecords->where('users.domainExpiryDate', '<=', $end_date);         
        }  
     }
    
    if($searchValue!=null){
       $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
    }
    
    if($request->domain != null){
        $totalRecords->where('users.domainName', 'like', '%' .$request->domain . '%');
    }

    if($request->state != null){
        $totalRecords->where('user_contact_details.state', '=', $request->state)
            ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
    }
    
    $totalRecordswithFilter = $totalRecords->count();

    $records = DB::table('users')->select('users.*','user_contact_details.phone')
      ->where('users.domainStatus', 7)
      ->join('user_contact_details', 'users.id', 'user_contact_details.user_id')
      ->orderBy('users.domainExpiryDate', 'desc')
      ->skip($start)
      ->take($rowperpage);

    
      if($request->from != null) {
        $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
        if ($request->from == $request->to) {
            $records->whereDate('users.domainExpiryDate', '=', $start_date);
        }else{
            $records->where('users.domainExpiryDate', '>=', $start_date);
        }
     }
        
     if($request->to != null) {
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $records->whereDate('users.domainExpiryDate', '=', $end_date);
        }else{
            $records->where('users.domainExpiryDate', '<=', $end_date);         
        }  
     }

     if($searchValue!=null){
        $records->where('users.domainName', 'like', '%' .$searchValue . '%');
     }
     
     if($request->domain != null){
        $records->where('users.domainName', 'like', '%' .$request->domain . '%');
     }

     if($request->state != null){
        $records->where('user_contact_details.state', '=', $request->state);
    }
    
    $list = $records->get();
    
    $data_arr = array();

    /*For Permission*/
    $user_id=Auth::guard('admin')->user()->id;
    $view_permission = '';
    $edit_permission = '';
    $delete_permission = '';
    if($user_id==1)
    {

              $view_permission = 1;
              $edit_permission = 1;
              $delete_permission = 1;
    }
    else
    {

    $permission = getUserHasRoleProgram($user_id,31);

    if(isset($permission))
    {
    
      $view_permission = $permission->view_priv??null;
      $edit_permission = $permission->modify_priv??null;
      $delete_permission = $permission->del_priv??null;
      
    
    }
    }
   /*For Permission*/
    
    foreach($list as $sno => $row){

        if($view_permission == 1)
        {
            $view = '<a class="btn btn-outline-primary" data-toggle="tooltip" data-placement="top" title="View More" href="' . route('admin.users-details-view', ['id' => base64_encode($row->id)]) . '">View More</a>';

            if($row->domainExpiryDate>Carbon::now()->format('Y-m-d')){
            $view.='<a href="javascript:void(0)" style="color:blue;margin-left:10px;" class="unhold_button" data-id="'.$row->id.'">Unhold</a>';
            }

        }else
        {
            $view = '<a class="btn btn-outline-primary" data-toggle="tooltip" data-placement="top" title="View More" href="#">View More</a>';
        }
    
       $data_arr[] = array(
           "id" => ++$start,
           'domain'=>$row->domainName,
           'inst'=>$row->institute,
           'phone'=>$row->phone,
           "period" => $row->domainPeriod,
           "date" =>date('d/m/Y',strtotime($row->created_at)), 
           "activate_date" =>date('d/m/Y',strtotime($row->domainCreationDate)), 
           "expiry_date" =>date('d/m/Y',strtotime($row->domainExpiryDate)), 
           "hold_date" =>date('d/m/Y',strtotime('+1 day',strtotime($row->domainExpiryDate))), 
           'action' => $view, 
       );
    }
    
    $response = array(
       "draw" => intval($draw),
       "iTotalRecords" =>$totalRecordswithFilter,
       "iTotalDisplayRecords" =>$totalRecordswithFilter,
       "aaData" => $data_arr
    );
    
    echo json_encode($response);
    exit;
    
    }
    
    public function holdexport(Request $request){
    
        $list = DB::table('users')->select('users.*')->where('users.domainStatus',7);
      
        if($request->dd1 != null) {
            $start_date=Carbon::parse($request->dd1)->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $list->whereDate('users.domainExpiryDate', '=', $start_date);
            }else{
                $list->where('users.domainExpiryDate', '>=', $start_date);
            }
         }
            
         if($request->dd2 != null) {
            $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d');
                $list->whereDate('users.domainExpiryDate', '=', $end_date);
            }else{
                $list->where('users.domainExpiryDate', '<=', $end_date);         
            }  
         }

         
         if($request->domain != null){
            $list->where('users.domainName', '=', $request->domain);
         }

         
         if($request->state != null){
            $list->where('user_contact_details.state', '=', $request->state)
                ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
          }
            
            $data = $list->get();
        
        $i = 0;

        $records = array(
            array("Hold Application List"),
            array(
                "S.NO.",
                "Domain Name",
                "Period (in years)",
                'Institute Name',
                'Application Date',
                'Domain Activate Date',
                'Expiry  Date',
                'Hold Date'
            )
        );
        
        foreach ($data as $row) {
            $records[] = array(
                ++$i,
                $row->domainName,
                $row->domainPeriod,
                $row->institute,
                date('d/m/Y', strtotime($row->created_at)),
                date('d/m/Y',strtotime($row->domainCreationDate)),
                date('d/m/Y',strtotime($row->domainExpiryDate)),
                date('d/m/Y',strtotime('+1 day',strtotime($row->domainExpiryDate)))
            );
        }
            
            $filename = "Hold Application List-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;

    }

    public function rejected(){
        $states=DB::table('regions')->orderBy('description','asc')->get();
        return view('reports.rejected',['states'=>$states]);
    }
    
    public function rejectedajax(Request $request){
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); 
        
        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');
        
        $columnIndex = $columnIndex_arr[0]['column']; 
        $columnName = $columnName_arr[$columnIndex]['data']; 
        $columnSortOrder = $order_arr[0]['dir']; 
        $searchValue = $search_arr['value']; 
        
        $totalRecordsQuery = DB::table('users')->select('count(*) as allcount')->where('users.document_status',1);
        

        if($request->from != null) {
            $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
    
            if ($request->from == $request->to) {
                $totalRecordsQuery->whereDate('users.created_at', '=', $start_date);
            }else{
                $totalRecordsQuery->where('users.created_at', '>=', $start_date);
            }
        }
           
        if($request->to != null) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
    
            if ($request->from == $request->to) {
                $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
                $totalRecordsQuery->whereDate('users.created_at', '=', $end_date);
            }else{
                $totalRecordsQuery->where('users.created_at', '<=', $end_date);
            }
        }

     
        if ($searchValue != null) {
            $totalRecordsQuery->where('users.domainName', 'like', '%' . $searchValue . '%');
        }
        
        if ($request->domain != null) {
            $totalRecordsQuery->where('users.domainName', 'like', '%' . $request->domain . '%');
        }
        
        if ($request->state != null) {
            $totalRecordsQuery->where('user_contact_details.state', '=', $request->state)
                ->join('user_contact_details', 'users.id', '=', 'user_contact_details.user_id');
        }
    
        $totalRecords = $totalRecordsQuery->count();
        
        $records = DB::table('users')
            ->select('users.*','user_contact_details.phone')
            ->where('users.document_status',1)
            ->join('user_contact_details', 'users.id', 'user_contact_details.user_id')
            ->orderBy('users.id', 'desc')
            ->skip($start)
            ->take($rowperpage);
        
            if($request->from != null) {
                $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
        
                if ($request->from == $request->to) {
                    $records->whereDate('users.created_at', '=', $start_date);
                }else{
                    $records->where('users.created_at', '>=', $start_date);
                }
            }
               
            if($request->to != null) {
                $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
        
                if ($request->from == $request->to) {
                    $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
                    $records->whereDate('users.created_at', '=', $end_date);
                }else{
                    $records->where('users.created_at', '<=', $end_date);
                }
            }
    
        
        if ($searchValue != null) {
            $records->where('users.domainName', 'like', '%' . $searchValue . '%');
        }
        
        if ($request->domain != null) {
            $records->where('users.domainName', 'like', '%' . $request->domain . '%');
        }
        
        if ($request->state != null) {
            $records->where('user_contact_details.state', '=', $request->state);
                
        }
        
        $list = $records->get();
        
        $data_arr = array();
        
        foreach ($list as $sno => $row) {

            $view = '<a class="btn btn-outline-primary" data-toggle="tooltip" data-placement="top" title="View More" href="' . route('admin.users-details-view', ['id' => base64_encode($row->id)]) . '">View More</a>';
            
            $status='Registration Application';

            if($row->domainStatus<=4){
                $status='Registration Application';
            }else if($row->domainStatus==10){
                $status='Renewal Application';
            }

                $data_arr[] = array(
                    "id" => ++$start,
                    'domain' => $row->domainName,
                    'inst' => $row->institute,
                    'phone'=>$row->phone,
                    "period" => $row->domainPeriod,
                    "date" => date('d/m/Y', strtotime($row->created_at)),
                    'action'=>$view,
                    'status'=>$status
                );
            
        }
        
        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecords,
            "iTotalDisplayRecords" => $totalRecords,
            "aaData" => $data_arr
        );
        
        echo json_encode($response);
        exit;
        
    
    }
    
    public function rejectedexport(Request $request){
            
        $list = DB::table('users')->select('*')->where('users.document_status',1);

        if($request->dd1 != null) {
            $start_date=Carbon::parse($request->dd1)->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $list->whereDate('users.created_at', '=', $start_date);
            }else{
                $list->where('users.created_at', '>=', $start_date);
            }
         }
            
         if($request->dd2 != null) {
            $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d');
                $list->whereDate('users.created_at', '=', $end_date);
            }else{
                $list->where('users.created_at', '<=', $end_date);         
            }  
         }
         
         if($request->domain != null){
            $list->where('users.domainName', '=', $request->domain);
         }

         if($request->state != null){
            $list->where('user_contact_details.state', '=', $request->state)
            ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
         }
            
            $data = $list->get();
          
            $i = 0;
            

            $records = array(
                array("Rejected Application List"),
                array(
                    "S.NO.",
                    "Domain Name",
                    "Period (in years)",
                    'Institute Name',
                    'Application Date',
                    'Status'
                )
            );
            
            foreach ($data as $row) {

                   
            $status='Registration Application';

            if($row->domainStatus<=4){
                $status='Registration Application';
            }else if($row->domainStatus==10){
                $status='Renewal Application';
            }
            
                $records[] = array(
                    ++$i,
                    $row->domainName,
                    $row->domainPeriod,
                    $row->institute,
                    date('d/m/Y', strtotime($row->created_at)),
                    $status
                );
            }
            
            
            $filename = "Rejected Application List-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;
    }

    public function expired(){
        $states=DB::table('regions')->orderBy('description','asc')->get();
        return view('reports.expired',['states'=>$states]);
    }
    
    
    public function expiredajax(Request $request){
         
    $draw = $request->get('draw');
    $start = $request->get("start");
    $rowperpage = $request->get("length"); 
    
    $columnIndex_arr = $request->get('order');
    $columnName_arr = $request->get('columns');
    $order_arr = $request->get('order');
    $search_arr = $request->get('search');
    
    $columnIndex = $columnIndex_arr[0]['column'];
    $columnName = $columnName_arr[$columnIndex]['data']; 
    $columnSortOrder = $order_arr[0]['dir']; 
    $searchValue = $search_arr['value']; 
    
    $totalRecords = DB::table('users')->select('count(*) as allcount')->where('users.domainExpiryDate','<',Carbon::now())->join('user_contact_details', 'users.id', 'user_contact_details.user_id');    ;

    if($request->from != null) {
       $start_date = $request->from;
       $totalRecords->where('users.domainExpiryDate', '>=', $start_date);
       if ($request->from == $request->to) {
        $totalRecords->orWhere('users.domainExpiryDate', '=', $start_date);
    }
    }
       
    if($request->to != null) {
        $end_date = $request->to;
        $totalRecords->where('users.domainExpiryDate', '<=', $end_date);  
        if ($request->from == $request->to) {
            $totalRecords->orWhere('users.domainExpiryDate', '=', $end_date);
        }   
    }
    
    if($searchValue!=null){
       $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
    }
    
    if($request->domain != null){
        $totalRecords->where('users.domainName', '=', $request->domain);
    }

    if($request->state != null){
        $totalRecords->where('user_contact_details.state', '=', $request->state);
    }
    
    $totalRecordswithFilter = $totalRecords->count();

    $records = DB::table('users')->select('users.*','user_contact_details.phone')
      ->where('users.domainExpiryDate','<',Carbon::now())
      ->join('user_contact_details', 'users.id', 'user_contact_details.user_id')
      ->orderBy('users.id', 'desc')
      ->skip($start)
      ->take($rowperpage);

      if($request->from != null) {
        $start_date = $request->from;
        $records->where('users.domainExpiryDate', '>=', $start_date);
        if ($request->from == $request->to) {
            $records->orWhere('users.domainExpiryDate', '=', $start_date);
        }
     }
        
     if($request->to != null) {
         $end_date = $request->to;
         $records->where('users.domainExpiryDate', '<=', $end_date);    
         if ($request->from == $request->to) {
            $records->orWhere('users.domainExpiryDate', '=', $end_date);
        } 
     }
     
     if($searchValue!=null){
        $records->where('users.domainName', 'like', '%' .$searchValue . '%');
     }
     
     if($request->domain != null){
        $records->where('users.domainName', '=', $request->domain);
     }

     if($request->state != null){
        $records->where('user_contact_details.state', '=', $request->state);
    }
    
    $list = $records->get();
    
    $data_arr = array();
    
    foreach($list as $sno => $row){
    
       $data_arr[] = array(
           "id" => ++$start,
           'domain'=>$row->domainName,
           'inst'=>$row->institute,
           'phone'=>$row->phone,
           "period" => $row->domainPeriod,
           "expiry_date" =>date('d/m/Y',strtotime($row->domainExpiryDate)), 
       );
    }
    
    $response = array(
       "draw" => intval($draw),
       "iTotalRecords" =>$totalRecordswithFilter,
       "iTotalDisplayRecords" =>$totalRecordswithFilter,
       "aaData" => $data_arr
    );
    
    echo json_encode($response);
    exit;
    
    }
    
    public function expiredexport(Request $request){
    
        $list = DB::table('users')->select('users.*','user_contact_details.phone')
        ->where('users.domainExpiryDate','<',Carbon::now())
        ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');;

         
    if($request->dd1 != null) {
        $start_date = $request->dd1;
        $totalRecords->where('users.domainExpiryDate', '>=', $start_date);
        if ($start_date == $request->dd2) {
         $totalRecords->orWhere('users.domainExpiryDate', '=', $start_date);
        }
     }
        
     if($request->dd2 != null) {
         $end_date = $request->dd2;
         $totalRecords->where('users.domainExpiryDate', '<=', $end_date);  
         if ($request->dd1 == $request->dd2) {
             $totalRecords->orWhere('users.domainExpiryDate', '=', $end_date);
         }   
     }
         
         if($request->domain != null){
            $list->where('users.domainName', '=', $request->domain);
         }

         
         if($request->state != null){
            $list->where('user_contact_details.state', '=', $request->state);
          }
            
            $data = $list->get();
            $i = 0;
            foreach($data as $row) {
            $records[] = array(
            "S.NO." => ++$i,
           'Domain Name'=>$row->domainName,
           "Period (in years) " => $row->domainPeriod,
           'Institute Name'=>$row->institute,
           'Phone No'=>$row->phone,
           'Expiry Date'=>date('d/m/Y',strtotime($row->domainExpiryDate)),
            );
            }
            
            $filename = "Expired Domain List-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_coloumn = false;
            if(!empty($records)) {
                foreach($records as $record) {
                    if(!$show_coloumn) {
                        echo implode("\t", array_keys($record)) . "\n";
                        $show_coloumn = true;
                    }
                    echo implode("\t", array_values($record)) . "\n";
                }
            }
            exit;
    }

    public function pendingrestore(){
        $states=DB::table('regions')->orderBy('description','asc')->get();
        return view('reports.pendingrestore',['states'=>$states]);
    }
    
    
    public function pendingrestoreajax(Request $request){
         
    $draw = $request->get('draw');
    $start = $request->get("start");
    $rowperpage = $request->get("length"); 
    
    $columnIndex_arr = $request->get('order');
    $columnName_arr = $request->get('columns');
    $order_arr = $request->get('order');
    $search_arr = $request->get('search');
    
    $columnIndex = $columnIndex_arr[0]['column'];
    $columnName = $columnName_arr[$columnIndex]['data']; 
    $columnSortOrder = $order_arr[0]['dir']; 
    $searchValue = $search_arr['value']; 
    
    $totalRecords = DB::table('users')->select('count(*) as allcount')->where('users.domainStatus',8)->join('user_contact_details', 'users.id', 'user_contact_details.user_id');    ;

    if($request->from != null) {
        $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
       if ($request->from == $request->to) {
        $totalRecords->whereDate('users.domainExpiryDate', '=', $start_date);
       }else{
        $totalRecords->where('users.domainExpiryDate', '>=', $start_date);
       }
    }
       
    if($request->to != null) {
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $totalRecords->whereDate('users.domainExpiryDate', '=', $end_date);
        }else{
            $totalRecords->where('users.domainExpiryDate', '<=', $end_date);     
        }
    }
    
    if($searchValue!=null){
       $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
    }
    
    if($request->domain != null){
        $totalRecords->where('users.domainName', '=', $request->domain);
    }

    if($request->state != null){
        $totalRecords->where('user_contact_details.state', '=', $request->state);
    }
    
    $totalRecordswithFilter = $totalRecords->count();

    $records = DB::table('users')->select('users.*','user_contact_details.phone')
      ->where('users.domainStatus',8)
      ->join('user_contact_details', 'users.id', 'user_contact_details.user_id')
      ->orderBy('users.domainExpiryDate', 'asc')
      ->skip($start)
      ->take($rowperpage);

  

    if($request->from != null) {
        $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
       if ($request->from == $request->to) {
        $records->whereDate('users.domainExpiryDate', '=', $start_date);
       }else{
        $records->where('users.domainExpiryDate', '>=', $start_date);
       }
    }
       
    if($request->to != null) {
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $records->whereDate('users.domainExpiryDate', '=', $end_date);
        }else{
            $records->where('users.domainExpiryDate', '<=', $end_date);     
        }
    }
     
     if($searchValue!=null){
        $records->where('users.domainName', 'like', '%' .$searchValue . '%');
     }
     
     if($request->domain != null){
        $records->where('users.domainName', '=', $request->domain);
     }

     if($request->state != null){
        $records->where('user_contact_details.state', '=', $request->state);
    }
    
    $list = $records->get();
    
    $data_arr = array();
    
    foreach($list as $sno => $row){

        $detailurl=url('ernetdash/admin-users-details').'/'.base64_encode($row->id);

        $action='<a class="btn btn-outline-primary mx-2" data-toggle="tooltip" data-placement="top"
        title="Edit" href="'.$detailurl.'"> <i class="fa fa-edit"></i></a>';

    
    
       $data_arr[] = array(
           "id" => ++$start,
           'domain'=>$row->domainName,
           'inst'=>$row->institute,
           'phone'=>$row->phone,
           "period" => $row->domainPeriod,
           "date" =>date('d/m/Y',strtotime($row->created_at)), 
           "activate_date" =>date('d/m/Y',strtotime($row->domainCreationDate)), 
           "expiry_date" =>date('d/m/Y',strtotime($row->domainExpiryDate)), 
           "hold_date" =>date('d/m/Y',strtotime('+1 day',strtotime($row->domainExpiryDate))), 
           "action"=>$action
       );
    }
    
    $response = array(
       "draw" => intval($draw),
       "iTotalRecords" =>$totalRecordswithFilter,
       "iTotalDisplayRecords" =>$totalRecordswithFilter,
       "aaData" => $data_arr
    );
    
    echo json_encode($response);
    exit;
    
    }
    
    public function pendingrestoreexport(Request $request){
    
        $list = DB::table('users')->select('users.*','user_contact_details.phone')->where('users.domainStatus',8)
        ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
      
        if($request->dd1 != null) {
            $start_date=Carbon::parse($request->dd1)->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $list->whereDate('users.domainExpiryDate', '=', $start_date);
            }else{
                $list->where('users.domainExpiryDate', '>=', $start_date);
            }
         }
            
         if($request->dd2 != null) {
            $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d');
                $list->whereDate('users.domainExpiryDate', '=', $end_date);
            }else{
                $list->where('users.domainExpiryDate', '<=', $end_date);         
            }  
         }
         
         if($request->domain != null){
            $list->where('users.domainName', '=', $request->domain);
         }

         
         if($request->state != null){
            $list->where('user_contact_details.state', '=', $request->state);
          }
            
            $data = $list->get();
     
            $i = 0;

            $records = array(
                array("Pending Restorable Domain List"),
                array(
                    "S.NO.",
                    "Domain Name",
                    "Period (in years)",
                    'Institute Name',
                    'Phone No',
                    'Expiry Date'
                )
            );
            
            foreach ($data as $row) {
                $records[] = array(
                    ++$i,
                    $row->domainName,
                    $row->domainPeriod,
                    $row->institute,
                    $row->phone,
                    date('d/m/Y', strtotime($row->domainExpiryDate))
                );
            }
            
            $filename = "Pending Restorable Domain List-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;
    }


    public function expire(){
        $states=DB::table('regions')->orderBy('description','asc')->get();
        return view('reports.expire',['states'=>$states]);
    }
    
    
    public function expireajax(Request $request){
         
    $draw = $request->get('draw');
    $start = $request->get("start");
    $rowperpage = $request->get("length"); 
    
    $columnIndex_arr = $request->get('order');
    $columnName_arr = $request->get('columns');
    $order_arr = $request->get('order');
    $search_arr = $request->get('search');
    
    $columnIndex = $columnIndex_arr[0]['column'];
    $columnName = $columnName_arr[$columnIndex]['data']; 
    $columnSortOrder = $order_arr[0]['dir']; 
    $searchValue = $search_arr['value']; 
    
    $totalRecords = DB::table('users')->select('count(*) as allcount')->where('domainStatus',6)->join('user_contact_details', 'users.id', 'user_contact_details.user_id');

    if($request->from != null && $request->to!=null) {
    
    if($request->from != null) {
        $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');

        if ($request->from == $request->to) {
            $totalRecords->whereDate('users.domainExpiryDate', '=', $start_date);
        }else{
            $totalRecords->where('users.domainExpiryDate', '>=', $start_date);
        }
    }
       
    if($request->to != null) {
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');

        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $totalRecords->whereDate('users.domainExpiryDate', '=', $end_date);
        }else{
            $totalRecords->where('users.domainExpiryDate', '<=', $end_date);
        }
    }

    }else{
        $totalRecords->whereMonth('users.domainExpiryDate', Carbon::now()->month);
        $totalRecords->whereYear('users.domainExpiryDate', Carbon::now()->year);
        $totalRecords->where('users.domainExpiryDate', '>',Carbon::now());
    }
    
    if($searchValue!=null){
       $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
    }
    
    if($request->domain != null){
        $totalRecords->where('users.domainName', '=', $request->domain);
    }

    if($request->state != null){
        $totalRecords->where('user_contact_details.state', '=', $request->state);
    }
    
    $totalRecordswithFilter = $totalRecords->count();

    $records = DB::table('users')->select('users.*','user_contact_details.phone')
      ->where('domainStatus',6)
      ->join('user_contact_details', 'users.id', 'user_contact_details.user_id')
      ->orderBy('users.domainExpiryDate', 'asc')
      ->skip($start)
      ->take($rowperpage);

      if($request->from != null && $request->to != null) {
      

        if($request->from != null) {
            $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
    
            if ($request->from == $request->to) {
                $records->whereDate('users.domainExpiryDate', '=', $start_date);
            }else{
                $records->where('users.domainExpiryDate', '>=', $start_date);
            }
        }
           
        if($request->to != null) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
    
            if ($request->from == $request->to) {
                $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
                $records->whereDate('users.domainExpiryDate', '=', $end_date);
            }else{
                $records->where('users.domainExpiryDate', '<=', $end_date);
            }
        }

     }else{

        $records->whereMonth('users.domainExpiryDate', Carbon::now()->month);
        $records->whereYear('users.domainExpiryDate', Carbon::now()->year);
        $records->where('users.domainExpiryDate', '>',Carbon::now());

     }
     
     if($searchValue!=null){
        $records->where('users.domainName', 'like', '%' .$searchValue . '%');
     }
     
     if($request->domain != null){
        $records->where('users.domainName', '=', $request->domain);
     }

     if($request->state != null){
        $records->where('user_contact_details.state', '=', $request->state);
    }
    
    $list = $records->get();
    
    $data_arr = array();
    
    foreach($list as $sno => $row){
    
        $detailurl=url('ernetdash/admin-users-details').'/'.base64_encode($row->id);

        $action='<a class="btn btn-outline-primary mx-2" data-toggle="tooltip" data-placement="top"
        title="Edit" href="'.$detailurl.'"> <i class="fa fa-edit"></i></a>';
        
       $data_arr[] = array(
           "id" => ++$start,
           'domain'=>$row->domainName,
           'inst'=>$row->institute,
           'phone'=>$row->phone,
           "period" => $row->domainPeriod,
           "expiry_date" =>date('d/m/Y',strtotime($row->domainExpiryDate)), 
           'action'=>$action
       );
    }
    
    $response = array(
       "draw" => intval($draw),
       "iTotalRecords" =>$totalRecordswithFilter,
       "iTotalDisplayRecords" =>$totalRecordswithFilter,
       "aaData" => $data_arr
    );
    
    echo json_encode($response);
    exit;
    
    }
    
    public function expireexport(Request $request){
    
        $list = DB::table('users')->select('users.*','user_contact_details.phone')
        ->where('domainStatus',6)
        ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');          

            
        if($request->dd1 != null && $request->dd2 != null) {

            if($request->dd1 != null) {
                $start_date=Carbon::parse($request->dd1)->format('Y-m-d H:i:s');
                if ($request->dd1 == $request->dd2) {
                    $list->whereDate('users.domainExpiryDate', '=', $start_date);
                }else{
                    $list->where('users.domainExpiryDate', '>=', $start_date);
                }
             }
                
             if($request->dd2 != null) {
                $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d H:i:s');
                if ($request->dd1 == $request->dd2) {
                    $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d');
                    $list->whereDate('users.domainExpiryDate', '=', $end_date);
                }else{
                    $list->where('users.domainExpiryDate', '<=', $end_date);         
                }  
             }

         
        }else{

            $list->whereMonth('users.domainExpiryDate', Carbon::now()->month);
            $list->whereYear('users.domainExpiryDate', Carbon::now()->year);
            $list->where('users.domainExpiryDate', '>',Carbon::now());
    
         }
    

         if($request->domain != null){
            $list->where('users.domainName', '=', $request->domain);
         }

         
         if($request->state != null){
            $list->where('user_contact_details.state', '=', $request->state);
          }
            
            $data = $list->get();

            $i = 0;
            foreach($data as $row) {
            $records[] = array(
            "S.NO." => ++$i,
           'Domain Name'=>$row->domainName,
           "Period (in years) " => $row->domainPeriod,
           'Institute Name'=>$row->institute,
           'Phone No'=>$row->phone,
           'Expiry Date'=>date('d/m/Y',strtotime($row->domainExpiryDate)),
            );
            }
            
            $filename = "Upcoming Expiring Domain List-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_coloumn = false;
            if(!empty($records)) {
                foreach($records as $record) {
                    if(!$show_coloumn) {
                        echo implode("\t", array_keys($record)) . "\n";
                        $show_coloumn = true;
                    }
                    echo implode("\t", array_values($record)) . "\n";
                }
            }
            exit;
    }


    public function pendingrenew(){
        $states=DB::table('regions')->orderBy('description','asc')->get();
        return view('reports.pendingrenew',['states'=>$states]);
    }
    
    
    public function pendingrenewajax(Request $request){
         
    $draw = $request->get('draw');
    $start = $request->get("start");
    $rowperpage = $request->get("length"); 
    
    $columnIndex_arr = $request->get('order');
    $columnName_arr = $request->get('columns');
    $order_arr = $request->get('order');
    $search_arr = $request->get('search');
    
    $columnIndex = $columnIndex_arr[0]['column'];
    $columnName = $columnName_arr[$columnIndex]['data']; 
    $columnSortOrder = $order_arr[0]['dir']; 
    $searchValue = $search_arr['value']; 
    
    $totalRecords = DB::table('users')->select('count(*) as allcount')
    ->where('users.domainStatus',10)->join('user_contact_details', 'users.id', 'user_contact_details.user_id');

    if($request->from != null) {
        $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
       if ($request->from == $request->to) {
        $totalRecords->whereDate('users.domainExpiryDate', '=', $start_date);
       }else{
        $totalRecords->where('users.domainExpiryDate', '>=', $start_date);
       }
    }
       
    if($request->to != null) {
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $totalRecords->whereDate('users.domainExpiryDate', '=', $end_date);
        }else{
            $totalRecords->where('users.domainExpiryDate', '<=', $end_date);     
        }
    }
    
    if($searchValue!=null){
       $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
    }
    
    if($request->domain != null){
        $totalRecords->where('users.domainName', 'like', '%' .$request->domain . '%');
    }

    if($request->state != null){
        $totalRecords->where('user_contact_details.state', '=', $request->state);
    }
    
    $totalRecordswithFilter = $totalRecords->count();

    $records = DB::table('users')->select('users.*','user_contact_details.phone')
      ->where('users.domainStatus',10)
      ->join('user_contact_details', 'users.id', 'user_contact_details.user_id')
      ->orderBy('users.domainExpiryDate', 'desc')
      ->skip($start)
      ->take($rowperpage);

      if($request->from != null) {
        $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
       if ($request->from == $request->to) {
        $records->whereDate('users.domainExpiryDate', '=', $start_date);
       }else{
        $records->where('users.domainExpiryDate', '>=', $start_date);
       }
    }
       
    if($request->to != null) {
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $records->whereDate('users.domainExpiryDate', '=', $end_date);
        }else{
            $records->where('users.domainExpiryDate', '<=', $end_date);     
        }
    }
     
     if($searchValue!=null){
        $records->where('users.domainName', 'like', '%' .$searchValue . '%');
     }
     
     if($request->domain != null){
        $records->where('users.domainName', 'like', '%' .$request->domain . '%');
     }

     if($request->state != null){
        $records->where('user_contact_details.state', '=', $request->state);
    }
    
    $list = $records->get();
    
    $data_arr = array();
    
    foreach($list as $sno => $row){
    
        $detailurl=url('ernetdash/admin-users-details').'/'.base64_encode($row->id);

$action='<a class="btn btn-outline-primary mx-2" data-toggle="tooltip" data-placement="top"
title="Edit" href="'.$detailurl.'"> <i class="fa fa-edit"></i></a>';


       $data_arr[] = array(
           "id" => ++$start,
           'domain'=>$row->domainName,
           'phone'=>$row->phone,
           "period" => $row->domainPeriod,
           "expiry_date" =>date('d/m/Y',strtotime($row->domainExpiryDate)), 
           'action'=>$action
       );
    }
    
    $response = array(
       "draw" => intval($draw),
       "iTotalRecords" =>$totalRecordswithFilter,
       "iTotalDisplayRecords" =>$totalRecordswithFilter,
       "aaData" => $data_arr
    );
    
    echo json_encode($response);
    exit;
    
    }
    
    public function pendingrenewexport(Request $request){
    
        $list = DB::table('users')->select('users.*','user_contact_details.phone')->where('users.domainStatus',10)
        ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
      
        if($request->dd1 != null) {
            $start_date=Carbon::parse($request->dd1)->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $list->whereDate('users.domainExpiryDate', '=', $start_date);
            }else{
                $list->where('users.domainExpiryDate', '>=', $start_date);
            }
         }
            
         if($request->dd2 != null) {
            $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d');
                $list->whereDate('users.domainExpiryDate', '=', $end_date);
            }else{
                $list->where('users.domainExpiryDate', '<=', $end_date);         
            }  
         }
         
         if($request->domain != null){
            $list->where('users.domainName', '=', $request->domain);
         }

         
         if($request->state != null){
            $list->where('user_contact_details.state', '=', $request->state);
          }
            
            $data = $list->get();
            

        $i = 0;

        $records = array(
            array("Pending Renew Domain List"),
            array(
                "S.NO.",
                "Domain Name",
                "Period (in years)",
                'Institute Name',
                'Phone No',
                'Expiry Date'
            )
        );
        
        foreach ($data as $row) {
            $records[] = array(
                ++$i,
                $row->domainName,
                $row->domainPeriod,
                $row->institute,
                $row->phone,
                date('d/m/Y', strtotime($row->domainExpiryDate))
            );
        }

            $filename = "Pending Renew Domain List-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;
    }


    public function domain(){
        $states=DB::table('regions')->orderBy('description','asc')->get();
        return view('reports.domain',['states'=>$states]);
    }

    public function renewdomain(){
        $states=DB::table('regions')->orderBy('description','asc')->get();
        return view('reports.renewdomain',['states'=>$states]);
    }

    public function dailyreport(){
        return view('reports.dailyreport');
    }
    
    
    public function domainajax(Request $request){
         
    $draw = $request->get('draw');
    $start = $request->get("start");
    $rowperpage = $request->get("length"); 
    
    $columnIndex_arr = $request->get('order');
    $columnName_arr = $request->get('columns');
    $order_arr = $request->get('order');
    $search_arr = $request->get('search');
    
    $columnIndex = $columnIndex_arr[0]['column'];
    $columnName = $columnName_arr[$columnIndex]['data']; 
    $columnSortOrder = $order_arr[0]['dir']; 
    $searchValue = $search_arr['value']; 
    
    $totalRecords = DB::table('users')->select('count(*) as allcount')
    ->join('user_contact_details','user_contact_details.user_id','users.id')
    ->whereIn('users.domainStatus',[6,7,8,10]);

    if($request->from != null) {
        $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');

        if ($request->from == $request->to) {
            $totalRecords->whereDate('users.domainCreationDate', '=', $start_date);
        }else{
            $totalRecords->where('users.domainCreationDate', '>=', $start_date);
        }
    }
       
    if($request->to != null) {
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');

        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $totalRecords->whereDate('users.domainCreationDate', '=', $end_date);
        }else{
            $totalRecords->where('users.domainCreationDate', '<=', $end_date);
        }
    }
   
    if($searchValue!=null){
       $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
    }
    
    if($request->domain != null){
        $totalRecords->where(function($query) use ($request) {
            $query->where('users.domainName', $request->domain)
                  ->orWhere('users.domainPunyCode', $request->domain);
        });
        // $totalRecords->where('users.domainName', 'like', '%' .$request->domain . '%');
    }

    if($request->state != null){
        $totalRecords->where('user_contact_details.state', '=', $request->state);
    }

    if($request->period != null){
        $totalRecords->where('users.domainPeriod', '=', $request->period);
    }


     if($request->ext != null){
    $domtype=$request->ext;
    $totalRecords->where('users.domainName', 'like', '%' .$domtype . '%');
    }

    
    if($request->status != null){
        $totalRecords->where('users.domainStatus', '=', $request->status);
    }
    
    $totalRecordswithFilter = $totalRecords->count();

    $records = DB::table('users')->select('users.*')
      ->whereIn('users.domainStatus',[6,7,8,10])
      ->join('user_contact_details','user_contact_details.user_id','users.id')
      ->orderBy('users.domainCreationDate', 'desc')
      ->skip($start)
      ->take($rowperpage);

      if($request->from != null) {
        $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
        if ($request->from == $request->to) {
            $records->whereDate('users.domainCreationDate', '=', $start_date);
        }else{
            $records->where('users.domainCreationDate', '>=', $start_date);
        }
     }
        
     if($request->to != null) {
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $records->whereDate('users.domainCreationDate', '=', $end_date);
        }else{
            $records->where('users.domainCreationDate', '<=', $end_date);    
        } 
     }
     
     if($searchValue!=null){
        $records->where('users.domainName', 'like', '%' .$searchValue . '%');
     }
     

     if($request->ext != null){
        $domtype=$request->ext;
        $records->where('users.domainName', 'like', '%' .$domtype . '%');
      }
     
     if($request->domain != null){
        $records->where(function($query) use ($request) {
            $query->where('users.domainName', $request->domain)
                  ->orWhere('users.domainPunyCode', $request->domain);
        });
        // $records->where('users.domainName', 'like', '%' .$request->domain . '%');
     }

     if($request->state != null){
        $records->where('user_contact_details.state', '=', $request->state);
    }

    if($request->period != null){
        $records->where('users.domainPeriod', '=', $request->period);
    }

    if($request->status != null){
        $records->where('users.domainStatus', '=', $request->status);
    }
    
    $list = $records->get();
    $data_arr = array();
    
    foreach($list as $sno => $row){
    
        $view = '<a class="btn btn-outline-primary" data-toggle="tooltip" data-placement="top" title="View More" href="' . route('admin.users-details-view', ['id' => base64_encode($row->id)]) . '">View More</a>';
        
       $data_arr[] = array(
           "id" => ++$start,
           'domain'=>$row->domainName,
           'inst'=>$row->institute,
           'phone'=>$row->email,
           "period" => $row->domainPeriod,
           "reg_date" =>date('d/m/Y',strtotime($row->domainCreationDate)), 
           "expiry_date" =>date('d/m/Y',strtotime($row->domainExpiryDate)), 
           'action'=>$view
       );
    }
    
    $response = array(
       "draw" => intval($draw),
       "iTotalRecords" =>$totalRecordswithFilter,
       "iTotalDisplayRecords" =>$totalRecordswithFilter,
       "aaData" => $data_arr
    );
    
    echo json_encode($response);
    exit;
    
    }


    public function renewdomainajax(Request $request){
         
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); 
        
        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');
        
        $columnIndex = $columnIndex_arr[0]['column'];
        $columnName = $columnName_arr[$columnIndex]['data']; 
        $columnSortOrder = $order_arr[0]['dir']; 
        $searchValue = $search_arr['value']; 
        
        $totalRecords = DB::table('domain_trails')->select('count(*) as allcount')
        ->join('users', 'users.id', 'domain_trails.user_id');
    

        if($request->from != null) {
            $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
    
            if ($request->from == $request->to) {
                $totalRecords->whereDate('domain_trails.created_at', '=', $start_date);
            }else{
                $totalRecords->where('domain_trails.created_at', '>=', $start_date);
            }
        }
           
        if($request->to != null) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');            
            if ($request->from == $request->to) {
                $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');            
                $totalRecords->whereDate('domain_trails.created_at', '=', $end_date);
            }else{
                $totalRecords->where('domain_trails.created_at', '<=', $end_date);
            }
        }
        
           
     
        if($searchValue!=null){
           $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
        }
        
        if($request->domain != null){
            $totalRecords->where('users.domainName', 'like', '%' .$request->domain . '%');
        }
    
        if($request->period != null){
            $totalRecords->where('users.domainPeriod', '=', $request->period);
        }
    
        $totalRecordswithFilter = $totalRecords->count();
    
        $records = DB::table('domain_trails')->select('domain_trails.*','users.domainName','users.domainPeriod','users.domainExpiryDate','users.institute','users.email')
          ->join('users', 'users.id', 'domain_trails.user_id')
          #->orderBy('domain_trails.created_at', 'desc')
          ->skip($start)
          ->take($rowperpage);
          $records->orderBy($columnName,$columnSortOrder);
    
     

        
        if($request->from != null) {
            $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
    
            if ($request->from == $request->to) {
                $records->whereDate('domain_trails.created_at', '=', $start_date);
            }else{
                $records->where('domain_trails.created_at', '>=', $start_date);
            }
        }
           
        if($request->to != null) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
    
            if ($request->from == $request->to) {
                $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');            
                $records->whereDate('domain_trails.created_at', '=', $end_date);
            }else{
                $records->where('domain_trails.created_at', '<=', $end_date);
            }
        }
            
     
         
         if($searchValue!=null){
            $records->where('users.domainName', 'like', '%' .$searchValue . '%');
         }
         
         if($request->domain != null){
            $records->where('users.domainName', 'like', '%' .$request->domain . '%');
         }
    
        
    
        if($request->period != null){
            $records->where('users.domainPeriod', '=', $request->period);
        }
    
    
        
        $list = $records->get();
        $data_arr = array();
        
        foreach($list as $sno => $row){
        
            $view = '<a class="btn btn-outline-primary" data-toggle="tooltip" data-placement="top" title="View More" href="' . route('admin.users-details-view', ['id' => base64_encode($row->user_id)]) . '">View More</a>';
    
          
            
           $data_arr[] = array(
               "id" => ++$start,
               'domain'=>$row->domainName,
               'inst'=>$row->institute,
               'email'=>$row->email,
               "domainPeriod" => $row->domainPeriod,
               "created_at" =>date('d/m/Y',strtotime($row->created_at)), 
               "domainExpiryDate" =>date('d/m/Y',strtotime($row->domainExpiryDate)), 
               'action'=>$view
           );
        }
        
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" =>$totalRecordswithFilter,
           "iTotalDisplayRecords" =>$totalRecordswithFilter,
           "aaData" => $data_arr
        );
        
        echo json_encode($response);
        exit;
        
        }

        

        public function dailyreportajax(Request $request){
         
            $draw = $request->get('draw');
            $start = $request->get("start");
            $rowperpage = $request->get("length"); 
            
            $columnIndex_arr = $request->get('order');
            $columnName_arr = $request->get('columns');
            $order_arr = $request->get('order');
            $search_arr = $request->get('search');
            
            $columnIndex = $columnIndex_arr[0]['column'];
            $columnName = $columnName_arr[$columnIndex]['data']; 
            $columnSortOrder = $order_arr[0]['dir']; 
            $searchValue = $search_arr['value']; 
            
            $totalRecords = DB::table('daily_reports')->select('count(*) as allcount');
    
            if($request->from != null) {
                $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
                if ($request->from == $request->to) {
                    $totalRecords->whereDate('created_at', '=', $start_date);
                }else{
                    $totalRecords->where('created_at', '>=', $start_date);
                }
            }
               
            if($request->to != null) {
                $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');            
                if ($request->from == $request->to) {
                    $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');            
                    $totalRecords->whereDate('created_at', '=', $end_date);
                }else{
                    $totalRecords->where('created_at', '<=', $end_date);
                }
            }
            
        
            $totalRecordswithFilter = $totalRecords->count();
        
            $records = DB::table('daily_reports')->select('daily_reports.*')
              ->skip($start)
              ->take($rowperpage);
              $records->orderBy($columnName,$columnSortOrder);
        
            
            if($request->from != null) {
                $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
        
                if ($request->from == $request->to) {
                    $records->whereDate('created_at', '=', $start_date);
                }else{
                    $records->where('created_at', '>=', $start_date);
                }
            }
               
            if($request->to != null) {
                $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
        
                if ($request->from == $request->to) {
                    $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');            
                    $records->whereDate('created_at', '=', $end_date);
                }else{
                    $records->where('created_at', '<=', $end_date);
                }
            }
            
            $list = $records->get();
            $data_arr = array();
            
            foreach($list as $sno => $row){
               $data_arr[] = array(
                   "id" => ++$start,
                   'pending_creation'=>$row->pending_creation,
                   'registered'=>$row->registered,
                   'renew'=>$row->renew,
                   'total_payment'=>number_format($row->total_payment, 2, '.', ',') ,
                   "created_at" =>date('d/m/Y',strtotime($row->created_at)), 
               );
            }
            
            $response = array(
               "draw" => intval($draw),
               "iTotalRecords" =>$totalRecordswithFilter,
               "iTotalDisplayRecords" =>$totalRecordswithFilter,
               "aaData" => $data_arr
            );
            
            echo json_encode($response);
            exit;
            
            }

            public function dailyreportexport(Request $request){
    
                $list = DB::table('daily_reports')->select('daily_reports.*');
               
                if($request->dd1 != null) {
                    $start_date=Carbon::parse($request->dd1)->format('Y-m-d H:i:s');
                    if ($request->dd1 == $request->dd2) {
                        $list->whereDate('created_at', '=', $start_date);
                    }else{
                        $list->where('created_at', '>=', $start_date);
                    }
                 }
                    
                 if($request->dd2 != null) {
                    $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d H:i:s');
                    if ($request->dd1 == $request->dd2) {
                        $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d');
                        $list->whereDate('created_at', '=', $end_date);
                    }else{
                        $list->where('created_at', '<=', $end_date);         
                    }  
                 }
                    
                $data = $list->get();
              
                $i = 0;
        
                $records = array(
                    array("Daily Report"),
                    array(
                        "S.NO.",
                        "Total Application Submitted ",
                        "Total Domain Registered",
                        'Total Domain Renewed',
                        'Total Payment Received',
                        'Date'
                    )
                );
                
                foreach ($data as $row) {
                    $records[] = array(
                        ++$i,
                        $row->pending_creation,
                        $row->registered,
                        $row->renew,
                        $row->total_payment,
                        date('d/m/Y',strtotime($row->created_at)),
                    );
                }
                    
                    $filename = "Daily Report-". date('d-m-Y H:i:s a ') . ".xls";
                    header("Content-Type: application/vnd.ms-excel");
                    header("Content-Disposition: attachment; filename=\"$filename\"");
                    $show_column = false;
        
                    foreach ($records as $record) {
                        if (!$show_column) {
                            echo implode("\t", array_map(function ($value) {
                                return  $value ;
                            }, $record)) . "\n";
                            $show_column = true;
                        } else {
                            echo implode("\t", $record) . "\n";
                        }
                    }
                    exit;
            }

        public function renewdomainexport(Request $request){
    
            $list = DB::table('domain_trails')->select('domain_trails.*','users.domainName','users.domainPeriod','users.domainExpiryDate','users.institute','users.email')
            ->join('users', 'users.id', 'domain_trails.user_id');
          

            if($request->dd1 != null) {
                $start_date=Carbon::parse($request->dd1)->format('Y-m-d H:i:s');
                if ($request->dd1 == $request->dd2) {
                    $list->whereDate('domain_trails.created_at', '=', $start_date);
                }else{
                    $list->where('domain_trails.created_at', '>=', $start_date);
                }
             }
                
             if($request->dd2 != null) {
                $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d H:i:s');
                if ($request->dd1 == $request->dd2) {
                    $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d');
                    $list->whereDate('domain_trails.created_at', '=', $end_date);
                }else{
                    $list->where('domain_trails.created_at', '<=', $end_date);         
                }  
             }
             
             if($request->domain != null){
                $list->where('users.domainName', '=', $request->domain);
             }
             
             if($request->period != null){
                $list->where('users.domainPeriod', '=', $request->period);
             }
    
         
            $data = $list->get();
          
    
            $i = 0;
    
            $records = array(
                array("Renewed Domain List"),
                array(
                    "S.NO.",
                    "Domain Name",
                    "Period (in years)",
                    'Institute Name',
                    'Email',
                    'Renew Date',
                    'Expiry Date'
                )
            );
            
            foreach ($data as $row) {
                $records[] = array(
                    ++$i,
                    $row->domainName,
                    $row->domainPeriod,
                    $row->institute,
                    $row->email,
                    date('d/m/Y',strtotime($row->created_at)),
                    date('d/m/Y', strtotime($row->domainExpiryDate))
                );
            }
                
                $filename = "Renewed Domain List-". date('d-m-Y H:i:s a ') . ".xls";
                header("Content-Type: application/vnd.ms-excel");
                header("Content-Disposition: attachment; filename=\"$filename\"");
                $show_column = false;
    
                foreach ($records as $record) {
                    if (!$show_column) {
                        echo implode("\t", array_map(function ($value) {
                            return  $value ;
                        }, $record)) . "\n";
                        $show_column = true;
                    } else {
                        echo implode("\t", $record) . "\n";
                    }
                }
                exit;
        }
    
    
    public function domainexport(Request $request){
    
        $list = DB::table('users')->select('users.*')->whereIn('users.domainStatus',[6,7,8,10])
        ->join('user_contact_details','user_contact_details.user_id','users.id');

         if($request->dd1 != null) {
            $start_date=Carbon::parse($request->dd1)->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $list->whereDate('users.domainCreationDate', '=', $start_date);
            }else{
                $list->where('users.domainCreationDate', '>=', $start_date);
            }
         }
            
         if($request->dd2 != null) {
            $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d');
                $list->whereDate('users.domainCreationDate', '=', $end_date);
            }else{
                $list->where('users.domainCreationDate', '<=', $end_date);         
            }  
         }

         if ($request->domain != null) {
            $list->where(function($query) use ($request) {
                $query->where('users.domainName', $request->domain)
                      ->orWhere('users.domainPunyCode', $request->domain);
            });
        }
         
         if($request->period != null){
            $list->where('users.domainPeriod', '=', $request->period);
         }

         if($request->ext != null){
            $domtype=$request->ext;
            $list->where('users.domainName', 'like', '%' .$domtype . '%');
          }
        
         if($request->state != null){
            $list->where('user_contact_details.state', '=', $request->state);
         }
    
        if($request->domain_status != null){
            $list->where('users.domainStatus', '=', $request->domain_status);
        }
    
        $data = $list->get();


        $i = 0;

        $records = array(
            array("Registered Domain List"),
            array(
                "S.NO.",
                "Domain Name",
                "Period (in years)",
                'Institute Name',
                'Email',
                'Registration Date',
                'Expiry Date'
            )
        );
        
        foreach ($data as $row) {
            $records[] = array(
                ++$i,
                $row->domainPunycode,
                $row->domainPeriod,
                $row->institute,
                $row->email,
                date('d/m/Y',strtotime($row->domainCreationDate)),
                date('d/m/Y', strtotime($row->domainExpiryDate))
            );
        }
            
            $filename = "Registered Domain List-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;
    }

    public function domainhi(){
        $states=DB::table('regions')->orderBy('description','asc')->get();
        return view('reports.domainhi',['states'=>$states]);
    }
    
    
    public function domainhiajax(Request $request){
         
    $draw = $request->get('draw');
    $start = $request->get("start");
    $rowperpage = $request->get("length"); 
    
    $columnIndex_arr = $request->get('order');
    $columnName_arr = $request->get('columns');
    $order_arr = $request->get('order');
    $search_arr = $request->get('search');
    
    $columnIndex = $columnIndex_arr[0]['column'];
    $columnName = $columnName_arr[$columnIndex]['data']; 
    $columnSortOrder = $order_arr[0]['dir']; 
    $searchValue = $search_arr['value']; 
    
    $totalRecords = DB::table('users')->select('count(*) as allcount')->where('users.domainStatus',6)->where('users.domainLangID',3)->join('user_contact_details', 'users.id', 'user_contact_details.user_id');    ;

    if($request->from != null) {
       $start_date = $request->from;
       $totalRecords->where('users.domainCreationDate', '>=', $start_date);
       if ($request->from == $request->to) {
        $totalRecords->orWhere('users.domainCreationDate', '=', $start_date);
    }
    }
       
    if($request->to != null) {
        $end_date = $request->to;
        $totalRecords->where('users.domainCreationDate', '<=', $end_date);  
        if ($request->from == $request->to) {
            $totalRecords->orWhere('users.domainCreationDate', '=', $end_date);
        }   
    }
    
    if($searchValue!=null){
       $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
    }
    
    if($request->domain != null){
        $totalRecords->where('users.domainName', 'like', '%' .$request->domain . '%');
    }

    if($request->state != null){
        $totalRecords->where('user_contact_details.state', '=', $request->state);
    }

    if($request->period != null){
        $totalRecords->where('users.domainPeriod', '=', $request->period);
    }

    if($request->status != null){
        $totalRecords->where('users.type', '=', $request->status);
    }
    
    $totalRecordswithFilter = $totalRecords->count();

    $records = DB::table('users')->select('users.*','user_contact_details.phone')
      ->where('users.domainStatus',6)
      ->where('users.domainLangID', 3)
      ->join('user_contact_details', 'users.id', 'user_contact_details.user_id')
      ->orderBy('users.id', 'desc')
      ->skip($start)
      ->take($rowperpage);

      if($request->from != null) {
        $start_date = $request->from;
        $records->where('users.domainCreationDate', '>=', $start_date);
        if ($request->from == $request->to) {
            $records->orWhere('users.domainCreationDate', '=', $start_date);
        }
     }
        
     if($request->to != null) {
         $end_date = $request->to;
         $records->where('users.domainCreationDate', '<=', $end_date);     
         if ($request->from == $request->to) {
            $records->orWhere('users.domainCreationDate', '=', $end_date);
        }
     }
     
     if($searchValue!=null){
        $records->where('users.domainName', 'like', '%' .$searchValue . '%');
     }
     
     if($request->domain != null){
       $records->where('users.domainName', 'like', '%' .$request->domain . '%');
     }

    if($request->status != null){
        $records->where('users.type', '=', $request->status);
    }

     if($request->state != null){
        $records->where('user_contact_details.state', '=', $request->state);
     }

     if($request->period != null){
        $records->where('users.domainPeriod', '=', $request->period);
     }
    
    $list = $records->get();
    
    $data_arr = array();
    
    foreach($list as $sno => $row){
    
        $view = '<a class="btn btn-outline-primary" data-toggle="tooltip" data-placement="top" title="View More" href="' . route('admin.users-details-view', ['id' => base64_encode($row->id)]) . '">View More</a>';

        if($row->domainExpiryDate>Carbon::now()->format('Y-m-d')){
        $view.='<a href="javascript:void(0)" style="color:blue;margin-left:10px;" class="hold_button" data-id="'.$row->id.'">Hold</a>';
        }

       $data_arr[] = array(
           "id" => ++$start,
           'domain'=>$row->domainName,
           'inst'=>$row->institute,
           'phone'=>$row->phone,
           "period" => $row->domainPeriod,
           "reg_date" =>date('d/m/Y',strtotime($row->domainCreationDate)), 
           "expiry_date" =>date('d/m/Y',strtotime($row->domainExpiryDate)), 
           'action'=>$view
       );
    }
    
    $response = array(
       "draw" => intval($draw),
       "iTotalRecords" =>$totalRecordswithFilter,
       "iTotalDisplayRecords" =>$totalRecordswithFilter,
       "aaData" => $data_arr
    );
    
    echo json_encode($response);
    exit;
    
    }


    public function domainhold(Request $request){

        $user=User::find($request->hold_id);
            
        $epp=new EPP();

        $epp->domainStatusUpdate($user->domainName,'clientHold','add');

        $data['email'] = $user->email;
        $data['name'] = $user->name;
        $data['title'] = 'Your Domain ('.$user->domainName .') has been put Hold';

        $data['content']='Your domain ('.$user->domainName.')  has been put on hold by ERNET India. Kindly, contact ERNET India for further details.';
        $data['remarks'] = $request->hold_remarks;
        
        Mail::send('front.email.domainHoldAdmin', $data, function($message)use($data) {
            $message->to($data["email"], $data["name"])
                    ->subject($data["title"]);
        });
          
        $update=User::where('id',$request->hold_id)->update(['domainStatus'=>7]);

        if($update){
            return response()->json(array('status'=>'success', 'message' => 'Hold Successfully'));
        }
        
        return response()->json(array('errors'=>'erorr', 'message' => 'Something Error'));

    }


    public function domainunhold(Request $request){

        $user=User::find($request->unhold_id);
            
        $epp=new EPP();

        $epp->domainStatusUpdate($user->domainName,'clientHold','rem');

        $data['email'] = $user->email;
        $data['name'] = $user->name;
        $data['title'] = 'Your Domain ('.$user->domainName .') has been Unhold';
        $data['remarks'] = $request->unhold_remarks;
        
        $data['content']='Your domain ('.$user->domainName.')  has been unhold by ERNET India.';
          
        $update=User::where('id',$request->unhold_id)->update(['domainStatus'=>6]);

        if($update){
            return response()->json(array('status'=>'success', 'message' => 'UnHold Successfully'));
        }
        
        return response()->json(array('errors'=>'erorr', 'message' => 'Something Error'));

    }
    
    public function domainhiexport(Request $request){
    
        $list = DB::table('users')->select('users.*','user_contact_details.phone')->where('users.domainStatus',6)
        ->where('users.domainLangID',3)
        ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
      
        if($request->dd1 != null) {
            $start_date = $request->dd1;
            $list->where('users.domainCreationDate', '>=', $start_date);
        }
            
         if($request->dd2 != null) {
             $end_date = $request->dd2;
             $list->where('users.domainCreationDate', '<=', $end_date);     
         }
         
         if($request->domain != null){
            $list->where('users.domainName', '=', $request->domain);
         }
         
          if($request->state != null){
            $list->where('user_contact_details.state', '=', $request->state);
          }

          if($request->period != null){
            $list->where('users.domainPeriod', '=', $request->period);
          }

          if($request->status != null){
            $list->where('users.type', '=', $request->status);
          }
            
            $data = $list->get();
      

        $i = 0;

        $records = array(
            array("Registered/Renewed Hindi Domain List"),
            array(
                "S.NO.",
                "Domain Name",
                "Period (in years)",
                'Institute Name',
                'Phone No',
                'Registration Date',
                'Expiry Date'
            )
        );
        
        foreach ($data as $row) {
            $records[] = array(
                ++$i,
                $row->domainName,
                $row->domainPeriod,
                $row->institute,
                $row->phone,
                date('d/m/Y',strtotime($row->domainCreationDate)),
                date('d/m/Y', strtotime($row->domainExpiryDate))
            );
        }
            
            $filename = "Registered/Renewed Domain List (Hindi) -". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;
    }

    public function whois(){
        return view('reports.whois');
    }

    public function whoisajax(Request $request){
        
        $domain=$request->domain;

        $epp=new EPP();

        $result=$epp->domainInfo($domain);

        $output=xmlConverter($result);

        $r=$output['epp']['response'];

        $dList = $r['resData']['domain:infData'];

        dd($dList);

        if (empty($dList['domain:status'])) {
            $dStatus = [$dList['domain:status_attr']['s']];
        } else {
            $dStatus = [];
            if(is_string())
            foreach ($dList['domain:status'] as $dStatusc) {
                if (isset($dStatusc['s'])) {
                    $dStatus[] = $dStatusc['s'];
                }
            }
        }

        $ns = [];
        if (isset($dList['domain:ns']['domain:hostObj'])) {
            $ns = $dList['domain:ns']['domain:hostObj'];
            sort($ns);
        }

        $host = [];
        if (isset($dList['domain:host'])) {
            $host = is_string($dList['domain:host']) ? [$dList['domain:host']] : $dList['domain:host'];
            sort($host);
        }

        $result = [
            "name" => $dList['domain:name'],
            "roid" => $dList['domain:roid'],
            "status" => is_string($dStatus) ? [$dStatus] : $dStatus,
            "registrant" => $dList['domain:registrant'],
            "contact" => [
                $dList['domain:contact']["0_attr"]["type"] => $dList['domain:contact']["0"],
                $dList['domain:contact']["1_attr"]["type"] => $dList['domain:contact']["1"],
                $dList['domain:contact']["2_attr"]["type"] => $dList['domain:contact']["2"]
            ],
            "ns" => $ns,
            "host" => $host,
            "clID" => $dList['domain:clID'],
            "crID" => $dList['domain:crID'],
            "upID" => isset($dList['domain:upID']) ? $dList['domain:upID'] : "",
            "upDate" => isset($dList['domain:upDate']) ? $dList['domain:upDate'] : "",
            "crDate" => $dList['domain:crDate'],
            "exDate" => ($dList['domain:exDate'] ?? ''),
            "trDate" => isset($dList['domain:trDate']) ? $dList['domain:trDate'] : "",

            "authInfo" => ($dList['domain:authInfo']['domain:pw'] ?? ''),
        ];

        $return = [
            "code" => $r['result_attr']['code'],
            "msg" => $r['result']['msg'],
            "lang" => $r['result']['msg_attr']['lang'],
            "domain" => $result

        ];
        
        dd($return);

        $htmlContent = view('admin.report.program_sales_report_list', compact('results','fromdate','todate'))->render();

        return response()->json(['html' => $htmlContent,'status'=>true]);
        
    }

    public function vas(){
        return view('reports.vas');
    }

    public function vasajax(Request $request){
         
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); 
        
        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');
        
        $columnIndex = $columnIndex_arr[0]['column'];
        $columnName = $columnName_arr[$columnIndex]['data']; 
        $columnSortOrder = $order_arr[0]['dir']; 
        $searchValue = $search_arr['value']; 
      
        $records = DB::table('projects')->select('projects.*','users.domainName')
          ->join('users', 'users.id', 'projects.user_id')
          ->where('projects.status',1)
          ->orderBy('projects.id', 'desc')
          ->skip($start)
          ->take($rowperpage);

        if($request->from != null) {
            $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
    
            if ($request->from == $request->to) {
                $records->whereDate('projects.created_at', '=', $start_date);
            }else{
                $records->where('projects.created_at', '>=', $start_date);
            }
        }
           
        if($request->to != null) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
    
            if ($request->from == $request->to) {
                $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
                $records->whereDate('projects.created_at', '=', $end_date);
            }else{
                $records->where('projects.created_at', '<=', $end_date);
            }
        }
            
         if($searchValue!=null){
            $records->where('users.domainName', 'like', '%' .$searchValue . '%');
         }
         
         if($request->domain != null){
            $records->where('users.domainName', 'like', '%' .$request->domain . '%');
         }

         if($request->vas_type != null){
            $records->where('projects.vas_type', $request->vas_type );
         }
    
        $list = $records->get();
        
        $data_arr = array();
        
        foreach($list as $sno => $row){
            $view = '<a class="btn btn-outline-primary" data-toggle="tooltip" data-placement="top" title="View More" href="' . route('admin.users-details-view', ['id' =>base64_encode($row->id)]) . '">View More</a>';
        
            $period=DB::table('transactions')->select('*')->where('user_id',$row->user_id)->where('transaction_type',$row->vas_type)->first();
            
            if($period){

                $decode=json_decode($period->request);

                $data_arr[] = array(
                    "id" => ++$start,
                    'domain'=>$row->domainName,
                    'temp'=>$row->project_name,
                    'period'=>$decode->years,
                    "type" => $row->vas_type,
                    "date" =>date('d/m/Y',strtotime($row->created_at)), 
                );
                
            }
        
        }
        
        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" =>count($data_arr),
           "iTotalDisplayRecords" =>count($data_arr),
           "aaData" => $data_arr
        );
        
        echo json_encode($response);
        exit;
        
    }

        public function vasexport(Request $request){
    
            $list = DB::table('projects')->select('projects.*','users.domainName')
            ->join('users', 'users.id', 'projects.user_id')
            ->where('projects.status',1);

         

             if($request->dd1 != null && $request->dd2 != null) {
                $start_date = $request->dd1;
                $end_date = $request->dd2;
                if ($request->dd1 != $request->dd2) {
                    $list->where('projects.created_at', '>=', $start_date);
                    $list->where('projects.created_at', '<=', $end_date);   
                }else{
                    $list->where('projects.created_at', '=', $start_date);
                }
             }
             
             if($request->domain != null){
                $list->where('users.domainName', '=', $request->domain);
             }
            
             if($request->vas_type != null){
                $list->where('projects.vas_type', $request->vas_type);
             }
                
            $data = $list->get();
    
            $i = 0;
    
            $records = array(
                array("Value Added Service Report"),
                array(
                    "S.NO.",
                    "Domain Name",
                    "Template Name",
                    "Period (in years)",
                    'Service Type',
                    'Creation Date'
                )
            );
            
            foreach ($data as $row) {

            $period=DB::table('transactions')->select('*')->where('user_id',$row->user_id)->where('transaction_type',$row->vas_type)->first();
            
            if($period){

                $decode=json_decode($period->request);

                $records[] = array(
                    ++$i,
                    $row->domainName,
                    $row->project_name,
                    $decode->years,
                    $row->vas_type,
                    date('d/m/Y',strtotime($row->created_at)), 
                );
                
            }

            }
                
                $filename = "Value Added Service Report -". date('d-m-Y H:i:s a ') . ".xls";
                header("Content-Type: application/vnd.ms-excel");
                header("Content-Disposition: attachment; filename=\"$filename\"");
                $show_column = false;
    
                foreach ($records as $record) {
                    if (!$show_column) {
                        echo implode("\t", array_map(function ($value) {
                            return  $value ;
                        }, $record)) . "\n";
                        $show_column = true;
                    } else {
                        echo implode("\t", $record) . "\n";
                    }
                }
                exit;
        }


    public function nozone(){
        $states=DB::table('regions')->orderBy('description','asc')->get();
        return view('reports.nozone',['states'=>$states]);
    }

    public function nozoneajax(Request $request){
         
    $draw = $request->get('draw');
    $start = $request->get("start");
    $rowperpage = $request->get("length"); 
    
    $columnIndex_arr = $request->get('order');
    $columnName_arr = $request->get('columns');
    $order_arr = $request->get('order');
    $search_arr = $request->get('search');
    
    $columnIndex = $columnIndex_arr[0]['column'];
    $columnName = $columnName_arr[$columnIndex]['data']; 
    $columnSortOrder = $order_arr[0]['dir']; 
    $searchValue = $search_arr['value']; 
    
    $totalRecords = DB::table('users')->select('count(*) as allcount')->where('users.domainStatus',6)
    ->where('users.zone_file',0)
    ->where('user_name_servers.server_type',1)->join('user_name_servers','user_name_servers.user_id','users.id')
    ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');

    if($request->from != null) {
        $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');

        if ($request->from == $request->to) {
            $totalRecords->whereDate('users.domainCreationDate', '=', $start_date);
        }else{
            $totalRecords->where('users.domainCreationDate', '>=', $start_date);
        }
    }
       
    if($request->to != null) {
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');

        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $totalRecords->whereDate('users.domainCreationDate', '=', $end_date);
        }else{
            $totalRecords->where('users.domainCreationDate', '<=', $end_date);
        }
    }
    
    if($searchValue!=null){
       $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
    }
    
    if($request->domain != null){
       
       $totalRecords->where('users.domainName', 'like', '%' .$request->domain . '%');
    }

    if($request->state != null){
        $totalRecords->where('user_contact_details.state', '=', $request->state);
    }
    
    $totalRecordswithFilter = $totalRecords->count();

    $records = DB::table('users')->select('users.*','user_contact_details.phone')
      ->where('users.domainStatus',6)
      ->where('users.zone_file',0)
      ->where('user_name_servers.server_type',1)->join('user_name_servers','user_name_servers.user_id','users.id')
      ->join('user_contact_details', 'users.id', 'user_contact_details.user_id')
      ->orderBy('users.domainCreationDate', 'desc')
      ->skip($start)
      ->take($rowperpage);

     
    if($request->from != null) {
        $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');

        if ($request->from == $request->to) {
            $records->whereDate('users.domainCreationDate', '=', $start_date);
        }else{
            $records->where('users.domainCreationDate', '>=', $start_date);
        }
    }
       
    if($request->to != null) {
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');

        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $records->whereDate('users.domainCreationDate', '=', $end_date);
        }else{
            $records->where('users.domainCreationDate', '<=', $end_date);
        }
    }

     if($searchValue!=null){
        $records->where('users.domainName', 'like', '%' .$searchValue . '%');
     }
     
     if($request->domain != null){
        $records->where('users.domainName', 'like', '%' .$request->domain . '%');
     }

     if($request->state != null){
        $records->where('user_contact_details.state', '=', $request->state);
    }
    
    $list = $records->get();
    
    $data_arr = array();
    
    foreach($list as $sno => $row){
        $view = '<a class="btn btn-outline-primary" data-toggle="tooltip" data-placement="top" title="View More" href="' . route('admin.users-details-view', ['id' =>base64_encode($row->id)]) . '">View More</a>';
    
       $data_arr[] = array(
           "id" => ++$start,
           'domain'=>$row->domainName,
           'inst'=>$row->institute,
           'phone'=>$row->phone,
           "period" => $row->domainPeriod,
           "reg_date" =>date('d/m/Y',strtotime($row->domainCreationDate)), 
           'action'=>$view,
       );
    }
    
    $response = array(
       "draw" => intval($draw),
       "iTotalRecords" =>$totalRecordswithFilter,
       "iTotalDisplayRecords" =>$totalRecordswithFilter,
       "aaData" => $data_arr
    );
    
    echo json_encode($response);
    exit;
    
    }
    
    public function nozoneexport(Request $request){
    
        $list = DB::table('users')->select('users.*','user_contact_details.phone')->where('users.domainStatus',6)
        ->where('users.zone_file',0)
        ->where('user_name_servers.server_type',1)->join('user_name_servers','user_name_servers.user_id','users.id')
        ->join('user_contact_details', 'users.id', 'user_contact_details.user_id');
    
        if($request->dd1 != null) {
            $start_date=Carbon::parse($request->dd1)->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $list->whereDate('users.domainCreationDate', '=', $start_date);
            }else{
                $list->where('users.domainCreationDate', '>=', $start_date);
            }
         }
            
         if($request->dd2 != null) {
            $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d');
                $list->whereDate('users.domainCreationDate', '=', $end_date);
            }else{
                $list->where('users.domainCreationDate', '<=', $end_date);         
            }  
         }
         
         if($request->domain != null){
            $list->where('users.domainName', '=', $request->domain);
         }

         
         if($request->state != null){
            $list->where('user_contact_details.state', '=', $request->state);
          }
            
            $data = $list->get();
      

        $i = 0;

        $records = array(
            array("Domain With No Zone List"),
            array(
                "S.NO.",
                "Domain Name",
                "Period (in years)",
                'Institute Name',
                'Phone No',
                'Registration Date',
            )
        );
        
        foreach ($data as $row) {
            $records[] = array(
                ++$i,
                $row->domainName,
                $row->domainPeriod,
                $row->institute,
                $row->phone,
                date('d/m/Y',strtotime($row->domainCreationDate)),
            );
        }
            
            $filename = "Domain With No Zone List-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;
    }

    public function nodnsrecord(){
        $states=DB::table('regions')->orderBy('description','asc')->get();
        return view('reports.nodnsrecord',['states'=>$states]);
    }

    public function nodnsrecordajax(Request $request){
         
    $draw = $request->get('draw');
    $start = $request->get("start");
    $rowperpage = $request->get("length"); 
    
    $columnIndex_arr = $request->get('order');
    $columnName_arr = $request->get('columns');
    $order_arr = $request->get('order');
    $search_arr = $request->get('search');
    
    $columnIndex = $columnIndex_arr[0]['column'];
    $columnName = $columnName_arr[$columnIndex]['data']; 
    $columnSortOrder = $order_arr[0]['dir']; 
    $searchValue = $search_arr['value']; 
    
    $totalRecords = DB::table('user_name_servers')->select('count(*) as allcount')
    ->where('user_name_servers.server_type',2)
    ->whereIn('users.domainStatus',[6])
    ->join('users','users.id','user_name_servers.user_id');


    if($request->from != null) {
        $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');

        if ($request->from == $request->to) {
            $totalRecords->whereDate('users.domainCreationDate', '=', $start_date);
        }else{
            $totalRecords->where('users.domainCreationDate', '>=', $start_date);
        }
    }
       
    if($request->to != null) {
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');

        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $totalRecords->whereDate('users.domainCreationDate', '=', $end_date);
        }else{
            $totalRecords->where('users.domainCreationDate', '<=', $end_date);
        }
    }

    
    if($searchValue!=null){
       $totalRecords->where('users.domainName', 'like', '%' .$searchValue . '%');
    }
    
    if($request->domain != null){
        $totalRecords->where('users.domainName', 'like', '%' .$request->domain . '%');
    }

    if($request->state != null){
        $totalRecords->where('user_contact_details.state', '=', $request->state);
    }
    
    $totalRecordswithFilter = $totalRecords->count();

    $records = DB::table('user_name_servers')->select('users.*')
      ->where('user_name_servers.server_type',2)
      ->whereIn('users.domainStatus',[6])
      ->join('users','users.id','user_name_servers.user_id')
      ->orderBy('users.domainCreationDate', 'desc')
      ->skip($start)
      ->take($rowperpage);


     if($request->from != null) {
        $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');

        if ($request->from == $request->to) {
            $records->whereDate('users.domainCreationDate', '=', $start_date);
        }else{
            $records->where('users.domainCreationDate', '>=', $start_date);
        }
    }
       
    if($request->to != null) {
        $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');

        if ($request->from == $request->to) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
            $records->whereDate('users.domainCreationDate', '=', $end_date);
        }else{
            $records->where('users.domainCreationDate', '<=', $end_date);
        }
    }
     
     if($searchValue!=null){
        $records->where('users.domainName', 'like', '%' .$searchValue . '%');
     }
     
     if($request->domain != null){
        $records->where('users.domainName', 'like', '%' .$request->domain . '%');
     }

     if($request->state != null){
        $records->where('user_contact_details.state', '=', $request->state);
    }
    
    $list = $records->get();
    
    $data_arr = array();
    
    foreach($list as $sno => $row){

        
        $detailurl=url('ernetdash/admin-users-details').'/'.base64_encode($row->id);

        $action='<a class="btn btn-outline-primary mx-2" data-toggle="tooltip" data-placement="top"
        title="Edit" href="'.$detailurl.'"> <i class="fa fa-edit"></i></a>';

    
       $data_arr[] = array(
           "id" => ++$start,
           'domain'=>$row->domainName,
           'inst'=>$row->institute,
           'email'=>$row->email,
           "period" => $row->domainPeriod,
           "reg_date" =>date('d/m/Y',strtotime($row->domainCreationDate)), 
           'action'=>$action
       );
    }
    
    $response = array(
       "draw" => intval($draw),
       "iTotalRecords" =>$totalRecordswithFilter,
       "iTotalDisplayRecords" =>$totalRecordswithFilter,
       "aaData" => $data_arr
    );
    
    echo json_encode($response);
    exit;
    
    }

    public function nodnsrecordexport(Request $request){
        
        $list = DB::table('users')->select('users.*')
        ->whereIn('users.domainStatus',[6])
        ->where('user_name_servers.server_type',2)
        ->join('user_name_servers','user_name_servers.user_id','users.id');

      
        if($request->dd1 != null) {
            $start_date=Carbon::parse($request->dd1)->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $list->whereDate('users.domainCreationDate', '=', $start_date);
            }else{
                $list->where('users.domainCreationDate', '>=', $start_date);
            }
         }
            
         if($request->dd2 != null) {
            $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d');
                $list->whereDate('users.domainCreationDate', '=', $end_date);
            }else{
                $list->where('users.domainCreationDate', '<=', $end_date);         
            }  
         }
         
         if($request->domain != null){
            $list->where('users.domainName', '=', $request->domain);
         }

            
            $data = $list->get();
      

        $i = 0;

        $records = array(
            array("Domains with Other Name Server"),
            array(
                "S.NO.",
                "Domain Name",
                "Period (in years)",
                'Institute Name',
                'Email',
                'Registration Date',
            )
        );
        
        foreach ($data as $row) {
            $records[] = array(
                ++$i,
                $row->domainName,
                $row->domainPeriod,
                $row->institute,
                $row->email,
                date('d/m/Y',strtotime($row->domainCreationDate)),
            );
        }
            
            $filename = "Domains with Other Name Server-". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;
    }


    public function payment(){
        $transaction_type = DB::table('transactions')->select('transaction_type')->whereNotNull('transaction_type')->distinct()->get();
        return view('reports.payment',compact('transaction_type'));
    }

    
    public function billdeskpayment(){
        $states=DB::table('regions')->orderBy('description','asc')->get();
        return view('reports.billdesk',['states'=>$states]);
    }

    public function billdeskpaymentajax(Request $request){
         
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); 

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');
        $columnIndex = $columnIndex_arr[0]['column']; 
        $columnName = $columnName_arr[$columnIndex]['data']; 
        $columnSortOrder = $order_arr[0]['dir']; 
        $searchValue = $search_arr['value']; 

        $countData = DB::table('transactions')->leftJoin('users', 'users.id', '=', 'transactions.user_id')
        ->where('transactions.transaction_status','0300');
       
     
        if($request->trns_type != null){
            $countData->where('transactions.transaction_type',  'LIKE', $request->trns_type . '%');
        }


        if($request->from != null) {
            $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
    
            if ($request->from == $request->to) {
                $countData->whereDate('transactions.created_at', '=', $start_date);
            }else{
                $countData->where('transactions.created_at', '>=', $start_date);
            }
        }
           
        if($request->to != null) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
    
            if ($request->from == $request->to) {
                $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
                $countData->whereDate('transactions.created_at', '=', $end_date);
            }else{
                $countData->where('transactions.created_at', '<=', $end_date);
            }
        }

      
         if($request->domain != null){
            $countData->where('users.domainName',$request->domain);
         }

         if($request->status != null){
            if($request->status==1){
                $countData->whereIn('users.domainStatus',[1,2,3,4,0]);
            }else{
                $countData->where('users.domainStatus',$request->status);
            }
         }


         if($request->period != null){
            $countData->where('transactions.period', '=', $request->period);
         }

         if($request->state != null){
            $countData->where('transactions.state_name', '=', $request->state);
         }

         if($request->trans_id != null){
            $countData->where('transactions.transaction_id', '=', $request->trans_id);
          }

          if($request->order_id != null){
            $countData->where('transactions.reference_id', '=', $request->order_id);
          }
         

          $totalRecordswithFilter = $countData->count();


        $totalRecords = $totalRecordswithFilter;
        $records = DB::table('transactions')->select('users.domainName','transactions.*')
        ->where('transactions.transaction_status','0300')
        ->leftJoin('users', 'transactions.user_id', '=', 'users.id')
        ->orderBy('transactions.created_at', 'desc');
         
            
        if($request->from != null) {
            $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
            if ($request->from == $request->to) {
                $records->whereDate('transactions.created_at', '=', $start_date);
            }else{
                $records->where('transactions.created_at', '>=', $start_date);
            }
        }
           
        if($request->to != null) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
    
            if ($request->from == $request->to) {
                $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
                $records->whereDate('transactions.created_at', '=', $end_date);
            }else{
                $records->where('transactions.created_at', '<=', $end_date);
            }
        }
             if($request->trns_type != null){
                $records->where('transactions.transaction_type',  'LIKE', $request->trns_type . '%');
             }
             if($request->domain != null){
                $records->where('users.domainName',$request->domain);
              }

              
              if($request->status != null){
                if($request->status==1){
                    $records->whereIn('users.domainStatus',[1,2,3,4,0]);
                }else{
                    $records->where('users.domainStatus',$request->status);
                }
             }
    

              if($request->period != null){
                $records->where('transactions.period', '=', $request->period);
              }

              if($request->trans_id != null){
                $records->where('transactions.transaction_id', '=', $request->trans_id);
              }

              if($request->order_id != null){
                $records->where('transactions.reference_id', '=', $request->order_id);
              }

              if($request->state != null){
                $records->where('transactions.state_name', '=', $request->state);
             }
             

        $list = $records->skip($start)->take($rowperpage)->get();

        $data_arr = array();

        foreach($list as $sno => $record){
                $id = $record->id;
                $txnAmount=$record->total_amount;

                $recordCreatedAt = $record->created_at;

                $dateTimeUTC = Carbon::parse($recordCreatedAt, 'Asia/Kolkata');
                $dateTimeIST = $dateTimeUTC->setTimezone('Asia/Kolkata');

                $formattedDate = $dateTimeIST->format('d-m-Y h:i a');

                $type='';

                if($record->transaction_type=='domainRegister'){
                    $type='Domain Registration Fee';
                }else if(trim($record->transaction_type)=='nameServerUpdate'){
                   $type='Ernet Name Server Fee';
                }else if($record->transaction_type=='domainRenewal'){
                   $type='Domain Renewal Fee';
                }else if($record->transaction_type=='domainRegisterWithNameServer'){
                   $type='Domain and DNS Fee';
                }else if($record->transaction_type=='userNameServerUpdate'){
                   $type='Name Server Update Fee';
                }else if($record->transaction_type=='ewaas'){
                    $type='WaaS Service';
                }else{
                   $type=$record->transaction_type;
                }

                $userId = $id; 
                $url = url('ernetdash/userParticularInvoice?id=' . $userId);

                $inv='<a href="'.$url.'" target="_blank" title="download payment invoice">Invoice</a>';

                $rec="R000$record->user_id/$record->id"; 

                $data_arr[] = array(
                    "id" => ++$start,
                    'trans'=>$record->transaction_id,
                    "ref" => $record->reference_id,
                    "status"=>$type,
                    "domain"=>$record->domainName!=null?$record->domainName:$record->domain,
                    "period"=>$record->duration==null?$record->period:$record->duration,
                    "org" => $record->org,
                    "add" => $record->address,
                    "state" => $record->state_name,
                    "gst_no" => $record->gst_no,
                    "amount" => $record->total_amount,
                    "created_at" =>$formattedDate,
                    "recp"=>$rec,
                    "inv"=>$inv
                );
            
        }
        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecords,
            "iTotalDisplayRecords" => $totalRecordswithFilter,
            "aaData" => $data_arr
        );

        echo json_encode($response);
        exit;
    
    }

    public function billdeskgettotalamount(Request $request){

        $countData=DB::table('transactions')
        ->select('transactions.*','users.domainName')
        ->leftJoin('users', 'transactions.user_id', '=', 'users.id')
        ->where('transactions.transaction_status','0300')
        ->orderBy('transactions.id','desc');
    
        if($request->from == null || $request->to == null) {

            $date=date('Y-m-d');
            $countData->whereDate('transactions.created_at', '=', $date);
        
        }

        if($request->from != null) {
            $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
    
            if ($request->from == $request->to) {
                $countData->whereDate('transactions.created_at', '=', $start_date);
            }else{
                $countData->where('transactions.created_at', '>=', $start_date);
            }
        }
           
        if($request->to != null) {
            $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d H:i:s');
    
            if ($request->from == $request->to) {
                $end_date=Carbon::parse($request->to)->endOfDay()->format('Y-m-d');
                $countData->whereDate('transactions.created_at', '=', $end_date);
            }else{
                $countData->where('transactions.created_at', '<=', $end_date);
            }
        }

        if($request->trns_type != null){
            $countData->where('transactions.transaction_type',  'LIKE', $request->trns_type . '%');
        }


        if($request->domain != null){
            $countData->where('users.domainName', 'like', '%' .$request->domain . '%');
         }

         if($request->period != null){
            $countData->where('transactions.period', '=', $request->period);
         }

         if($request->state != null){
            $countData->where('transactions.state_name', '=', $request->state);
         }

         if($request->trans_id != null){
            $countData->where('transactions.transaction_id', '=', $request->trans_id);
          }

          if($request->order_id != null){
            $countData->where('transactions.reference_id', '=', $request->order_id);
          }
         
          $total_Amount=$countData->sum('transactions.total_amount');
       
        return response()->json(['totalamount'=>$total_Amount]);
    }



  public function updatePaymentRecord(Request $request){

   $users = DB::table('transactions')
   ->where('transaction_status','0002')
   ->where('id',$request->id)->get();

     foreach ($users as $user){
  
      $data=DB::table('payment_gateway_setting')->where('id',2)->first();

      $mid = $data->merchant_id;
      $secretKey = $data->checksum_key;
      $clientId = $data->security_id;

      $payloadData = [
          "mercid" => $mid,
          "orderid" =>$user->reference_id ,
      ];
              
      $traceid = uniqid();
      $currentTimestamp = time();

      $headers = ["alg" => "HS256", "clientid" => $clientId, "kid" => "HMAC"];

       $curl_payload = JWT::encode($payloadData, $secretKey, "HS256", null ,$headers);

      $apiurl="https://api.billdesk.com/payments/ve1_2/transactions/get";

      $curl = curl_init($apiurl);
      curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($curl, CURLOPT_HTTPHEADER, [
          'Content-Type: application/jose', 
          'Accept: application/jose', 
          'BD-Traceid: ' . $traceid, 
          'BD-Timestamp: ' . $currentTimestamp,
      ]);
       
      curl_setopt($curl, CURLOPT_POST, true);
      curl_setopt($curl, CURLOPT_POSTFIELDS, $curl_payload);
       
      $result = curl_exec($curl);
      
      curl_close($curl);

      $encodedString = $result;
 
      $decodedresponse = JWT::decode($encodedString, new Key($secretKey, 'HS256'));

      try{

        if (property_exists($decodedresponse, 'status')) {

            return response()->json(['status'=>false,'message'=>'Payment Record not found on billdesk']);           

        }else{

            if ($decodedresponse->auth_status=='0300'){

                $trans=DB::table('transactions')->where('reference_id',$decodedresponse->orderid)->where('transaction_status','0002')->first();
                
                $status=false;
      
                if($trans!=null){
      
                    $payment_type = $trans->transaction_type;
                    $user_id=$trans->user_id;
        
                    $status=DB::table('transactions')->where('reference_id','=',$decodedresponse->orderid)->update(
                        [
                            'transaction_status'=>'0300',
                            'transaction_id'=>$decodedresponse->transactionid,
                            'response'=>json_encode($decodedresponse),
                            'response_format'=>'cron'
                        ]
                    );
        
                }
      
              
                if($status){
      
                    if ($payment_type == 'domainRegister'){
                        $updated_date = date('Y-m-d H:i:s');
                        $user = User::find($user_id);
                        $user->domainStatus = 3;
                        $user->updated_at = $updated_date;
                        $user->save();
        
                        if($trans->dns!='' && $trans->dns!=null){
      
                            $nameserver=json_decode($trans->dns,true);
        
                            DB::table('user_name_servers')
                                ->updateOrInsert(
                                ['user_id' => $user_id],
                                $nameserver
                            );
      
                        }
                       
        
                        if(Session::get('dnsse_data')!=null){
        
                            $dns_id = DB::table('user_name_servers')->where('user_id','=', $user_id)->first()->id;
                            DB::table('dns_security-extension')->where('user_dns_server_id','=',$dns_id)->delete();
                            
                            foreach (Session::get('dnsse_data') as $dnssec){
                                $dnssec['user_dns_server_id'] = $dns_id;
                                DB::table('dns_security-extension')->insert($dnssec);
                            }
        
                        }
                        
      
                    }elseif ($payment_type == 'domainRegisterWithNameServer'){
                        
                        $nameserver=json_decode($trans->dns);
                        
                        DB::table('user_name_servers')
                            ->updateOrInsert(
                                ['user_id' => $user_id],
                                [
                                      "user_id" => $user_id,
                                      "server_type" => $nameserver->server_type??1,
                                      "primary_name_server" => $nameserver->primary_name_server??'',
                                      "secondary_name_server1" => $nameserver->secondary_name_server1??'',
                                      "secondary_name_server2" => $nameserver->secondary_name_server2??'',
                                      "secondary_name_server3" => $nameserver->secondary_name_server3??'',
                                      "secondary_name_server4" => $nameserver->secondary_name_server4??'',
                                      "secondary_name_server5" => $nameserver->secondary_name_server5??'',
                                      "ernet_name_server_duration_year" => $nameserver->ernet_name_server_duration_year??1,
                                ]
        
                            );
            
                        $updated_date = date('Y-m-d H:i:s');
                        $user = User::find($user_id);
                        $user->domainStatus = 3;
                        $user->updated_at = $updated_date;
                        $user->save();
        
                   
                    }elseif ($payment_type == 'nameServerUpdate'){
                        $nameserver1=json_decode($trans->dns);
                        
                        DB::table('user_name_servers')
                            ->updateOrInsert(
                                ['user_id' => $user_id],
                                [
                                      "user_id" => $user_id,
                                      "server_type" => $nameserver1->server_type??1,
                                      "primary_name_server" => $nameserver1->primary_name_server??'',
                                      "secondary_name_server1" => $nameserver1->secondary_name_server1??'',
                                      "secondary_name_server2" => $nameserver1->secondary_name_server2??'',
                                      "secondary_name_server3" => $nameserver1->secondary_name_server3??'',
                                      "secondary_name_server4" => $nameserver1->secondary_name_server4??'',
                                      "secondary_name_server5" => $nameserver1->secondary_name_server5??'',
                                      "ernet_name_server_duration_year" => $nameserver1->ernet_name_server_duration_year??1,
                                ]
                            );
        
                            $namserver=DB::table('user_name_servers')->where('user_id',$user_id)->first();
        
                            if($namserver!=null){
                                
                            $savedns=[
                                $namserver->primary_name_server,
                                $namserver->secondary_name_server1,
                            ];
                        
                            $paramscreate=[
                                'ns1'=>[
                                    'host'=>$namserver->primary_name_server,
                                    'ip4'=>$namserver->primary_name_server_ip,
                                    'ip6'=>$namserver->primary_name_server_ip6,
                                ],
                                'ns2'=>[
                                    'host'=>$namserver->secondary_name_server1,
                                    'ip4'=>$namserver->secondary_name_server1_ip,
                                    'ip6'=>$namserver->secondary_name_server1_ip6,
                                ],
                            ];
                        
                            if($namserver->secondary_name_server2!=null){
                                $paramscreate['ns3']=[
                                    'host'=>$namserver->secondary_name_server2,
                                    'ip4'=>$namserver->secondary_name_server2_ip,
                                    'ip6'=>$namserver->secondary_name_server2_ip6,
                                ];
                                array_push($savedns,$namserver->secondary_name_server2);
                            }
                        
                            if($namserver->secondary_name_server3!=null){
                                $paramscreate['ns4']=[
                                    'host'=>$namserver->secondary_name_server3,
                                    'ip4'=>$namserver->secondary_name_server3_ip,
                                    'ip6'=>$namserver->secondary_name_server3_ip6,
                                ];
                                array_push($savedns,$namserver->secondary_name_server3);
                            }
                        
                            if($namserver->secondary_name_server4!=null){
                                $paramscreate['ns5']=[
                                    'host'=>$namserver->secondary_name_server4,
                                    'ip4'=>$namserver->secondary_name_server4_ip,
                                    'ip6'=>$namserver->secondary_name_server4_ip6,
                                ];
                                array_push($savedns,$namserver->secondary_name_server4);
                            }
                        
                            if($namserver->secondary_name_server5!=null){
                                $paramscreate['ns6']=[
                                    'host'=>$namserver->secondary_name_server5,
                                    'ip4'=>$namserver->secondary_name_server5_ip,
                                    'ip6'=>$namserver->secondary_name_server5_ip6,
                                ];
                                array_push($savedns,$namserver->secondary_name_server5);
                            }
        
                        
                            $epp=new EPP();
                        
                            $user = DB::table('users')->where('id',$user_id)->first();
                        
                            $respone=$epp->domainInfo($user->domainName);
                        
                            $xml = new \SimpleXMLElement($respone);
                        
                            $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                        
                            $nameservers = $xml->xpath('//domain:hostObj');
                        
                            $remNSD = array();
                            foreach ($nameservers as $nameserver) {
                             $remNSD[] = (string) $nameserver;
                            }
                            $res=$epp->domainupdateNameServerLatest($user->domainName,$paramscreate,$savedns,$remNSD);
      
                           
        
                            $updated_date = date('Y-m-d H:i:s');
        
                            $status = DB::table('zones')
                            ->updateOrInsert(
                                ['user_id' => $user_id],
                                [
                                    'server'=>$namserver->primary_name_server,
                                    'user_id' => $user_id,
                                    'domain'=>$user->domainPunycode,
                                    'reverse_zone'=>1,
                                    'custom_settings'=>0,
                                    'refresh'=>0,
                                    'retry'=>7200,
                                    'expire'=>3628800,
                                    'negative_ttl'=>0,
                                    'default_ttl'=>345640,
                                    'updated_at'=>$updated_date
                                ]
                            );
        
                            $zone=Zone::where('domain',$user->domainPunycode)->first();
               
                            
        
                        }
                     
                    }elseif ($payment_type == 'userNameServerUpdate'){
                        
                        if($trans->dns!='' && $trans->dns!=null){
      
                            $nameserver=json_decode($trans->dns,true);
        
                            DB::table('user_name_servers')
                                ->updateOrInsert(
                                ['user_id' => $user_id],
                                $nameserver
                            );
      
                        }
      
                        $dns_record = DB::table('user_name_servers')->where('user_id','=', $user_id)->first();
        
                        $dns_id = $dns_record->id;
        
                        DB::table('dns_security-extension')->where('user_dns_server_id','=',$dns_id)->delete();
                        
                        if(Session::get('dnsse_data')!=null){
        
                            foreach (Session::get('dnsse_data') as $dnssec){
                                $dnssec['user_dns_server_id'] = $dns_id;
                                DB::table('dns_security-extension')->insert($dnssec);
                            }
        
                        }
        
                        $namserver=DB::table('user_name_servers')->where('user_id',$user_id)->first();
        
                        $savedns=[
                            $namserver->primary_name_server,
                            $namserver->secondary_name_server1,
                        ];
                    
                        $paramscreate=[
                            'ns1'=>[
                                'host'=>$namserver->primary_name_server,
                                'ip4'=>$namserver->primary_name_server_ip,
                                'ip6'=>$namserver->primary_name_server_ip6,
                            ],
                            'ns2'=>[
                                'host'=>$namserver->secondary_name_server1,
                                'ip4'=>$namserver->secondary_name_server1_ip,
                                'ip6'=>$namserver->secondary_name_server1_ip6,
                            ],
                        ];
                    
                        if($namserver->secondary_name_server2!=null){
                            $paramscreate['ns3']=[
                                'host'=>$namserver->secondary_name_server2,
                                'ip4'=>$namserver->secondary_name_server2_ip,
                                'ip6'=>$namserver->secondary_name_server2_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server2);
                        }
                    
                        if($namserver->secondary_name_server3!=null){
                            $paramscreate['ns4']=[
                                'host'=>$namserver->secondary_name_server3,
                                'ip4'=>$namserver->secondary_name_server3_ip,
                                'ip6'=>$namserver->secondary_name_server3_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server3);
                        }
                    
                        if($namserver->secondary_name_server4!=null){
                            $paramscreate['ns5']=[
                                'host'=>$namserver->secondary_name_server4,
                                'ip4'=>$namserver->secondary_name_server4_ip,
                                'ip6'=>$namserver->secondary_name_server4_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server4);
                        }
                    
                        if($namserver->secondary_name_server5!=null){
                            $paramscreate['ns6']=[
                                'host'=>$namserver->secondary_name_server5,
                                'ip4'=>$namserver->secondary_name_server5_ip,
                                'ip6'=>$namserver->secondary_name_server5_ip6,
                            ];
                            array_push($savedns,$namserver->secondary_name_server5);
                        }
                    
                        $epp=new EPP();
                    
                        $user = DB::table('users')->where('id',$user_id)->first();
                    
                        $respone=$epp->domainInfo($user->domainName);
                    
                        $xml = new \SimpleXMLElement($respone);
        
                        $xmlElement = new \SimpleXMLElement($respone);
                        $xmlElement->registerXPathNamespace('secDNS', 'urn:ietf:params:xml:ns:secDNS-1.1');
                    
                        $dsDataArray = [];
                        $dsDataElements = $xmlElement->xpath('//secDNS:dsData');
                    
                        if($dsDataElements!=null){
                            foreach ($dsDataElements as $dsDataElement) {
                                $dsDataArray[] = [
                                    'keyTag' => (string) $dsDataElement->children('secDNS', true)->keyTag,
                                    'alg' => (string) $dsDataElement->children('secDNS', true)->alg,
                                    'digestType' => (string) $dsDataElement->children('secDNS', true)->digestType,
                                    'digest' => (string) $dsDataElement->children('secDNS', true)->digest
                                ];
                            }
                            $res=$epp->domainremDNSSEC($user->domainName,$dsDataArray);
                        }
                    
                        $xml->registerXPathNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                    
                        $nameservers = $xml->xpath('//domain:hostObj');
                    
                        $remNSD = array();
                        foreach ($nameservers as $nameserver) {
                         $remNSD[] = (string) $nameserver;
                        }
                    
                      
                        $res=$epp->domainupdateNameServerLatest($user->domainName,$paramscreate,$savedns,$remNSD);
                        
                        $dsdtaas=DB::table('dns_security-extension')->where('user_dns_server_id',$namserver->id)->get();
        
                        $addDsData=[];
        
                        foreach ($dsdtaas as $name) {
                            if($name->key_tag!=null || $name->key_tag!=''){
                            $addDsData[] = [
                                'keyTag' => $name->key_tag,
                                'alg' => $name->algorithm,
                                'digestType' => $name->digest_type=='SHA1'?"1":'',
                                'digest' => $name->digest,
                            ];
                            }
                        }
        
                        $res=$epp->domainupdateDNSSEC($user->domainName,$addDsData);
        
                        $data['title'] = 'Name server of your domain ('.Auth::user()->domainName.') has been updated';
                        $data['email'] = Auth::user()->email;
                        $data['name'] = Auth::user()->name;
                        $data['domain'] = Auth::user()->domainName;
                        Mail::send('front.email.user-name-server-updated', $data, function($message)use($data) {
                            $message->to($data["email"], $data["name"])
                                ->subject($data["title"]);
                        });
        
                    
        
                        if($dns_record->server_type==2){
        
                            $zone=Zone::where('domain',$user->domainPunycode)->first();
               
                            if($zone!=null){
                                $this->deletezone($zone);
                            }
        
                        }
        
                    }elseif ($payment_type == 'domainRenewal'){
                        $updated_date = date('Y-m-d H:i:s');
                        $user = User::find($user_id);
      
                        $update = DB::table('user_documents')
                        ->where('user_id','=', $user_id)
                        ->update(['status'=>1]);
      
                        $domainPrice = $trans->total_amount;
                        $user->domainPrice = $domainPrice;
                        $user->domainStatus = 10;
      
                        if($user->renew_years==1){
                            $user->renew_years = $trans->period-1;
                        }else if($user->renew_years==2){
                            $user->renew_years = $trans->period-2;   
                        }else{
                            $user->renew_years = $trans->period;
                        }
      
                        $user->updated_at = $updated_date;
                        $user->save();
           
                        $user2 = User::find($user_id);
      
                        $epp=new EPP();
                
                        $expiryDate = Carbon::parse($user2->domainExpiryDate);
                        $currentDate = Carbon::now();
                
                    if ($currentDate->diffInDays($expiryDate) >= 40) {
                
                    $futureDate = $expiryDate->addDays(40);
                
                    $orderDate = $futureDate->format('Y-m-d\TH:i:s\.0\Z');
                
                    $currentDateTime = Carbon::now('Asia/Kolkata');
                
                    $outputDateTime = $currentDateTime->format('Y-m-d\TH:i:s\.0\Z');
                
                    $epp->domainRestoreRequest($user2->domainName);
                
                    $epp->domainRestoreReport($user2->domainName,$orderDate,$outputDateTime);
                
                    $epp->domainStatusUpdate($user2->domainName,'clientHold','add');
      
                    }
                            
                    }

                    return response()->json(['status'=>true,'message'=>'Payment Updated Successfully']);
      
                }
               
            }else{

               
                return response()->json(['status'=>false,'message'=>$decodedresponse->transaction_error_desc]);
                
            }

        }



      }catch(\Throwable $e){

        return response()->json(['status'=>false,'message'=>$e->getMessage()]);

        
      }


    }

    }

    public function failedpayment(){
        $transaction_type = DB::table('transactions')->select('transaction_type')->whereNotNull('transaction_type')->distinct()->get();
        return view('reports.failed',compact('transaction_type'));
    }

    public function failedpaymentajax(Request $request){
         
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); 

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');
        $columnIndex = $columnIndex_arr[0]['column']; 
        $columnName = $columnName_arr[$columnIndex]['data']; 
        $columnSortOrder = $order_arr[0]['dir']; 
        $searchValue = $search_arr['value']; 

        $countData = DB::table('transactions')->join('users', 'users.id', '=', 'transactions.user_id')
        ->where('transactions.transaction_status','0002');
      
         if($request->domain != null){
            $countData->where('users.domainName',$request->domain);
         }

         if($request->period != null){
            $countData->where('users.domainPeriod', '=', $request->period);
         }

         
        if ($request->from != null) {
            $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');

            if ($request->from == $request->to) {
                $countData->whereDate('transactions.created_at', '=', $start_date);
            }else{
                $countData->where('transactions.created_at', '>=', $start_date);
            }
        }
        
        if ($request->to != null) {
            $end_date=Carbon::parse($request->from)->endOfDay()->format('Y-m-d H:i:s');

            if ($request->from == $request->to) {
                $end_date=Carbon::parse($request->from)->endOfDay()->format('Y-m-d');
                $countData->whereDate('transactions.created_at', '=', $end_date);
            }else{
                $countData->where('transactions.created_at', '<=', $end_date);
            }
        }


        if($request->order_id != null){
            $countData->where('transactions.reference_id', '=', $request->order_id);
          }
         

         

        $totalRecordswithFilter = $countData->select(DB::raw('count(*) as allcount'))->count();
        $totalRecords = $totalRecordswithFilter;
        $records = DB::table('transactions')->select('users.domainName','users.domainStatus','transactions.*','users.domainPeriod','users.institute')
        ->where('transactions.transaction_status','0002')
        ->join('users', 'transactions.user_id', '=', 'users.id')
        ->orderBy('transactions.created_at', 'desc');

             if ($request->from != null) {
                $start_date=Carbon::parse($request->from)->format('Y-m-d H:i:s');
    
                if ($request->from == $request->to) {
                    $records->whereDate('transactions.created_at', '=', $start_date);
                }else{
                    $records->where('transactions.created_at', '>=', $start_date);
                }
            }
            
            if ($request->to != null) {
                $end_date=Carbon::parse($request->from)->endOfDay()->format('Y-m-d H:i:s');
    
                if ($request->from == $request->to) {
                    $end_date=Carbon::parse($request->from)->endOfDay()->format('Y-m-d');
                    $records->whereDate('transactions.created_at', '=', $end_date);
                }else{
                    $records->where('transactions.created_at', '<=', $end_date);
                }
            }
    

             if($request->trns_type != null){
                $records->where('transactions.transaction_type', '=', $request->trns_type);
             }
             if($request->domain != null){
                $records->where('users.domainName', 'like', '%' .$request->domain . '%');
              }

             if($request->period != null){
                $records->where('users.domainPeriod', '=', $request->period);
              }

              
        if($request->order_id != null){
            $records->where('transactions.reference_id', '=', $request->order_id);
          }
    

        $list = $records->skip($start)->take($rowperpage)->get();

        $data_arr = array();

        foreach($list as $sno => $record){
            if($record->response_payload){
                $id = $record->id;
                $txnAmount=$record->total_amount;

                $recordCreatedAt = $record->created_at;

                $dateTimeUTC = Carbon::parse($recordCreatedAt, 'Asia/Kolkata');
                $dateTimeIST = $dateTimeUTC->setTimezone('Asia/Kolkata');

                $formattedDate = $dateTimeIST->format('d-m-Y H:i a');

                $type='';

                if($record->transaction_type=='domainRegister'){
                    $type='Domain Registration Fee';
                }else if($record->transaction_type=='nameServerUpdate'){
                   $type='Ernet Name Server Fee';
                }else if($record->transaction_type=='domainRenewal'){
                   $type='Domain Renewal Fee';
                }else if($record->transaction_type=='domainRegisterWithNameServer'){
                   $type='Domain and DNS Fee';
                }else if($record->transaction_type=='userNameServerUpdate'){
                   $type='Name Server Update Fee';
                }else{
                   $type=$record->transaction_type;
                }

            
                $txnref=$record->reference_id;
                $bref=$record->transaction_id;

                $status=$txnref;

                $contact=DB::table('user_contact_details')->where('user_id',$record->user_id)->first();

                $details=$record->institute;
                $domainPeriod = $record->domainPeriod;

                $view = '<a class="btn btn-primary updatePayment" style="color:#fff" data-id="'.$record->id.'">Update</a>';

                $data_arr[] = array(
                    "id" => ++$start,
                    'domain'=>$record->domainName,
                    "type" => $type,
                    "status"=>$status,
                    "period"=>$domainPeriod,
                    "txnAmount" => $txnAmount,
                    "created_at" =>$formattedDate,
                    "action"=>$view
                );
            }
        }
        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecords,
            "iTotalDisplayRecords" => $totalRecordswithFilter,
            "aaData" => $data_arr
        );

        echo json_encode($response);
        exit;
    
    }

    public function gettotalamount(Request $request){

        $transaction=DB::table('transactions')
        ->select('transactions.*','users.domainName','users.domainPeriod')
        ->where('transactions.transaction_status','0300')
        ->join('users', 'transactions.user_id', '=', 'users.id')
        ->orderBy('transactions.created_at','desc');
    

        if ($request->from != null) {
            $start_date = $request->from;
            if ($request->from == $request->to) {
                $transaction->whereDate('transactions.created_at', '=', $start_date);
            }else{
                $transaction->where('transactions.created_at', '>=', $start_date);
            }

        }
        
        if ($request->to != null) {
            $end_date = Carbon::parse($request->to)->endOfDay();
            
            if ($request->from == $request->to) {
                $transaction->whereDate('transactions.created_at', '=', $end_date);
            }else{
                $transaction->where('transactions.created_at', '<=', $end_date);
            }
        }

    
         
         if($request->trns_type != null){
            $transaction->where('transactions.transaction_type', '=', $request->trns_type);
         }

         if($request->domain != null){
            $transaction->where('users.domainName', 'like', '%' .$request->domain . '%');
         }

         if($request->period != null){
            $transaction->where('users.domainPeriod', '=', $request->period);
         }


          $total_Amount=$transaction->sum('transactions.total_amount');

        return response()->json(['totalamount'=>$total_Amount]);
    }
    
    public function paymentajax(Request $request){
         
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); 

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');
        $columnIndex = $columnIndex_arr[0]['column']; 
        $columnName = $columnName_arr[$columnIndex]['data']; 
        $columnSortOrder = $order_arr[0]['dir']; 
        $searchValue = $search_arr['value']; 

        $countData = DB::table('transactions')->join('users', 'users.id', '=', 'transactions.user_id')
        ->where('transactions.transaction_status','0300');
    
        if($request->from != null) {
            $start_date = $request->from;
            $countData->where('transactions.created_at', '>=', $start_date);
            if ($request->from == $request->to) {
                $countData->orWhere('transactions.created_at', '=', $start_date);
            }
        }
        if($request->trns_type != null){
            $countData->where('transactions.transaction_type', '=', $request->trns_type);
         }
         if($request->to != null) {
             $end_date = $request->to;
             $countData->where('transactions.created_at', '<=', $end_date); 
             if ($request->from == $request->to) {
                $countData->orWhere('transactions.created_at', '=', $end_date);
            }    
         }
         
         if($request->domain != null){
            $countData->where('users.domainName', 'like', '%' .$request->domain . '%');
         }

         if($request->period != null){
            $countData->where('users.domainPeriod', '=', $request->period);
         }
         

        $totalRecordswithFilter = $countData->select(DB::raw('count(*) as allcount'))->count();
        $totalRecords = $totalRecordswithFilter;
        $records = DB::table('transactions')->select('users.domainName','users.domainStatus','transactions.*','users.domainPeriod','users.institute')
        ->where('transactions.transaction_status','0300')
        ->join('users', 'transactions.user_id', '=', 'users.id')
        ->orderBy('transactions.id', 'desc');
         
            if($request->from != null) {
                $start_date = $request->from;
                $records->where('transactions.created_at', '>=', $start_date);

                if ($request->from == $request->to) {
                    $records->orWhere('transactions.created_at', '=', $start_date);
                }

            }
                
             if($request->to != null) {
                 $end_date = $request->to;
                 $records->whereDate('transactions.created_at', '<=', $end_date); 
                 if ($request->from == $request->to) {
                    $records->orWhere('transactions.created_at', '=', $end_date);
                }    
             }

             if($request->trns_type != null){
                $records->where('transactions.transaction_type', '=', $request->trns_type);
             }
             if($request->domain != null){
                $records->where('users.domainName', 'like', '%' .$request->domain . '%');
              }

             if($request->period != null){
                $records->where('users.domainPeriod', '=', $request->period);
              }
    

        $list = $records->skip($start)->take($rowperpage)->get();

        $data_arr = array();

        foreach($list as $sno => $record){
            if($record->response_payload){
                $id = $record->id;
                $txnAmount=$record->total_amount;

                $recordCreatedAt = $record->created_at;

                $dateTimeUTC = Carbon::parse($recordCreatedAt, 'Asia/Kolkata');
                $dateTimeIST = $dateTimeUTC->setTimezone('Asia/Kolkata');

                $formattedDate = $dateTimeIST->format('d-m-Y h:i a');

                $type='';

                if($record->transaction_type=='domainRegister'){
                    $type='Domain Registration Fee';
                }else if($record->transaction_type=='nameServerUpdate'){
                   $type='Ernet Name Server Fee';
                }else if($record->transaction_type=='domainRenewal'){
                   $type='Domain Renewal Fee';
                }else if($record->transaction_type=='domainRegisterWithNameServer'){
                   $type='Domain and DNS Fee';
                }else if($record->transaction_type=='userNameServerUpdate'){
                   $type='Name Server Update Fee';
                }else{
                   $type=$record->transaction_type;
                }

            
                $txnref=$record->reference_id;
                $bref=$record->transaction_id;

                $status='Paid (PIG Ref - <br>'.$txnref.' <br>Transaction Id-<br>'.$bref.')';

                $contact=DB::table('user_contact_details')->where('user_id',$record->user_id)->first();

                $details=$record->institute;
                $domainPeriod = $record->domainPeriod;


                $data_arr[] = array(
                    "id" => ++$start,
                    'domain'=>$record->domainName,
                    "type" => $type,
                    "status"=>$status,
                    "details"=>$details,
                    "period"=>$domainPeriod,
                    "txnAmount" => $txnAmount,
                    "created_at" =>$formattedDate,
                );
            }
        }
        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecords,
            "iTotalDisplayRecords" => $totalRecordswithFilter,
            "aaData" => $data_arr
        );

        echo json_encode($response);
        exit;
    
    }
    
    public function paymentexport(Request $request){
    
        $list = DB::table('transactions')->select('transactions.*','users.*')
        ->join('users', 'users.id', 'transactions.user_id') 
        ->orderBy('transactions.id', 'desc');
      
        if($request->dd1 != null) {
            $start_date = $request->dd1;
            $list->where('transactions.updated_at', '>=', $start_date);
        }
            
         if($request->dd2 != null) {
             $end_date = $request->dd2;
             $list->where('transactions.updated_at', '<=', $end_date);     
         }
         
         if($request->domain != null){
            $list->where('users.domainName', '=', $request->domain);
         }

            $data = $list->get();
      

  

            $i = 0;

            $records = array(
                array("Payment Report"),
                array(
                    "S.NO.",
                    "Domain Name",
                    "Institute Name",
                    "Domain Period",
                    'Service',
                    'Total Amount',
                    'Payment Details',
                    'Transaction Date'
                )
            );
            
            foreach ($data as $row) {

                $txnAmount = $record->total_amount;    
                $type='';

                if($row->transaction_type=='domainRegister'){
                    $type='Domain Registration Fee';
                }else if($row->transaction_type=='nameServerUpdate'){
                   $type='Ernet Name Server Fee';
                }else if($row->transaction_type=='domainRenewal'){
                   $type='Domain Renewal Fee';
                }else if($row->transaction_type=='domainRegisterWithNameServer'){
                   $type='Domain and DNS Fee';
                }else if($row->transaction_type=='userNameServerUpdate'){
                   $type='Name Server Update Fee';
                }else{
                   $type=$row->transaction_type;
                }

               
                $txnref=$record->reference_id;
                $bref=$record->transaction_id;

                $status='Paid (PIG Ref-'.$txnref.' Transaction Id-'.$bref.')';

                $contact=DB::table('user_contact_details')->where('user_id',$row->user_id)->first();

                if($contact){
                    $details='Name:'.$row->name.' Address:'.$contact->address;
                }else{
                    $details='Name:'.$row->name.' Address:';
                }
                
                $records[] = array(
                    ++$i,
                    $row->domainName,
                    $row->institute,
                    $row->domainPeriod,
                    $type,
                    $txnAmount,
                    $status,
                    date('d/m/Y', strtotime($row->created_at))
                );
            }
            
            $filename = "Payment Report -". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;

    }

    private function removeSpecialCharacters($string) {
        $cleanedString = preg_replace('/[^a-zA-Z0-9-, \s]/', '', $string);

        return $cleanedString;

    }


    public function billdeskpaymentexport(Request $request){
    
        $list = DB::table('transactions')->select('transactions.*','users.domainName')
        ->where('transactions.transaction_status','0300')
        ->leftJoin('users', 'users.id', 'transactions.user_id') 
        ->orderBy('transactions.created_at', 'desc');

        if($request->dd1 != null) {
            $start_date=Carbon::parse($request->dd1)->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $list->whereDate('transactions.created_at', '=', $start_date);
            }else{
                $list->where('transactions.created_at', '>=', $start_date);
            }
         }
            
         if($request->dd2 != null) {
            $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d H:i:s');
            if ($request->dd1 == $request->dd2) {
                $end_date=Carbon::parse($request->dd2)->endOfDay()->format('Y-m-d');
                $list->whereDate('transactions.created_at', '=', $end_date);
            }else{
                $list->where('transactions.created_at', '<=', $end_date);         
            }  
         }

      

         if($request->domain != null){
            $list->where('users.domainName', '=', $request->domain);
         }

         if($request->trns_type != null){
            $list->where('transactions.transaction_type',  'LIKE', $request->trns_type . '%');
         }

          if($request->period != null){
            $list->where('transactions.period', '=', $request->period);
          }

          if($request->trans_id != null){
            $list->where('transactions.transaction_id', '=', $request->trans_id);
          }

          if($request->order_id != null){
            $list->where('transactions.reference_id', '=', $request->order_id);
          }

          if($request->state != null){
            $list->where('transactions.state_name', '=', $request->state);
         }

            $data = $list->get();
      

            $i = 0;

            $records = array(
                array("Payment Report"),
                array(
                    "S.NO.",
                    "PGI Ref. No.",
                    "User ID ",
                    "Status",
                    'Domain Name',
                    'Period',
                    'ORG',
                    'Address',
                    'State Name',
                    'GST No.',
                    'Net Amount',
                    'Date of Txn',
                    'Receipt No.'
                )
            );
            
            foreach ($data as $row) {

                $id = $row->id;
                $txnAmount=$row->total_amount;

                $recordCreatedAt = $row->created_at;

                $dateTimeUTC = Carbon::parse($recordCreatedAt, 'Asia/Kolkata');
                $dateTimeIST = $dateTimeUTC->setTimezone('Asia/Kolkata');

                $formattedDate = $dateTimeIST->format('d-m-Y h:i a');

                $type='';

                if($row->transaction_type=='domainRegister'){
                    $type='Domain Registration Fee';
                }else if(trim($row->transaction_type)=='nameServerUpdate'){
                   $type='Ernet Name Server Fee';
                }else if($row->transaction_type=='domainRenewal'){
                   $type='Domain Renewal Fee';
                }else if($row->transaction_type=='domainRegisterWithNameServer'){
                   $type='Domain and DNS Fee';
                }else if($row->transaction_type=='userNameServerUpdate'){
                   $type='Name Server Update Fee';
                }else{
                   $type=$row->transaction_type;
                }
                
                $domain= $row->domainName!=null?$row->domainName:$row->domain;
                $p=$row->period==0?"NA":$row->period;
                $address=$this->removeSpecialCharacters($row->address);

                $rec="R000$row->user_id/$row->id"; 

                $records[] = array(
                    ++$i,
                    $row->transaction_id,
                    $row->reference_id,
                    $type,
                    $domain,
                    $p,
                    $row->org,
                    $address,
                    $row->state_name,
                    $row->gst_no,
                    $row->total_amount,
                    $formattedDate,
                    $rec
                );
            }
            
            $filename = "Payment Report -". date('d-m-Y H:i:s a ') . ".xls";
            header("Content-Type: application/vnd.ms-excel");
            header("Content-Disposition: attachment; filename=\"$filename\"");
            $show_column = false;

            foreach ($records as $record) {
                if (!$show_column) {
                    echo implode("\t", array_map(function ($value) {
                        return  $value ;
                    }, $record)) . "\n";
                    $show_column = true;
                } else {
                    echo implode("\t", $record) . "\n";
                }
            }
            exit;

    }
    


    public function Nixigettotalamount(Request $request){
        $transaction = DB::table('transactions')->join('users', 'transactions.user_id', '=', 'users.id')->select('transactions.*', 'users.*');

        if($request->domain_type != null) {
            if($request->domain_type==1){
                $transaction->where('users.clarify',0)->whereIn('users.domainStatus',[2,3,1,4,0]);
            }elseif($request->domain_type==2){
                $transaction->where('domainStatus','=',5);
            }elseif($request->domain_type==3){
                $transaction->join('user_documents', 'users.id', '=', 'user_documents.user_id')->where('user_documents.status', '=', 0);
            }elseif($request->domain_type==4){
                $transaction->where('domainStatus','=',10);
            }elseif($request->domain_type==5){
                $transaction->where('domainStatus','=',7);
            }elseif($request->domain_type==6){
                $transaction->where('domainStatus','=',8);
            }elseif($request->domain_type==7){
                $transaction->where('users.domainExpiryDate', '<=', DB::raw('CURDATE()'))->whereBetween(DB::raw('DATEDIFF(users.domainExpiryDate, users.domainExpiryDate)'), [70, 75]);
            }elseif($request->domain_type==8){
                $transaction->where('users.domainLangID','=',2)->whereIn('users.domainStatus',[6,10]);
            }elseif($request->domain_type==9){
                $transaction->where('users.domainLangID','=',3)->where('users.domainStatus','=',6);
            }
            
        }



        if($request->from != null) {
            
            $start_date = $request->from;
            $transaction->where('transactions.updated_at', '>=', $start_date);
            if ($request->from == $request->to) {
                $transaction->orWhere('transactions.updated_at', '=', $start_date);
            }
        }
            
         if($request->to != null) {
             $end_date = $request->to;
             $transaction->where('transactions.updated_at', '<=', $end_date); 
             if ($request->from == $request->to) {
                $transaction->orWhere('transactions.updated_at', '=', $end_date);
            }    
         }
         
         
         if($request->trns_type != null){
            $transaction->where('transactions.transaction_type', '=', $request->trns_type);
         }
         

         $transactions=$transaction->get();
        $totalAmount = 0;
        foreach ($transactions as $transaction) {
            
            $totalAmount+=$transaction->total_amount;

        }
        return response()->json(['totalamount'=>$totalAmount]);
    }
    public function NixiPayment(){
        $transaction_type = DB::table('transactions')->select('transaction_type')->whereNotNull('transaction_type')->distinct()->get();
        return view('reports.nixipayment',compact('transaction_type'));
    }
    public function NixiPaymentAjax(Request $request){
        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); 

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');
        $columnIndex = $columnIndex_arr[0]['column']; 
        $columnName = $columnName_arr[$columnIndex]['data']; 
        $columnSortOrder = $order_arr[0]['dir']; 
        $searchValue = $search_arr['value']; 
        $countData = DB::table('transactions')->join('users', 'users.id', '=', 'transactions.user_id');
        if($request->domain_type != null) {
            if($request->domain_type==1){
                $countData->where('users.clarify',0)->whereIn('users.domainStatus',[2,3,1,4,0]);
            }elseif($request->domain_type==2){
                $countData->where('domainStatus','=',5);
            }elseif($request->domain_type==3){
                $countData->join('user_documents', 'users.id', '=', 'user_documents.user_id')->where('user_documents.status', '=', 0);
            }elseif($request->domain_type==4){
                $countData->where('domainStatus','=',10);
            }elseif($request->domain_type==5){
                $countData->where('domainStatus','=',7);
            }elseif($request->domain_type==6){
                $countData->where('domainStatus','=',8);
            }elseif($request->domain_type==7){
                $countData->where('users.domainExpiryDate', '<=', DB::raw('CURDATE()'))->whereBetween(DB::raw('DATEDIFF(users.domainExpiryDate, users.domainExpiryDate)'), [70, 75]);
            }elseif($request->domain_type==8){
                $countData->where('users.domainLangID','=',2)->whereIn('users.domainStatus',[6,10]);
            }elseif($request->domain_type==9){
                $countData->where('users.domainLangID','=',3)->where('users.domainStatus','=',6);
            }
        }
        if($request->from != null) {
            $start_date = $request->from;
            $countData->where('transactions.updated_at', '>=', $start_date);
            if ($request->from == $request->to) {
                $countData->orWhere('transactions.updated_at', '=', $start_date);
            }
        }
        if($request->trns_type != null){
            $countData->where('transactions.transaction_type', '=', $request->trns_type);
         }
         if($request->to != null) {
             $end_date = $request->to;
             $countData->where('transactions.updated_at', '<=', $end_date); 
             if ($request->from == $request->to) {
                $countData->orWhere('transactions.updated_at', '=', $end_date);
            }    
         }
         
         if($request->domain != null){
            $countData->where('users.domainName', 'like', '%' .$request->domain . '%');
         }
         

        $totalRecordswithFilter = $countData->select(DB::raw('count(*) as allcount'))->count();
        $totalRecords = $totalRecordswithFilter;
        $records = DB::table('transactions')->join('users', 'transactions.user_id', '=', 'users.id')->select('transactions.*', 'users.*')->orderBy('transactions.id', 'desc')->skip($start)->take($rowperpage);
            if($request->domain_type != null) {
                if($request->domain_type==1){
                    $records->where('clarify',0)->whereIn('domainStatus',[2,3,1,4,0]);
                }elseif($request->domain_type==2){
                    $records->where('domainStatus','=',5);
                }elseif($request->domain_type==3){
                    $records->join('user_documents', 'users.id', '=', 'user_documents.user_id')->where('user_documents.status', '=', 0);
                }elseif($request->domain_type==4){
                    $records->where('domainStatus','=',10);
                }elseif($request->domain_type==5){
                    $records->where('domainStatus','=',7);
                }elseif($request->domain_type==6){
                    $records->where('domainStatus','=',8);
                }elseif($request->domain_type==7){
                    $records->where('users.domainExpiryDate', '<=', DB::raw('CURDATE()'))->whereBetween(DB::raw('DATEDIFF(users.domainExpiryDate, users.domainExpiryDate)'), [70, 75]);
                }elseif($request->domain_type==8){
                    $records->where('users.domainLangID','=',2)->whereIn('users.domainStatus',[6,10]);
                }elseif($request->domain_type==9){
                    $records->where('users.domainLangID','=',3)->where('users.domainStatus','=',6);
                }
            }
            if($request->from != null) {
                $start_date = $request->from;
                $records->where('transactions.updated_at', '>=', $start_date);
                if ($request->from == $request->to) {
                    $records->orWhere('transactions.updated_at', '=', $start_date);
                }
            }
                
             if($request->to != null) {
                 $end_date = $request->to;
                 $records->where('transactions.updated_at', '<=', $end_date); 
                 if ($request->from == $request->to) {
                    $records->orWhere('transactions.updated_at', '=', $end_date);
                }    
             }
             if($request->trns_type != null){
                $records->where('transactions.transaction_type', '=', $request->trns_type);
             }
             if($request->domain != null){
                $records->where('users.domainName', 'like', '%' .$request->domain . '%');
             }
    
        $list = $records->get();

        $data_arr = array();

        foreach($list as $sno => $record){
            if($record->response_payload){
                $id = $record->id;
                $txnAmount = $record->total_amount;
                $created_at = Carbon::parse($record->created_at)->format('d-m-Y');

                $type='';

                if($record->transaction_type=='domainRegister'){
                    $type='Domain Registration Fee';
                }else if($record->transaction_type=='nameServerUpdate'){
                   $type='Ernet Name Server Fee';
                }else if($record->transaction_type=='domainRenewal'){
                   $type='Domain Renewal Fee';
                }else if($record->transaction_type=='domainRegisterWithNameServer'){
                   $type='Domain and DNS Fee';
                }else if($record->transaction_type=='userNameServerUpdate'){
                   $type='Name Server Update Fee';
                }else{
                   $type=$record->transaction_type;
                }

                $txnref=$record->reference_id;
                $bref=$record->transaction_id;

                $contact=DB::table('user_contact_details')->where('user_id',$record->user_id)->first();

                $details='Name:'.$record->name.'<br> Address:'.$contact->address;

                $data_arr[] = array(
                    "id" => ++$start,
                    'domain'=>$record->domainName,
                    "type" => $type,
                    "period"=>$record->domainPeriod,
                    "ernetstatus"=>($record->domainStatus == 0 || $record->domainStatus == 1 ||$record->domainStatus == 2||$record->domainStatus == 4||$record->domainStatus == 3) ? "Incomplete" : (($record->domainStatus == 5) ? "Pending Creation" : (($record->domainStatus == 6) ? "Active":(($record->domainStatus == 7) ? "Hold" :(($record->domainStatus == 8) ? "Deleted":(($record->domainStatus == 10) ? "Renewal Required":"" ))))),
                    "ernetexpiredate"=>"",
                    "nixidetail"=>"",
                    "nixiexpiredate"=>"",
                    
                    "txnAmount" => $txnAmount,
                    "created_at" => $created_at
                );
            }
        }
        $response = array(
            "draw" => intval($draw),
            "iTotalRecords" => $totalRecords,
            "iTotalDisplayRecords" => $totalRecordswithFilter,
            "aaData" => $data_arr
        );

        echo json_encode($response);
        exit;
    }

    
}
