<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\Admin;
use Hash;
use DB,Redirect,Mail;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Session;
use App\Models\LoginHistoryAdmin;
use App\Models\User;
use App\Library\EPP;

class AdminController extends Controller
{
    
    public function forgot()
	{
		return view('admin.forgot');
	}

	public function changepassword(){
		return view('admin.changepassword');
	}

	public function forgotpass($token)
	{
		$obj = DB::table('admins')->where('forgot_url', $token)->first();
		if(!$obj) {
			return redirect('ernetdash/forgot')->with('error', 'No record found');
		}
		return view('admin.forgotchange', ['obj' => $obj]);
	}

	public function verify_change_password(Request $request)
    {
        $params = $request->all();
        $messages = [
            'old_password.required' => 'Please enter old password.',
            'new_password.required' => 'Please enter new password.',
            'confirm_password.required' => 'Please enter confirm password.'
        ];
        $rules = ['old_password' =>'required','new_password' =>'required|regex:/^[a-zA-Z0-9@$#&.! ]+$/','confirm_password' =>'same:new_password|min:8'];
        $validator = validator()->make($params, $rules, $messages);
        if ($validator->fails())
        {
            return Redirect::back()->withErrors($validator->errors());
        }

        $user_id = Auth::guard('admin')->user()->id;

        $obj = DB::table('admins')->where('id', $user_id)->first();

            if (Hash::check($request->old_password,$obj->password)) 
            {
                $password = Hash::make($request->new_password);
                $status = DB::table('admins')->where('id', $obj->id)->update([
                    'password' => $password
                ]);
               return redirect('ernetdash/changepassword')->with('success', 'Password changed successfully.');
            }
            else
            {
                return redirect('ernetdash/changepassword')->with('error', 'Opps! You have entered invalid credentials.');
            }
        
        return redirect('ernetdash/changepassword')->with('error', 'The current password is incorrect.');

    }

    public function reset_googleauth(Request $request){

        $id=$request->id;
        $user=User::find($id);

        if($user){

            $update=DB::table('users')->where('id',$id)->update(['google2fa_secret'=>null]);

            return ['status'=> 'success' ,  'message'=> 'Reset successfully'];

        }

        return ['status'=> 'error' ,'message'=> 'fetched successfully'];

    }

    public function hardcopy_received(Request $request){

        $id=$request->id;
        $user=User::find($id);

        if($user){

            $update=DB::table('users')->where('id',$id)->update(['hard_copy'=>2]);

            return ['status'=> 'success' ,  'message'=> 'Updated successfully'];

        }

        return ['status'=> 'error' ,'message'=> 'not  updated'];

    }

    

    public function autologin(Request $request){

        if($request->token!=''){
        $user = User::where('auth_token', $request->token)->first();
       
            if ($user!=null) {
                 
            Auth::loginUsingId($user->id);
                   
            $url = 'https://registry.ernet.in/user-dashboard';
            return redirect()->to($url);

            }

        }else {
               
       $url = 'https://vas.registry.ernet.in/test-portal/public/projects';
       return redirect()->to($url);
       
        }  

    }

	
    public function add_contact_details($id)
    {
		$data['id']=$id;
		$data['details']=DB::table('users')->where('id',$id)->first();
        $data['title'] = 'Domain Contact Details';
        $data['states'] = DB::table('regions')->orderBy('description')->get();
        $data['cities'] = DB::table('cities')->get();
        return view('admin.pages/add-contact-details',$data);
    }

	public function domainContactDetailsList($id)
    {
        $user_id = $id;
        $data = DB::table('user_contact_details')->where('user_id','=',$user_id)->first();
        return ['status'=> true , 'data' => $data, 'message'=> 'fetched successfully'];
    }

	public function updateInstitutionDetail(Request $request)
    {
        $user_id = $request->id;
        $user = User::find($user_id);

        $data = [
            "address" => $request->input('address'),
            "state" => $request->input('state'),
            "city" => $request->input('city'),
            "pincode" => $request->input('pincode'),
            "phone" => $request->input('phone'),
            "prefix_phone" => $request->input('prefix_phone'),
            "mobile" => $request->input('mobile'),
            "gst_no" => $request->input('gst'),
        ];

		$update=DB::table('users')->where('id',$user_id)->update(['institute'=>$request->input('institution'),'affilation_no'=>$request->affilation_no]);

        $status = DB::table('user_contact_details')
            ->updateOrInsert(
                ['user_id' => $user_id],
                $data
            );

            if($user->domainStatus>5){

                $epp = new EPP();
        
                $res = $epp->domainInfo($user->domainName);
                
                
               $output=xmlConverter($res);
        
                $r=$output['epp']['response'];
          
                $regId=$r['resData']['domain:infData']['domain:registrant'];
        
                $usercontact=DB::table('user_contact_details')->select('*')->where('user_id',$user->id)->first();
    
                $org=$user->institute;
                $name='';
                $address=$usercontact->address;
                $city=$usercontact->city;
                $state=$usercontact->state;
                $postcode=$usercontact->pincode;
                $email='';
                $mobileno='';
        
                $name=$user->name;
                $email=$user->email;
                $mobileno=$usercontact->mobile;
    
               $params=[
                'name'=>$name,
                'org'=>$this->removeSpecialCharacters($org),
                'address'=>$this->removeSpecialCharacters($address),
                'city'=>$this->removeSpecialCharacters($city),
                'state'=>$this->removeSpecialCharacters($state),
                'postcode'=>$postcode,
                'country'=>'IN',
                'mobile'=>'+91.'.$mobileno,
                'email'=>$email,
                ];
                    
    
                $result = $epp->contactUpdate($regId,$params);
            
    
            }

        return $status;
    }
    public function updateInstitutionHeadDetail(Request $request)
    {
        $user_id = $request->id;
        
        $user = User::find($user_id);

        $data = $request->input('head');
        $status = DB::table('user_contact_details')
            ->updateOrInsert(
                ['user_id' => $user_id],
                ['institution_head_detail' => $data]
            );

        if($user->domainStatus>5){

            $epp = new EPP();
    
            $res = $epp->domainInfo($user->domainName);
            
            $output=xmlConverter($res);
    
            $r=$output['epp']['response'];
      
            $regId=$r['resData']['domain:infData']['domain:registrant'];
    
            $usercontact=DB::table('user_contact_details')->select('*')->where('user_id',$user->id)->first();

            $org=$user->institute;
            $name='';
            $address=$usercontact->address;
            $city=$usercontact->city;
            $state=$usercontact->state;
            $postcode=$usercontact->pincode;
            $email='';
            $mobileno='';
    
            $name=$user->name;
            $email=$user->email;
            $mobileno=$usercontact->mobile;

           $params=[
            'name'=>$name,
            'org'=>$this->removeSpecialCharacters($org),
            'address'=>$this->removeSpecialCharacters($address),
            'city'=>$this->removeSpecialCharacters($city),
            'state'=>$this->removeSpecialCharacters($state),
            'postcode'=>$postcode,
            'country'=>'IN',
            'mobile'=>'+91.'.$mobileno,
            'email'=>$email,
            ];
                

            $result = $epp->contactUpdate($regId,$params);
        

        }
       
        return $status;
    }

    private function removeSpecialCharacters($string) {
        $cleanedString = preg_replace('/[^a-zA-Z0-9- \s]/', '', $string);    
        return $cleanedString;
    }

    public function updateAdministrativeDetail(Request $request)
    {
        $user_id = $request->id;
        $user = User::find($user_id);

        $data = $request->input('administrative');
        $status = DB::table('user_contact_details')
            ->updateOrInsert(
                ['user_id' => $user_id],
                ['administrative_detail' => $data]
            );

            if($user->domainStatus>5){

                $epp = new EPP();
        
                $res = $epp->domainInfo($user->domainName);
                
                $dom = new \DOMDocument();
                $dom->loadXML($res);
                
                $xpath = new \DOMXPath($dom);
                $xpath->registerNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                $regId = $xpath->query('//domain:contact[@type="admin"]');
                if ($regId->length > 0) {
                    $regId = $regId->item(0)->nodeValue;
                }
        
                $usercontact=DB::table('user_contact_details')->select('*')->where('user_id',$user->id)->first();
    
                $org=$user->institute;
                $name='';
                $address=$usercontact->address;
                $city=$usercontact->city;
                $state=$usercontact->state;
                $postcode=$usercontact->pincode;
                $email='';
                $mobileno='';
        
                $value=json_decode($usercontact->administrative_detail,true);

                $name=$value['name']??'';
                $email=$value['email']??'';
                $mobileno=$value['mobile']??'';
    
               $params=[
                'name'=>$name,
                'org'=>$this->removeSpecialCharacters($org),
                'address'=>$this->removeSpecialCharacters($address),
                'city'=>$this->removeSpecialCharacters($city),
                'state'=>$this->removeSpecialCharacters($state),
                'postcode'=>$postcode,
                'country'=>'IN',
                'mobile'=>'+91.'.$mobileno,
                'email'=>$email,
                ];
                        
                $result = $epp->contactUpdate($regId,$params);
            
    
            }

        return $status;
    }
    public function updateBillingDetail(Request $request)
    {
        $user_id = $request->id;
        $user = User::find($user_id);

        $data = $request->input('billing');
        $status = DB::table('user_contact_details')
            ->updateOrInsert(
                ['user_id' => $user_id],
                ['billing_contact_detail' => $data]
            );

            
            if($user->domainStatus>5){

                $epp = new EPP();
        
                $res = $epp->domainInfo($user->domainName);
                
                $dom = new \DOMDocument();
                $dom->loadXML($res);
                
                $xpath = new \DOMXPath($dom);
                $xpath->registerNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                $regId = $xpath->query('//domain:contact[@type="billing"]');
                if ($regId->length > 0) {
                    $regId = $regId->item(0)->nodeValue;
                }
        
                $usercontact=DB::table('user_contact_details')->select('*')->where('user_id',$user->id)->first();
    
                $org=$user->institute;
                $name='';
                $address=$usercontact->address;
                $city=$usercontact->city;
                $state=$usercontact->state;
                $postcode=$usercontact->pincode;
                $email='';
                $mobileno='';
        
                $value=json_decode($usercontact->billing_contact_detail,true);

                $name=$value['name']??'';
                $email=$value['email']??'';
                $mobileno=$value['mobile']??'';
    
               $params=[
                'name'=>$name,
                'org'=>$this->removeSpecialCharacters($org),
                'address'=>$this->removeSpecialCharacters($address),
                'city'=>$this->removeSpecialCharacters($city),
                'state'=>$this->removeSpecialCharacters($state),
                'postcode'=>$postcode,
                'country'=>'IN',
                'mobile'=>'+91.'.$mobileno,
                'email'=>$email,
                ];
                        
                $result = $epp->contactUpdate($regId,$params);
            
    
            }

        return $status;
    }
    public function updateTechnicalDetail(Request $request)
    {
        try {
            $user_id = $request->id;
            $user = User::find($user_id);

            $data = $request->input('technical');
            $status = DB::table('user_contact_details')
                ->updateOrInsert(
                    ['user_id' => $user_id],
                    ['technical_detail' => $data]
                );

                if($user->domainStatus>5){

                    $epp = new EPP();
            
                    $res = $epp->domainInfo($user->domainName);
                    
                    $dom = new \DOMDocument();
                    $dom->loadXML($res);
                    
                    $xpath = new \DOMXPath($dom);
                    $xpath->registerNamespace('domain', 'urn:ietf:params:xml:ns:domain-1.0');
                    $regId = $xpath->query('//domain:contact[@type="tech"]');
                    if ($regId->length > 0) {
                        $regId = $regId->item(0)->nodeValue;
                    }
            
                    $usercontact=DB::table('user_contact_details')->select('*')->where('user_id',$user->id)->first();
        
                    $org=$user->institute;
                    $name='';
                    $address=$usercontact->address;
                    $city=$usercontact->city;
                    $state=$usercontact->state;
                    $postcode=$usercontact->pincode;
                    $email='';
                    $mobileno='';
            
                    $value=json_decode($usercontact->technical_detail,true);
    
                    $name=$value['name']??'';
                    $email=$value['email']??'';
                    $mobileno=$value['mobile']??'';
        
                   $params=[
                    'name'=>$name,
                    'org'=>$this->removeSpecialCharacters($org),
                    'address'=>$this->removeSpecialCharacters($address),
                    'city'=>$this->removeSpecialCharacters($city),
                    'state'=>$this->removeSpecialCharacters($state),
                    'postcode'=>$postcode,
                    'country'=>'IN',
                    'mobile'=>'+91.'.$mobileno,
                    'email'=>$email,
                    ];
                            
                    $result = $epp->contactUpdate($regId,$params);
                
        
                }

            //update status
            $updated_date = Carbon::now();
            $user = User::find($user_id);
            if ($user->domainStatus == 0){
                $user->domainStatus = 1;
            }
            $user->updated_at = $updated_date;
            $user->save();


            return ['status'=> true , 'msg'=> 'Technical Details saved successfully!'];
        } catch (Throwable $e) {
            return ['status'=>false, 'msg'=>$e->getMessage()];
        }
    }
    
	public function changeforgotpass(Request $request)
	{
		$params = $request->all();
		$message = [
			'confirmpassword.same' => "The confirm password and password didn't match."
		];
		$rules = ['otp' =>'required', 'password' =>'required|min:8', 'confirmpassword' =>'same:password|min:8'];
		$validator = validator()->make($params, $rules,$message);
		if ($validator->fails())
		{
			return Redirect::back()->withErrors($validator->errors());
		}
		
		$obj = DB::table('admins')->where('forgot_url', $request->url)->first();
		if(!$obj) {
			return redirect('ernetdash')->with('error', 'Opps! You have entered invalid credentials');
		}
		
		if($obj->forgot_otp != $request->otp) {
			return redirect('ernetdash/forgot-pass/'.$request->url)->with('error', 'Invalid OTP, Kindly, enter correct OTP');
		}
		
		$password = Hash::make($request->password);
		$status = DB::table('admins')->where('id', $obj->id)->update([
			'password' => $password,
			'forgot_otp' => null,
			'forgot_url' => null
		]);
		
		if($status)
		{
			return redirect('ernetdash')->with('success', 'You have successfully changed your password.');
		}
		
		return redirect('ernetdash/forgot-pass/'.$request->url)->with('error', 'Something wrong');
		
	}


    public function forgotsend(Request $request)
	{
		$params = $request->all();
		$messages = [
			'email.required' => 'Please enter user name.'
		];
		$rules = ['email' =>'required'];
		$validator = validator()->make($params, $rules, $messages);
		if ($validator->fails())
		{
			return Redirect::back()->withErrors($validator->errors());
		}
		
		$obj = DB::table('admins')->where('username', $request->email)->first();
		
		if($obj) {
			
				$data = $this->sendMail($obj);
				if($data['status'] = 'success') {
					$msg = $data['message'];
					return redirect('ernetdash/forgot')->with('success', $msg);
				} else if($data['status'] = 'false') {
					return redirect('ernetdash/forgot')->with('error', $data['message']);
				}

		} else {
			return redirect('ernetdash/forgot')->with('error', 'Opps! You have entered invalid credentials');
		}
	}


	private function sendMail($obj)
	{
		
		$user_id = $obj->username;
		$to_email = $obj->email;
		$otp = mt_rand(1000, 9999);
		$string = encrypt($obj->email); 
		
		$url = url('ernetdash/forgot-pass/'.$string);
		$data = array('user_id' => $user_id, 'email' => $to_email, 'url' => $url, 'body' => $otp);
		
			Mail::send('admin.email.forgot', $data, function($message)use($data)
			{
				$message->to($data["email"], $data["user_id"])
				->subject("Ernet");
			});

			if (Mail::flushMacros())
			{
				return array('status' => 'false', 'message' => 'Mail not send');
			}
			else
			{		
				DB::table('admins')->where('id', $obj->id)->update(['forgot_otp' => $otp, 'forgot_url' => $string]);
				return array('status' => 'success', 'message' => 'OTP is sent successfully to your registered email id Please check your email');
			}
	}

    public function login(Request $request)
    {
      //return view('front.maintainance');

      $pageTitle = '';

      // Check the route and set the title accordingly
      if ($request->is('bulkdomainpanel')) {
          $pageTitle = 'Bulk Domain Panel';
      } elseif ($request->is('ernetdash')) {
          $pageTitle = 'Admin Login';
      }
  
      if(is_logged_in())
      {
        return redirect()->route('admin.dashboard');
      }
      return view('admin.pages.admin-login',compact('pageTitle'));

    }

    public function attemptLogin(Request $request)
    {
        $message['status']='error';
        $message['message']='Invalid Request';
        if($request->has('admin_login_email') && $request->has('admin_login_password'))
        {

         $role=1;

          if ($request->get('login_type')==='Bulk Domain Panel') {
            $role=2;
          }

        //   dd($role);
            
          if(Auth::guard('admin')->attempt(['username'=>$request->admin_login_email, 'password' =>$request->admin_login_password,'role'=>$role]))
          {            
            $registration_data = Auth::user();
            $request->session()->put('login_data', $registration_data);
            session(['user_agent' => request()->header('User-Agent')]);

            if (Auth::guard('admin')->user()->status==1) {

                if (Auth::guard('admin')->user()->active_session_token==null) {

                    $sessionToken = Str::random(32); 
                    Session::put('auth_token', $sessionToken);
                    $storetoken=DB::table('admins')->where('id',Auth::guard('admin')->user()->id)->update(['active_session_token'=>$sessionToken]);

                    $this->loginHistory(Auth::guard('admin')->user()->id);
                
                        if(Auth::guard('admin')->user()->role==2)
                        {
                            $message['status']='bulkuploaderrole';
                            $message['message']='Successfully logged into the system.';
                            
                            
                        }else{
                            

                          
                            if(Auth::guard('admin')->user()->role==2)
                            {
                                $message['status']='bulkuploaderrole';
                                $message['message']='Successfully logged into the system.';
                            
                            }else{

                        if(Auth::guard('admin')->user()->fig_status==0){
                            $message['status']='figcheck';
                            $message['message']='Please register for authentication';
                            
                        }else{
                            $message['status']='success';
                            $message['message']='Please verify';

                            $this->loginHistory(Auth::guard('admin')->user()->id);
                        }

                        }
                    }
                }
                else
                {

                    
                    if(Auth::guard('admin')->user()->role==2)
                    {
                        $sessionToken = Str::random(32); 
                        Session::put('auth_token', $sessionToken);
                        $storetoken=DB::table('admins')->where('id',Auth::guard('admin')->user()->id)->update(['active_session_token'=>$sessionToken]);
    
                        $message['status']='bulkuploaderrole';
                        $message['message']='Successfully logged into the system.';
                    }else{

                    $message['status']='samelogin';
                    $message['message']='Active Session Found';
                    $this->loginHistory(Auth::guard('admin')->user()->id);
                     
                 }

                }
        }
            else
            {
                $message['status']='error';
                $message['message']='User id deactivated, Please contact system administrator';
            }
        }
          else
          {
              $message['status']='error';
              $message['message']='Invalid Login details';
          }
          return $message;
        }
    }

    public function accesstokenupdate()
    {
        $sessionToken = Str::random(32); 
        Session::put('auth_token', $sessionToken);
        $storetoken=DB::table('admins')->where('id',Auth::guard('admin')->user()->id)->update(['active_session_token'=>$sessionToken]);
        return array('status' => 'success', 'message' => 'success');
    }


    /*==============================================*/
    public function admin_register()
    {
        return view('admin.pages/admin-register');
    }
     public function admin_forgot_password()
    {
        return view('admin.pages/admin-forgot-password');
    }
    public function logout()
    {
        $storetoken=DB::table('admins')->where('id',Auth::guard('admin')->user()->id)->update(['active_session_token'=>null]);

        $this->logoutHistory(Auth::guard('admin')->user()->id);

        $role=Auth::guard('admin')->user()->role;

        if($role==1){
            Auth::guard('admin')->logout();
        }else{
            return redirect('/bulkdomainpanel');
        }

    }

    public function capturefinger()
    {
         return view('admin.pages/captureFinger');
    }

    public function add(Request $request)
    {
       $id = Auth::guard('admin')->user()->id;   
       $data = [
            "fingerprint" => $request->input('fingerprint'),
            "fig_status" => '1',
        ];

        $status = DB::table('admins')
            ->updateOrInsert(
                ['id' => $id],
                $data
            );
        #return $status;
        if($status)
        {
            return response()->json(array('status'=>'success', 'message' => 'Your fingerprint has been added successfully.'));
            #$message['status']='success';
            #$message['message']='Your fingerprint has been added successfully.';
            
        }
    }
    public function matchfinger()
    {

        #dd(Session::get('login_data'));
        $savedFingerData = Auth::guard('admin')->user()->fingerprint;

       #$data = DB::table('admins')->where('id','=',$id)->first('fingerprint');
        return view('admin.pages/matchFinger',['savedFingerData' => $savedFingerData]);
         
    }

    private function logoutHistory($userid)
	{
		$res = LoginHistoryAdmin::where('user_id', $userid)->where('logout', 0)->first();
		if($res) {
			if($res->logout == 0)
			{
				$pkid = $res->id;
				$datetime1 = $res->login_time;
				$datetime2 = date('Y-m-d H:i:s');
					
				$time1 = strtotime($datetime1);
				$time2 = strtotime($datetime2);
				
				$diff =  abs(strtotime($datetime1) - strtotime($datetime2));
					
				$difftext =	seconds2humanApi($diff);
					
				$durationCount = 0;
					
				$result = LoginHistoryAdmin::where('user_id', $userid)->get();
				foreach($result as $resultdata) {
					$durationCount += $resultdata->duration;
				}
				
					if($durationCount == 0)
					{
						$updateq =	LoginHistoryAdmin::where('id', $pkid)->update(
						[
							'logout_time' => $datetime2,
							'duration' => $diff,
							'duration_time' => $difftext,
							'total_duration' => $diff,
							'total_duration_time' => $difftext,
							'logout' => 1
						]);
					}
					else
					{
						$datetime1 = $res->login_time;
						$datetime2 = date('Y-m-d H:i:s');
						
						$time1 = strtotime($datetime1);
						$time2 = strtotime($datetime2);
						$diff =  abs(strtotime($datetime1) - strtotime($datetime2));
						$difftext =	seconds2humanApi($diff);
						$durationCountsum = $durationCount+$diff;
						$durationCountdifftext =	seconds2humanApi($durationCountsum);
						// $updateq =  "update `login_history` set 
						// 	logout_time='$datetime2',
						// 	duration = '$diff',
						// 	duration_time = '$difftext', 
						// 	total_duration = '$durationCountsum',
						// 	total_duration_time = '$durationCountdifftext', 
						// 	logout = 1 
						// 	WHERE `id`='$pkid'";
							
						$updateq =	LoginHistoryAdmin::where('id', $pkid)->update(
						[
							'logout_time' => $datetime2,
							'duration' => $diff,
							'duration_time' => $difftext,
							'total_duration' => $durationCountsum,
							'total_duration_time' => $durationCountdifftext,
							'logout' => 1
						]);

					}
			}
		}
	}


    private function loginHistory($userId)
	{
		$obj = LoginHistoryAdmin::where('user_id', $userId)->where('logout', 0)->first();
		if($obj == null)
		{
			$datetime = date('Y-m-d H:i:s');
			LoginHistoryAdmin::create(['user_id' => $userId, 'login_time' => $datetime]);
		}else {
			if($obj->logout == 0) {
				$pkid = $obj->id;
				$datetime1 = $obj->login_time;
				$datetime2 = date('Y-m-d H:i:s');
				
				$time1 = strtotime($datetime1);
				$time2 = strtotime($datetime2);
				
				$diff =  abs(strtotime($datetime1) - strtotime($datetime2));
				$difftext = seconds2human($diff);
				$durationCount = 0;
				
				$result = LoginHistoryAdmin::where('user_id', $userId)->get();
				foreach($result as $resultdata) {
					$durationCount += $resultdata->duration;
				}
				
				if($durationCount == 0)
				{
					$isUpdate =	LoginHistoryAdmin::where('id', $pkid)->update(
						[
							'logout_time' => $datetime2,
							'duration' => $diff,
							'duration_time' => $difftext,
							'total_duration' => $diff,
							'total_duration_time' => $difftext,
							'logout' => 1
						]
					);
				}
				else
				{
					$datetime1 = $obj->login_time;
					$datetime2 = date('Y-m-d H:i:s');
					
					$time1 = strtotime($datetime1);
					$time2 = strtotime($datetime2);
					$diff =  abs(strtotime($datetime1) - strtotime($datetime2));
					$difftext =	seconds2human($diff);
					$durationCountsum = $durationCount+$diff;
					$durationCountdifftext = seconds2human($durationCountsum);
					
						$isUpdate =	LoginHistoryAdmin::where('id', $pkid)->update(
						[
							'logout_time' => $datetime2,
							'duration' => $diff,
							'duration_time' => $difftext,
							'total_duration' => $durationCountsum,
							'total_duration_time' => $difftext,
							'logout' => 1
						]
					);
				}
				
				if($isUpdate) {
					$datetime = date('Y-m-d H:i:s');
					LoginHistoryAdmin::create(['user_id' => $userId, 'login_time' => $datetime]);
				}
				
			} else {
				$datetime = date('Y-m-d H:i:s');
				LoginHistoryAdmin::create(['user_id' => $userId, 'login_time' => $datetime]);
			}
		}
	}

}