<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Auth,Log,Mail,DB;
use Validator;
use App\Library\EPP;
use App\Models\Misc;
use Hash;
use Illuminate\Support\Str;
use App\Models\Zone;

class BulkDomainController extends Controller
{

    public function bulkdomainRegistration(Request $request)
    {
        $id=$request->id;
        $admin=DB::table('admins')->where('id',$id)->first();
        return view('admin.bulkadmin/registration',['id'=>$id,'admin'=>$admin]);
    }

    public function bulkdomainRegistration_ajaxcall(Request $request){

             $draw = $request->get('draw');
             $start = $request->get("start");
             $rowperpage = $request->get("length"); 
    
             $columnIndex_arr = $request->get('order');
             $columnName_arr = $request->get('columns');
             $order_arr = $request->get('order');
             $search_arr = $request->get('search');
    
             $columnIndex = $columnIndex_arr[0]['column']; 
             $columnName = $columnName_arr[$columnIndex]['data'];
             $columnSortOrder = $order_arr[0]['dir']; 
             $searchValue = $search_arr['value']; 
    
             $records = DB::table('users')
                       ->select('users.id','users.domainName','users.user_id','admins.org_name','users.institute','users.domainLangId','users.status','users.domainStatus','users.applicationDate','users.updated_at')
                       ->whereNotNull('user_id')
                       ->where('domainStatus',5)
                       ->join('admins','admins.id','users.user_id');

            if ($request->has('name') && ! empty($request->name))
            {
                $records->where('users.name', 'LIKE','%'. $request->name.'%');
            }
            
            if ($request->has('user_name') && ! empty($request->user_name))
            {
                $records->where('users.domainName', 'LIKE','%'. $request->user_name.'%');
            }

            if ($request->has('user_id') && ! empty($request->user_id))
            {
                $records->where('users.user_id', $request->user_id);
            }

            if ($request->has('id') && ! empty($request->id))
            {
                $records->where('users.user_id', $request->id);
            }
            
            
            if ($request->has('institute_name') && ! empty($request->institute_name))
            {
                $records->where('users.institute', 'LIKE','%'. $request->institute_name.'%');
            }
            
            if ($request->has('domainLangId') && ! empty($request->domainLangId))
            {
                $records->where('users.domainLangId',  $request->domainLangId);
            }

            if ($request->has('domainLangIds') && ! empty($request->domainLangIds))
            {
                $records->where('users.domainLangId',  $request->domainLangIds);
            }

            if ($request->has('status') && ! empty($request->status))
            {
                $records->where('users.status', $request->status);
            }

            if ($request->has('domainStatus') && ! empty($request->domainStatus))
            {
                $records->where('users.domainStatus', $request->domainStatus);
            }

            if ($request->filled('from_date') && $request->filled('to_date')) {

                $start_date = Carbon::parse($request->from_date)->format('Y-m-d H:i:s');
                $end_date = Carbon::parse($request->to_date)->endOfDay()->format('Y-m-d H:i:s');
            
                if ($start_date == $end_date) {
                    $records->whereDate('users.applicationDate', '=', $start_date);
                } else {
                    $records->whereBetween('users.applicationDate', [$start_date, $end_date]);
                }

            } elseif ($request->filled('from_date')) {

                $start_date = Carbon::parse($request->from_date)->format('Y-m-d H:i:s');
                $records->where('users.applicationDate', '>=', $start_date);

            } elseif ($request->filled('to_date')) {

                $end_date = Carbon::parse($request->to_date)->endOfDay()->format('Y-m-d H:i:s');
                $records->where('users.applicationDate', '<=', $end_date);

            }    
           
           $count=$records->count();

           $records->skip($start)
            ->take($rowperpage);

            $records->orderBy($columnName,$columnSortOrder);

            $list = $records->get();
    
             $data_arr = array();
             
             foreach($list as $sno => $record){
    
                $action='';
    
                if($record->applicationDate == Null|| $record->applicationDate == '' || $record->applicationDate == '0000-00-00 00:00:00'){
                    $appdate='NA';
                }else{
                    $appdate=Carbon::parse($record->applicationDate)->format('d/m/Y');
                }
               
                $lastdate=Carbon::parse($record->updated_at)->format('d/m/Y');

                $status='';
                if($record->domainStatus<=4  && $record->document_status!=1){
                    $status='Incomplete Application';
                }
                elseif($record->domainStatus<=4 && $record->document_status==1){
                   $status='Doc Rejected - <br> Registration Application';
                }elseif($record->domainStatus==5){
                    $status='Pending Domain Creation';
                }elseif($record->domainStatus==6){
                    $status='Active Domain';
                }

                $detailurl=url('ernetdash/admin-users-details').'/'.base64_encode($record->id);

                $action.='<a class="btn btn-outline-primary mx-2" data-toggle="tooltip" data-placement="top"
                title="Edit" href="'.$detailurl.'"> <i class="fa fa-edit"></i></a>';

                $action.='<a class="delete_admin btn btn-danger text-white mx-2" data-toggle="tooltip" data-placement="top"
                title="Delete" href="javascript:void(0)" data-id="'.$record->id.'"><i class="fa fa-trash"></i> </a>';
             
                $data_arr[] = array(
                 "id" => '<input type="checkbox" onclick="check()" class="checkbox" name="domain_list[]" value="' . $record->id . '"/>',
                  "sn" => ++$start,
                  "org_name" => $record->org_name,
                  "domainName" => $record->domainName,
                  "inst" => $record->institute,
                  "appdate"=>$appdate,
                  "lastdate"=>$lastdate,
                  "status"=>$status,
                  "Action"=>$action,
                );

             }
    
             $response = array(
                "draw" => intval($draw),
                "iTotalRecords" => $count,
                "iTotalDisplayRecords" =>$count,
                "aaData" => $data_arr
             );
    
             echo json_encode($response);
             exit;

    }


    public function bulkorgdetails(Request $request)
    {
        return view('admin.bulkadmin/org_details');
    }


    public function bulkorgdetails_ajaxcall(Request $request){

        $draw = $request->get('draw');
        $start = $request->get("start");
        $rowperpage = $request->get("length"); 

        $columnIndex_arr = $request->get('order');
        $columnName_arr = $request->get('columns');
        $order_arr = $request->get('order');
        $search_arr = $request->get('search');

        $columnIndex = $columnIndex_arr[0]['column']; 
        $columnName = $columnName_arr[$columnIndex]['data'];
        $columnSortOrder = $order_arr[0]['dir']; 
        $searchValue = $search_arr['value']; 

        $records = DB::table('users')
                  ->select('users.user_id')
                  ->join('admins','admins.id','users.user_id')
                  ->whereNotNull('users.user_id')
                  ->whereIn('users.domainStatus',[5,6,7,8,10])
                  ->where('users.user_type',2)
                  
                  ->groupBy('users.user_id');
       

      $records->skip($start)
       ->take($rowperpage);

       $list = $records->get();

       $count=$list->count();

        $data_arr = array();
        
        foreach($list as $sno => $record){

            $admins=DB::table('admins')->select('org_name','name','email')->where('id',$record->user_id)->first();

            $detailurl = url('ernetdash/reports/bulkdomain') . '?id=' . $record->user_id;
            
           $action='<a class="btn btn-outline-primary mx-2" data-toggle="tooltip" data-placement="top"
           title="Edit" href="'.$detailurl.'"> <i class="fa fa-eye"></i></a>';

           $data_arr[] = array(
             "id" => ++$start,
             "org_name" => '<a href="'.$detailurl.'" class="text-primary" title="View Details">'.$admins->org_name.'</a>',
            
             "name" => $admins->name??'',
             "email" => $admins->email??'',
             
           );

        }

        $response = array(
           "draw" => intval($draw),
           "iTotalRecords" => $count,
           "iTotalDisplayRecords" =>$count,
           "aaData" => $data_arr
        );

        echo json_encode($response);
        exit;

    }
    

    public function registerDomain(Request $request)
    {
        try {

            $domain_list = $request->domain_list;

			if(is_array($domain_list))
			{
				
				if(count($domain_list) > 0)
				{

                    foreach($domain_list as $domain){

                        $user = User::where('id', $domain)->first();

                        if($user) {
                            $updated_date = now();
                            $namserver = DB::table('user_name_servers')->where('user_id', $user->id)->first();
                            
                            if($namserver && $namserver->server_type == 1) {
                                $status = DB::table('zones')->updateOrInsert(
                                    ['user_id' => $user->id],
                                    [
                                        'server' => $namserver->primary_name_server,
                                        'user_id' => $user->id,
                                        'domain' => $user->domainPunycode,
                                        'reverse_zone' => 1,
                                        'custom_settings' => 0,
                                        'refresh' => 0,
                                        'retry' => 7200,
                                        'expire' => 3628800,
                                        'negative_ttl' => 0,
                                        'default_ttl' => 0,
                                        'updated_at' => $updated_date
                                    ]
                                );
                                
                                $zone = Zone::where('domain', $user->domainPunycode)->first();
                            }
                            
                            $epp = new EPP();
                            $domainName = $user->domainPunycode;
                            $period = $user->domainPeriod ?? 1;
                            $domainId = $user->id;
                            $password = Str::random(8);
                        
                            $eppdomainresult = $epp->create_domain($domainName, $period, $user->email, $password, $domainId);
                          
                            // return ['status'=>false, 'msg'=>$eppdomainresult];

                            $xmlresult = simplexml_load_string($eppdomainresult);
                            $resultAttributes = $xmlresult->response->result->attributes();
                            $resultcode = (string)$resultAttributes['code'];
                            $resultMessage = (string)$xmlresult->response->result->msg;
                        

                            if($resultcode == '1000' && $resultMessage == 'Command completed successfully') {

                                if($namserver && $namserver->server_type != 3) {
                                    $paramscreate = [
                                        'ns1' => [
                                            'host' => $namserver->primary_name_server,
                                            'ip4' => $namserver->primary_name_server_ip,
                                            'ip6' => $namserver->primary_name_server_ip6,
                                        ],
                                        'ns2' => [
                                            'host' => $namserver->secondary_name_server1,
                                            'ip4' => $namserver->secondary_name_server1_ip,
                                            'ip6' => $namserver->secondary_name_server1_ip6,
                                        ],
                                    ];
                        
                                    for($i = 2; $i <= 5; $i++) {
                                        $field = "secondary_name_server$i";
                                        $fieldIp = "secondary_name_server${i}_ip";
                                        $fieldIp6 = "secondary_name_server${i}_ip6";
                                        
                                        if($namserver->$field) {
                                            $paramscreate["ns$i"] = [
                                                'host' => $namserver->$field,
                                                'ip4' => $namserver->$fieldIp,
                                                'ip6' => $namserver->$fieldIp6,
                                            ];
                                        }
                                    }
                        
                                    $response = $epp->domainaddNameServer($domainName, $paramscreate);
                        
                                    $dsdtaas = DB::table('dns_security-extension')->where('user_dns_server_id', $namserver->id)->get();
                        
                                    $addDsData = [];
                        
                                    foreach($dsdtaas as $name) {
                                        if($name->key_tag) {
                                            $addDsData[] = [
                                                'keyTag' => $name->key_tag,
                                                'alg' => $name->algorithm,
                                                'digestType' => $name->digest_type == 'SHA1' ? "1" : '',
                                                'digest' => $name->digest,
                                            ];
                                        }
                                    }
                        
                                    $res = $epp->domainupdateDNSSEC($domainName, $addDsData);
                                }
                        
                                $updatedoc = DB::table('user_documents')->where('user_id', $user->id)->update(['status'=>2]);

                                $user->domainCreationDate = now();
                                $user->domainExpiryDate = now()->addYears($period);
                                $user->domainStatus = 6;
                                $user->updated_at = $updated_date;
                                $user->save();


                            }

                        }else{

                            return ['status'=>false, 'msg'=>"Domain not found"];

                        }
                                                
                       
                    }

                    return ['status'=>true, 'msg'=>'Domain Registered Successfully'];


                }else{

                    return response()->json(array('status'=>false,'msg'=>'Please Select atleast one domain to register'));

                }


            }else{

            return response()->json(array('status'=>false,'msg'=>'Please Select atleast one domain to register'));

            }

                
        } catch (\Throwable $e)
        {
            $error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
            return response()->json(array('status'=>false,'msg'=>$error));
        }

    }
   

}