<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use DB;
use Illuminate\Http\Request;
use Auth, Validator;
use App\Components\EmailSettingManager;
use App\Models\EmailSetting;

class EmailSettingsController extends Controller
{
    public function index() 
	{
		$data['title'] = 'Setting';
        $getSettingQry = DB::table('misc_settings')->first();
        $data['getSettingData'] = $getSettingQry;
		return view('admin.pages.admin-emails-settings',$data);
	}
    public function save(Request $request)
	{
		try
		{
			if($request->isMethod('post'))
			{
				$params = $request->all();
				
				$validator = Validator::make($params,[
                    'host_name' =>'required',
					'port_number' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
                    'username' =>'required|regex:/^[a-zA-Z0-9@.& ]+$/',
                    'password' =>'required',
                    'from_address' =>'required|regex:/^[a-zA-Z0-9@.& ]+$/',
                    'from_name' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
				]);
				
				if($validator->fails())
				{
					return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
				}
                $host_name = $request->host_name;
				$port_number = $request->port_number;
                $username = $request->username;
                $password = $request->password;
                $from_address = $request->from_address;
                $from_name = $request->from_name;

				$departmentObj = EmailSettingManager::getInstance();
				               
				$status = $departmentObj->create([
                    'host_name' => $host_name,
                    'port_number' => $port_number,
                    'username' => $username,
                    'password' => $password,
                    'from_address' => $from_address,
                    'from_name' => $from_name,
					'status'=>2
                ]);
				
				if($status)
				{
					return response()->json(array('status'=>'success'));
				}
				
				return response()->json(array('status'=>'error', 'error' => 'Something Wrong'));
			}
		
			return redirect('home')->with('error', 'Not valid');
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','data'=>$error));
		}
	}
	
	public function update(Request $request)
	{
		try
		{
			$params = $request->all();

			$messages = [
				'status.unique' => 'Active Email Already exist',
			];
			
			$validator = Validator::make($params,[
                    'host_name' =>'required',
					'port_number' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
                    'username' =>'required|regex:/^[a-zA-Z0-9@.& ]+$/',
                    'password' =>'required',
                    'from_address' =>'required|regex:/^[a-zA-Z0-9@.& ]+$/',
                    'from_name' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
					'status'=>'required|regex:/^[a-zA-Z0-9& ]+$/'
			]);
			
			if($request->status==1){
                $check=DB::table('email_settings')->where('status',1)->where('id','!=',$request->id)->first();

				if($check){
					return response()->json(array('status'=>'single', 'message' => "Active Email settings record already exists, Record can't be modified"));
				}
			}

			if($validator->fails())
			{
				return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
			}
			    $id = $request->id;
                $host_name = $request->host_name;
			    $port_number = $request->port_number;
                $username = $request->username;
                $password = $request->password;
                $from_address = $request->from_address;
                $from_name = $request->from_name;
			$departmentObj = EmailSettingManager::getInstance();
		
			$status = $departmentObj->updateById($id, [
                'host_name' => $host_name,
                'port_number' => $port_number,
                'username' => $username,
                'password' => $password,
                'from_address' => $from_address,
                'from_name' => $from_name,
				'status'=>$request->status
            ]);
			
			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Update.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError'));
		}
	}
	
	public function deleteById(Request $request)
	{
		try
		{
			$id = $request->id;
			$departmentObj = EmailSettingManager::getInstance();
			$department = $departmentObj->getStateById($id);
			
			if($department == null)
			{
				return response()->json(array('status'=>'error', 'message' => 'Record not found.'));
			}
			
			$status = $departmentObj->deleteById($id);
			
			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','error'=>$error));
		}
	}
	
	public function get(Request $request)
	{
		
		$id = $request->id;
		$departmentObj = EmailSetting::find($id);
		
		return response()->json(array('status'=>'success', 'data' =>$departmentObj ));
		
	}
	
	public function ajaxcall(Request $request)
	{
		 ## Read value
		 $draw = $request->get('draw');
		 $start = $request->get("start");
		 $rowperpage = $request->get("length"); // Rows display per page

		 $columnIndex_arr = $request->get('order');
		 $columnName_arr = $request->get('columns');
		 $order_arr = $request->get('order');
		 $search_arr = $request->get('search');

		 $columnIndex = $columnIndex_arr[0]['column']; // Column index
		 $columnName = $columnName_arr[$columnIndex]['data']; // Column name
		 $columnSortOrder = $order_arr[0]['dir']; // asc or desc
		 $searchValue = $search_arr['value']; // Search value

		 $countData = EmailSetting::select('count(*) as allcount');
		 
		if($searchValue != null) {
			$countData->where('host_name', 'like', '%' .$searchValue . '%');
		}
		
		$totalRecordswithFilter = $countData->count();
		$totalRecords = $totalRecordswithFilter;
		 $records = EmailSetting::select('*')
		   ->skip($start)
		   ->take($rowperpage);
		   
			if($columnName == 'id') {
			   $records->orderBy($columnName,$columnSortOrder);
			}
			
			if($searchValue != null) {
				$records->where('host_name', 'like', '%' .$searchValue . '%');
			}
		
		$list = $records->get();

		 $data_arr = array();
		 
		 foreach($list as $sno => $record){
			$id = $record->id;
            $host_name = $record->host_name;
			$port_number = $record->port_number;
            $username = $record->username;
            $password = $record->password;
            $from_address = $record->from_address;
            $from_name = $record->from_name;

			$action='';

			$userid=Auth::guard('admin')->user()->id;

			$edit=$del=true;
			$priv=getUserHasRoleProgram($userid,8);

			if($priv!=null){
				$edit=$priv->modify_priv==1 ?true:false;
				$del=$priv->del_priv==1 ?true:false;
			}

			if($edit){
				$action.=' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>';
			}

			if($del){
				$action.= '<a class="dropdown-items delete" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="'.$id.'"><i class="fa fa-trash fs-4 text-danger"></i></a>';
			}

			// $action = ' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>
            // <a class="dropdown-items delete" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="'.$id.'"><i class="fa fa-trash fs-4"></i></a>';
			
			$data_arr[] = array(
			  "id" => ++$start,
              "host_name" => $host_name,
			  "port_number" => $port_number,
              "username" => $username,
              "password" => $password,
              "from_address" => $from_address,
			  "status"=>$record->status==1 ?"Active":"Deactive",
			  "Action" => $action
			);
		 }

		 $response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordswithFilter,
			"aaData" => $data_arr
		 );

		 echo json_encode($response);
		 exit;
	}
	
	private function exceptionHandling($error)
	{
			$obj = \App\Components\AuditReportManager::getInstance();
			$data = array('name' => "State Master", 'data' => $error, 'user_id' => Auth::user()->id);
			$obj->save($data);		
	}
}
