<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Metaregistrar\EPP\eppConnection;
use Metaregistrar\EPP\eppHttpConnection;
use Metaregistrar\EPP\eppException;
use Metaregistrar\EPP\eppCheckDomainRequest;
use Metaregistrar\EPP\eppCheckDomainResponse;

class EppController extends Controller
{
    public function test(Request $request)
    {
        if ($request->has('domain')){
            $domain = $request->input('domain');
            if ($domain != null){
                $conn = eppConnection::create('settings.ini');
                $result = $this->checkdomains($conn,$domain);
                dd($result);
            }
        }

        $conn = eppConnection::create('settings.ini');
        $result = $this->checkdomains($conn,'google.com');
        dd($result);

   }
   public function checkdomains($conn, $domains) {
       // Create request to be sent to EPP service
       $check = new eppCheckDomainRequest($domains);
       // Write request to EPP service, read and check the results
       if ($response = $conn->request($check)) {
           /* @var $response eppCheckDomainResponse */
           // Walk through the results
           $checks = $response->getCheckedDomains();
           foreach ($checks as $check) {
               echo $check['domainname'] . " is " . ($check['available'] ? 'free' : 'taken');
               if ($check['available']) {
                   echo ' (' . $check['reason'] .')';
               }
               echo "\n";
           }
       }
   }
}
