<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Auth, Validator, Redirect;
use App\Models\PaymentGatewaySetting;
use App\Components\PaymentGatewaySettingManager;

class PaymentGatewaySettingsController extends Controller
{
    public function index() 
	{
		return view('admin/PaymentGetwayList/index');
	}
    public function save(Request $request)
	{
		try
		{
			if($request->isMethod('post'))
			{
				$params = $request->all();
				
				$validator = Validator::make($params,[
                    'payment_gateway' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
                    'merchant_id' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
                    'security_id' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
                    'checksum_key' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
				]);
				
				if($validator->fails())
				{
					return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
				}
                $payment_gateway = $request->payment_gateway;
                $merchant_id = $request->merchant_id;
                $security_id = $request->security_id;
                $checksum_key = $request->checksum_key;

				$departmentObj = PaymentGatewaySettingManager::getInstance();
				               
				$status = $departmentObj->create([
                    'payment_gateway' => $payment_gateway,
                    'transaction_url' => '',
                    'merchant_id' => $merchant_id,
                    'security_id' => $security_id,
                    'checksum_key' => $checksum_key
                ]);
				
				if($status)
				{
					return response()->json(array('status'=>'success'));
				}
				
				return response()->json(array('status'=>'error', 'error' => 'Something Wrong'));
			}
		
			return redirect('home')->with('error', 'Not valid');
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','data'=>$error));
		}
	}
	
	public function update(Request $request)
	{
		try
		{
			$params = $request->all();
			
			$validator = Validator::make($params,[
                'payment_gateway' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
                'merchant_id' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
                'security_id' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
                'checksum_key' =>'required|regex:/^[a-zA-Z0-9& ]+$/',
			]);
			
			if($validator->fails())
			{
				return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
			}
			    $id = $request->id;
                $payment_gateway = $request->payment_gateway;
                $merchant_id = $request->merchant_id;
                $security_id = $request->security_id;
                $checksum_key = $request->checksum_key;

			$departmentObj = PaymentGatewaySettingManager::getInstance();
		
		
			$status = $departmentObj->updateById($id, [
                'payment_gateway' => $payment_gateway,
                'transaction_url' => '',
                'merchant_id' => $merchant_id,
                'security_id' => $security_id,
                'checksum_key' => $checksum_key
            ]);
			
			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Update.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError'));
		}
	}
	
	public function deleteById(Request $request)
	{
		try
		{
			$id = $request->id;
			$departmentObj = PaymentGatewaySettingManager::getInstance();
			$department = $departmentObj->getStateById($id);
			
			if($department == null)
			{
				return response()->json(array('status'=>'error', 'message' => 'Record not found.'));
			}
			
			$status = $departmentObj->deleteById($id);
			
			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','error'=>$error));
		}
	}
	
	public function get(Request $request)
	{
		
		$id = $request->id;
		$departmentObj = PaymentGatewaySetting::find($id);
		
		return response()->json(array('status'=>'success', 'data' =>$departmentObj ));
		
	}
	
	public function ajaxcall(Request $request)
	{
		 ## Read value
		 $draw = $request->get('draw');
		 $start = $request->get("start");
		 $rowperpage = $request->get("length"); // Rows display per page

		 $columnIndex_arr = $request->get('order');
		 $columnName_arr = $request->get('columns');
		 $order_arr = $request->get('order');
		 $search_arr = $request->get('search');

		 $columnIndex = $columnIndex_arr[0]['column']; // Column index
		 $columnName = $columnName_arr[$columnIndex]['data']; // Column name
		 $columnSortOrder = $order_arr[0]['dir']; // asc or desc
		 $searchValue = $search_arr['value']; // Search value

		 $countData = PaymentGatewaySetting::select('count(*) as allcount');
		 
		if($searchValue != null) {
			$countData->where('payment_gateway', 'like', '%' .$searchValue . '%');
		}
		
		$totalRecordswithFilter = $countData->count();
		$totalRecords = $totalRecordswithFilter;
		 $records = PaymentGatewaySetting::select('*')
		   ->skip($start)
		   ->take($rowperpage);
		   
			if($columnName == 'id') {
			   $records->orderBy($columnName,$columnSortOrder);
			}
			
			if($searchValue != null) {
				$records->where('payment_gateway', 'like', '%' .$searchValue . '%');
			}
		
		$list = $records->get();

		 $data_arr = array();
		 
		 foreach($list as $sno => $record){
			$id = $record->id;
            $payment_gateway = $record->payment_gateway;
            $merchant_id = $record->merchant_id;
            $security_id = $record->security_id;
            $checksum_key = $record->checksum_key;
			$edit = asset('icon/edit2.png');
			$delete = asset('icon/del.png');
            
			$action='';

			$userid=Auth::guard('admin')->user()->id;

			$edit=$del=true;
			$priv=getUserHasRoleProgram($userid,7);

			if($priv!=null){
				$edit=$priv->modify_priv==1 ?true:false;
				$del=$priv->del_priv==1 ?true:false;
			}

			if($edit){
				$action.=' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>';
			}

			// if($del){
			// 	$action.= '<a class="dropdown-items delete" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="'.$id.'"><i class="fa fa-trash fs-4"></i></a>';
			// }

			// $action = ' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>
            // <a class="dropdown-items delete" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="'.$id.'"><i class="fa fa-trash fs-4"></i></a>';
			
			$data_arr[] = array(
			  "id" => ++$start,
              "payment_gateway" => $payment_gateway,
              "merchant_id" => $merchant_id,
              "checksum_key" => $checksum_key,
			  "security_id" => $security_id,
			  "Action" => $action
			);
		 }

		 $response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordswithFilter,
			"aaData" => $data_arr
		 );

		 echo json_encode($response);
		 exit;
	}
	
	private function exceptionHandling($error)
	{
			$obj = \App\Components\AuditReportManager::getInstance();
			$data = array('name' => "State Master", 'data' => $error, 'user_id' => Auth::user()->id);
			$obj->save($data);		
	}
}
