<?php

namespace App\Http\Controllers\admin\master;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Hash;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Auth, Validator, Redirect, DB,File;	
use App\Models\Admin;
use App\Models\User;
use App\Components\AdminManager;
use Illuminate\Http\Request;
use Carbon\Carbon;
class AdminsController extends Controller
{

	

	public function Updatedoc(Request $request){
		$updateid = $request->updateid;
		$name = $request->name;
		$institute = $request->institute;
		$address = $request->address;
		$email = $request->email;
		$contact = $request->contact;
		$gst = $request->gst;

		$head_name = $request->head_name;
		$head_designation = $request->head_designation;
		$head_email = $request->head_email;
		$head_phone = $request->head_phone;
		$head_mobile = $request->head_mobile;

		$admin_name = $request->admin_name;
		$admin_designation = $request->admin_designation;
		$admin_email = $request->admin_email;
		$admin_phone = $request->admin_phone;
		$admin_mobile = $request->admin_mobile;

		$bill_name = $request->bill_name;
		$bill_designation = $request->bill_designation;
		$bill_email = $request->bill_email;
		$bill_phone = $request->bill_phone;
		$bill_mobile = $request->bill_mobile;

		$tech_name = $request->tech_name;
		$tech_designation = $request->tech_designation;
		$tech_email = $request->tech_email;
		$tech_phone = $request->tech_phone;
		$tech_mobile = $request->tech_mobile;

		$rules = [

            'Undertaking' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
			'Application' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
			'Authorization' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
			'Affiliation' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
			'Address' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
			'DST' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',

			'name' => "required",
			'institute' => "required",
			'address' => "required",
			'email' => "required",
			'contact' => "required",
			'gst' => "required",

			'head_name' => "required",
			'head_designation' => "required",
			'head_email' => "required",
			'bill_phone' => "required",
			'admin_mobile' => "required",

			'admin_name' => "required",
			'admin_designation' => "required",
			'admin_email' => "required",
			'admin_phone' => "required",
			'admin_mobile' => "required",

		    'bill_name' => "required",
			'bill_designation' => "required",
			'bill_email' => "required",
			'bill_phone' => "required",
			'bill_mobile' => "required",

			'tech_name' => "required",
			'tech_designation' => "required",
			'tech_email' => "required",
			'tech_phone' => "required",
			'tech_mobile' => "required",

         ];

        $validator = Validator::make($request->all(), $rules);
        if ($validator->fails()) {
            return response()->json(['status' => 'error' , 'message' => $validator->errors()]);
        }

		if($head_name){
			$update = DB::table('users')->where('id' , $updateid)->update([
				'domainName' => $name,
				'institute' => $institute,
				'address'   => $address,
				'contact'   => $contact,
			]);
		}

		if($gst){
			$headData = [
				'name' => $head_name,
				'designation' => $head_designation,
				'email' => $head_email,
				'phone' => $head_phone,
				'mobile' => $head_mobile,
			];

			$adminData = [
				'name' => $admin_name,
		        'designation' => $admin_designation,
		        'email' => $admin_email,
		        'phone' => $admin_phone,
		        'mobile' => $admin_mobile,
			];

			$billData = [
				'name' => $request->bill_name,
		        'designation' => $request->bill_designation,
		        'email' => $request->bill_email,
		        'phone' => $request->bill_phone,
		        'mobile' => $request->bill_mobile,
			];

			$techData = [
				'name' => $request->tech_name,
		        'designation' => $request->tech_designation,
		         'email' => $request->tech_email,
		        'phone' => $request->tech_phone,
		        'email' => $request->tech_mobile,
			];
			

			$update = DB::table('user_contact_details')->where('user_id' , $updateid)->update([
				'gst_no' => $gst,
				'institution_head_detail' => $headData,
				'administrative_detail' => $adminData,
				'billing_contact_detail' => $billData,
				'technical_detail' => $techData,
			]);
		}

		$DOC = [1, 2, 6, 7 , 13 , 14];
		foreach ($DOC as $val) {
			$fileInputName = 'file_' . $val;
		
			if ($request->hasFile($fileInputName)) {
				$filename = time() . '_' . $request->file($fileInputName)->getClientOriginalName();
				$filePath = 'user/docs/' . $updateid;
		
				$request->file($fileInputName)->move(public_path($filePath , $filename));
		
				$updateData = [
					'name' => $filename,
					'path' => $filename,
					'document_category_id' => $val
				];

				$update = DB::table('user_documents')->updateOrInsert(['document_category_id' => $val], $updateData);
		
			}
		}

		if($update){
			return response()->json(['status' => 'success', 'msg' => 'Documents have been updated successfully']);
		}


	}

	public function Domiandoc(Request $request){
		$id = $request->id;

		$data = DB::table('users')->where('id' , $id)->first();
		$userData = [
			'id' => $data->id,
			'domainName' => $data->domainName,
			'Email' => $data->email,
			'institute' => $data->institute,
			'domainPeriod' => $data->domainPeriod,
			'address' => $data->address,
			'contact' => $data->contact,
			'gst' => $data->contact,
		];

		$UserID = $data->id;
		$contactData = DB::table('user_contact_details')->where('user_id' , $UserID)->first();
		$contact = [
			'gst_no' => $contactData->gst_no,
			'head' => json_decode($contactData->institution_head_detail),
			'admini' => json_decode($contactData->administrative_detail),
			'billing' => json_decode($contactData->billing_contact_detail),
			'technical' => json_decode($contactData->technical_detail),
		];

		$DOC = DB::table('user_documents')->where('user_id' , $UserID)->get();

		return response()->json(['data' => $userData , 'contact' => $contact , 'doc' => $DOC]);
	}

	public function Uploaddoc(Request $request){
      
		$datadocmatch = $request->datadocmatch;

   
	if (empty($datadocmatch)) {
    return response()->json(['status' => 'error', 'message' => 'No data provided']);
    }

    $ids = explode(',', $datadocmatch);

    $errors = [];

    $dataID = [1, 2, 6];
    foreach ($dataID as $id) {
    $fieldName = 'file_' . $id;
    $rules = [
        $fieldName => 'required|mimes:pdf|max:2048',
    ];

    $validator = Validator::make($request->only($fieldName), $rules);
    if ($validator->fails()) {
        $errors[$fieldName] = $validator->errors()->get($fieldName);
    }
    }

    if (!empty($errors)) {
    return response()->json(['status' => 'error', 'message' => $errors]);
    }

    $firstFolder = null;

    foreach ($ids as $mainID) {
    foreach ($dataID as $id) {
        $fieldName = 'file_' . $id;
        
        if ($request->hasFile($fieldName)) { 
            $doc = $request->file($fieldName);
            $filename = time() . $doc->getClientOriginalName();

           
                $firstFolder = public_path('user/docs/') . $mainID;

                if (!file_exists($firstFolder)) {
                    mkdir($firstFolder, 0755, true);
                }

				$pathdata = copy($doc->getRealPath(), $firstFolder . '/' . $filename);

                if (!$pathdata) {
                    return response()->json(['status' => false, 'error' => 'Failed to move the uploaded file for user ID: ' . $mainID]);
                }
    

            $oldpath = '';
            $docprevious = DB::table('user_documents')->where('user_id', $mainID)->where('document_category_id', $id)->first();

            if ($docprevious != null) {
                $oldpath = $docprevious->path;
            }

            $status = DB::table('user_documents')->updateOrInsert(
                ['user_id' => $mainID, 'document_category_id' => $id],
                [
                    'user_id' => $mainID,
                    'document_category_id' => $id,
                    'name' => pathinfo($filename, PATHINFO_FILENAME),
                    'path' => $filename,
                    'old_path' => $oldpath,
                    'status' => 1
                ]
            );
        } else {
            return response()->json(['status' => 'error', 'error' => 'No file uploaded']);
        }
    }
}

return response()->json(['status' => 'success', 'msg' => 'Documents have been uploaded successfully']);

    }

	public function Domaindoc(Request $request){
		$data = $request->ids;
		$value = [1, 2, 6];
        $DOC = DB::table('document_category')->whereIn('id', $value)->get();
		return view('admin/admins/upload_doc' , compact('DOC' , 'data'));
	}

	public function ManageDomain(){
		$value = [1, 2, 6, 7 , 13 , 14];
        $DOC = DB::table('document_category')->whereIn('id', $value)->get();
		return view('admin/admins/manage_domain' , compact('DOC'));
	}

	public function Domainview(Request $request){

		$draw = $request->get('draw');
		$start = $request->get("start");
		$rowperpage = $request->get("length"); 

		$columnIndex_arr = $request->get('order');
		$columnName_arr = $request->get('columns');
		$order_arr = $request->get('order');
		$search_arr = $request->get('search');

		$columnIndex = $columnIndex_arr[0]['column']; 
		$columnName = $columnName_arr[$columnIndex]['data']; 
		$columnSortOrder = $order_arr[0]['dir']; 
		$searchValue = $search_arr['value']; 

		$userid=Auth::guard('admin')->user()->id;
		$countData = DB::table('users')->where('user_id' , $userid);
		
	   if($searchValue != null) {
		   $countData->where('domainName', 'like', '%' .$searchValue . '%');
	   }
	   
	   $totalRecordswithFilter = $countData->count();
	   $totalRecords = $totalRecordswithFilter;
	   $records = DB::table('users')->where('user_id' , $userid)
		  ->skip($start)
		  ->take($rowperpage)
		  ->orderBy('id','desc');

	   if($searchValue != null) {
		   $records->where('domainName', 'like', '%' .$searchValue . '%');
	   }
	   
		  
	   $list = $records->get();

		$data_arr = array();
		
		foreach($list as $sno => $record){
		   $id = $record->id;
		   $name = $record->domainName;
		   $institute = $record->institute;
		   $domainPeriod = $record->domainPeriod;
		   $address = $record->address;
		   $contact = $record->contact;
		   
		   $action = '<a class="dropdown-items" href="' . route('view.domainData', ['id' => encrypt($id)]) . '" style="float:left">Manage Domain</a>';
		  
		   $data_arr[] = array(
			 "id" => ++$start,
			 "name" => $name,
			 "institute"=>$institute,
			 "domainPeriod" => $domainPeriod,
			 'address' => $address,
			 'contact' => $record->contact,
			 "status"=>$record->status==1 ?"Active":"Deactive",
			 "Action" => $action
		   );
		}

		$response = array(
		   "draw" => intval($draw),
		   "iTotalRecords" => $totalRecords,
		   "iTotalDisplayRecords" => $totalRecordswithFilter,
		   "aaData" => $data_arr
		);

		echo json_encode($response);
		exit;

	}

	public function uploadDomain(){
		return view('admin/admins/upload_domain');
	}


	public function checkDomain(Request $request) {
		
		$data = json_decode($request->input('jsonData'), true);
	
		if (!is_array($data)) {
			$data = [$data];
		}
	
		$matchedRecords = [];
		$unmatchedRecords = [];
		
		foreach ($data as $value) {
			
			$main = $value['0'];
			$matches = DB::table('users')->where('domainName', $main)->get();
			
			if ($matches->isNotEmpty()) {
				$matchedRecords[] = $matches->toArray(); 
			} else {
				$unmatchedRecords[] = $value;
			}
		}
	
		if (!empty($matchedRecords) && $this->isHeaderRow($matchedRecords[0])) {
			array_shift($matchedRecords);
		}
		
	
		$results = [
			'matched' => $matchedRecords,
			'unmatched' => $unmatchedRecords,
		];

		return response()->json($results);
	}

	private function isHeaderRow($row) {
		return is_array($row) && count($row) > 0 && is_string($row[0]);
	}
	
	

	public function SaveDomain(Request $request){

		$data = $request->unmatchedData;

		$period = $request->period;
		$userId = Auth::guard('admin')->user()->id;
		$insertedIds = [];

		foreach ($data as $row) {

			$domainName = $row['0'];
			$period = $request->period;
			if (preg_match('/[\x{0900}-\x{097F}]+/u', $domainName)) {
				$language = '1'; 
			} elseif (preg_match('/[a-zA-Z]+/u', $domainName)) {
				$language = '2'; 
			}
			$parts = explode('.', $domainName);
			$extention = $parts[count($parts) - 2] . '.' . $parts[count($parts) - 1];

			if($extention){
				$extensiondata = DB::table('domain_extensions')->where('domain_extension' , $extention)->first();
				$extensionID = $extensiondata->domain_language_id;
				$extensionmain = $extensiondata->id;
				$domianData = DB::table('domain_extension_prices')->where('domain_extension_id' , $extensionID)->where('year' , $period)->first();
				$DomainPrice = $domianData->price;
			}

			$instituteName = $row['1'];
			$address = $row['4'];
			$contactDetails = $row['2'];
			$emailData = $row['3'];
			$gst = $row['5'];

			$headname = $row['6'];
			$head_designation = $row['7'];
			$head_email = $row['8'];
			$head_phone = $row['9'];
			$head_mobile = $row['10'];

			$Admin_name = $row['11'];
			$Admin_designation = $row['12'];
			$Admin_email = $row['13'];
			$Admin_phone = $row['14'];
			$Admin_mobile = $row['15'];

			$Billing_name = $row['16'];
			$Billing_designation = $row['17'];
			$Billing_email = $row['18'];
			$Billing_phone = $row['19'];
			$Billing_mobile = $row['20'];

			$Technical_name = $row['21'];
			$Technical_designation = $row['22'];
			$Technical_email = $row['23'];
			$Technical_phone = $row['24'];
			$Technical_mobile = $row['25'];
			$pincode = $row['26'];

			$stateData = DB::table('cities')->select('cities.*','regions.description as state_name')->where('cities.pincode',$pincode)->join('regions','regions.id','cities.region_id')->first();
			$state =  $stateData->state_name;
			$city =  $stateData->name;

			$insertedId = DB::table('users')->insertGetId([
				'user_id' => $userId,
				'name'  => Auth::guard('admin')->user()->name,
				'domainName' => $domainName,
				'domainPunycode' => $domainName,
				'institute' => $instituteName,
				'address' => $address,
				'domainLangID' => $language,
				'domainPeriod' => $period,
				'domainPrice' => $DomainPrice,
				'domainExtensionID' => $extensionmain,
				'contact' => $contactDetails,
				'email' => $emailData,
				'domainCreationDate' => Carbon::now(),
				'domainExpiryDate' => Carbon::now()->addYears($period),
				'status' => 1,
				'domainStatus' => 2,
			]);

			if ($insertedId) {
				$insertedIds[] = $insertedId;

				DB::table('user_contact_details')->insert([
					'user_id' => $insertedId,
					'state' => $state,
					'city'  => $city,
					'pincode' => $pincode,
					'admin_id' => $userId,
					'gst_no'  => $gst,
					'address' => $address,
					'mobile' => $contactDetails,
					'phone' => $contactDetails,
					'institution_head_detail' => json_encode([
						'name' => $headname,
						'designation' => $head_designation,
						'email' => $head_email,
						'phone' => $head_phone,
						'mobile' => $head_mobile,
					]),
					'administrative_detail' => json_encode([
						'name' => $Admin_name,
						'designation' => $Admin_designation,
						'email' => $Admin_email,
						'phone' => $Admin_phone,
						'mobile' => $Admin_mobile,
					]),
					'billing_contact_detail' => json_encode([
						'name' => $Billing_name,
						'designation' => $Billing_designation,
						'email' => $Billing_email,
						'phone' => $Billing_phone,
						'mobile' => $Billing_mobile,
					]),
					'technical_detail' => json_encode([
						'name' => $Technical_name,
						'designation' => $Technical_designation,
						'email' => $Technical_email,
						'phone' => $Technical_phone,
						'mobile' => $Technical_mobile,
					]),
				]);

				$server = DB::table('ernet_name_servers')->first();
				$primary_name_server = $server->primary_name_server;
				$secondary_name_server = json_decode($server->secondary_name_server, true); 

				$secondary_name_server1 = $secondary_name_server[0];
				$secondary_name_server2 = $secondary_name_server[1];
				$secondary_name_server3 = $secondary_name_server[2];
				$secondary_name_server4 = $secondary_name_server[3];
				$secondary_name_server5 = $secondary_name_server[4];

			$ernetDNS = DB::table('user_name_servers')->insert([
				'user_id' => $insertedId,
				'server_type' => 1,
				'primary_name_server' => $primary_name_server,
				'secondary_name_server1' => $secondary_name_server1,
				'secondary_name_server2' => $secondary_name_server2,
				'secondary_name_server3' => $secondary_name_server3,
				'secondary_name_server4' => $secondary_name_server4,
				'secondary_name_server5' => $secondary_name_server5
			]);

		
		}
	}

	if (!empty($insertedIds)) {
		return response()->json(['status' => 'success', 'inserted_ids' => $insertedIds]);
	} else {
		return response()->json(['status' => 'error', 'error' => 'Failed to insert records']);
	}

}

	
	public function index() 
	{
		return view('admin/admins/index');
	}
	
	public function save(Request $request)
	{

        try
		{
			if($request->isMethod('post'))
			{
				$params = $request->all();
				$messages = [
					'max' => 'User ID should not be greater than 50 characters.',
				];
				$validator = Validator::make($params,[
					'user_id' =>'required|max:50|unique:admins,username|regex:/^[a-zA-Z0-9]+$/',
                    'name' =>'required|regex:/^[a-zA-Z0-9 ]+$/',
                    'email'=>'required|email|unique:admins,email',
                    'mobile'=>'required|digits:10',
                    'password'=>'required|min:8|regex:/^[a-zA-Z0-9@#!]+$/',
                    'status'=>'required'
				], $messages);
				
				if($validator->fails())
				{
					return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
				}
				$description = $request->user_id;
				$departmentObj = AdminManager::getInstance();
				
                $params=[
                    'username'=>$request->user_id,
                    'name'=>$request->name,
					'org_name'=>$request->org_name,
					'designation'=>$request->designation,
					'phone'=>$request->phone,
                    'email'=>$request->email,
                    'mobile'=>$request->mobile,
                    'password'=>Hash::make($request->password),
                    'status'=>$request->status,
					'role'=>$request->role
                ];

				$status = $departmentObj->create($params);
				
				if($status)
				{
					return response()->json(array('status'=>'success'));
				}
				
				return response()->json(array('status'=>'error', 'error' => 'Something Wrong'));
			}
		
			return redirect('home')->with('error', 'Not valid');
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','error'=>$error));
		}

	}
	
	public function update(Request $request)
	{
        try
		{
			$params = $request->all();
				$messages = [
					'max' => 'User ID should not be greater than 50 characters.',
				];
				$validator = Validator::make($params,[
                    'name' =>'required|regex:/^[a-zA-Z0-9 ]+$/',
                    'email'=>'required|email',
                    'mobile'=>'required|digits:10',
                    'status'=>'required'
				], $messages);
				
				if($validator->fails())
				{
					return response()->json(array('status'=>'errors', 'message' => $validator->errors()));
				}    
			
			$user_id=Auth::guard('admin')->user()->id;
        
			$oldrecord = Admin::find($request->id);
			$clone = $oldrecord->replicate();

			$params=[
				'name'=>$request->name,
				'email'=>$request->email,
				'org_name'=>$request->org_name,
				'designation'=>$request->designation,
				'phone'=>$request->phone,
				'mobile'=>$request->mobile,
				'status'=>$request->status
			];

				$status = $oldrecord->update($params);
	
				$newrecord=$oldrecord->getChanges();
				$changes = 'ID- '.$request->id.' ';
	
					foreach($params as $key=> $para){
						if(isset($newrecord[$key]) && isset($clone->$key)){
						   $changes .= $key.' Old Value '.$clone->$key.' New Value '.$para.' ';
						}
					}
		 
					if($changes != '')
					{
						$st=Storehistory($user_id,'Admin Users','Update',$changes);
					}

			
			if($status)
			{
				return response()->json(array('status'=>'success', 'message' => 'Successfully Update.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','error'=>$error));
		}
	}
	
	public function deleteById(Request $request)
	{
		try
		{
			$id = $request->id;
			$departmentObj = AdminManager::getInstance();
			$department = $departmentObj->getAdminById($id);
			
			if($department == null)
			{
				return response()->json(array('status'=>'error', 'message' => 'Record not found.'));
			}
			
			$status = $departmentObj->deleteById($id);
			
			if($status)
			{
				$user_id=Auth::guard('admin')->user()->id;

				$st=Storehistory($user_id,'Admin Users','Delete',$department);

				return response()->json(array('status'=>'success', 'message' => 'Successfully Delete.'));
			}
			
			return response()->json(array('status'=>'error', 'message' => 'Something went wrong please try again.'));
		}
		catch (\Throwable $e)
		{
			$error = $e->getMessage().', File Path = '.$e->getFile().', Line Number = '.$e->getLine();
			return response()->json(array('status'=>'exceptionError','error'=>$error));
		}
	}
	
	public function get(Request $request)
	{
		
		$id = $request->id;
		$departmentObj = Admin::find($id);
		
		
		return response()->json(array('status'=>'success', 'data' =>$departmentObj ));
		
	}
	
	public function ajaxcall(Request $request)
	{
		 $draw = $request->get('draw');
		 $start = $request->get("start");
		 $rowperpage = $request->get("length"); 

		 $columnIndex_arr = $request->get('order');
		 $columnName_arr = $request->get('columns');
		 $order_arr = $request->get('order');
		 $search_arr = $request->get('search');

		 $columnIndex = $columnIndex_arr[0]['column']; 
		 $columnName = $columnName_arr[$columnIndex]['data']; 
		 $columnSortOrder = $order_arr[0]['dir']; 
		 $searchValue = $search_arr['value']; 

		 $countData = Admin::select('count(*) as allcount');
		 
		if($searchValue != null) {
			$countData->where('username', 'like', '%' .$searchValue . '%');
		}
		
		$totalRecordswithFilter = $countData->count();
		$totalRecords = $totalRecordswithFilter;
		$records = Admin::select('*')
		   ->skip($start)
		   ->take($rowperpage)
		   ->orderBy('id','desc');

        if($searchValue != null) {
			$records->where('username', 'like', '%' .$searchValue . '%');
		}
		
           
		$list = $records->get();

		 $data_arr = array();
		 
		 foreach($list as $sno => $record){
			$id = $record->id;
			$code = '<a href="javascript:void(0);" style="" class="view" data-id="'.$id.'">'.$record->username.'</a>';
			$edit = asset('icon/edit2.png');
			$delete = asset('icon/del.png');

			$action='';

			$userid=Auth::guard('admin')->user()->id;

			$edit=$del=true;
			$priv=getUserHasRoleProgram($userid,19);

			if($priv!=null){
				$edit=$priv->modify_priv==1 ?true:false;
				$del=$priv->del_priv==1 ?true:false;
			}

			if($edit){
				$action.=' <a class="dropdown-items update" href="javascript:void(0);" style="float:left" data-id="'.$id.'" ><i class="fa fa-edit fs-4"></i></a>';
			}

			if($del){
				$action.= '<a class="dropdown-items delete" href="javascript:void(0);" style="margin-left:10px;float:left" data-id="'.$id.'"><i class="fa fa-trash fs-4"></i></a>';
			}
			
			$reset='<a href="javascript:void(0)" style="color:#fff;" class="mx-2 my-2 change_passwordbutton btn btn-primary" data-id="'.$id.'">Reset Password</a>';

			$data_arr[] = array(
			  "id" => ++$start,
			  "user_id" => $code,
			  "name" => $record->name,
              "email"=>$record->email,
              "status"=>$record->status==1 ?"Active":"Deactive",
			  "role"=>$record->role==1 ?"Admin":"Bulk Uploader",
			  "Action" => $action,
			  'reset'=>$reset
			);
		 }

		 $response = array(
			"draw" => intval($draw),
			"iTotalRecords" => $totalRecords,
			"iTotalDisplayRecords" => $totalRecordswithFilter,
			"aaData" => $data_arr
		 );

		 echo json_encode($response);
		 exit;
	}
	
	
}